/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.annotator;

import com.intellij.codeHighlighting.RainbowHighlighter;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.intention.EmptyIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.ProblemDescriptorUtil;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.TextAttributesScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.CidrLangUtil;
import com.jetbrains.cidr.lang.daemon.clang.ClangDiagnosticUtils;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangdBridge;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.CLionClangInspectionBridgeProblemGroup;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangAnnotatorUtil;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangAppliedDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangErrorProblemGroup;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangHighlightKey;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangHighlighting;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangInfoProblemGroup;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangProblemGroup;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangWarningProblemGroup;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangdQuickFix;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangFileFacade;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIdeFacade;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangLanguageServiceUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangUrlConverter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.Trustworthiness;
import com.jetbrains.cidr.lang.editor.colors.OCHighlightingKeys;
import com.jetbrains.cidr.lang.inspections.OCInspectionUtil;
import com.jetbrains.cidr.util.CidrConcurrentUtilsKt;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangErrorsAnnotatorPass
extends TextEditorHighlightingPass
implements DumbAware {
    private static final int HINTS_LIMIT = 32;
    private static final int HINT_LENGTH_LIMIT = 240;
    private static final Logger LOG = Logger.getInstance((String)ClangErrorsAnnotatorPass.class.getName());
    @NotNull
    private final PsiFile myFile;
    @NotNull
    private final Editor myEditor;
    @NotNull
    private final TextRange myRestrictRange;
    @NotNull
    private final HighlightInfoHolder myHolder;
    private int myParseVersion;

    public ClangErrorsAnnotatorPass(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Document document, @NotNull TextRange restrictRange) {
        if (file == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(1);
        }
        if (document == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(2);
        }
        if (restrictRange == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(3);
        }
        super(file.getProject(), document);
        this.myParseVersion = -1;
        this.myFile = file;
        this.myEditor = editor;
        this.myRestrictRange = restrictRange;
        this.myHolder = new HighlightInfoHolder(file, new HighlightInfoFilter[0]);
    }

    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(4);
        }
        this.myHolder.clear();
        this.myParseVersion = -1;
        if (!ClangUtils.isClangdOn((Project)this.myProject)) {
            return;
        }
        if (!ClangAnnotatorUtil.shouldAnnotate((Project)this.myProject, (PsiFile)this.myFile)) {
            return;
        }
        VirtualFile virtualFile = this.myFile.getViewProvider().getVirtualFile();
        if (!ClangdBridge.isClangdShowErrors((Project)this.myProject, (VirtualFile)virtualFile)) {
            return;
        }
        ClangAppliedDiagnostic.clearDiagnostics((UserDataHolder)this.myFile);
        ClangLanguageService service = ClangLanguageServiceProvider.getIfStarted((Project)this.myProject);
        if (service == null) {
            return;
        }
        service.runWithParsed(virtualFile, response -> {
            if (response == null) {
                return;
            }
            this.myParseVersion = response.getVersion();
            ClangUtils.traceClangd((Logger)LOG, (String)("Getting highlightings and diagnostics for " + virtualFile.getName() + "[" + this.myParseVersion + "]."));
            CompletableFuture highlightingsFuture = response.getHighlightings();
            List highlightings = (List)ClangErrorsAnnotatorPass.waitForClangFuture(this.myProject, virtualFile, response.getVersion(), highlightingsFuture, "highlightings");
            if (highlightings != null) {
                this.makeHighlightings(service.getClangIdeFacade(), highlightings);
            }
            CompletableFuture diagnosticsFuture = response.getDiagnostics();
            List diagnostics = (List)ClangErrorsAnnotatorPass.waitForClangFuture(this.myProject, virtualFile, response.getVersion(), diagnosticsFuture, "diagnostics");
            if (diagnostics != null) {
                Trustworthiness trustworthiness = response.getTrustworthiness();
                this.makeAnnotations(service.getClangIdeFacade(), trustworthiness, diagnostics, service.getUrlConverter());
            }
        });
    }

    @Nullable
    private static <T> T waitForClangFuture(@NotNull Project project, @NotNull VirtualFile virtualFile, int curFileVersion, @NotNull Future<Supplier<T>> future, @NonNls @NotNull String waitingForWhat) {
        if (project == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(5);
        }
        if (virtualFile == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(6);
        }
        if (future == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(7);
        }
        if (waitingForWhat == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(8);
        }
        try {
            Supplier supplier = (Supplier)CidrConcurrentUtilsKt.waitCancelAndWriteActionAware(future, (long)Long.MAX_VALUE, (String)waitingForWhat);
            if (supplier != null) {
                ClangUtils.warnClangd((Logger)LOG, (String)(waitingForWhat + " for " + virtualFile.getName() + "[" + curFileVersion + "] received."));
                return supplier.get();
            }
            ClangUtils.warnClangd((Logger)LOG, (String)(waitingForWhat + " for " + virtualFile.getName() + "[" + curFileVersion + "] are unavailable."));
        }
        catch (IndexOutOfBoundsException ex) {
            ClangLanguageService service = ClangLanguageServiceProvider.getIfStarted((Project)project);
            int version = service != null ? service.getVersion(virtualFile) : -2;
            LOG.error("Got IOOBE when applying " + waitingForWhat + " for version " + curFileVersion + " while the latest version is [" + version + "]", (Throwable)ex);
        }
        catch (TimeoutException ex) {
            ClangUtils.warnClangd((Logger)LOG, (String)("Waiting for " + waitingForWhat + " for " + virtualFile.getName() + "[" + curFileVersion + "] took too much time."), (Throwable)ex);
        }
        catch (ProcessCanceledException ex) {
            ClangUtils.warnClangd((Logger)LOG, (String)("Waiting for " + waitingForWhat + " for " + virtualFile.getName() + "[" + curFileVersion + "] is cancelled."), (Throwable)ex);
            throw ex;
        }
        catch (ExecutionException ex) {
            ClangUtils.logServerException((Logger)LOG, (String)ex.getMessage(), (ExecutionException)ex);
        }
        return null;
    }

    private void makeAnnotations(@NotNull ClangIdeFacade facade2, @NotNull Trustworthiness trustworthiness, @Nullable List<ClangDiagnostic> diags, @NotNull ClangUrlConverter converter) {
        if (facade2 == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(9);
        }
        if (trustworthiness == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(10);
        }
        if (converter == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(11);
        }
        if (!ContainerUtil.isEmpty(diags)) {
            ClangDiagnosticUtils.filterDiagnostics((PsiFile)this.myFile, (Trustworthiness)trustworthiness, diags).stream().sorted((l, r) -> {
                int byLine = l.getStartLine() - r.getStartLine();
                return byLine != 0 ? byLine : l.getStartColumn() - r.getStartColumn();
            }).forEachOrdered(diag -> {
                HighlightInfo annotation = ClangErrorsAnnotatorPass.makeAnnotation(facade2, diag, this.myFile, this.myEditor.getDocument(), this.myHolder, converter);
                if (annotation != null) {
                    ClangAppliedDiagnostic.putDiagnostic((UserDataHolder)this.myFile, (HighlightInfo)annotation, (ClangDiagnostic)diag);
                }
            });
        }
    }

    private void makeHighlightings(@NotNull ClangIdeFacade facade2, @Nullable List<ClangHighlighting> highlightings) {
        if (facade2 == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(12);
        }
        if (!ContainerUtil.isEmpty(highlightings)) {
            ArrayList<ClangHighlighting> sortedHighlightings = new ArrayList<ClangHighlighting>(highlightings);
            sortedHighlightings.sort((l, r) -> {
                int byLine = l.getStartLine() - r.getStartLine();
                return byLine != 0 ? byLine : l.getStartColumn() - r.getStartColumn();
            });
            for (ClangHighlighting highlighting : sortedHighlightings) {
                this.makeHighlighting(highlighting, facade2.getFileFacade(this.myFile.getVirtualFile(), this.myEditor.getDocument()), this.myHolder);
            }
        }
    }

    @Nullable
    public static HighlightInfo makeAnnotation(@NotNull ClangIdeFacade facade2, @NotNull ClangDiagnostic diagnostic, @NotNull PsiFile file, @NotNull Document document, @NotNull HighlightInfoHolder holder, @NotNull ClangUrlConverter converter) {
        ClangFileFacade fileFacade;
        HighlightInfo specialAnnotation;
        if (facade2 == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(13);
        }
        if (diagnostic == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(14);
        }
        if (file == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(15);
        }
        if (document == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(16);
        }
        if (holder == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(17);
        }
        if (converter == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(18);
        }
        if ((specialAnnotation = ClangErrorsAnnotatorPass.makeSpecialAnnotation(facade2, diagnostic, file, fileFacade = facade2.getFileFacade(file.getViewProvider().getVirtualFile(), document), holder, converter)) != null) {
            return specialAnnotation;
        }
        return ClangErrorsAnnotatorPass.makeSimpleAnnotation(facade2, diagnostic, file, fileFacade, holder, null, converter);
    }

    @Nullable
    private static HighlightInfo makeSpecialAnnotation(@NotNull ClangIdeFacade facade2, @NotNull ClangDiagnostic diagnostic, @NotNull PsiFile file, @NotNull ClangFileFacade fileFacade, @NotNull HighlightInfoHolder holder, @NotNull ClangUrlConverter converter) {
        if (facade2 == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(19);
        }
        if (diagnostic == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(20);
        }
        if (file == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(21);
        }
        if (fileFacade == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(22);
        }
        if (holder == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(23);
        }
        if (converter == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(24);
        }
        String code = diagnostic.getCode();
        if (ClangDiagnosticUtils.isUnusedIncludeDirectiveDiagnostic((ClangDiagnostic)diagnostic)) {
            String inspectionName;
            Class UIInspectionCls = ClangdBridge.getUnusedIncludesInspection();
            String string = inspectionName = UIInspectionCls != null ? OCInspectionUtil.getInspectionShortName((Class)UIInspectionCls) : "UnusedIncludes";
            if (inspectionName == null) {
                return null;
            }
            assert (code != null) : "to fix the warning";
            CLionClangInspectionBridgeProblemGroup problemGroup = new CLionClangInspectionBridgeProblemGroup(inspectionName, code);
            return ClangErrorsAnnotatorPass.makeSimpleAnnotation(facade2, diagnostic, file, fileFacade, holder, (ProblemGroup)problemGroup, converter);
        }
        return null;
    }

    @Nullable
    private static HighlightInfo makeSimpleAnnotation(@NotNull ClangIdeFacade facade2, @NotNull ClangDiagnostic diagnostic, @NotNull PsiFile file, @NotNull ClangFileFacade fileFacade, @NotNull HighlightInfoHolder holder, @Nullable ProblemGroup problemGroup, @NotNull ClangUrlConverter converter) {
        TextRange clangRange;
        if (facade2 == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(25);
        }
        if (diagnostic == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(26);
        }
        if (file == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(27);
        }
        if (fileFacade == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(28);
        }
        if (holder == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(29);
        }
        if (converter == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(30);
        }
        if ((clangRange = ClangDiagnosticUtils.createClangTextRange((ClangDiagnostic)diagnostic, (ClangFileFacade)fileFacade)) == null) {
            return null;
        }
        String diagnosticMessage = diagnostic.getMessage();
        List<String> sufficesToRemove = Arrays.asList(" (fix available)", " (fixes available)");
        for (String s : sufficesToRemove) {
            if (!diagnosticMessage.endsWith(s)) continue;
            diagnosticMessage = diagnosticMessage.substring(0, diagnosticMessage.length() - s.length());
        }
        String tooltip = ClangErrorsAnnotatorPass.renderTooltip(facade2, diagnosticMessage, diagnostic.getNotes(), file, fileFacade, converter);
        ArrayList<IntentionWrapper> fixes = new ArrayList<IntentionWrapper>(ContainerUtil.map((Collection)diagnostic.getClangdFixits(), f -> new ClangdQuickFix(f)));
        if (problemGroup == null) {
            if (diagnostic.getCode() != null && diagnostic.getCode().startsWith("-W")) {
                problemGroup = new ClangWarningProblemGroup(file, clangRange, diagnostic.getCode());
                if (diagnostic.getClangdFixits().isEmpty() && diagnostic.getClionFixits().isEmpty()) {
                    EmptyIntentionAction fixToRegister = new EmptyIntentionAction(ClangWarningProblemGroup.getClangProblemName());
                    fixes.add(new IntentionWrapper((IntentionAction)fixToRegister));
                }
            } else {
                problemGroup = new ClangErrorProblemGroup(diagnostic.getCode());
            }
        }
        HighlightInfoType highlightInfoType = ClangErrorsAnnotatorPass.getHighlightInfoType(diagnostic, file.getProject());
        HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo((HighlightInfoType)highlightInfoType).range(clangRange).description(diagnosticMessage).escapedToolTip(tooltip).problemGroup(problemGroup);
        if (ClangErrorsAnnotatorPass.isAnnotationAtEndOfLine((Segment)clangRange, fileFacade.getText())) {
            builder.endOfLine();
        }
        for (IntentionAction intentionAction : fixes) {
            builder.registerFix(intentionAction, ClangErrorsAnnotatorPass.getSpecificSuppressOptions(problemGroup), null, clangRange, null);
        }
        HighlightInfo clangAnnotation = builder.create();
        holder.add(clangAnnotation);
        return clangAnnotation;
    }

    private void makeHighlighting(@NotNull ClangHighlighting highlighting, @NotNull ClangFileFacade fileFacade, @NotNull HighlightInfoHolder holder) {
        block11: {
            TextRange clangRange;
            if (highlighting == null) {
                ClangErrorsAnnotatorPass.$$$reportNull$$$0(31);
            }
            if (fileFacade == null) {
                ClangErrorsAnnotatorPass.$$$reportNull$$$0(32);
            }
            if (holder == null) {
                ClangErrorsAnnotatorPass.$$$reportNull$$$0(33);
            }
            if ((clangRange = ClangDiagnosticUtils.createClangTextRange((ClangHighlighting)highlighting, (ClangFileFacade)fileFacade)) == null) {
                return;
            }
            if (clangRange.getLength() > 0) {
                try {
                    EditorColorsScheme scheme;
                    Field field = OCHighlightingKeys.class.getDeclaredField(highlighting.getType());
                    Object textAttributesKey = field.get(OCHighlightingKeys.class);
                    if ((textAttributesKey == OCHighlightingKeys.PARAMETER || textAttributesKey == OCHighlightingKeys.LOCAL_VARIABLE) && RainbowHighlighter.isRainbowEnabledWithInheritance((TextAttributesScheme)(scheme = EditorColorsManager.getInstance().getGlobalScheme()), (Language)this.myFile.getLanguage())) {
                        return;
                    }
                    if (!(textAttributesKey instanceof TextAttributesKey)) {
                        throw new IllegalArgumentException("Incorrect highlighting type " + highlighting.getType());
                    }
                    TextAttributesKey key = (TextAttributesKey)textAttributesKey;
                    HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.INFORMATION).problemGroup((ProblemGroup)new ClangInfoProblemGroup()).range(clangRange).textAttributes(key).create();
                    holder.add(info);
                }
                catch (NoSuchFieldException e) {
                    assert (false) : "Unknown highlighting type: " + highlighting.getType();
                }
                catch (IllegalAccessException e) {
                    if ($assertionsDisabled) break block11;
                    throw new AssertionError((Object)("Can't get highlighting type " + highlighting.getType()));
                }
            }
        }
    }

    public void doApplyInformationToEditor() {
        if (ClangUtils.isClangdOn((Project)this.myProject) && this.myParseVersion >= 0) {
            VirtualFile vf = this.myFile.getViewProvider().getVirtualFile();
            ClangUtils.traceClangd((Logger)LOG, (String)("Applying diags for " + vf.getName() + "[" + this.myParseVersion + "]."));
        }
        ArrayList<HighlightInfo> highlights = new ArrayList<HighlightInfo>();
        for (int i = 0; i < this.myHolder.size(); ++i) {
            HighlightInfo info = this.myHolder.get(i);
            highlights.add(info);
        }
        this.updateHighlights(highlights);
    }

    private void updateHighlights(@NotNull List<HighlightInfo> newHighlights) {
        if (newHighlights == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(34);
        }
        HashMap<ClangHighlightKey, HighlightInfo> oldHighlightsMap = new HashMap<ClangHighlightKey, HighlightInfo>();
        DaemonCodeAnalyzerEx.processHighlights((Document)this.myDocument, (Project)this.myFile.getProject(), null, (int)0, (int)this.myFile.getTextLength(), highlightInfo -> {
            if (highlightInfo.getProblemGroup() instanceof ClangProblemGroup) {
                oldHighlightsMap.put(new ClangHighlightKey(highlightInfo), (HighlightInfo)highlightInfo);
            }
            return true;
        });
        List<HighlightInfo> mergedHighlights = this.mergeHighlights(newHighlights, oldHighlightsMap);
        UpdateHighlightersUtil.setHighlightersToEditor((Project)this.myProject, (Document)this.myDocument, (int)0, (int)this.myFile.getTextLength(), mergedHighlights, (EditorColorsScheme)this.getColorsScheme(), (int)this.getId());
    }

    @NotNull
    private List<HighlightInfo> mergeHighlights(@NotNull List<HighlightInfo> newHighlights, @NotNull Map<ClangHighlightKey, HighlightInfo> oldHighlightsMap) {
        if (newHighlights == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(35);
        }
        if (oldHighlightsMap == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(36);
        }
        ArrayList<HighlightInfo> result = new ArrayList<HighlightInfo>(newHighlights.size());
        for (HighlightInfo newHighlight : newHighlights) {
            if (this.myRestrictRange.containsOffset(newHighlight.getStartOffset()) && this.myRestrictRange.containsOffset(newHighlight.getEndOffset())) {
                result.add(newHighlight);
                continue;
            }
            HighlightInfo oldHighlight = oldHighlightsMap.get(new ClangHighlightKey(newHighlight));
            result.add(oldHighlight != null ? ClangErrorsAnnotatorPass.mergeHighlights(newHighlight, oldHighlight, this.myDocument, this.getColorsScheme()).create() : newHighlight);
        }
        ArrayList<HighlightInfo> arrayList = result;
        if (arrayList == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(37);
        }
        return arrayList;
    }

    private static boolean isAnnotationAtEndOfLine(@NotNull Segment annotation, @NotNull CharSequence text) {
        if (annotation == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(38);
        }
        if (text == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(39);
        }
        if (annotation.getStartOffset() != annotation.getEndOffset()) {
            return false;
        }
        if (text.length() <= annotation.getStartOffset()) {
            return true;
        }
        char firstChar = text.charAt(annotation.getStartOffset());
        return firstChar == '\n' || firstChar == '\r';
    }

    @NotNull
    public static ProblemHighlightType clangdSeverity2ProblemHighlightType(@NotNull ClangDiagnostic diag) {
        if (diag == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(40);
        }
        ProblemHighlightType type = ClangDiagnosticUtils.isUnusedIncludeDirectiveDiagnostic((ClangDiagnostic)diag) ? ProblemHighlightType.LIKE_UNUSED_SYMBOL : (ClangDiagnosticUtils.isUnusedDiagnostic((ClangDiagnostic)diag) ? ProblemHighlightType.LIKE_UNUSED_SYMBOL : (ClangErrorsAnnotatorPass.isUnresolvedIdentifierDiagnostic(diag) ? ProblemHighlightType.LIKE_UNKNOWN_SYMBOL : (ClangErrorsAnnotatorPass.isDeprecationDiagnostic(diag) ? ProblemHighlightType.LIKE_DEPRECATED : (diag.getSeverity() == HighlightSeverity.ERROR ? ProblemHighlightType.GENERIC_ERROR : (diag.getSeverity() == HighlightSeverity.WARNING ? ProblemHighlightType.WARNING : (diag.getSeverity() == HighlightSeverity.INFORMATION || diag.getSeverity() == HighlightSeverity.WEAK_WARNING ? ProblemHighlightType.WEAK_WARNING : ProblemHighlightType.GENERIC_ERROR_OR_WARNING))))));
        ProblemHighlightType problemHighlightType = type;
        if (problemHighlightType == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(41);
        }
        return problemHighlightType;
    }

    @NotNull
    private static HighlightInfoType getHighlightInfoType(@NotNull ClangDiagnostic diag, @NotNull Project project) {
        if (diag == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(42);
        }
        if (project == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(43);
        }
        ProblemHighlightType type = ClangErrorsAnnotatorPass.clangdSeverity2ProblemHighlightType(diag);
        HighlightSeverity severity = ClangDiagnosticUtils.getHighlightSeverity((ClangDiagnostic)diag);
        HighlightInfoType highlightInfoType = ProblemDescriptorUtil.getHighlightInfoType((ProblemHighlightType)type, (HighlightSeverity)severity, (SeverityRegistrar)SeverityRegistrar.getSeverityRegistrar((Project)project));
        if (highlightInfoType == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(44);
        }
        return highlightInfoType;
    }

    private static boolean isUnresolvedIdentifierDiagnostic(@NotNull ClangDiagnostic diagnostic) {
        String name;
        if (diagnostic == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(45);
        }
        if ((name = diagnostic.getCode()) != null) {
            switch (name) {
                case "undeclared_var_use": 
                case "undeclared_var_use_suggest": 
                case "no_member": 
                case "unknown_typename": 
                case "unknown_typename_suggest": 
                case "-Wimplicit-function-declaration": {
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isDeprecationDiagnostic(@NotNull ClangDiagnostic diagnostic) {
        String name;
        if (diagnostic == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(46);
        }
        return (name = diagnostic.getCode()) != null && name.equals("-Wdeprecated-declarations");
    }

    @NotNull
    @NlsSafe
    private static String renderTooltip(@NotNull ClangIdeFacade facade2, @NlsSafe @NotNull String message, @Nullable List<String> notes, @NotNull PsiFile file, @NotNull ClangFileFacade fileFacade, @NotNull ClangUrlConverter converter) {
        if (facade2 == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(47);
        }
        if (message == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(48);
        }
        if (file == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(49);
        }
        if (fileFacade == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(50);
        }
        if (converter == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(51);
        }
        HtmlBuilder tooltip = new HtmlBuilder();
        tooltip.append(message);
        if (notes != null) {
            int counter = 0;
            for (String note : notes) {
                tooltip.br();
                if (++counter >= 32) {
                    tooltip.append("...");
                    break;
                }
                ClangPreparedNote clangNote = ClangErrorsAnnotatorPass.parseAndPrepareNote(facade2, note, file, fileFacade, converter);
                if (clangNote != null) {
                    tooltip.appendLink("#navigation/" + clangNote.path + ":" + clangNote.offset, StringUtil.shortenTextWithEllipsis((String)clangNote.message, (int)240, (int)0));
                    continue;
                }
                tooltip.append(note);
            }
        }
        String string = tooltip.wrapWithHtmlBody().toString();
        if (string == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(52);
        }
        return string;
    }

    @Nullable
    private static ClangPreparedNote parseAndPrepareNote(@NotNull ClangIdeFacade facade2, @NotNull String note, @NotNull PsiFile file, @NotNull ClangFileFacade fileFacade, @NotNull ClangUrlConverter converter) {
        if (facade2 == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(53);
        }
        if (note == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(54);
        }
        if (file == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(55);
        }
        if (fileFacade == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(56);
        }
        if (converter == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(57);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        ClangLanguageServiceUtils.ClangNote parsedNote = ClangLanguageServiceUtils.parseNote((String)note, (ClangUrlConverter)converter);
        if (parsedNote != null) {
            String path = parsedNote.path;
            if (path.contentEquals(file.getName())) {
                path = file.getVirtualFile().getPath();
            } else {
                if (path.contentEquals("<built-in>")) {
                    return null;
                }
                VirtualFile vf = CidrLangUtil.findBestFile((Project)file.getProject(), (String)parsedNote.path, (int)parsedNote.line, (int)parsedNote.character, candidate -> ClangdBridge.isInProjectSourcesOrLibraries((Project)file.getProject(), (VirtualFile)candidate));
                ClangFileFacade clangFileFacade = fileFacade = vf != null ? facade2.getFileFacade(vf) : null;
            }
            if (fileFacade == null) {
                ClangUtils.warnClangd((Logger)LOG, (String)("Failed to find a document for " + path));
                return null;
            }
            return new ClangPreparedNote(parsedNote.message, path, fileFacade.getLineStartOffset(Math.max(0, parsedNote.line - 1)) + Math.max(0, parsedNote.character - 1));
        }
        return null;
    }

    @NotNull
    public static HighlightInfo.Builder mergeHighlights(@NotNull HighlightInfo newHighlight, @NotNull HighlightInfo oldHighlight, @Nullable Document document, @Nullable EditorColorsScheme scheme) {
        TextAttributes textAttributes;
        ProblemGroup clangProblemGroup;
        if (newHighlight == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(58);
        }
        if (oldHighlight == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(59);
        }
        HighlightInfo.Builder mergedBuilder = HighlightInfo.newHighlightInfo((HighlightInfoType)newHighlight.type).range(new TextRange(newHighlight.startOffset, newHighlight.endOffset)).severity(newHighlight.getSeverity());
        if (newHighlight.getDescription() != null) {
            mergedBuilder.description(newHighlight.getDescription());
        }
        if (newHighlight.isAfterEndOfLine()) {
            mergedBuilder.endOfLine();
        }
        if (newHighlight.getToolTip() != null) {
            mergedBuilder.escapedToolTip(newHighlight.getToolTip());
        }
        if ((clangProblemGroup = newHighlight.getProblemGroup()) != null) {
            mergedBuilder.problemGroup(clangProblemGroup);
        }
        if (ClangErrorsAnnotatorPass.canApplyTextAttributes(textAttributes = oldHighlight.getTextAttributes(null, scheme), document, newHighlight.startOffset, newHighlight.endOffset)) {
            mergedBuilder.textAttributes(textAttributes);
        } else {
            textAttributes = newHighlight.getTextAttributes(null, scheme);
            if (ClangErrorsAnnotatorPass.canApplyTextAttributes(textAttributes, document, newHighlight.startOffset, newHighlight.endOffset)) {
                mergedBuilder.textAttributes(textAttributes);
            }
        }
        TextRange newRange = new TextRange(newHighlight.getStartOffset(), newHighlight.getEndOffset());
        oldHighlight.findRegisteredQuickFix((descriptor, __) -> {
            String displayName = descriptor.getDisplayName();
            HighlightDisplayKey displayKey = displayName != null ? HighlightDisplayKey.find((String)displayName) : null;
            mergedBuilder.registerFix(descriptor.getAction(), ClangErrorsAnnotatorPass.getSpecificSuppressOptions(clangProblemGroup), displayName, newRange, displayKey);
            return null;
        });
        HighlightInfo.Builder builder = mergedBuilder;
        if (builder == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(60);
        }
        return builder;
    }

    @Nullable
    private static List<IntentionAction> getSpecificSuppressOptions(@Nullable ProblemGroup problemGroup) {
        if (!(problemGroup instanceof ClangWarningProblemGroup)) {
            return null;
        }
        Object[] options = ((ClangWarningProblemGroup)problemGroup).getSuppressActions(null);
        return ContainerUtil.subArrayAsList((Object[])options, (int)0, (int)(options.length - 1));
    }

    private static boolean canApplyTextAttributes(@Nullable TextAttributes textAttributes, @Nullable Document document, int from, int to) {
        if (textAttributes == null) {
            return false;
        }
        if (document == null) {
            return true;
        }
        return ClangErrorsAnnotatorPass.hasVisibleUnderline(textAttributes) || ClangErrorsAnnotatorPass.hasVisibleCharacters(document, from, to);
    }

    private static boolean hasVisibleUnderline(@NotNull TextAttributes attributes) {
        if (attributes == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(61);
        }
        return attributes.getErrorStripeColor() != null;
    }

    private static boolean hasVisibleCharacters(@NotNull Document document, int from, int to) {
        if (document == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(62);
        }
        assert (from <= to) : "Why 'from' offset is greater than 'to' offset?";
        if (from == to) {
            return false;
        }
        CharSequence sequence = document.getImmutableCharSequence();
        for (int offset = from; offset < to; ++offset) {
            if (Character.isWhitespace(sequence.charAt(offset))) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 37, 41, 44, 52, 60 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 16: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restrictRange";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 5: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "future";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "waitingForWhat";
                break;
            }
            case 9: 
            case 12: 
            case 13: 
            case 19: 
            case 25: 
            case 47: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facade";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trustworthiness";
                break;
            }
            case 11: 
            case 18: 
            case 24: 
            case 30: 
            case 51: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
            case 14: 
            case 20: 
            case 26: 
            case 45: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diagnostic";
                break;
            }
            case 17: 
            case 23: 
            case 29: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 22: 
            case 28: 
            case 32: 
            case 50: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileFacade";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighting";
                break;
            }
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newHighlights";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldHighlightsMap";
                break;
            }
            case 37: 
            case 41: 
            case 44: 
            case 52: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/annotator/ClangErrorsAnnotatorPass";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 40: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diag";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "note";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newHighlight";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldHighlight";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/annotator/ClangErrorsAnnotatorPass";
                break;
            }
            case 37: 
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeHighlights";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "clangdSeverity2ProblemHighlightType";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlightInfoType";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "renderTooltip";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doCollectInformation";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "waitForClangFuture";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "makeAnnotations";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "makeHighlightings";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "makeAnnotation";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "makeSpecialAnnotation";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "makeSimpleAnnotation";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "makeHighlighting";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "updateHighlights";
                break;
            }
            case 35: 
            case 36: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "mergeHighlights";
                break;
            }
            case 37: 
            case 41: 
            case 44: 
            case 52: 
            case 60: {
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "isAnnotationAtEndOfLine";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "clangdSeverity2ProblemHighlightType";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getHighlightInfoType";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "isUnresolvedIdentifierDiagnostic";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "isDeprecationDiagnostic";
                break;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "renderTooltip";
                break;
            }
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "parseAndPrepareNote";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "hasVisibleUnderline";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "hasVisibleCharacters";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 37, 41, 44, 52, 60 -> new IllegalStateException(string);
        };
    }

    private static final class ClangPreparedNote {
        @NlsSafe
        @NotNull
        final String message;
        @NlsSafe
        @NotNull
        final String path;
        final int offset;

        private ClangPreparedNote(@NlsSafe @NotNull String message, @NlsSafe @NotNull String path, int offset) {
            if (message == null) {
                ClangPreparedNote.$$$reportNull$$$0(0);
            }
            if (path == null) {
                ClangPreparedNote.$$$reportNull$$$0(1);
            }
            this.message = message;
            this.path = path;
            this.offset = offset;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "message";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "path";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/annotator/ClangErrorsAnnotatorPass$ClangPreparedNote";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

