/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.performance;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.project.workspace.CidrWorkspaceManager;
import com.jetbrains.performancePlugin.commands.Waiter;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

public class OCWaitForSymbolsCommand
extends AbstractCommand {
    public static final String PREFIX = "%waitForSymbols";
    private static final Logger LOG = Logger.getInstance(OCWaitForSymbolsCommand.class);

    public OCWaitForSymbolsCommand(String text, int line) {
        super(text, line);
    }

    @NotNull
    protected Promise<Object> _execute(@NotNull PlaybackContext context) {
        if (context == null) {
            OCWaitForSymbolsCommand.$$$reportNull$$$0(0);
        }
        AsyncPromise result = new AsyncPromise();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            boolean success;
            try {
                success = Waiter.checkCondition(() -> OCWaitForSymbolsCommand.areSymbolsReady(context.getProject())).await(10L, TimeUnit.HOURS);
            }
            catch (InterruptedException e) {
                result.setError((Throwable)e);
                LOG.debug((Throwable)e);
                return;
            }
            result.setResult((Object)success);
        });
        AsyncPromise asyncPromise = result;
        if (asyncPromise == null) {
            OCWaitForSymbolsCommand.$$$reportNull$$$0(1);
        }
        return asyncPromise;
    }

    private static boolean areSymbolsReady(@NotNull Project project) {
        if (project == null) {
            OCWaitForSymbolsCommand.$$$reportNull$$$0(2);
        }
        return FileSymbolTablesCache.areSymbolsLoaded((Project)project) && CidrWorkspaceManager.getInstance((Project)project).getModelsAreReady() && !DumbService.isDumb((Project)project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/performance/OCWaitForSymbolsCommand";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/performance/OCWaitForSymbolsCommand";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "_execute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "_execute";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "areSymbolsReady";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

