/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculatorHelper;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCLanguageKindCalculatorBase {
    @Nullable
    public static OCLanguageKind tryPsiFile(@NotNull PsiFile file) {
        if (file == null) {
            OCLanguageKindCalculatorBase.$$$reportNull$$$0(0);
        }
        for (OCLanguageKindCalculatorHelper each : OCLanguageKindCalculatorBase.getHelpers()) {
            OCLanguageKind result = each.getLanguageByPsiFile(file);
            if (result == null) continue;
            return result;
        }
        return OCFileTypeHelpers.getLanguageKind((String)file.getVirtualFile().getName());
    }

    @Nullable
    public static OCLanguageKind calculateMinimalKindByExtension(@Nullable Project project, @NotNull String name) {
        OCLanguageKind result;
        if (name == null) {
            OCLanguageKindCalculatorBase.$$$reportNull$$$0(1);
        }
        if ((result = OCLanguageKindCalculatorBase.tryFileExtension(project, name)) != null) {
            return result;
        }
        return OCFileTypeHelpers.getLanguageKind((String)name);
    }

    @Nullable
    public static OCLanguageKind tryFileExtension(@Nullable Project project, @NotNull String name) {
        if (name == null) {
            OCLanguageKindCalculatorBase.$$$reportNull$$$0(2);
        }
        if (project == null) {
            return null;
        }
        for (OCLanguageKindCalculatorHelper each : OCLanguageKindCalculatorBase.getHelpers()) {
            OCLanguageKind result = each.getLanguageByExtension(project, name);
            if (result == null) continue;
            return result;
        }
        return !OCFileTypeHelpers.isHeaderFile((String)name) ? OCFileTypeHelpers.getLanguageKindStrict((String)name) : null;
    }

    @NotNull
    static List<OCLanguageKindCalculatorHelper> getHelpers() {
        List list = OCLanguageKindCalculatorHelper.EP_NAME.getExtensionList();
        if (list == null) {
            OCLanguageKindCalculatorBase.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Nullable
    static OCLanguageKind trySpecifiedFileType(@Nullable Project project, @Nullable VirtualFile file) {
        if (project == null || file == null) {
            return null;
        }
        for (OCLanguageKindCalculatorHelper each : OCLanguageKindCalculatorBase.getHelpers()) {
            OCLanguageKind result = each.getSpecifiedLanguage(project, file);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Nullable
    public static OCLanguageKind tryFileTypeAndExtension(@Nullable Project project, @Nullable VirtualFile file) {
        if (file == null) {
            return null;
        }
        OCLanguageKind result = OCLanguageKindCalculatorBase.trySpecifiedFileType(project, file);
        if (result != null) {
            return result;
        }
        result = OCLanguageKindCalculatorBase.tryFileExtension(project, file.getName());
        if (result != null) {
            return result;
        }
        return null;
    }

    @NotNull
    public static OCLanguageKind findLanguageKind(@Nullable Set<OCLanguageKind> enabledLanguageKinds, @NotNull String fileName, boolean isObjC) {
        if (fileName == null) {
            OCLanguageKindCalculatorBase.$$$reportNull$$$0(4);
        }
        boolean isCpp = OCLanguageKindCalculatorBase.isCppPreferred(enabledLanguageKinds, fileName);
        boolean isCuda = OCFileTypeHelpers.isCudaFile((String)fileName);
        OCLanguageKind oCLanguageKind = CLanguageKind.find((boolean)isObjC, (boolean)isCpp, (boolean)isCuda);
        if (oCLanguageKind == null) {
            OCLanguageKindCalculatorBase.$$$reportNull$$$0(5);
        }
        return oCLanguageKind;
    }

    public static boolean isObjCFile(@NotNull Project project, @Nullable VirtualFile vf) {
        OCLanguageKind languageKind;
        if (project == null) {
            OCLanguageKindCalculatorBase.$$$reportNull$$$0(6);
        }
        return (languageKind = OCLanguageKindCalculatorBase.tryFileTypeAndExtension(project, vf)) != null && languageKind.isObjC();
    }

    private static boolean isCppPreferred(@Nullable Set<OCLanguageKind> kinds, @NotNull String name) {
        if (name == null) {
            OCLanguageKindCalculatorBase.$$$reportNull$$$0(7);
        }
        return OCFileTypeHelpers.isCppFile((String)name) || ContainerUtil.isEmpty(kinds) || ContainerUtil.exists(kinds, OCLanguageKind::isCpp);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/workspace/OCLanguageKindCalculatorBase";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/workspace/OCLanguageKindCalculatorBase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelpers";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findLanguageKind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "tryPsiFile";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "calculateMinimalKindByExtension";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "tryFileExtension";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findLanguageKind";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isObjCFile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isCppPreferred";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5 -> new IllegalStateException(string);
        };
    }
}

