/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.formatting;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.jetbrains.cidr.lang.CidrLangBundle;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class CidrProjectWizardFilesFormatter {
    public static final ExtensionPointName<CidrProjectWizardFilesFormatter> EP_NAME = ExtensionPointName.create((String)"cidr.lang.projectWizardFilesFormatter");

    public abstract void reformatProjectFiles(@NotNull List<VirtualFile> var1, @NotNull Project var2);

    protected static boolean isSourceFile(@NotNull VirtualFile file) {
        if (file == null) {
            CidrProjectWizardFilesFormatter.$$$reportNull$$$0(0);
        }
        return OCFileTypeHelpers.isHeaderFile((String)file.getPath()) || OCFileTypeHelpers.isSourceFile((String)file.getPath());
    }

    protected static void reformatTextFiles(@NotNull Collection<VirtualFile> files, @NotNull Logger logger, @NotNull Project project) {
        if (files == null) {
            CidrProjectWizardFilesFormatter.$$$reportNull$$$0(1);
        }
        if (logger == null) {
            CidrProjectWizardFilesFormatter.$$$reportNull$$$0(2);
        }
        if (project == null) {
            CidrProjectWizardFilesFormatter.$$$reportNull$$$0(3);
        }
        for (VirtualFile file : files) {
            CidrProjectWizardFilesFormatter.reformatTextFile(file, logger, project);
        }
    }

    protected static void reformatTextFile(@NotNull VirtualFile file, @NotNull Logger logger, @NotNull Project project) {
        if (file == null) {
            CidrProjectWizardFilesFormatter.$$$reportNull$$$0(4);
        }
        if (logger == null) {
            CidrProjectWizardFilesFormatter.$$$reportNull$$$0(5);
        }
        if (project == null) {
            CidrProjectWizardFilesFormatter.$$$reportNull$$$0(6);
        }
        logger.assertTrue(ApplicationManager.getApplication().isWriteAccessAllowed());
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (psiFile != null) {
            CodeStyleManager.getInstance((Project)project).reformatText(psiFile, 0, psiFile.getTextLength());
        }
    }

    protected static void runFormatAction(@NotNull Project project, @NotNull Runnable formatRunnable) {
        if (project == null) {
            CidrProjectWizardFilesFormatter.$$$reportNull$$$0(7);
        }
        if (formatRunnable == null) {
            CidrProjectWizardFilesFormatter.$$$reportNull$$$0(8);
        }
        WriteCommandAction.runWriteCommandAction((Project)project, (String)CidrLangBundle.message("project.wizard.format.source.files", new Object[0]), null, (Runnable)formatRunnable, (PsiFile[])new PsiFile[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logger";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formatRunnable";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/formatting/CidrProjectWizardFilesFormatter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isSourceFile";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "reformatTextFiles";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "reformatTextFile";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "runFormatAction";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

