/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang;

import com.intellij.cidr.cpp.lexer.CidrLexerSettings;
import com.intellij.cidr.cpp.lexer.OCLexer;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.ui.HyperlinkLabel;
import com.jetbrains.cidr.PluginUtils;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageStandard;
import com.jetbrains.cidr.lang.lexer.OCLexerSettings;
import com.jetbrains.cidr.lang.parser.OCLexerTokenTypes;
import java.awt.Component;
import java.io.File;
import java.nio.file.Path;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CidrLangUtil {
    public static boolean enableObjectiveCSettings() {
        return PluginUtils.hasAppCode() || Registry.is((String)"clion.enable.objc.settings", (boolean)false);
    }

    @NotNull
    @NlsSafe
    public static String getOCLanguageDisplayName() {
        return CidrLangUtil.enableObjectiveCSettings() ? "C/C++/Objective-C" : "C/C++";
    }

    @NotNull
    public static HyperlinkLabel createLinkToConfigurable(@NlsContexts.LinkLabel @NotNull String hyperlinkText, final @NotNull Class<? extends Configurable> targetConfigurable, final @Nullable Predicate<? super Configurable> predicate, final @Nullable Consumer<? super Configurable> additionalConsumer) {
        if (hyperlinkText == null) {
            CidrLangUtil.$$$reportNull$$$0(0);
        }
        if (targetConfigurable == null) {
            CidrLangUtil.$$$reportNull$$$0(1);
        }
        final HyperlinkLabel hyperlinkLabel = new HyperlinkLabel(hyperlinkText);
        hyperlinkLabel.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                DataContext dataContext = DataManager.getInstance().getDataContext((Component)hyperlinkLabel);
                Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
                if (project != null) {
                    ShowSettingsUtil.getInstance().showSettingsDialog(project, c -> ConfigurableWrapper.cast((Class)targetConfigurable, (UnnamedConfigurable)c) != null && (predicate == null || predicate.test(c)), additionalConsumer);
                }
            }
        });
        HyperlinkLabel hyperlinkLabel2 = hyperlinkLabel;
        if (hyperlinkLabel2 == null) {
            CidrLangUtil.$$$reportNull$$$0(2);
        }
        return hyperlinkLabel2;
    }

    @NotNull
    @NlsSafe
    public static String getPrettyNameFromClassName(@NotNull Class<?> clazz) {
        if (clazz == null) {
            CidrLangUtil.$$$reportNull$$$0(3);
        }
        String className = clazz.getSimpleName();
        if (clazz.isAnonymousClass()) {
            className = clazz.getSuperclass().getSimpleName();
        }
        return CidrLangUtil.getPrettyNameFromClassName(className);
    }

    @NotNull
    public static String getPrettyNameFromClassName(@NotNull String className) {
        if (className == null) {
            CidrLangUtil.$$$reportNull$$$0(4);
        }
        StringBuilder result = new StringBuilder();
        className = StringUtil.trimStart((String)className, (String)"OC");
        className = StringUtil.trimEnd((String)className, (String)"Inspection");
        className = StringUtil.trimEnd((String)className, (String)"IntentionAction");
        for (String word : StringUtil.findMatches((String)className, (Pattern)Pattern.compile("([A-Z][a-z]*)"))) {
            if (!result.isEmpty()) {
                result.append(' ').append(StringUtil.decapitalize((String)word));
                continue;
            }
            result.append(word);
        }
        String string = result.toString();
        if (string == null) {
            CidrLangUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    public static void restartCodeAnalyzer() {
        Project[] openProjects;
        for (Project project : openProjects = ProjectManager.getInstance().getOpenProjects()) {
            if (!project.isInitialized() || project.isDisposed()) continue;
            DaemonCodeAnalyzerEx.getInstanceEx((Project)project).restart((Object)"CidrLangUtil.restartCodeAnalyzer");
        }
    }

    public static boolean isAcceptablePosition(@NotNull Document doc, int line, int column) {
        if (doc == null) {
            CidrLangUtil.$$$reportNull$$$0(6);
        }
        return line < doc.getLineCount() || line == 0 && column == 0;
    }

    @Nullable
    public static VirtualFile findBestFile(@NotNull Project project, @NotNull String path, int requestedLine, int requestedColumn, @NotNull Predicate<VirtualFile> fileAcceptor) {
        Document document;
        VirtualFile file;
        if (project == null) {
            CidrLangUtil.$$$reportNull$$$0(7);
        }
        if (path == null) {
            CidrLangUtil.$$$reportNull$$$0(8);
        }
        if (fileAcceptor == null) {
            CidrLangUtil.$$$reportNull$$$0(9);
        }
        long targetStamp = 0L;
        VirtualFile targetVirtualFile = null;
        for (VirtualFile file2 : LocalFileSystem.getInstance().findCachedFilesForPath(path)) {
            Document document2;
            if (!fileAcceptor.test(file2) || (document2 = FileDocumentManager.getInstance().getDocument(file2)) == null || requestedLine >= document2.getLineCount()) continue;
            if (targetVirtualFile == null) {
                targetVirtualFile = file2;
                targetStamp = document2.getModificationStamp();
                continue;
            }
            long curStamp = document2.getModificationStamp();
            if (curStamp <= targetStamp) continue;
            targetVirtualFile = file2;
            targetStamp = curStamp;
        }
        if (targetVirtualFile == null && (file = VfsUtil.findFile((Path)new File(path).toPath(), (boolean)false)) != null && (document = FileDocumentManager.getInstance().getDocument(file)) != null && CidrLangUtil.isAcceptablePosition(document, requestedLine, requestedColumn)) {
            targetVirtualFile = file;
        }
        return targetVirtualFile;
    }

    public static boolean isIdentifier(@NotNull String name, @NotNull OCLanguageKind kind, @Nullable OCLanguageStandard languageStandard) {
        if (name == null) {
            CidrLangUtil.$$$reportNull$$$0(10);
        }
        if (kind == null) {
            CidrLangUtil.$$$reportNull$$$0(11);
        }
        return CidrLangUtil.getTokenType(name, kind, languageStandard) == OCLexerTokenTypes.IDENTIFIER;
    }

    @Nullable
    public static IElementType getTokenType(@NotNull String name, @NotNull OCLanguageKind kind, @Nullable OCLanguageStandard languageStandard) {
        if (name == null) {
            CidrLangUtil.$$$reportNull$$$0(12);
        }
        if (kind == null) {
            CidrLangUtil.$$$reportNull$$$0(13);
        }
        CidrLexerSettings.Builder lexerSettings = OCLexerSettings.forLanguage(kind);
        if (languageStandard != null) {
            lexerSettings.setLanguageStandard(languageStandard);
        }
        OCLexer lexer = new OCLexer(lexerSettings.build());
        lexer.start((CharSequence)name);
        IElementType tt = lexer.getTokenType();
        lexer.advance();
        return lexer.getTokenType() == null ? tt : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hyperlinkText";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetConfigurable";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/CidrLangUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doc";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileAcceptor";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/CidrLangUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createLinkToConfigurable";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrettyNameFromClassName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createLinkToConfigurable";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPrettyNameFromClassName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptablePosition";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findBestFile";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isIdentifier";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getTokenType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5 -> new IllegalStateException(string);
        };
    }
}

