/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.CUDALanguageKind;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculatorBase;
import icons.CidrLangIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CidrFileIconProvider {
    private static Icon getHeaderIcon(@Nullable OCLanguageKind languageKind) {
        if (languageKind instanceof CUDALanguageKind) {
            return CidrLangIcons.FileTypes.Cuh;
        }
        return CidrLangIcons.FileTypes.H;
    }

    @Nullable
    public static Icon getIcon(@Nullable VirtualFile virtualFile, @NotNull String fileName, @Nullable Project project) {
        if (fileName == null) {
            CidrFileIconProvider.$$$reportNull$$$0(0);
        }
        boolean isHeaderFile = OCFileTypeHelpers.isHeaderFile((String)fileName);
        OCLanguageKind kind = null;
        if (virtualFile != null) {
            kind = OCLanguageKindCalculatorBase.tryFileTypeAndExtension(project, virtualFile);
        }
        if (kind == null) {
            kind = OCLanguageKindCalculatorBase.calculateMinimalKindByExtension(project, fileName);
        }
        if (isHeaderFile) {
            return CidrFileIconProvider.getHeaderIcon(kind);
        }
        if (kind instanceof CLanguageKind) {
            CLanguageKind cLanguageKind = (CLanguageKind)kind;
            return switch (cLanguageKind) {
                default -> throw new MatchException(null, null);
                case CLanguageKind.C -> CidrLangIcons.FileTypes.C;
                case CLanguageKind.CPP -> CidrLangIcons.FileTypes.Cpp;
                case CLanguageKind.OBJ_C, CLanguageKind.OBJ_CPP -> CidrLangIcons.FileTypes.M;
            };
        }
        if (kind instanceof CUDALanguageKind) {
            return CidrLangIcons.FileTypes.CU;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/jetbrains/cidr/lang/CidrFileIconProvider", "getIcon"));
    }
}

