/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.dfa.statistics;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.rml.dfa.DfaEvaluationStatus;
import com.intellij.rml.dfa.utils.measurements.DfaMeasurementKind;
import com.intellij.rml.dfa.utils.measurements.DfaSingleMeasurementResult;
import com.jetbrains.cidr.lang.dfa.statistics.DfaRunAggregationStatistics;
import com.jetbrains.cidr.lang.dfa.statistics.DfaRunInfoAggregator;
import com.jetbrains.cidr.lang.dfa.statistics.DfaStatisticsCollector;
import com.jetbrains.cidr.lang.dfa.statistics.DfaStatisticsMeasurement;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import org.HdrHistogram.Histogram;
import org.jetbrains.annotations.NotNull;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 &2\u00020\u0001:\u0001&B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J`\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0015H\u0002J\u0016\u0010\b\u001a\u00020\u001a2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\n\u001a\u00020\u000bJ,\u0010\u001e\u001a\u001e\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\r0 \u0012\u0004\u0012\u00020!0\u001fj\u0002`\"2\u0006\u0010\n\u001a\u00020\u000bH\u0002J0\u0010#\u001a\"\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\r0 \u0012\u0004\u0012\u00020!\u0018\u00010\u001fj\u0004\u0018\u0001`\"2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010$\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J8\u0010%\u001a\u00020!*\u001e\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\r0 \u0012\u0004\u0012\u00020!0\u001fj\u0002`\"2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/jetbrains/cidr/lang/dfa/statistics/DfaStatisticService;", "", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "recordRunInfo", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "status", "Lcom/intellij/rml/dfa/DfaEvaluationStatus;", "durationMs", "", "bddOpCount", "bddMem", "hasErrors", "", "domS", "", "domV", "domC", "domM", "domI", "Lkotlinx/coroutines/Job;", "measurement", "Lcom/jetbrains/cidr/lang/dfa/statistics/DfaStatisticsMeasurement;", "flushStatistics", "getOrCreateStatistics", "Ljava/util/concurrent/ConcurrentHashMap;", "Lkotlin/Pair;", "Lcom/jetbrains/cidr/lang/dfa/statistics/DfaRunInfoAggregator;", "Lcom/jetbrains/cidr/lang/dfa/statistics/DfaRunFileStatistics;", "getStatistics", "clearStatistics", "getAggregator", "Companion", "intellij.clion.dfa"})
@SourceDebugExtension(value={"SMAP\nDfaStatisticsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DfaStatisticsService.kt\ncom/jetbrains/cidr/lang/dfa/statistics/DfaStatisticService\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,173:1\n72#2,2:174\n1#3:176\n*S KotlinDebug\n*F\n+ 1 DfaStatisticsService.kt\ncom/jetbrains/cidr/lang/dfa/statistics/DfaStatisticService\n*L\n154#1:174,2\n154#1:176\n*E\n"})
public final class DfaStatisticService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private final ReentrantLock lock;
    @NotNull
    private static final Key<ConcurrentHashMap<Pair<Boolean, DfaEvaluationStatus>, DfaRunInfoAggregator>> KEY;
    @NotNull
    private static final Logger LOG;

    public DfaStatisticService(@NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.cs = cs;
        this.lock = new ReentrantLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void recordRunInfo(VirtualFile file, DfaEvaluationStatus status, long durationMs, long bddOpCount, long bddMem, boolean hasErrors, int domS, int domV, int domC, int domM, int domI) {
        Integer fileSize = (Integer)ReadAction.compute(() -> DfaStatisticService.recordRunInfo$lambda$0(file));
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            ConcurrentHashMap<Pair<Boolean, DfaEvaluationStatus>, DfaRunInfoAggregator> stats = this.getOrCreateStatistics(file);
            DfaRunInfoAggregator aggregator = this.getAggregator(stats, hasErrors, status);
            aggregator.addRunInfo(durationMs, bddOpCount, bddMem, fileSize.intValue(), domS, domV, domC, domM, domI);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        LOG.debug("Collect statistics for " + file.getName() + ": " + status + ", hasErrors=" + hasErrors + ", " + durationMs + " ms, " + bddMem + " byte, " + bddOpCount + " ops, " + (long)fileSize.intValue() + " loc, S=" + (long)domS + ", V=" + (long)domV + ", C=" + (long)domC + ", M=" + (long)domM + ", I=" + (long)domI);
    }

    @NotNull
    public final Job recordRunInfo(@NotNull VirtualFile file, @NotNull DfaStatisticsMeasurement measurement) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)((Object)measurement), (String)"measurement");
        return BuildersKt.launch$default((CoroutineScope)this.cs, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(measurement, file, null){
            int label;
            final /* synthetic */ DfaStatisticsMeasurement $measurement;
            final /* synthetic */ VirtualFile $file;
            {
                this.$measurement = $measurement;
                this.$file = $file;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        DfaSingleMeasurementResult.Status status = this.$measurement.getStatus();
                        if (status == null || (status = status.getValue()) == null) {
                            return Unit.INSTANCE;
                        }
                        DfaSingleMeasurementResult.Status status2 = status;
                        DfaSingleMeasurementResult.Numeric.ExecutionDuration executionDuration = this.$measurement.getTotalTime();
                        if (executionDuration == null) {
                            return Unit.INSTANCE;
                        }
                        long timeMs = executionDuration.getMillis();
                        DfaSingleMeasurementResult.Numeric.MemoryConsumption memoryConsumption = this.$measurement.getMemoryPeak();
                        if (memoryConsumption == null) {
                            return Unit.INSTANCE;
                        }
                        long memBytes = memoryConsumption.getBytes();
                        Object object = this.$measurement.getBddOps();
                        if (object == null || (object = object.getValue()) == null) {
                            return Unit.INSTANCE;
                        }
                        long bddOps = ((Number)object).longValue();
                        boolean hasErrors = this.$measurement.hasErrors();
                        Integer n = this.$measurement.getDomainSize((com.intellij.rml.dfa.utils.Key<DfaSingleMeasurementResult.Numeric>)DfaMeasurementKind.DomainSizes.Companion.getDOMAIN_S_SIZE());
                        if (n == null) {
                            return Unit.INSTANCE;
                        }
                        int domS = n;
                        Integer n2 = this.$measurement.getDomainSize((com.intellij.rml.dfa.utils.Key<DfaSingleMeasurementResult.Numeric>)DfaMeasurementKind.DomainSizes.Companion.getDOMAIN_V_SIZE());
                        if (n2 == null) {
                            return Unit.INSTANCE;
                        }
                        int domV = n2;
                        Integer n3 = this.$measurement.getDomainSize((com.intellij.rml.dfa.utils.Key<DfaSingleMeasurementResult.Numeric>)DfaMeasurementKind.DomainSizes.Companion.getDOMAIN_C_SIZE());
                        if (n3 == null) {
                            return Unit.INSTANCE;
                        }
                        int domC = n3;
                        Integer n4 = this.$measurement.getDomainSize((com.intellij.rml.dfa.utils.Key<DfaSingleMeasurementResult.Numeric>)DfaMeasurementKind.DomainSizes.Companion.getDOMAIN_M_SIZE());
                        if (n4 == null) {
                            return Unit.INSTANCE;
                        }
                        int domM = n4;
                        Integer n5 = this.$measurement.getDomainSize((com.intellij.rml.dfa.utils.Key<DfaSingleMeasurementResult.Numeric>)DfaMeasurementKind.DomainSizes.Companion.getDOMAIN_I_SIZE());
                        if (n5 == null) {
                            return Unit.INSTANCE;
                        }
                        int domI = n5;
                        boolean $i$f$service = false;
                        Class<DfaStatisticService> serviceClass$iv = DfaStatisticService.class;
                        Object object2 = ApplicationManager.getApplication().getService(serviceClass$iv);
                        if (object2 == null) {
                            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                        }
                        DfaStatisticService.access$recordRunInfo((DfaStatisticService)object2, this.$file, (DfaEvaluationStatus)status2, timeMs, bddOps, memBytes, hasErrors, domS, domV, domC, domM, domI);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @NotNull
    public final Job flushStatistics(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return BuildersKt.launch$default((CoroutineScope)this.cs, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, file, null){
            int label;
            final /* synthetic */ DfaStatisticService this$0;
            final /* synthetic */ VirtualFile $file;
            {
                this.this$0 = $receiver;
                this.$file = $file;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ConcurrentHashMap $i$a$-withLock-DfaStatisticService$flushStatistics$1$statMap$2;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object = DfaStatisticService.access$getLock$p(this.this$0);
                        Object[] objectArray = this.this$0;
                        Object object2 = this.$file;
                        object.lock();
                        try {
                            boolean bl = false;
                            ConcurrentHashMap statMap = DfaStatisticService.access$getStatistics((DfaStatisticService)objectArray, (VirtualFile)object2);
                            if (statMap == null) {
                                Unit unit = Unit.INSTANCE;
                                return unit;
                            }
                            DfaStatisticService.access$clearStatistics((DfaStatisticService)objectArray, (VirtualFile)object2);
                            $i$a$-withLock-DfaStatisticService$flushStatistics$1$statMap$2 = statMap;
                        }
                        finally {
                            object.unlock();
                        }
                        ConcurrentHashMap statMap = $i$a$-withLock-DfaStatisticService$flushStatistics$1$statMap$2;
                        objectArray = new Boolean[]{Boxing.boxBoolean((boolean)false), Boxing.boxBoolean((boolean)true)};
                        object = CollectionsKt.listOf((Object[])objectArray).iterator();
                        while (object.hasNext()) {
                            boolean hasErrors = (Boolean)object.next();
                            object2 = DfaEvaluationStatus.getEntries().iterator();
                            while (object2.hasNext()) {
                                DfaEvaluationStatus status;
                                DfaRunInfoAggregator aggregator = DfaStatisticService.access$getAggregator(this.this$0, statMap, hasErrors, status = (DfaEvaluationStatus)object2.next());
                                if (aggregator.getRecordCount() == 0) continue;
                                Histogram durationHist = aggregator.getDurationInMsRecorder().getIntervalHistogram();
                                Histogram memoryHist = aggregator.getMemoryUsageInByteRecorder().getIntervalHistogram();
                                String string = this.$file.getPath();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                                DfaRunAggregationStatistics stat = new DfaRunAggregationStatistics(string, status, hasErrors, aggregator.getRecordCount(), MathKt.roundToLong((double)durationHist.getMean()), durationHist.getMaxValue(), durationHist.getValueAtPercentile(95.0), MathKt.roundToLong((double)memoryHist.getMean()), memoryHist.getMaxValue(), memoryHist.getValueAtPercentile(95.0), MathKt.roundToLong((double)aggregator.getBddOpCountRecorder().getIntervalHistogram().getMean()), MathKt.roundToInt((double)aggregator.getFileLineCountRecorder().getIntervalHistogram().getMean()), MathKt.roundToInt((double)aggregator.getDomSRecorder().getIntervalHistogram().getMean()), MathKt.roundToInt((double)aggregator.getDomVRecorder().getIntervalHistogram().getMean()), MathKt.roundToInt((double)aggregator.getDomCRecorder().getIntervalHistogram().getMean()), MathKt.roundToInt((double)aggregator.getDomMRecorder().getIntervalHistogram().getMean()), MathKt.roundToInt((double)aggregator.getDomIRecorder().getIntervalHistogram().getMean()));
                                DfaStatisticsCollector.INSTANCE.log(stat);
                            }
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final ConcurrentHashMap<Pair<Boolean, DfaEvaluationStatus>, DfaRunInfoAggregator> getOrCreateStatistics(VirtualFile file) {
        ConcurrentHashMap statMap = (ConcurrentHashMap)file.getUserData(KEY);
        if (statMap == null) {
            ConcurrentHashMap<Pair<Boolean, DfaEvaluationStatus>, DfaRunInfoAggregator> result = new ConcurrentHashMap<Pair<Boolean, DfaEvaluationStatus>, DfaRunInfoAggregator>();
            file.putUserData(KEY, result);
            return result;
        }
        return statMap;
    }

    private final ConcurrentHashMap<Pair<Boolean, DfaEvaluationStatus>, DfaRunInfoAggregator> getStatistics(VirtualFile file) {
        return (ConcurrentHashMap)file.getUserData(KEY);
    }

    private final void clearStatistics(VirtualFile file) {
        file.putUserData(KEY, null);
    }

    /*
     * WARNING - void declaration
     */
    private final DfaRunInfoAggregator getAggregator(ConcurrentHashMap<Pair<Boolean, DfaEvaluationStatus>, DfaRunInfoAggregator> $this$getAggregator, boolean hasErrors, DfaEvaluationStatus status) {
        void $this$getOrPut$iv;
        ConcurrentMap concurrentMap = $this$getAggregator;
        Pair key$iv = TuplesKt.to((Object)hasErrors, (Object)status);
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(key$iv);
        if (object == null) {
            boolean bl = false;
            DfaRunInfoAggregator default$iv = new DfaRunInfoAggregator();
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        Intrinsics.checkNotNullExpressionValue(object, (String)"getOrPut(...)");
        return (DfaRunInfoAggregator)object;
    }

    private static final Integer recordRunInfo$lambda$0(VirtualFile $file) {
        Document doc;
        Document document = doc = FileDocumentManager.getInstance().getDocument($file);
        return document != null ? document.getLineCount() : 0;
    }

    public static final /* synthetic */ void access$recordRunInfo(DfaStatisticService $this, VirtualFile file, DfaEvaluationStatus status, long durationMs, long bddOpCount, long bddMem, boolean hasErrors, int domS, int domV, int domC, int domM, int domI) {
        $this.recordRunInfo(file, status, durationMs, bddOpCount, bddMem, hasErrors, domS, domV, domC, domM, domI);
    }

    public static final /* synthetic */ ReentrantLock access$getLock$p(DfaStatisticService $this) {
        return $this.lock;
    }

    public static final /* synthetic */ DfaRunInfoAggregator access$getAggregator(DfaStatisticService $this, ConcurrentHashMap $receiver, boolean hasErrors, DfaEvaluationStatus status) {
        return $this.getAggregator($receiver, hasErrors, status);
    }

    public static final /* synthetic */ ConcurrentHashMap access$getStatistics(DfaStatisticService $this, VirtualFile file) {
        return $this.getStatistics(file);
    }

    public static final /* synthetic */ void access$clearStatistics(DfaStatisticService $this, VirtualFile file) {
        $this.clearStatistics(file);
    }

    static {
        Key key = Key.create((String)"DFA_RUNS_INFO");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        KEY = key;
        Logger logger = Logger.getInstance(DfaStatisticService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R[\u0010\u0004\u001aO\u0012F\u0012D\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\u0004\u0012\u00020\n \f*\"\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\u0004\u0012\u00020\n\u0018\u00010\u0006j\u0004\u0018\u0001`\u000b0\u0006j\u0002`\u000b0\u0005\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/cidr/lang/dfa/statistics/DfaStatisticService$Companion;", "", "<init>", "()V", "KEY", "Lcom/intellij/openapi/util/Key;", "Ljava/util/concurrent/ConcurrentHashMap;", "Lkotlin/Pair;", "", "Lcom/intellij/rml/dfa/DfaEvaluationStatus;", "Lcom/jetbrains/cidr/lang/dfa/statistics/DfaRunInfoAggregator;", "Lcom/jetbrains/cidr/lang/dfa/statistics/DfaRunFileStatistics;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.clion.dfa"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

