/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.dfa.bridge;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.psi.OCStructuredBindingDeclaration;
import com.jetbrains.cidr.lang.psi.OCStructuredBindingList;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCRealType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCDFAUtils {
    public static String getTypeConstant(OCType type, Number value, @NotNull OCResolveContext context, @NotNull PsiFile file) {
        if (context == null) {
            OCDFAUtils.$$$reportNull$$$0(0);
        }
        if (file == null) {
            OCDFAUtils.$$$reportNull$$$0(1);
        }
        if (type instanceof OCIntType) {
            OCIntType intType = (OCIntType)type;
            if (value instanceof Long) {
                return Long.toString((Long)value);
            }
            if (value instanceof Double) {
                return Double.toString((Double)value);
            }
            int intValue = (Integer)value;
            if (OCIntType.isBool((OCType)type, (OCResolveContext)context)) {
                return intType.getValue(intValue != 0, context);
            }
            if (intType.isChar() && !Character.isISOControl((char)intValue) && intValue >= 0) {
                return "'" + (char)intValue + "'";
            }
        } else if (type instanceof OCStructType && ((OCStructType)type).isEnum()) {
            OCDeclaratorSymbol field = OCDFAUtils.getEnumField((OCStructType)type, value, file);
            if (field != null) {
                return "'" + field.getName() + "'";
            }
        } else {
            if (type.isPointer() && value instanceof Integer && (Integer)value == 0) {
                return type.getDefaultValue(context);
            }
            if (type instanceof OCRealType) {
                if (value instanceof Double) {
                    return Double.toString((Double)value);
                }
                if (value instanceof Integer) {
                    return Double.toString(((Integer)value).intValue());
                }
            }
        }
        return value.toString();
    }

    @Nullable
    public static OCDeclaratorSymbol getEnumField(OCStructType enumType, Number value, PsiFile file) {
        for (OCDeclaratorSymbol field : enumType.getFields()) {
            if (field.getKind() != OCSymbolKind.ENUM_CONST || !value.equals(OCExpressionEvaluator.evaluateEnumConst((OCSymbol)field, (PsiFile)file))) continue;
            return field;
        }
        return null;
    }

    @Nullable
    public static PsiElement getBindingDeclaration(@NotNull PsiElement el) {
        if (el == null) {
            OCDFAUtils.$$$reportNull$$$0(2);
        }
        return PsiTreeUtil.getParentOfType((PsiElement)PsiTreeUtil.getParentOfType((PsiElement)el, OCStructuredBindingList.class), OCStructuredBindingDeclaration.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "el";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/dfa/bridge/OCDFAUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getTypeConstant";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getBindingDeclaration";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

