/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.dfa;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.rml.dfa.AnalysisOptions;
import com.intellij.rml.dfa.DfaAnalysisRmlResult;
import com.intellij.rml.dfa.DfaRegistry;
import com.intellij.rml.dfa.DfaSessionProvider;
import com.intellij.rml.dfa.DfaSummarySession;
import com.intellij.rml.dfa.PathSensitiveMode;
import com.intellij.rml.dfa.attributes.Attribute;
import com.intellij.rml.dfa.attributes.DfaTuple;
import com.intellij.rml.dfa.ir.IrLocation;
import com.intellij.rml.dfa.ir.ast.IrFunctionID;
import com.intellij.rml.dfa.utils.Cancellation;
import com.intellij.rml.dfa.utils.FormatHelperKt;
import com.intellij.rml.dfa.utils.RMLOptions;
import com.intellij.rml.dfa.utils.graph.Graph;
import com.intellij.rml.dfa.utils.measurements.DfaMeasurementRunner;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIdeFacade;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangUrlConverter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdIndexerCustomTasksBuilder;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdIndexerService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionClangDFAConfigParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangParseResponse;
import com.jetbrains.cidr.lang.dfa.DFATuplesParserKt;
import com.jetbrains.cidr.lang.dfa.OCContextSensitiveBuilder;
import com.jetbrains.cidr.lang.dfa.OCDFAInput;
import com.jetbrains.cidr.lang.dfa.OCSourceGliderService;
import com.jetbrains.cidr.lang.dfa.statistics.DfaStatisticsMeasurement;
import com.jetbrains.cidr.lang.inspections.dfa.OCDFAInspectionConfigUtil;
import com.jetbrains.cidr.lang.settings.DfaMemoryLeakSettings;
import com.jetbrains.cidr.util.CidrConcurrentUtilsKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCDFAInspectionBaseRunner {
    protected static final Logger LOG = Logger.getInstance((String)OCDFAInspectionBaseRunner.class.getName());
    public static final Key<ProblemsHolder> TEST_PROBLEMS_HOLDER = Key.create((String)"TEST_PROBLEMS_HOLDER");
    public static final Key<List<VirtualFile>> TEST_SCOPE = Key.create((String)"TEST_SCOPE");
    public static final Key<String> GENERATE_IR = Key.create((String)"GENERATE_IR");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Pair<List<DfaTuple>, Map<Attribute, IrLocation>> getDFAInput(@NotNull VirtualFile file, boolean isBatchMode, ClangLanguageService languageService) {
        if (file == null) {
            OCDFAInspectionBaseRunner.$$$reportNull$$$0(0);
        }
        if (isBatchMode && languageService.isIndexer()) {
            ClangdIndexerService indexer = (ClangdIndexerService)languageService;
            ClangUrlConverter urlConverter = languageService.getUrlConverter();
            Ref parsedTuples = Ref.create();
            ClangdIndexerCustomTasksBuilder tasksBuilder = new ClangdIndexerCustomTasksBuilder(indexer);
            Map answers = (Map)ReadAction.computeCancellable(() -> {
                ClionClangDFAConfigParams dfaOptions = indexer.getClangIdeFacade().getDFAOptions(indexer.getContext().getProject(), file);
                return tasksBuilder.addDfaInput(dfaOptions, Collections.singletonList(file));
            });
            indexer.runCustomTasks(Collections.singletonList(file), tasksBuilder.create(), controllingFuture -> {
                try {
                    Stream tuplesStream = (Stream)CidrConcurrentUtilsKt.waitCancelAware((Future)((Future)answers.get(file)), (String)"dfa input");
                    if (tuplesStream == null) {
                        return;
                    }
                    parsedTuples.set(DFATuplesParserKt.parseDFATuples(tuplesStream.collect(Collectors.toList()), urlConverter));
                }
                catch (ExecutionException e) {
                    ClangUtils.logServerException((Logger)LOG, (String)e.getMessage(), (ExecutionException)e);
                }
                catch (Exception ex) {
                    if (ex instanceof ControlFlowException) {
                        ExceptionUtil.rethrow((Throwable)ex);
                    }
                    LOG.error((Throwable)ex);
                }
            });
            return (Pair)parsedTuples.get();
        }
        long timeStart = System.currentTimeMillis();
        ClangUrlConverter urlConverter = languageService.getUrlConverter();
        try {
            Pair tasksBuilder = (Pair)languageService.computeWithOpenedAndParsed(file, response -> {
                if (response == null) {
                    return null;
                }
                CompletableFuture dfaInputFuture = response.getDFAInput();
                ClangUtils.warnClangd((Logger)LOG, (String)("Starting clangd DFA: " + file.getName()));
                Supplier result = (Supplier)CidrConcurrentUtilsKt.waitCancelAndWriteActionAware((Future)dfaInputFuture, (long)Long.MAX_VALUE, (String)"dfaInput");
                if (result == null) {
                    return null;
                }
                int origDFAUsageInBytes = ClangParseResponse.getOriginalDFAMemoryUsage((CompletableFuture)dfaInputFuture);
                int compressedDFAUsageInBytes = ClangParseResponse.getCompressedDFAMemoryUsage((CompletableFuture)dfaInputFuture);
                ClangUtils.warnClangd((Logger)LOG, (String)("Received " + ClangUtils.renderHumanReadableSize((long)origDFAUsageInBytes) + " (compressed to " + ClangUtils.renderHumanReadableSize((long)compressedDFAUsageInBytes) + ") DFA inputs"));
                return DFATuplesParserKt.parseDFATuples((List)result.get(), urlConverter);
            });
            return tasksBuilder;
        }
        catch (CancellationException e) {
            ClangUtils.warnClangd((Logger)LOG, (String)("clangd DFA cancelled by service: " + e.getMessage()), (Throwable)e);
            Pair<List<DfaTuple>, Map<Attribute, IrLocation>> pair = null;
            return pair;
        }
        catch (TimeoutException e) {
            ClangUtils.warnClangd((Logger)LOG, (String)("clangd DFA timeout: " + file.getName()), (Throwable)e);
            Pair<List<DfaTuple>, Map<Attribute, IrLocation>> pair = null;
            return pair;
        }
        catch (ExecutionException e) {
            ClangUtils.logServerException((Logger)LOG, (String)e.getMessage(), (ExecutionException)e);
            Pair<List<DfaTuple>, Map<Attribute, IrLocation>> pair = null;
            return pair;
        }
        catch (Exception e) {
            if (!(e instanceof ControlFlowException)) {
                ClangUtils.warnClangd((Logger)LOG, (String)"clangd DFA exception: ", (Throwable)e);
            }
            Pair<List<DfaTuple>, Map<Attribute, IrLocation>> pair = null;
            return pair;
        }
        finally {
            long timeEnd = System.currentTimeMillis();
            ClangUtils.warnClangd((Logger)LOG, (String)("clangd DFA input builder finished: " + file.getName() + " - " + (double)(timeEnd - timeStart) / 1000.0 + " sec"));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static DfaAnalysisRmlResult computeDFA(@NotNull OCDFAInput dfaInput, Project project, long timeLimit, long perFunctionTimeLimit, long opCntLimit, int n, RMLOptions rMLOptions, @Nullable VirtualFile virtualFile) {
        void file;
        void options;
        void maxTasksPerTime;
        if (dfaInput == null) {
            OCDFAInspectionBaseRunner.$$$reportNull$$$0(1);
        }
        return OCDFAInspectionBaseRunner.computeDFA(dfaInput, project, timeLimit, perFunctionTimeLimit, opCntLimit, (int)maxTasksPerTime, (RMLOptions)options, null, (VirtualFile)file);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static DfaAnalysisRmlResult computeDFA(@NotNull OCDFAInput dfaInput, Project project, long timeLimit, long perFunctionTimeLimit, long opCntLimit, int maxTasksPerTime, RMLOptions rMLOptions, @Nullable DfaMeasurementRunner dfaMeasurementRunner, @Nullable VirtualFile virtualFile) {
        void benchmarkRunner;
        void options;
        void file;
        if (dfaInput == null) {
            OCDFAInspectionBaseRunner.$$$reportNull$$$0(2);
        }
        if (DfaRegistry.isLogEnabled()) {
            LOG.warn("DFA started; file: " + (file != null ? file.getName() : "null"));
        }
        long start2 = System.currentTimeMillis();
        options.set(AnalysisOptions.INSTANCE.getAnalysisTimeLimitMs(), (Object)timeLimit);
        options.set(AnalysisOptions.INSTANCE.getAnalysisOperationsCntLimit(), (Object)opCntLimit);
        options.set(AnalysisOptions.INSTANCE.getFunctionEvaluationTimeLimitMs(), (Object)perFunctionTimeLimit);
        if (maxTasksPerTime == -1) {
            maxTasksPerTime = (Integer)AnalysisOptions.INSTANCE.getMaxTasksPerTime().getDefaultValue();
        }
        options.set(AnalysisOptions.INSTANCE.getMaxTasksPerTime(), (Object)maxTasksPerTime);
        options.set(AnalysisOptions.INSTANCE.getEnableLogging(), (Object)DfaRegistry.isLogEnabled());
        if (file == null) {
            options.set(AnalysisOptions.INSTANCE.getUseDiskProvidersStorage(), (Object)true);
        }
        DfaSummarySession session = DfaSessionProvider.Companion.getInstance().createSummarySession(OCSourceGliderService.getInstance().getDescription(), project, (RMLOptions)options);
        if (file != null && Registry.is((String)"cidr.inspection.dfa.enable.fus")) {
            DfaStatisticsMeasurement statisticsMeasurement = new DfaStatisticsMeasurement(maxTasksPerTime, (VirtualFile)file);
            statisticsMeasurement.setHasErrors(ContainerUtil.exists((Iterable)dfaInput.getAllFunctionTuples().values(), tuple -> tuple.getRelation().equals("HasErrors")));
            session.registerMeasurement((DfaMeasurementRunner)statisticsMeasurement);
        }
        if (benchmarkRunner != null) {
            session.registerMeasurement((DfaMeasurementRunner)benchmarkRunner);
        }
        List<DfaTuple> globalTuples = OCContextSensitiveBuilder.Companion.getGlobalTuples(dfaInput.getCommonTuples());
        List<DfaTuple> predefinedTuples = OCContextSensitiveBuilder.Companion.getPredefinedTuples();
        Graph<Attribute> callGraph = OCContextSensitiveBuilder.Companion.buildCallGraph(dfaInput.getCommonTuples());
        HashMap<IrFunctionID, Map<PathSensitiveMode, List<DfaTuple>>> functions = new HashMap<IrFunctionID, Map<PathSensitiveMode, List<DfaTuple>>>();
        for (Attribute function : callGraph.nodes()) {
            if (function == null) continue;
            functions.put(new IrFunctionID(function), OCDFAInspectionBaseRunner.preprocessTuples(function, dfaInput.getFunctionTuples(function).stream().toList()));
        }
        DfaAnalysisRmlResult result = session.runDfaForProject(functions, globalTuples, predefinedTuples, callGraph, dfaInput.getLocations());
        if (DfaRegistry.isLogEnabled()) {
            LOG.warn("DFA finished in " + FormatHelperKt.formatDuration((long)(System.currentTimeMillis() - start2)) + "; total files size: " + FormatHelperKt.formatMemorySize((long)dfaInput.getFilesSize()) + "; file: " + (file != null ? file.getName() : "null"));
        }
        return result;
    }

    private static Map<PathSensitiveMode, List<DfaTuple>> preprocessTuples(Attribute function, List<DfaTuple> tuples) {
        HashMap<PathSensitiveMode, List<DfaTuple>> result = new HashMap<PathSensitiveMode, List<DfaTuple>>();
        OCContextSensitiveBuilder builder = new OCContextSensitiveBuilder(function, tuples, new Cancellation(){

            public void checkCancelled() throws CancellationException {
                ProgressManager.checkCanceled();
            }
        });
        for (PathSensitiveMode mode : PathSensitiveMode.getEntries()) {
            List<DfaTuple> list = builder.getTuples(mode == PathSensitiveMode.PathSensitive);
            if (list == null) continue;
            result.put(mode, list);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static OCDFAInput getDFAInput(@NotNull List<VirtualFile> files, Project project, boolean isBatchMode) {
        ClangdIndexerService languageService;
        if (files == null) {
            OCDFAInspectionBaseRunner.$$$reportNull$$$0(3);
        }
        ClangLanguageServiceProvider provider = Objects.requireNonNull(ClangLanguageServiceProvider.getProvider((Project)project));
        Object object = languageService = isBatchMode ? provider.getOrStartStatelessIndexer() : provider.getOrStart();
        if (isBatchMode && languageService == null) {
            languageService = provider.getOrStart();
        }
        if (languageService == null) {
            return null;
        }
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        boolean logEnabled = DfaRegistry.isLogEnabled();
        long startTime = System.currentTimeMillis();
        String activityName = "Building tuples in clangd";
        ClionClangDFAConfigParams batchModeClangParams = new ClionClangDFAConfigParams(OCDFAInspectionConfigUtil.isInspectHeaderFunctionsMode(null), -1, DfaMemoryLeakSettings.INSTANCE.getAllocatingFunctions(), DfaMemoryLeakSettings.INSTANCE.getDeallocatingFunctions());
        if (logEnabled) {
            LOG.warn(activityName + " started; files: " + files.stream().map(VirtualFile::getName).collect(Collectors.joining(", ")));
        }
        if (isBatchMode && languageService.isIndexer()) {
            ClangdIndexerService indexer = languageService;
            ClangUrlConverter urlConverter = languageService.getUrlConverter();
            DfaInputBuilder builder = new DfaInputBuilder();
            AtomicInteger processedFiles = new AtomicInteger(0);
            ClangdIndexerCustomTasksBuilder tasksBuilder = new ClangdIndexerCustomTasksBuilder(indexer);
            Map answers = (Map)ReadAction.computeCancellable(() -> tasksBuilder.addDfaInput(batchModeClangParams, files));
            List futures = ContainerUtil.map(answers.entrySet(), it -> {
                VirtualFile file = (VirtualFile)it.getKey();
                CompletableFuture resultFuture = (CompletableFuture)it.getValue();
                return ((CompletableFuture)resultFuture.thenApply(tuples -> tuples != null ? DFATuplesParserKt.parseDFATuples(tuples.collect(Collectors.toList()), urlConverter) : null)).thenAccept(input2 -> {
                    int processedCnt = processedFiles.incrementAndGet();
                    if (logEnabled) {
                        FormatHelperKt.logProgress((int)processedCnt, (int)files.size(), (long)startTime);
                    }
                    indicator.setText(OCInspectionsBundle.message((String)"dfa.message.preparing", (Object[])new Object[]{file.getName()}));
                    indicator.setFraction((double)processedCnt / (double)(files.size() * 3));
                    if (input2 != null) {
                        builder.addInput((Pair<List<DfaTuple>, Map<Attribute, IrLocation>>)input2, file);
                    }
                });
            });
            Ref result = Ref.create();
            indexer.runCustomTasks(files, tasksBuilder.create(), controllingFuture -> {
                try {
                    for (CompletableFuture future : futures) {
                        CidrConcurrentUtilsKt.waitCancelAware((Future)future, (String)"get dfa input");
                    }
                    if (logEnabled) {
                        LOG.warn(activityName + " finished; files: " + files.stream().map(VirtualFile::getName).collect(Collectors.joining(", ")));
                    }
                    result.set((Object)builder.build());
                }
                catch (ExecutionException e) {
                    LOG.error((Throwable)e);
                }
            });
            return (OCDFAInput)result.get();
        }
        DfaInputBuilder builder = new DfaInputBuilder();
        try {
            if (isBatchMode) {
                project.putUserData(ClangIdeFacade.CLANG_DFA_CONFIG, Optional.of(batchModeClangParams));
            }
            ClangdIndexerService finalLanguageService = languageService;
            Ref index = Ref.create((Object)0);
            FormatHelperKt.mapWithLogging(files, (boolean)logEnabled, (String)activityName, arg_0 -> OCDFAInspectionBaseRunner.lambda$getDFAInput$9(isBatchMode, (ClangLanguageService)finalLanguageService, indicator, index, files, builder, arg_0));
        }
        finally {
            if (isBatchMode) {
                project.putUserData(ClangIdeFacade.CLANG_DFA_CONFIG, null);
            }
        }
        return builder.build();
    }

    private static /* synthetic */ VirtualFile lambda$getDFAInput$9(boolean isBatchMode, ClangLanguageService finalLanguageService, ProgressIndicator indicator, Ref index, List files, DfaInputBuilder builder, VirtualFile file) {
        Pair<List<DfaTuple>, Map<Attribute, IrLocation>> curInput = OCDFAInspectionBaseRunner.getDFAInput(file, isBatchMode, finalLanguageService);
        indicator.setText(OCInspectionsBundle.message((String)"dfa.message.preparing", (Object[])new Object[]{file.getName()}));
        indicator.setFraction((double)((Integer)index.get()).intValue() / (double)(files.size() * 3));
        indicator.checkCanceled();
        builder.addInput(curInput, file);
        index.set((Object)((Integer)index.get() + 1));
        return file;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfaInput";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/dfa/OCDFAInspectionBaseRunner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getDFAInput";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "computeDFA";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class DfaInputBuilder {
        private final MultiMap<Attribute, DfaTuple> functionTuples = new MultiMap();
        private final List<DfaTuple> commonTuples = new ArrayList<DfaTuple>();
        private final Set<Attribute> processedFunctions = new HashSet<Attribute>();
        private final Map<Attribute, IrLocation> locations = new HashMap<Attribute, IrLocation>();
        long totalSize = 0L;

        private DfaInputBuilder() {
        }

        public void addInput(@Nullable Pair<List<DfaTuple>, Map<Attribute, IrLocation>> input2, VirtualFile file) {
            if (input2 == null) {
                return;
            }
            HashSet<Attribute> curFunctions = new HashSet<Attribute>();
            this.totalSize += new File(file.getPath()).length();
            this.locations.putAll((Map)input2.component2());
            for (DfaTuple tuple : (List)input2.component1()) {
                Attribute function = tuple.getFunction();
                if (function != null && this.processedFunctions.contains(function)) continue;
                curFunctions.add(function);
                if (function == null) {
                    this.commonTuples.add(tuple);
                    continue;
                }
                this.functionTuples.putValue((Object)function, (Object)tuple);
            }
            this.processedFunctions.addAll(curFunctions);
        }

        public OCDFAInput build() {
            return new OCDFAInput(this.functionTuples, this.commonTuples, this.locations, this.totalSize);
        }
    }
}

