/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.dfa;

import com.intellij.rml.dfa.attributes.Attribute;
import com.intellij.rml.dfa.attributes.DfaTuple;
import com.intellij.rml.dfa.ir.IrLocation;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class OCDFAInput {
    private final MultiMap<Attribute, DfaTuple> functionTuples;
    private final List<DfaTuple> commonTuples;
    private final Map<Attribute, IrLocation> locations;
    private final long filesSize;
    private static final String TooComplexRelationName = "TooComplex";

    public OCDFAInput(MultiMap<Attribute, DfaTuple> functionTuples, List<DfaTuple> commonTuples, Map<Attribute, IrLocation> locations, long size) {
        this.functionTuples = functionTuples;
        this.commonTuples = commonTuples;
        this.locations = locations;
        this.filesSize = size;
    }

    public MultiMap<Attribute, DfaTuple> getAllFunctionTuples() {
        return this.functionTuples;
    }

    public Collection<DfaTuple> getFunctionTuples(@NotNull Attribute function) {
        if (function == null) {
            OCDFAInput.$$$reportNull$$$0(0);
        }
        return this.functionTuples.get((Object)function);
    }

    public List<DfaTuple> getCommonTuples() {
        return this.commonTuples;
    }

    public List<DfaTuple> getAllTuples() {
        return Stream.concat(this.functionTuples.values().stream(), this.commonTuples.stream()).toList();
    }

    public boolean isEmpty() {
        return this.functionTuples.isEmpty() && this.commonTuples.isEmpty();
    }

    public Map<Attribute, IrLocation> getLocations() {
        return this.locations;
    }

    public long getFilesSize() {
        return this.filesSize;
    }

    public boolean isTooComplex() {
        return ContainerUtil.exists(this.commonTuples, tuple -> tuple.getRelation().equals(TooComplexRelationName));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/jetbrains/cidr/lang/dfa/OCDFAInput", "getFunctionTuples"));
    }
}

