/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.clion.perf;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Version;
import com.intellij.profiler.clion.CPPProfilerBundleKt;
import com.intellij.profiler.clion.ProfilerEnvironmentHost;
import com.intellij.profiler.clion.perf.PerfProfilerSettings;
import com.intellij.profiler.clion.perf.PerfSample;
import com.intellij.profiler.clion.perf.PerfScriptParser;
import com.intellij.profiler.clion.perf.PerfUtils;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/intellij/profiler/clion/perf/PerfScriptProcess;", "", "<init>", "()V", "Companion", "intellij.profiler.clion"})
@SourceDebugExtension(value={"SMAP\nPerfScriptProcess.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PerfScriptProcess.kt\ncom/intellij/profiler/clion/perf/PerfScriptProcess\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,59:1\n13#2:60\n*S KotlinDebug\n*F\n+ 1 PerfScriptProcess.kt\ncom/intellij/profiler/clion/perf/PerfScriptProcess\n*L\n18#1:60\n*E\n"})
public final class PerfScriptProcess {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(PerfScriptProcess.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JW\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2!\u0010\n\u001a\u001d\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00070\u000b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u0012\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/profiler/clion/perf/PerfScriptProcess$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "execute", "", "perfDataPath", "Ljava/nio/file/Path;", "onSampleParsed", "Lkotlin/Function1;", "Lcom/intellij/profiler/clion/perf/PerfSample;", "Lkotlin/ParameterName;", "name", "sample", "onFinish", "Lkotlin/Function0;", "project", "Lcom/intellij/openapi/project/Project;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "environmentHost", "Lcom/intellij/profiler/clion/ProfilerEnvironmentHost;", "isNoInlineSupported", "", "version", "Lcom/intellij/openapi/util/Version;", "intellij.profiler.clion"})
    public static final class Companion {
        private Companion() {
        }

        public final void execute(@NotNull Path perfDataPath, @NotNull Function1<? super PerfSample, Unit> onSampleParsed, @NotNull Function0<Unit> onFinish, @NotNull Project project, @NotNull ProgressIndicator indicator, @NotNull ProfilerEnvironmentHost environmentHost) {
            Intrinsics.checkNotNullParameter((Object)perfDataPath, (String)"perfDataPath");
            Intrinsics.checkNotNullParameter(onSampleParsed, (String)"onSampleParsed");
            Intrinsics.checkNotNullParameter(onFinish, (String)"onFinish");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            Intrinsics.checkNotNullParameter((Object)environmentHost, (String)"environmentHost");
            if (!Files.exists(perfDataPath, new LinkOption[0])) {
                LOG.warn("Cannot execute perf script: perf data is not found");
                onFinish.invoke();
                return;
            }
            Version perfVersion = PerfUtils.Companion.getPerfVersion(indicator, environmentHost, project);
            GeneralCommandLine cl = new GeneralCommandLine();
            String string = environmentHost.getEnvPath(PerfProfilerSettings.Companion.getInstance().getState().getExecutablePath(), project);
            if (string == null) {
                throw new ExecutionException(CPPProfilerBundleKt.profilerMessage("profiler.exception.perf.empty.path", new Object[0]));
            }
            cl.setExePath(string);
            String[] stringArray = new String[]{"script", "--fields", "comm,tid,ip,sym,dso"};
            cl.addParameters(stringArray);
            if (this.isNoInlineSupported(perfVersion) && !PerfProfilerSettings.Companion.getInstance().getState().getProcessInlineFunctions()) {
                cl.addParameter("--no-inline");
            }
            stringArray = new String[]{"-i", environmentHost.getEnvPath(((Object)perfDataPath).toString(), project)};
            cl.addParameters(stringArray);
            PerfScriptParser parser = new PerfScriptParser(onSampleParsed);
            BaseProcessHandler<?> processHandler = PerfUtils.Companion.createProcessHandler(cl, parser, environmentHost, project);
            processHandler.addProcessListener((ProcessListener)new ProcessAdapter(parser, onFinish){
                final /* synthetic */ PerfScriptParser $parser;
                final /* synthetic */ Function0<Unit> $onFinish;
                {
                    this.$parser = $parser;
                    this.$onFinish = $onFinish;
                }

                public void processWillTerminate(ProcessEvent event, boolean willBeDestroyed) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    this.$parser.finish();
                    this.$onFinish.invoke();
                }
            });
            environmentHost.runProcess((ProcessHandler)processHandler, indicator, -1, project);
        }

        private final boolean isNoInlineSupported(Version version) {
            return version != null && version.major >= 5;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

