/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.clion.perf;

import com.intellij.openapi.project.Project;
import com.intellij.profiler.api.BaseCallStackElement;
import com.intellij.profiler.clion.NavigatableSymbolSearcher;
import com.intellij.profiler.model.NativeCall;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.util.containers.Interner;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0011\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\u0005\u0010\tJ\b\u0010\n\u001a\u00020\u0003H\u0016J\u0006\u0010\u0004\u001a\u00020\u0003J\u001d\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013J\t\u0010\u0014\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c2\u0003J\u001d\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\f2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\rR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/profiler/clion/perf/NavigatableNativeCall;", "Lcom/intellij/profiler/api/BaseCallStackElement;", "library", "", "methodWithClassOrFunction", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "nativeCall", "Lcom/intellij/profiler/model/NativeCall;", "(Lcom/intellij/profiler/model/NativeCall;)V", "fullName", "isNavigatable", "", "()Z", "calcNavigatables", "", "Lcom/intellij/psi/NavigatablePsiElement;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)[Lcom/intellij/psi/NavigatablePsiElement;", "component1", "component2", "copy", "equals", "other", "", "hashCode", "", "toString", "Companion", "intellij.profiler.clion"})
public final class NavigatableNativeCall
extends BaseCallStackElement {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String library;
    @NotNull
    private final String methodWithClassOrFunction;
    private final boolean isNavigatable;
    @NotNull
    private final NativeCall nativeCall;

    public NavigatableNativeCall(@NotNull String library, @NotNull String methodWithClassOrFunction) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        Intrinsics.checkNotNullParameter((Object)methodWithClassOrFunction, (String)"methodWithClassOrFunction");
        this.library = library;
        this.methodWithClassOrFunction = methodWithClassOrFunction;
        this.isNavigatable = true;
        this.nativeCall = new NativeCall(this.library, this.methodWithClassOrFunction);
    }

    public NavigatableNativeCall(@NotNull NativeCall nativeCall) {
        Intrinsics.checkNotNullParameter((Object)nativeCall, (String)"nativeCall");
        this(nativeCall.getLibrary(), nativeCall.methodWithClassOrFunction());
    }

    @NotNull
    public String fullName() {
        return this.nativeCall.fullName();
    }

    @NotNull
    public final String methodWithClassOrFunction() {
        return this.nativeCall.methodWithClassOrFunction();
    }

    public boolean isNavigatable() {
        return this.isNavigatable;
    }

    @NotNull
    public NavigatablePsiElement[] calcNavigatables(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        NavigatablePsiElement[] navigatablePsiElementArray = NavigatableSymbolSearcher.findNavigatableSymbols(this.methodWithClassOrFunction, project);
        Intrinsics.checkNotNullExpressionValue((Object)navigatablePsiElementArray, (String)"findNavigatableSymbols(...)");
        return navigatablePsiElementArray;
    }

    private final String component1() {
        return this.library;
    }

    private final String component2() {
        return this.methodWithClassOrFunction;
    }

    @NotNull
    public final NavigatableNativeCall copy(@NotNull String library, @NotNull String methodWithClassOrFunction) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        Intrinsics.checkNotNullParameter((Object)methodWithClassOrFunction, (String)"methodWithClassOrFunction");
        return new NavigatableNativeCall(library, methodWithClassOrFunction);
    }

    public static /* synthetic */ NavigatableNativeCall copy$default(NavigatableNativeCall navigatableNativeCall, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = navigatableNativeCall.library;
        }
        if ((n & 2) != 0) {
            string2 = navigatableNativeCall.methodWithClassOrFunction;
        }
        return navigatableNativeCall.copy(string, string2);
    }

    @NotNull
    public String toString() {
        return "NavigatableNativeCall(library=" + this.library + ", methodWithClassOrFunction=" + this.methodWithClassOrFunction + ")";
    }

    public int hashCode() {
        int result = this.library.hashCode();
        result = result * 31 + this.methodWithClassOrFunction.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof NavigatableNativeCall)) {
            return false;
        }
        NavigatableNativeCall navigatableNativeCall = (NavigatableNativeCall)((Object)other);
        if (!Intrinsics.areEqual((Object)this.library, (Object)navigatableNativeCall.library)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.methodWithClassOrFunction, (Object)navigatableNativeCall.methodWithClassOrFunction);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0010\b\u0002\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/profiler/clion/perf/NavigatableNativeCall$Companion;", "", "<init>", "()V", "read", "Lcom/intellij/profiler/clion/perf/NavigatableNativeCall;", "string", "", "interner", "Lcom/intellij/util/containers/Interner;", "intellij.profiler.clion"})
    @SourceDebugExtension(value={"SMAP\nNavigatableNativeCall.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NavigatableNativeCall.kt\ncom/intellij/profiler/clion/perf/NavigatableNativeCall$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,39:1\n1#2:40\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final NavigatableNativeCall read(@NotNull String string, @Nullable Interner<String> interner) {
            NavigatableNativeCall navigatableNativeCall;
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            NativeCall nativeCall = NativeCall.Companion.read$default((NativeCall.Companion)NativeCall.Companion, (String)string, interner, null, (int)4, null);
            if (nativeCall != null) {
                NativeCall p0 = nativeCall;
                boolean bl = false;
                navigatableNativeCall = new NavigatableNativeCall(p0);
            } else {
                navigatableNativeCall = null;
            }
            return navigatableNativeCall;
        }

        public static /* synthetic */ NavigatableNativeCall read$default(Companion companion, String string, Interner interner, int n, Object object) {
            if ((n & 2) != 0) {
                interner = null;
            }
            return companion.read(string, (Interner<String>)interner);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

