/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.clion.dtrace;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.profiler.api.AttachFailedException;
import com.intellij.profiler.api.AttachableTargetProcess;
import com.intellij.profiler.api.ProfilerProcess;
import com.intellij.profiler.api.XLocalAttachProfiler;
import com.intellij.profiler.clion.CPPProfilerBundleKt;
import com.intellij.profiler.clion.DTraceProfilerConfigurationExtensionKt;
import com.intellij.profiler.clion.NativeTargetProcess;
import com.intellij.profiler.clion.dtrace.CPPDTraceProfilerProcess;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u000e\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u00100\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lcom/intellij/profiler/clion/dtrace/DTraceAttachProfiler;", "Lcom/intellij/profiler/api/XLocalAttachProfiler;", "processInfo", "Lcom/intellij/execution/process/ProcessInfo;", "<init>", "(Lcom/intellij/execution/process/ProcessInfo;)V", "profilerDisplayName", "", "getProfilerDisplayName", "()Ljava/lang/String;", "targetProcess", "Lcom/intellij/profiler/clion/NativeTargetProcess;", "getTargetProcess", "()Lcom/intellij/profiler/clion/NativeTargetProcess;", "attachProfiler", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/profiler/api/ProfilerProcess;", "Lcom/intellij/profiler/api/AttachableTargetProcess;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.profiler.clion"})
@SourceDebugExtension(value={"SMAP\nDTraceAttachProfiler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DTraceAttachProfiler.kt\ncom/intellij/profiler/clion/dtrace/DTraceAttachProfiler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,29:1\n1#2:30\n*E\n"})
public final class DTraceAttachProfiler
implements XLocalAttachProfiler {
    @NotNull
    private final String profilerDisplayName;
    @NotNull
    private final NativeTargetProcess targetProcess;

    public DTraceAttachProfiler(@NotNull ProcessInfo processInfo) {
        Intrinsics.checkNotNullParameter((Object)processInfo, (String)"processInfo");
        this.profilerDisplayName = "DTrace profiler";
        this.targetProcess = new NativeTargetProcess(processInfo);
    }

    @NotNull
    public String getProfilerDisplayName() {
        return this.profilerDisplayName;
    }

    @NotNull
    public NativeTargetProcess getTargetProcess() {
        return this.targetProcess;
    }

    @NotNull
    public Promise<? extends ProfilerProcess<? extends AttachableTargetProcess>> attachProfiler(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!SystemInfo.isMac) {
            return Promises.rejectedPromise((Throwable)((Throwable)new AttachFailedException(CPPProfilerBundleKt.profilerMessage("profiler.exception.not.supported.so", new Object[0]))));
        }
        ExecutionException executionException = DTraceProfilerConfigurationExtensionKt.validateDTraceSettings(project);
        if (executionException != null) {
            ExecutionException it = executionException;
            boolean bl = false;
            return Promises.rejectedPromise((Throwable)it);
        }
        AttachableTargetProcess attachableTargetProcess = this.getTargetProcess();
        PerformInBackgroundOption performInBackgroundOption = PerformInBackgroundOption.DEAF;
        Intrinsics.checkNotNullExpressionValue((Object)performInBackgroundOption, (String)"DEAF");
        return CPPDTraceProfilerProcess.Companion.attach(attachableTargetProcess, performInBackgroundOption, 10000, project);
    }
}

