/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.profiling.sanitizers;

import com.intellij.cidr.profiling.memory.MemoryProfileUtil;
import com.intellij.cidr.profiling.memory.error.MemoryProfileFrame;
import com.intellij.clion.profiling.sanitizers.SanitizersKind;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.cpp.execution.CidrExecutionUtil;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCRunConfiguration;
import com.jetbrains.cidr.lang.workspace.compiler.AppleClangCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.ClangClCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.ClangCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.GCCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SanitizersUtil {
    @NonNls
    public static final String STACK_TRACE_FORMAT_SEPARATOR = "###";
    @NonNls
    public static final String STACK_TRACE_FORMAT = StringUtil.join(Arrays.asList("pc_%p", "func_%f", "file_%s", "line_%l", "obj_%M"), (String)"###");
    public static final Version MIN_CLANG_VERSION = new Version(3, 8, 0);
    public static final Version MIN_APPLE_CLANG_VERSION = new Version(8, 0, 0);
    public static final Version MIN_GCC_VERSION = new Version(5, 0, 0);

    private SanitizersUtil() {
    }

    public static NotificationGroup getNotificationGroup() {
        return NotificationGroupManager.getInstance().getNotificationGroup("Sanitizers");
    }

    @Nullable
    public static SanitizersKind getSanitizerKindFromSwitch(@NotNull String compilerSwitch) {
        String kind;
        if (compilerSwitch == null) {
            SanitizersUtil.$$$reportNull$$$0(0);
        }
        if (!compilerSwitch.startsWith("-fsanitize=")) {
            return null;
        }
        return switch (kind = compilerSwitch.substring(compilerSwitch.indexOf(61) + 1)) {
            case "address" -> SanitizersKind.ADDRESS_SANITIZER;
            case "leak" -> SanitizersKind.LEAK_SANITIZER;
            case "memory" -> SanitizersKind.MEMORY_SANITIZER;
            case "thread" -> SanitizersKind.THREAD_SANITIZER;
            case "undefined" -> SanitizersKind.UNDEFINED_BEHAVIOR_SANITIZER;
            default -> null;
        };
    }

    public static boolean compiledWithSanitizeSwitch(@NotNull OCRunConfiguration applicableConfiguration) {
        if (applicableConfiguration == null) {
            SanitizersUtil.$$$reportNull$$$0(1);
        }
        return CidrExecutionUtil.compiledWithCompilerSwitches((OCRunConfiguration)applicableConfiguration, List.of("-fsanitize="));
    }

    public static boolean compilerSupported(@NotNull OCResolveConfiguration configuration, @NotNull OCLanguageKind languageKind, @NotNull OCCompilerKind compilerKind) {
        if (configuration == null) {
            SanitizersUtil.$$$reportNull$$$0(2);
        }
        if (languageKind == null) {
            SanitizersUtil.$$$reportNull$$$0(3);
        }
        if (compilerKind == null) {
            SanitizersUtil.$$$reportNull$$$0(4);
        }
        if (compilerKind != ClangCompilerKind.INSTANCE && compilerKind != AppleClangCompilerKind.INSTANCE && compilerKind != GCCCompilerKind.INSTANCE && compilerKind != ClangClCompilerKind.INSTANCE) {
            return false;
        }
        List defines = configuration.getCompilerSettings(languageKind).getPreprocessorDefines();
        int major = 0;
        int minor = 0;
        if (compilerKind == ClangCompilerKind.INSTANCE || compilerKind == AppleClangCompilerKind.INSTANCE || compilerKind == ClangClCompilerKind.INSTANCE) {
            for (String define : defines) {
                if (define.contains("__clang_major__")) {
                    major = SanitizersUtil.parseVersionFromMacro(define);
                    continue;
                }
                if (!define.contains("__clang_minor__")) continue;
                minor = SanitizersUtil.parseVersionFromMacro(define);
            }
            Version version = new Version(major, minor, 0);
            return version.isOrGreaterThan(Integer.valueOf(SanitizersUtil.MIN_CLANG_VERSION.major), Integer.valueOf(SanitizersUtil.MIN_CLANG_VERSION.minor)) || version.isOrGreaterThan(Integer.valueOf(SanitizersUtil.MIN_APPLE_CLANG_VERSION.major), Integer.valueOf(SanitizersUtil.MIN_APPLE_CLANG_VERSION.minor));
        }
        for (String define : defines) {
            if (define.contains("__GNUC__")) {
                major = SanitizersUtil.parseVersionFromMacro(define);
                continue;
            }
            if (!define.contains("__GNUC_MINOR__")) continue;
            minor = SanitizersUtil.parseVersionFromMacro(define);
        }
        Version version = new Version(major, minor, 0);
        return version.isOrGreaterThan(Integer.valueOf(SanitizersUtil.MIN_GCC_VERSION.major), Integer.valueOf(SanitizersUtil.MIN_GCC_VERSION.minor));
    }

    private static int parseVersionFromMacro(@NotNull String define) {
        List defineParts;
        if (define == null) {
            SanitizersUtil.$$$reportNull$$$0(5);
        }
        return (defineParts = StringUtil.split((String)define, (String)" ")).size() == 3 ? StringUtil.parseInt((String)((String)defineParts.get(2)), (int)0) : 0;
    }

    @Nullable
    public static MemoryProfileFrame readFrameFromText(@NotNull String frameText, @NotNull CidrToolEnvironment environment, @Nullable File workingDirectory, @NotNull Project project) {
        if (frameText == null) {
            SanitizersUtil.$$$reportNull$$$0(6);
        }
        if (environment == null) {
            SanitizersUtil.$$$reportNull$$$0(7);
        }
        if (project == null) {
            SanitizersUtil.$$$reportNull$$$0(8);
        }
        List frameParts = StringUtil.split((String)frameText, (String)STACK_TRACE_FORMAT_SEPARATOR);
        if ((frameParts = ContainerUtil.map((Collection)frameParts, part -> part.trim())).size() != 5) {
            return null;
        }
        HashSet emptyValues = ContainerUtil.newHashSet((Object[])new String[]{"<null>", "0", "??", ""});
        MemoryProfileFrame frame = new MemoryProfileFrame();
        for (String part2 : frameParts) {
            String obj;
            if (part2.startsWith("pc_")) {
                String pc = part2.substring("pc_".length());
                if (emptyValues.contains(pc)) continue;
                frame.setInstructionPointer(pc);
                continue;
            }
            if (part2.startsWith("func_")) {
                String function = part2.substring("func_".length());
                if (emptyValues.contains(function)) continue;
                frame.setFunction(function);
                continue;
            }
            if (part2.startsWith("file_")) {
                String rawFilePath = part2.substring("file_".length());
                File rawFile = new File(rawFilePath);
                String fileName = StringUtil.notNullize((String)rawFile.getName());
                if (!emptyValues.contains(fileName)) {
                    frame.setFile(fileName);
                }
                String directory = null;
                String resolvedLocalDirectory = null;
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    resolvedLocalDirectory = directory = rawFile.getParent();
                } else if (FileUtil.exists((String)rawFilePath)) {
                    resolvedLocalDirectory = directory = SanitizersUtil.getAbsoluteDirectoryPath(rawFile);
                } else if (FileUtil.exists((String)environment.toLocalPath(rawFilePath))) {
                    localFile = new File(environment.toLocalPath(rawFilePath));
                    resolvedLocalDirectory = directory = SanitizersUtil.getAbsoluteDirectoryPath(localFile);
                } else if (FileUtil.exists((String)environment.toLocalPath(workingDirectory, rawFilePath))) {
                    localFile = new File(environment.toLocalPath(workingDirectory, rawFilePath));
                    resolvedLocalDirectory = directory = SanitizersUtil.getAbsoluteDirectoryPath(localFile);
                } else {
                    String resolvedPath;
                    VirtualFile projectFile = SanitizersUtil.findProjectFileByFileName(fileName, project);
                    if (projectFile != null) {
                        String dirPath = projectFile.getParent().getPath();
                        directory = StringUtil.notNullize((String)dirPath);
                        resolvedLocalDirectory = dirPath;
                    } else if (!emptyValues.contains(rawFilePath) && StringUtil.isNotEmpty((String)(resolvedPath = SanitizersUtil.resolvePath(rawFilePath, workingDirectory, environment)))) {
                        directory = new File(rawFilePath).getParent();
                        resolvedLocalDirectory = new File(resolvedPath).getParent();
                    }
                }
                if (!StringUtil.isNotEmpty((String)directory) || emptyValues.contains(directory)) continue;
                frame.setDirectory(directory);
                frame.setResolvedLocalDirectory(resolvedLocalDirectory);
                continue;
            }
            if (part2.startsWith("line_")) {
                String line = part2.substring("line_".length());
                if (emptyValues.contains(line)) continue;
                frame.setLine(line);
                continue;
            }
            if (!part2.startsWith("obj_") || emptyValues.contains(obj = part2.substring("obj_".length()))) continue;
            frame.setBinary(obj);
        }
        return frame;
    }

    public static String resolvePath(@NotNull String path, @Nullable File workingDirectory, @NotNull CidrToolEnvironment environment) {
        if (path == null) {
            SanitizersUtil.$$$reportNull$$$0(9);
        }
        if (environment == null) {
            SanitizersUtil.$$$reportNull$$$0(10);
        }
        if (!path.contains("..")) {
            return MemoryProfileUtil.tryResolvePath(path, environment);
        }
        if (workingDirectory == null) {
            return null;
        }
        String workingDirectoryEnvPath = environment.toEnvPath(workingDirectory.getPath());
        String pathToResolve = FileUtil.join((String[])new String[]{workingDirectoryEnvPath, path});
        return MemoryProfileUtil.tryResolvePath(pathToResolve, environment);
    }

    public static VirtualFile findProjectFileByFileName(@NotNull String fileName, @NotNull Project project) {
        if (fileName == null) {
            SanitizersUtil.$$$reportNull$$$0(11);
        }
        if (project == null) {
            SanitizersUtil.$$$reportNull$$$0(12);
        }
        GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)project);
        return (VirtualFile)ReadAction.compute(() -> FilenameIndex.firstVirtualFileWithName((String)fileName, (boolean)true, (GlobalSearchScope)scope, null));
    }

    @NotNull
    public static String writeFrameToText(@NotNull MemoryProfileFrame frame) {
        if (frame == null) {
            SanitizersUtil.$$$reportNull$$$0(13);
        }
        return SanitizersUtil.writeFrameToText(frame, "");
    }

    @NotNull
    public static String writeFrameToText(@NotNull MemoryProfileFrame frame, @NotNull String emptyValue) {
        if (frame == null) {
            SanitizersUtil.$$$reportNull$$$0(14);
        }
        if (emptyValue == null) {
            SanitizersUtil.$$$reportNull$$$0(15);
        }
        Map<String, String> placeholderToValueMap = Map.of("%p", StringUtil.notNullize((String)frame.getInstructionPointer(), (String)emptyValue), "%f", StringUtil.notNullize((String)frame.getFunction(), (String)emptyValue), "%s", StringUtil.isNotEmpty((String)frame.getFile()) && StringUtil.isNotEmpty((String)frame.getDirectory()) ? FileUtil.join((String[])new String[]{frame.getDirectory(), frame.getFile()}) : emptyValue, "%l", StringUtil.notNullize((String)frame.getLine(), (String)emptyValue), "%M", StringUtil.notNullize((String)frame.getBinary(), (String)emptyValue));
        StringBuilder builder = new StringBuilder(STACK_TRACE_FORMAT);
        for (Map.Entry<String, String> entry : placeholderToValueMap.entrySet()) {
            int startIndex = builder.indexOf(entry.getKey());
            builder.replace(startIndex, startIndex + entry.getKey().length(), entry.getValue());
        }
        String string = builder.toString();
        if (string == null) {
            SanitizersUtil.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    public static String modifyOptions(@NotNull String options, @NotNull String key, @NotNull String value) {
        if (options == null) {
            SanitizersUtil.$$$reportNull$$$0(17);
        }
        if (key == null) {
            SanitizersUtil.$$$reportNull$$$0(18);
        }
        if (value == null) {
            SanitizersUtil.$$$reportNull$$$0(19);
        }
        ArrayList<Object> modifiedFlags = new ArrayList<Object>();
        for (String flag : StringUtil.split((String)options, (String)" ")) {
            if (flag.startsWith(key)) continue;
            modifiedFlags.add(flag);
        }
        modifiedFlags.add(key + "=" + value);
        String string = StringUtil.join(modifiedFlags, (String)" ");
        if (string == null) {
            SanitizersUtil.$$$reportNull$$$0(20);
        }
        return string;
    }

    @NotNull
    private static String getAbsoluteDirectoryPath(@NotNull File file) {
        if (file == null) {
            SanitizersUtil.$$$reportNull$$$0(21);
        }
        String string = StringUtil.notNullize((String)FileUtil.toCanonicalPath((String)file.getParent()));
        if (string == null) {
            SanitizersUtil.$$$reportNull$$$0(22);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 16, 20, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilerSwitch";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicableConfiguration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageKind";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilerKind";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "define";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameText";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "emptyValue";
                break;
            }
            case 16: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/clion/profiling/sanitizers/SanitizersUtil";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/clion/profiling/sanitizers/SanitizersUtil";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "writeFrameToText";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "modifyOptions";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getAbsoluteDirectoryPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSanitizerKindFromSwitch";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "compiledWithSanitizeSwitch";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "compilerSupported";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parseVersionFromMacro";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "readFrameFromText";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "resolvePath";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findProjectFileByFileName";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "writeFrameToText";
                break;
            }
            case 16: 
            case 20: 
            case 22: {
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "modifyOptions";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getAbsoluteDirectoryPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 16, 20, 22 -> new IllegalStateException(string);
        };
    }
}

