/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.profiling.sanitizers;

import com.intellij.clion.profiling.sanitizers.SanitizersKind;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="SanitizersSettings", storages={@Storage(value="other.xml")})
public class SanitizersSettings
implements PersistentStateComponent<SanitizersSettings> {
    private boolean myUseVisualRepresentation = true;
    private Map<SanitizersKind, String> mySanitizersFlags = new HashMap<SanitizersKind, String>();

    public SanitizersSettings() {
        for (SanitizersKind sanitizer : SanitizersKind.values()) {
            this.mySanitizersFlags.put(sanitizer, SanitizersSettings.getDefaultFlags(sanitizer));
        }
    }

    public boolean isUseVisualRepresentation() {
        return this.myUseVisualRepresentation;
    }

    public void setUseVisualRepresentation(boolean useVisualRepresentation) {
        this.myUseVisualRepresentation = useVisualRepresentation;
    }

    public Map<SanitizersKind, String> getSanitizersFlags() {
        return this.mySanitizersFlags;
    }

    public void setSanitizersFlags(Map<SanitizersKind, String> sanitizersFlags) {
        this.mySanitizersFlags = new HashMap<SanitizersKind, String>(sanitizersFlags);
    }

    @Nullable
    public SanitizersSettings getState() {
        return this;
    }

    public void loadState(@NotNull SanitizersSettings state) {
        if (state == null) {
            SanitizersSettings.$$$reportNull$$$0(0);
        }
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
    }

    @NotNull
    public static SanitizersSettings getInstance() {
        SanitizersSettings sanitizersSettings = (SanitizersSettings)ApplicationManager.getApplication().getService(SanitizersSettings.class);
        if (sanitizersSettings == null) {
            SanitizersSettings.$$$reportNull$$$0(1);
        }
        return sanitizersSettings;
    }

    private static String getDefaultFlags(@NotNull SanitizersKind sanitizer) {
        if (sanitizer == null) {
            SanitizersSettings.$$$reportNull$$$0(2);
        }
        if (sanitizer == SanitizersKind.ADDRESS_SANITIZER) {
            return "detect_stack_use_after_return=false";
        }
        return "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/clion/profiling/sanitizers/SanitizersSettings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sanitizer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/clion/profiling/sanitizers/SanitizersSettings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultFlags";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

