/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.profiling.sanitizers;

import com.intellij.cidr.profiling.memory.MemoryProfileTreeDataModel;
import com.intellij.cidr.profiling.memory.error.MemoryProfileError;
import com.intellij.cidr.profiling.memory.error.MemoryProfileFrame;
import com.intellij.cidr.profiling.memory.error.MemoryProfileProblemDescription;
import com.intellij.clion.profiling.sanitizers.SanitizerFatalErrorKind;
import com.intellij.clion.profiling.sanitizers.SanitizersUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import java.io.File;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SanitizerOutputConsumer
implements Consumer<String> {
    @RegExp
    private static final String ID = "(?:[0-9]+)";
    @RegExp
    private static final String SANITIZER = "[A-Za-z]+Sanitizer";
    private static final Pattern[] BEGIN_PATTERNS = new Pattern[]{Pattern.compile("^((?:==(?:[0-9]+)==)?(?:ERROR|WARNING): [A-Za-z]+Sanitizer:) .*$"), Pattern.compile("^((?:.*) runtime error: )(.*)")};
    private static final Pattern[] END_PATTERNS = new Pattern[]{Pattern.compile("==(?:[0-9]+)==ABORTING"), Pattern.compile("[A-Za-z]+Sanitizer: reported .*"), Pattern.compile("Exiting"), Pattern.compile("SUMMARY: [A-Za-z]+Sanitizer: .*")};
    private static final Pattern DEBUG_FATAL_ERROR_NOTE_PATTERN = Pattern.compile(".*HINT: LeakSanitizer does not work under ptrace \\(strace, gdb, etc\\)");
    private static final Pattern FATAL_ERROR_PATTERN = Pattern.compile("==[0-9]+==.* has encountered a fatal error.");
    @NotNull
    private final MemoryProfileTreeDataModel myDataModel;
    @NotNull
    private final CidrToolEnvironment myEnvironment;
    @Nullable
    private final File myWorkingDirectory;
    @NotNull
    private final Project myProject;
    @Nullable
    private MemoryProfileError myCurrentError;
    @NotNull
    private String myPreviousLine;
    @Nullable
    private SanitizerFatalErrorKind myFatalErrorKind;

    public SanitizerOutputConsumer(@NotNull MemoryProfileTreeDataModel dataModel, @NotNull CidrToolEnvironment environment, @Nullable File workingDirectory, @NotNull Project project) {
        if (dataModel == null) {
            SanitizerOutputConsumer.$$$reportNull$$$0(0);
        }
        if (environment == null) {
            SanitizerOutputConsumer.$$$reportNull$$$0(1);
        }
        if (project == null) {
            SanitizerOutputConsumer.$$$reportNull$$$0(2);
        }
        this.myPreviousLine = "";
        this.myDataModel = dataModel;
        this.myEnvironment = environment;
        this.myWorkingDirectory = workingDirectory;
        this.myProject = project;
    }

    public void consume(@Nullable String line) {
        if (StringUtil.isEmpty((String)line)) {
            return;
        }
        if (this.checkFatalError(line)) {
            return;
        }
        if (this.parseBegin(line) || this.parseEnd(line)) {
            return;
        }
        if (this.myCurrentError == null) {
            return;
        }
        MemoryProfileFrame frame = SanitizersUtil.readFrameFromText(line, this.myEnvironment, this.myWorkingDirectory, this.myProject);
        if (frame != null) {
            MemoryProfileProblemDescription description = this.getProblemDescriptionForFrame();
            description.getStack().pushFrame(frame);
        }
        this.myPreviousLine = line;
    }

    public void finish() {
        if (this.myCurrentError != null) {
            this.addErrorToModel(this.myCurrentError);
            this.myCurrentError = null;
        }
    }

    public boolean hasFatalError() {
        return this.myFatalErrorKind != null;
    }

    @NlsContexts.NotificationContent
    @Nullable
    public SanitizerFatalErrorKind getFatalErrorKind() {
        return this.myFatalErrorKind;
    }

    private boolean checkFatalError(@NotNull String line) {
        if (line == null) {
            SanitizerOutputConsumer.$$$reportNull$$$0(3);
        }
        if (FATAL_ERROR_PATTERN.matcher(line).find()) {
            this.myFatalErrorKind = SanitizerFatalErrorKind.UNKNOWN_FATAL_ERROR;
            return true;
        }
        if (DEBUG_FATAL_ERROR_NOTE_PATTERN.matcher(line).find()) {
            this.myFatalErrorKind = SanitizerFatalErrorKind.LEAK_SANITIZER_DEBUG_NOT_SUPPORTED;
            return true;
        }
        return false;
    }

    private MemoryProfileProblemDescription getProblemDescriptionForFrame() {
        List<MemoryProfileProblemDescription> descriptions = this.myCurrentError.getProblemDescriptions();
        if (descriptions.isEmpty()) {
            descriptions.add(new MemoryProfileProblemDescription(this.getProblemText()));
            return descriptions.get(descriptions.size() - 1);
        }
        MemoryProfileProblemDescription description = descriptions.get(descriptions.size() - 1);
        if (StringUtil.isNotEmpty((String)this.myPreviousLine) && SanitizersUtil.readFrameFromText(this.myPreviousLine, this.myEnvironment, this.myWorkingDirectory, this.myProject) != null) {
            return description;
        }
        if (description.hasText() && description.getStack().isEmpty()) {
            return description;
        }
        descriptions.add(new MemoryProfileProblemDescription(this.getProblemText()));
        return descriptions.get(descriptions.size() - 1);
    }

    @NotNull
    private String getProblemText() {
        return StringUtil.startsWithChar((CharSequence)this.myPreviousLine, (char)'=') ? "" : SanitizerOutputConsumer.trimAndCapitalize(this.myPreviousLine);
    }

    private boolean parseBegin(@NotNull String line) {
        if (line == null) {
            SanitizerOutputConsumer.$$$reportNull$$$0(4);
        }
        for (Pattern pattern : BEGIN_PATTERNS) {
            Matcher matcher = pattern.matcher(line);
            if (!matcher.find()) continue;
            String prefix = matcher.group(1);
            String suffix = line.substring(prefix.length());
            if (this.myCurrentError != null) {
                this.addErrorToModel(this.myCurrentError);
            }
            this.myCurrentError = new MemoryProfileError();
            this.myCurrentError.setCaption(SanitizerOutputConsumer.trimAndCapitalize(suffix));
            return true;
        }
        return false;
    }

    private boolean parseEnd(@NotNull String line) {
        if (line == null) {
            SanitizerOutputConsumer.$$$reportNull$$$0(5);
        }
        if (ContainerUtil.exists((Object[])END_PATTERNS, pattern -> pattern.matcher(line).find())) {
            if (this.myCurrentError != null) {
                this.addErrorToModel(this.myCurrentError);
                this.myCurrentError = null;
            }
            return true;
        }
        return false;
    }

    private void addErrorToModel(@NotNull MemoryProfileError error) {
        Application application;
        if (error == null) {
            SanitizerOutputConsumer.$$$reportNull$$$0(6);
        }
        if ((application = ApplicationManager.getApplication()).isDispatchThread()) {
            this.myDataModel.addError(error);
        } else {
            application.invokeLater(() -> this.myDataModel.addError(error));
        }
    }

    @NotNull
    private static String trimAndCapitalize(@NotNull String str) {
        if (str == null) {
            SanitizerOutputConsumer.$$$reportNull$$$0(7);
        }
        String string = StringUtil.capitalize((String)StringUtil.trim((String)str));
        if (string == null) {
            SanitizerOutputConsumer.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataModel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/clion/profiling/sanitizers/SanitizerOutputConsumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/clion/profiling/sanitizers/SanitizerOutputConsumer";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "trimAndCapitalize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkFatalError";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parseBegin";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parseEnd";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addErrorToModel";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "trimAndCapitalize";
                break;
            }
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8 -> new IllegalStateException(string);
        };
    }
}

