/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.profiling.profiler;

import com.intellij.cidr.profiling.memory.MemoryProfileUtil;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.profiler.clion.ProfilerEnvironmentHost;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.cpp.toolchains.WSL;
import com.jetbrains.cidr.execution.CidrRunProcessUtil;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.system.CidrProcessBuilder;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010\u000e\u001a\u00020\r2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\tH\u0016JS\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00072\b\u0010\u0019\u001a\u0004\u0018\u00010\u00072\b\u0010\u001a\u001a\u0004\u0018\u00010\u00072\b\u0010\u001b\u001a\u0004\u0018\u00010\u00072\b\u0010\u001c\u001a\u0004\u0018\u00010\u0007H\u0016\u00a2\u0006\u0002\u0010\u001dJ(\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&2\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010(\u001a\u00020\u00132\u0006\u0010)\u001a\u00020\u00132\u0006\u0010*\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/intellij/clion/profiling/profiler/CppProfilerEnvironmentHost;", "Lcom/intellij/profiler/clion/ProfilerEnvironmentHost;", "environment", "Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;", "<init>", "(Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;)V", "shouldCheckFilePathExist", "", "project", "Lcom/intellij/openapi/project/Project;", "getPath", "Ljava/nio/file/Path;", "path", "", "getEnvPath", "getTempDirectory", "isRemote", "isWSL", "getWSLVersion", "", "createProcessHandler", "Lcom/intellij/execution/process/BaseProcessHandler;", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "colored", "usePty", "captureProcessOutput", "splitLines", "withElevated", "(Lcom/intellij/execution/configurations/GeneralCommandLine;Lcom/intellij/openapi/project/Project;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/Boolean;)Lcom/intellij/execution/process/BaseProcessHandler;", "runProcess", "Lcom/intellij/execution/process/ProcessOutput;", "handler", "Lcom/intellij/execution/process/ProcessHandler;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "timeout", "getProcessList", "", "Lcom/intellij/execution/process/ProcessInfo;", "sendSignal", "pid", "signalName", "intellij.clion.profiling"})
public final class CppProfilerEnvironmentHost
implements ProfilerEnvironmentHost {
    @NotNull
    private final CidrToolEnvironment environment;

    public CppProfilerEnvironmentHost(@NotNull CidrToolEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        this.environment = environment;
    }

    @Override
    public boolean shouldCheckFilePathExist(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return MemoryProfileUtil.checkPathExistAllowed(this.environment.getHostMachine());
    }

    @Override
    @NotNull
    public Path getPath(@NotNull String path, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Path path2 = this.environment.getHostMachine().getPath(path, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getPath(...)");
        return path2;
    }

    @Override
    @NotNull
    public String getEnvPath(@Nullable String path, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = this.environment.toEnvPath(path);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toEnvPath(...)");
        return string;
    }

    @Override
    @NotNull
    public Path getTempDirectory(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Path path = this.environment.getHostMachine().getTempDirectory();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getTempDirectory(...)");
        return path;
    }

    @Override
    public boolean isRemote(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return this.environment.getHostMachine().isRemote();
    }

    @Override
    public boolean isWSL(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return this.environment instanceof CPPEnvironment && ((CPPEnvironment)this.environment).getToolSet().isWSL();
    }

    @Override
    public int getWSLVersion(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!this.isWSL(project)) {
            return -1;
        }
        CidrToolEnvironment cidrToolEnvironment = this.environment;
        Intrinsics.checkNotNull((Object)cidrToolEnvironment, (String)"null cannot be cast to non-null type com.jetbrains.cidr.cpp.toolchains.CPPEnvironment");
        WSL wSL = (WSL)((CPPEnvironment)cidrToolEnvironment).getToolSet();
        if (wSL == null) {
            return -1;
        }
        WSL wsl = wSL;
        WSLDistribution wSLDistribution = wsl.getWslDistribution();
        return wSLDistribution != null ? wSLDistribution.getVersion() : -1;
    }

    @Override
    @NotNull
    public BaseProcessHandler<?> createProcessHandler(@NotNull GeneralCommandLine commandLine, @NotNull Project project, @Nullable Boolean colored, @Nullable Boolean usePty, @Nullable Boolean captureProcessOutput, @Nullable Boolean splitLines, @Nullable Boolean withElevated) {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        CidrProcessBuilder cidrProcessBuilder = this.environment.getHostMachine().createProcessBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)cidrProcessBuilder, (String)"createProcessBuilder(...)");
        CidrProcessBuilder processBuilder = cidrProcessBuilder;
        if (colored != null) {
            processBuilder.withColoredOutput(colored.booleanValue());
        }
        if (usePty != null) {
            processBuilder.withPty(usePty.booleanValue());
        }
        if (captureProcessOutput != null) {
            processBuilder.withCapturedOutput(captureProcessOutput.booleanValue());
        }
        if (splitLines != null) {
            processBuilder.withSplitToLines(splitLines.booleanValue());
        }
        if (withElevated != null) {
            processBuilder.withElevated(withElevated.booleanValue());
        }
        return processBuilder.build(commandLine);
    }

    @Override
    @NotNull
    public ProcessOutput runProcess(@NotNull ProcessHandler handler2, @NotNull ProgressIndicator indicator, int timeout, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)handler2, (String)"handler");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ProcessOutput processOutput = CidrRunProcessUtil.runProcess((ProcessHandler)handler2, (ProgressIndicator)indicator, (int)timeout);
        Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"runProcess(...)");
        return processOutput;
    }

    @Override
    @NotNull
    public List<ProcessInfo> getProcessList(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        List list = this.environment.getHostMachine().getProcessList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getProcessList(...)");
        return list;
    }

    @Override
    public int sendSignal(int pid, @NotNull String signalName, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)signalName, (String)"signalName");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return this.environment.getHostMachine().sendSignal(pid, signalName);
    }
}

