/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.profiling.eventtrace.toolwindow;

import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.ui.content.Content;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0015B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010J\u001e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\rJ\u000e\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/clion/profiling/eventtrace/toolwindow/EventTraceService;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "lastUpdate", "", "", "Lcom/intellij/clion/profiling/eventtrace/toolwindow/EventTraceService$ComponentPanel;", "getCacheFile", "Lcom/intellij/ui/content/Content;", "id", "lastUpdateTime", "", "setCacheFile", "", "component", "remove", "ComponentPanel", "intellij.clion.profiling"})
public final class EventTraceService {
    @NotNull
    private final Project project;
    @NotNull
    private final Map<String, ComponentPanel> lastUpdate;

    public EventTraceService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.lastUpdate = new HashMap();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final Content getCacheFile(@NotNull String id, long lastUpdateTime) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        if (this.lastUpdate.containsKey(id)) {
            ComponentPanel componentPanel = this.lastUpdate.get(id);
            Intrinsics.checkNotNull((Object)componentPanel);
            ComponentPanel last = componentPanel;
            if (last.getLastUpdateTime() == lastUpdateTime) {
                return last.getPanel();
            }
            this.lastUpdate.remove(id);
            return null;
        }
        return null;
    }

    public final void setCacheFile(@NotNull String id, long lastUpdateTime, @NotNull Content component2) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        this.lastUpdate.put(id, new ComponentPanel(lastUpdateTime, component2));
    }

    public final void remove(@NotNull Content component2) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        for (Map.Entry<String, ComponentPanel> panels : this.lastUpdate.entrySet()) {
            if (!Intrinsics.areEqual((Object)panels.getValue().getPanel(), (Object)component2)) continue;
            this.lastUpdate.remove(panels.getKey());
            break;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/clion/profiling/eventtrace/toolwindow/EventTraceService$ComponentPanel;", "", "lastUpdateTime", "", "panel", "Lcom/intellij/ui/content/Content;", "<init>", "(JLcom/intellij/ui/content/Content;)V", "getLastUpdateTime", "()J", "getPanel", "()Lcom/intellij/ui/content/Content;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.clion.profiling"})
    public static final class ComponentPanel {
        private final long lastUpdateTime;
        @NotNull
        private final Content panel;

        public ComponentPanel(long lastUpdateTime, @NotNull Content panel) {
            Intrinsics.checkNotNullParameter((Object)panel, (String)"panel");
            this.lastUpdateTime = lastUpdateTime;
            this.panel = panel;
        }

        public final long getLastUpdateTime() {
            return this.lastUpdateTime;
        }

        @NotNull
        public final Content getPanel() {
            return this.panel;
        }

        public final long component1() {
            return this.lastUpdateTime;
        }

        @NotNull
        public final Content component2() {
            return this.panel;
        }

        @NotNull
        public final ComponentPanel copy(long lastUpdateTime, @NotNull Content panel) {
            Intrinsics.checkNotNullParameter((Object)panel, (String)"panel");
            return new ComponentPanel(lastUpdateTime, panel);
        }

        public static /* synthetic */ ComponentPanel copy$default(ComponentPanel componentPanel, long l, Content content, int n, Object object) {
            if ((n & 1) != 0) {
                l = componentPanel.lastUpdateTime;
            }
            if ((n & 2) != 0) {
                content = componentPanel.panel;
            }
            return componentPanel.copy(l, content);
        }

        @NotNull
        public String toString() {
            return "ComponentPanel(lastUpdateTime=" + this.lastUpdateTime + ", panel=" + this.panel + ")";
        }

        public int hashCode() {
            int result = Long.hashCode(this.lastUpdateTime);
            result = result * 31 + this.panel.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ComponentPanel)) {
                return false;
            }
            ComponentPanel componentPanel = (ComponentPanel)other;
            if (this.lastUpdateTime != componentPanel.lastUpdateTime) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.panel, (Object)componentPanel.panel);
        }
    }
}

