/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.profiling.eventtrace.parser.panels;

import com.fasterxml.jackson.core.JsonParseException;
import com.intellij.clion.profiling.CLionProfilingBundle;
import com.intellij.clion.profiling.eventtrace.exception.IncompleteDurationEventException;
import com.intellij.clion.profiling.eventtrace.exception.IncorrectTimeSequenceExceptions;
import com.intellij.clion.profiling.eventtrace.exception.TraceEventBuildTreeException;
import com.intellij.clion.profiling.eventtrace.exception.TraceEventFormatException;
import com.intellij.clion.profiling.eventtrace.intervals.ColorizeTimelineInterval;
import com.intellij.clion.profiling.eventtrace.intervals.TraceLineIntervalEvent;
import com.intellij.clion.profiling.eventtrace.parser.events.TraceEventParser;
import com.intellij.clion.profiling.eventtrace.parser.panels.EventTraceTimelineModel;
import com.intellij.clion.profiling.eventtrace.parser.panels.TextDefaultTimelineCellRenderer;
import com.intellij.clion.profiling.eventtrace.parser.panels.TimelineTimeConverter;
import com.intellij.clion.profiling.eventtrace.parser.panels.TraceEventPanel;
import com.intellij.clion.profiling.eventtrace.parser.panels.TraceEventTimeLinePanelKt;
import com.intellij.execution.filters.Filter;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.profiler.ui.timeline.TimelineCellRenderer;
import com.intellij.profiler.ui.timeline.TimelineComponent;
import com.intellij.profiler.ui.timeline.TimelineConverter;
import com.intellij.profiler.ui.timeline.TimelineModel;
import com.intellij.profiler.ui.timeline.TimelinePanel;
import com.intellij.ui.JBColor;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.event.MouseListener;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;
import javax.swing.tree.DefaultMutableTreeNode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\"\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0019\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000e2\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011H\u0002J\u001d\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u000b\u0010\u0016\u001a\u00070\r\u00a2\u0006\u0002\b\u000eH\u0002J\u0014\u0010\u0005\u001a\u00020\u00062\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011H\u0016J*\u0010\u0005\u001a\u0004\u0018\u00010\u00062\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u00182\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\u0019"}, d2={"Lcom/intellij/clion/profiling/eventtrace/parser/panels/TraceEventTimeLinePanel;", "Lcom/intellij/clion/profiling/eventtrace/parser/panels/TraceEventPanel;", "Lcom/intellij/clion/profiling/eventtrace/parser/panels/EventTraceTimelineModel;", "<init>", "()V", "getPanel", "Lcom/intellij/clion/profiling/eventtrace/parser/panels/TraceEventPanel$PanelWithStatus;", "model", "filter", "Lcom/intellij/execution/filters/Filter;", "project", "Lcom/intellij/openapi/project/Project;", "getTextOfException", "", "Lcom/intellij/openapi/util/NlsSafe;", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "getExceptionPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "icon", "Ljavax/swing/Icon;", "text", "result", "Lcom/intellij/clion/profiling/eventtrace/parser/panels/TraceEventPanel$ReloadResult;", "intellij.clion.profiling"})
public final class TraceEventTimeLinePanel
extends TraceEventPanel<EventTraceTimelineModel> {
    @Override
    @NotNull
    public TraceEventPanel.PanelWithStatus getPanel(@NotNull EventTraceTimelineModel model, @Nullable Filter filter, @NotNull Project project) {
        OnePixelSplitter onePixelSplitter;
        TimelinePanel timelinePanel2;
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        TimelinePanel $this$getPanel_u24lambda_u240 = timelinePanel2 = new TimelinePanel((TimelineModel)model, null, null, 6, null);
        boolean bl = false;
        $this$getPanel_u24lambda_u240.setTimelineRenderer((TimelineCellRenderer)new TextDefaultTimelineCellRenderer<DefaultMutableTreeNode, TraceLineIntervalEvent>(){

            public JBColor getBackground(TimelineComponent<?, TraceLineIntervalEvent> panel, TimelineModel.TimelineInterval<TraceLineIntervalEvent> node) {
                JBColor jBColor;
                Intrinsics.checkNotNullParameter(panel, (String)"panel");
                Intrinsics.checkNotNullParameter(node, (String)"node");
                if (node instanceof ColorizeTimelineInterval && ((ColorizeTimelineInterval)node).getColor() != null) {
                    JBColor jBColor2 = ((ColorizeTimelineInterval)node).getColor();
                    jBColor = jBColor2;
                    Intrinsics.checkNotNull((Object)jBColor2);
                } else {
                    jBColor = new JBColor(0xDBDBDB, 0xA3A3A3);
                }
                return jBColor;
            }
        });
        $this$getPanel_u24lambda_u240.getChart().setTimeFormatter((TimelineConverter)new TimelineTimeConverter($this$getPanel_u24lambda_u240.getRange(), model.getTimeUnit()));
        $this$getPanel_u24lambda_u240.setRootVisible(model.getRoot().getChildCount() == 0 && ((CharSequence)model.getRoot().getUserObject().toString()).length() > 0);
        TimelinePanel timelinePanel3 = timelinePanel2;
        timelinePanel3.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 20));
        JBPanelWithEmptyText jBPanelWithEmptyText = new JBPanelWithEmptyText().withEmptyText(CLionProfilingBundle.message("profiler.eventtracer.no.event.selected.hover.and.select.event", new Object[0]));
        Intrinsics.checkNotNullExpressionValue((Object)jBPanelWithEmptyText, (String)"withEmptyText(...)");
        JBPanelWithEmptyText label = jBPanelWithEmptyText;
        JBScrollPane scroll = new JBScrollPane((Component)label, 20, 31);
        scroll.putClientProperty(DialogWrapper.DIALOG_CONTENT_PANEL_PROPERTY, (Object)true);
        scroll.setBorder((Border)new JBEmptyBorder(UIUtil.PANEL_REGULAR_INSETS));
        OnePixelSplitter $this$getPanel_u24lambda_u241 = onePixelSplitter = new OnePixelSplitter(false, 0.8f, 0.4f, 0.95f);
        boolean bl2 = false;
        $this$getPanel_u24lambda_u241.setFirstComponent((JComponent)timelinePanel3);
        $this$getPanel_u24lambda_u241.setSecondComponent((JComponent)scroll);
        OnePixelSplitter onePixelSplitter2 = onePixelSplitter;
        timelinePanel3.getChart().addMouseListener((MouseListener)new TraceEventParser.LineMouseListener(timelinePanel3, onePixelSplitter2, this.getHyperLinkListenerGetter(filter, project), filter));
        return new TraceEventPanel.PanelWithStatus((JComponent)onePixelSplitter2, TraceEventPanel.PanelWithStatus.Status.NORMAL);
    }

    private final String getTextOfException(Exception e) {
        String string;
        Exception exception = e;
        if (exception instanceof IncorrectTimeSequenceExceptions) {
            String string2 = CLionProfilingBundle.message("profiler.eventtracer.error.incorrect.time", new Object[0]);
            Intrinsics.checkNotNull((Object)string2);
            string = string2;
        } else if (exception instanceof IncompleteDurationEventException) {
            String string3 = CLionProfilingBundle.message("profiler.eventtracer.error.incomplete.event", new Object[0]);
            Intrinsics.checkNotNull((Object)string3);
            string = string3;
        } else if (exception instanceof TraceEventBuildTreeException) {
            String string4 = CLionProfilingBundle.message("profiler.eventtracer.error.tree.on.parsing", new Object[0]);
            Intrinsics.checkNotNull((Object)string4);
            string = string4;
        } else if (exception instanceof TraceEventFormatException) {
            String string5 = CLionProfilingBundle.message("profiler.eventtracer.error.format.on.parsing", new Object[0]);
            Intrinsics.checkNotNull((Object)string5);
            string = string5;
        } else if (exception instanceof JsonParseException) {
            String string6 = CLionProfilingBundle.message("profiler.eventtracer.error.on.parsing", new Object[0]);
            Intrinsics.checkNotNull((Object)string6);
            string = string6;
        } else if (exception instanceof IOException) {
            String string7 = CLionProfilingBundle.message("profiler.eventtracer.error.on.reading", new Object[0]);
            Intrinsics.checkNotNull((Object)string7);
            string = string7;
        } else {
            TraceEventTimeLinePanelKt.access$getLogger$p().error((Throwable)e);
            String string8 = CLionProfilingBundle.message("profiler.eventtracer.label.get.something.wrong.on.showing", new Object[0]);
            Intrinsics.checkNotNull((Object)string8);
            string = string8;
        }
        return string;
    }

    private final DialogPanel getExceptionPanel(Icon icon, String text) {
        return BuilderKt.panel(arg_0 -> TraceEventTimeLinePanel.getExceptionPanel$lambda$0(text, icon, arg_0));
    }

    @Override
    @NotNull
    public TraceEventPanel.PanelWithStatus getPanel(@NotNull Exception e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Icon icon = AllIcons.General.BalloonError;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"BalloonError");
        return new TraceEventPanel.PanelWithStatus((JComponent)this.getExceptionPanel(icon, this.getTextOfException(e)), TraceEventPanel.PanelWithStatus.Status.EXCEPTION);
    }

    @Override
    @Nullable
    public TraceEventPanel.PanelWithStatus getPanel(@NotNull TraceEventPanel.ReloadResult<EventTraceTimelineModel> result, @Nullable Filter filter, @NotNull Project project) {
        Intrinsics.checkNotNullParameter(result, (String)"result");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        TraceEventPanel.PanelWithStatus panel = null;
        if (result.getModel() != null) {
            panel = this.getPanel(result.getModel(), filter, project);
        }
        if (result.getException() != null) {
            panel = this.getPanel(result.getException());
        }
        return panel;
    }

    private static final Unit getExceptionPanel$lambda$0(String $text, Icon $icon, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> TraceEventTimeLinePanel.getExceptionPanel$lambda$0$0($text, $icon, arg_0), (int)1, null).resizableRow();
        return Unit.INSTANCE;
    }

    private static final Unit getExceptionPanel$lambda$0$0(String $text, Icon $icon, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label($text).applyToComponent(arg_0 -> TraceEventTimeLinePanel.getExceptionPanel$lambda$0$0$0($icon, arg_0)).align(Align.CENTER);
        return Unit.INSTANCE;
    }

    private static final Unit getExceptionPanel$lambda$0$0$0(Icon $icon, JLabel $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setIcon($icon);
        return Unit.INSTANCE;
    }
}

