/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.profiling.eventtrace.parser.panels;

import com.intellij.ide.nls.NlsMessages;
import com.intellij.profiler.ui.timeline.TimelineComponent;
import com.intellij.profiler.ui.timeline.TimelineConverter;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lcom/intellij/clion/profiling/eventtrace/parser/panels/TimelineTimeConverter;", "Lcom/intellij/profiler/ui/timeline/TimelineConverter;", "range", "Lcom/intellij/profiler/ui/timeline/TimelineComponent$Range;", "minor", "Ljava/util/concurrent/TimeUnit;", "<init>", "(Lcom/intellij/profiler/ui/timeline/TimelineComponent$Range;Ljava/util/concurrent/TimeUnit;)V", "getRange", "()Lcom/intellij/profiler/ui/timeline/TimelineComponent$Range;", "getMinor", "()Ljava/util/concurrent/TimeUnit;", "convert", "", "scale", "", "time", "", "intellij.clion.profiling"})
public final class TimelineTimeConverter
implements TimelineConverter {
    @NotNull
    private final TimelineComponent.Range range;
    @NotNull
    private final TimeUnit minor;

    public TimelineTimeConverter(@NotNull TimelineComponent.Range range, @NotNull TimeUnit minor) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)((Object)minor), (String)"minor");
        this.range = range;
        this.minor = minor;
    }

    @NotNull
    public final TimelineComponent.Range getRange() {
        return this.range;
    }

    @NotNull
    public final TimeUnit getMinor() {
        return this.minor;
    }

    @NotNull
    public String convert(int scale, long time) {
        String string;
        if (time == this.range.getStart()) {
            string = "0";
        } else {
            String string2 = new NlsMessages.NlsDurationFormatter().setDurationTimeUnit(this.minor).setMaxFragments(2).formatDuration(time - this.range.getStart());
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"formatDuration(...)");
        }
        return string;
    }
}

