/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.profiling.eventtrace.parser.events;

import com.fasterxml.jackson.databind.JsonNode;
import com.intellij.clion.profiling.eventtrace.abstractevent.TraceEvent;
import com.intellij.clion.profiling.eventtrace.event.GoogleTraceEvent;
import com.intellij.clion.profiling.eventtrace.event.GoogleTraceEventTypesEnum;
import com.intellij.clion.profiling.eventtrace.event.GoogleTraceGlobalEventTypes;
import com.intellij.clion.profiling.eventtrace.exception.FieldMissedException;
import com.intellij.clion.profiling.eventtrace.exception.FieldWrongTypeEventException;
import com.intellij.clion.profiling.eventtrace.holder.ClosableEventHolder;
import com.intellij.clion.profiling.eventtrace.holder.HolderFactory;
import com.intellij.clion.profiling.eventtrace.intervals.EventToTreeGoogleEventParser;
import com.intellij.clion.profiling.eventtrace.parser.AnyParser;
import com.intellij.clion.profiling.eventtrace.parser.ColorParser;
import com.intellij.clion.profiling.eventtrace.parser.EventParser;
import com.intellij.clion.profiling.eventtrace.parser.IntParser;
import com.intellij.clion.profiling.eventtrace.parser.JsonParser;
import com.intellij.clion.profiling.eventtrace.parser.LongParser;
import com.intellij.clion.profiling.eventtrace.parser.MapParser;
import com.intellij.clion.profiling.eventtrace.parser.ResultLogger;
import com.intellij.clion.profiling.eventtrace.parser.StringParser;
import com.intellij.clion.profiling.eventtrace.parser.TypeInstantEventParser;
import com.intellij.clion.profiling.eventtrace.parser.events.JSONTraceEventParser;
import com.intellij.clion.profiling.eventtrace.utils.ExceptionsUtilsKt;
import com.intellij.clion.profiling.eventtrace.utils.TimeUtilsKt;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u001dH\u0016J\u0018\u0010 \u001a\u00020!2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020#H\u0016J\u0018\u0010$\u001a\u00020!2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020#H\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR$\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u000e0\rj\b\u0012\u0004\u0012\u00020\u000e`\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006%"}, d2={"Lcom/intellij/clion/profiling/eventtrace/parser/events/GoogleTraceEventParser;", "Lcom/intellij/clion/profiling/eventtrace/parser/events/JSONTraceEventParser;", "totalResultLogger", "", "<init>", "(I)V", "resultLogger", "Lcom/intellij/clion/profiling/eventtrace/parser/ResultLogger;", "getResultLogger", "()Lcom/intellij/clion/profiling/eventtrace/parser/ResultLogger;", "setResultLogger", "(Lcom/intellij/clion/profiling/eventtrace/parser/ResultLogger;)V", "nodes", "Ljava/util/ArrayList;", "Lcom/intellij/clion/profiling/eventtrace/holder/HolderFactory$NodeHolderData;", "Lkotlin/collections/ArrayList;", "getNodes", "()Ljava/util/ArrayList;", "parser", "Lcom/intellij/clion/profiling/eventtrace/intervals/EventToTreeGoogleEventParser;", "getParser", "()Lcom/intellij/clion/profiling/eventtrace/intervals/EventToTreeGoogleEventParser;", "leaf", "Lcom/intellij/clion/profiling/eventtrace/holder/HolderFactory$LeafHolderData;", "getLeaf", "()Lcom/intellij/clion/profiling/eventtrace/holder/HolderFactory$LeafHolderData;", "parseEvent", "Lcom/intellij/clion/profiling/eventtrace/abstractevent/TraceEvent;", "node", "Lcom/fasterxml/jackson/databind/JsonNode;", "getEventsNode", "mainNode", "beforeParse", "", "holder", "Lcom/intellij/clion/profiling/eventtrace/holder/ClosableEventHolder;", "afterParse", "intellij.clion.profiling"})
@SourceDebugExtension(value={"SMAP\nGoogleTraceEventParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoogleTraceEventParser.kt\ncom/intellij/clion/profiling/eventtrace/parser/events/GoogleTraceEventParser\n+ 2 JsonParser.kt\ncom/intellij/clion/profiling/eventtrace/parser/JsonParserKt\n*L\n1#1,85:1\n262#2:86\n232#2,17:87\n*S KotlinDebug\n*F\n+ 1 GoogleTraceEventParser.kt\ncom/intellij/clion/profiling/eventtrace/parser/events/GoogleTraceEventParser\n*L\n53#1:86\n53#1:87,17\n*E\n"})
public final class GoogleTraceEventParser
extends JSONTraceEventParser {
    @NotNull
    private ResultLogger resultLogger;
    @NotNull
    private final ArrayList<HolderFactory.NodeHolderData> nodes;
    @NotNull
    private final EventToTreeGoogleEventParser parser;
    @NotNull
    private final HolderFactory.LeafHolderData leaf;

    public GoogleTraceEventParser(int totalResultLogger) {
        this.resultLogger = new ResultLogger(totalResultLogger);
        Object[] objectArray = new HolderFactory.NodeHolderData[]{new HolderFactory.NodeHolderData("", "Empty", "pid", new GoogleTraceGlobalEventTypes(GoogleTraceEventTypesEnum.GLOBAL)), new HolderFactory.NodeHolderData("Process", "Process", "tid", new GoogleTraceGlobalEventTypes(GoogleTraceEventTypesEnum.PROCESS))};
        this.nodes = CollectionsKt.arrayListOf((Object[])objectArray);
        objectArray = new JBColor[]{new JBColor(new Color(153, 204, 255), JBColor.BLUE.getDarkVariant().darker()), new JBColor(new Color(153, 255, 153), JBColor.GREEN.getDarkVariant().darker()), new JBColor(new Color(230, 153, 230), JBColor.YELLOW.getDarkVariant().darker()), new JBColor(new Color(255, 204, 153), JBColor.ORANGE.getDarkVariant().darker())};
        this.parser = new EventToTreeGoogleEventParser(TimeUnit.MICROSECONDS, (JBColor[])objectArray, this);
        this.leaf = new HolderFactory.LeafHolderData("Thread", "Thread", this.parser);
    }

    public /* synthetic */ GoogleTraceEventParser(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 1;
        }
        this(n);
    }

    @Override
    @NotNull
    public ResultLogger getResultLogger() {
        return this.resultLogger;
    }

    @Override
    public void setResultLogger(@NotNull ResultLogger resultLogger) {
        Intrinsics.checkNotNullParameter((Object)resultLogger, (String)"<set-?>");
        this.resultLogger = resultLogger;
    }

    @Override
    @NotNull
    public ArrayList<HolderFactory.NodeHolderData> getNodes() {
        return this.nodes;
    }

    @NotNull
    public final EventToTreeGoogleEventParser getParser() {
        return this.parser;
    }

    @Override
    @NotNull
    public HolderFactory.LeafHolderData getLeaf() {
        return this.leaf;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public TraceEvent parseEvent(@NotNull JsonNode node) {
        void node$iv$iv;
        void node$iv;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        JsonNode jsonNode = node;
        String name$iv = "event: " + node;
        boolean $i$f$parseNotNull = false;
        void var5_5 = node$iv;
        String name$iv$iv = name$iv;
        boolean $i$f$parse = false;
        Pair[] pairArray = new Pair[]{new Pair((Object)Reflection.getOrCreateKotlinClass(Integer.TYPE), (Object)new IntParser()), new Pair((Object)Reflection.getOrCreateKotlinClass(String.class), (Object)new StringParser()), new Pair((Object)Reflection.getOrCreateKotlinClass(Long.TYPE), (Object)new LongParser()), new Pair((Object)Reflection.getOrCreateKotlinClass(Object.class), (Object)new AnyParser()), new Pair((Object)Reflection.getOrCreateKotlinClass(Map.class), (Object)new MapParser()), new Pair((Object)Reflection.getOrCreateKotlinClass(JBColor.class), (Object)new ColorParser()), new Pair((Object)Reflection.getOrCreateKotlinClass(GoogleTraceEvent.class), (Object)new EventParser()), new Pair((Object)Reflection.getOrCreateKotlinClass(GoogleTraceGlobalEventTypes.class), (Object)new TypeInstantEventParser())};
        Map parsers$iv$iv = MapsKt.mapOf((Pair[])pairArray);
        Object v = parsers$iv$iv.get(Reflection.getOrCreateKotlinClass(GoogleTraceEvent.class));
        Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type com.intellij.clion.profiling.eventtrace.parser.JsonParser<*>");
        JsonParser parser$iv$iv = (JsonParser)v;
        if (!((Boolean)parser$iv$iv.getEnter().invoke((Object)node$iv$iv)).booleanValue()) {
            String string = String.valueOf(Reflection.getOrCreateKotlinClass(GoogleTraceEvent.class).getSimpleName());
            String string2 = node$iv$iv.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            throw ExceptionsUtilsKt.exceptionWrongType(name$iv$iv, string, string2);
        }
        GoogleTraceEvent googleTraceEvent = (GoogleTraceEvent)parser$iv$iv.getApply().invoke((Object)node$iv$iv);
        if (googleTraceEvent == null) {
            throw new FieldMissedException(name$iv);
        }
        return googleTraceEvent;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public JsonNode getEventsNode(@NotNull JsonNode mainNode) {
        JsonNode jsonNode;
        Intrinsics.checkNotNullParameter((Object)mainNode, (String)"mainNode");
        if (!mainNode.has("traceEvents")) {
            if (!mainNode.isArray()) {
                throw new FieldMissedException("traceEvents");
            }
            jsonNode = mainNode;
        } else {
            void var3_2;
            JsonNode trace = mainNode.get("traceEvents");
            if (!trace.isArray()) {
                throw new FieldWrongTypeEventException("traceEvents", "Array", "Not array");
            }
            void var2_3 = var3_2;
            Intrinsics.checkNotNull((Object)var2_3);
            jsonNode = var2_3;
        }
        return jsonNode;
    }

    @Override
    public void beforeParse(@NotNull JsonNode node, @NotNull ClosableEventHolder holder) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
    }

    @Override
    public void afterParse(@NotNull JsonNode node, @NotNull ClosableEventHolder holder) {
        TimeUnit timeUnit;
        TimeUnit timeUnit2;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Map map = holder.getMetadata();
        String string = "displayTimeUnit";
        if (node.has("displayTimeUnit")) {
            String string2 = node.get("displayTimeUnit").asText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asText(...)");
            timeUnit2 = TimeUtilsKt.getTimeUnit(string2);
            if (timeUnit2 == null) {
                timeUnit2 = TimeUnit.MICROSECONDS;
            }
        } else {
            timeUnit2 = TimeUnit.MICROSECONDS;
        }
        TimeUnit $this$afterParse_u24lambda_u240 = timeUnit = timeUnit2;
        boolean bl = false;
        this.parser.setTimeUnit($this$afterParse_u24lambda_u240);
        map.put(string, timeUnit);
    }

    public GoogleTraceEventParser() {
        this(0, 1, null);
    }
}

