/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.profiling.eventtrace.parser;

import com.intellij.clion.profiling.CLionProfilingBundle;
import com.intellij.clion.profiling.eventtrace.exception.TraceEventFormatException;
import com.intellij.clion.profiling.eventtrace.toolwindow.EventTraceToolWindowUi;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0014J\u000e\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0018J\u0006\u0010\u001d\u001a\u00020\u0003J\u0006\u0010\u001e\u001a\u00020\u001fJ!\u0010 \u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u00152\u000e\u0010!\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0013H\u0086\u0002J\r\u0010\"\u001a\u00070#\u00a2\u0006\u0002\b$H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0007\"\u0004\b\u0010\u0010\u0005RF\u0010\u0011\u001a:\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00150\u0012j\u001c\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u0015`\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000RF\u0010\u0017\u001a:\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00180\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00150\u0012j\u001c\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00180\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u0015`\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/clion/profiling/eventtrace/parser/ResultLogger;", "", "countParsers", "", "<init>", "(I)V", "getCountParsers", "()I", "count", "", "getCount", "()J", "setCount", "(J)V", "currentCountParsers", "getCurrentCountParsers", "setCurrentCountParsers", "exceptions", "Ljava/util/HashMap;", "Lkotlin/reflect/KClass;", "Lcom/intellij/clion/profiling/eventtrace/exception/TraceEventFormatException;", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lkotlin/collections/HashMap;", "eventTraceContainerFailed", "Lcom/intellij/clion/profiling/eventtrace/toolwindow/EventTraceToolWindowUi$EventTraceFileContainer;", "addException", "", "e", "addContainerFailed", "typesOfExceptions", "isSuccessful", "", "get", "clazz", "toString", "", "Lorg/jetbrains/annotations/Nls;", "intellij.clion.profiling"})
public final class ResultLogger {
    private final int countParsers;
    private long count;
    private int currentCountParsers;
    @NotNull
    private final HashMap<KClass<? extends TraceEventFormatException>, ConcurrentLinkedQueue<TraceEventFormatException>> exceptions;
    @NotNull
    private final HashMap<KClass<? extends EventTraceToolWindowUi.EventTraceFileContainer>, ConcurrentLinkedQueue<EventTraceToolWindowUi.EventTraceFileContainer>> eventTraceContainerFailed;

    public ResultLogger(int countParsers) {
        this.countParsers = countParsers;
        this.exceptions = new HashMap();
        this.eventTraceContainerFailed = new HashMap();
    }

    public final int getCountParsers() {
        return this.countParsers;
    }

    public final long getCount() {
        return this.count;
    }

    public final void setCount(long l) {
        this.count = l;
    }

    public final int getCurrentCountParsers() {
        return this.currentCountParsers;
    }

    public final void setCurrentCountParsers(int n) {
        this.currentCountParsers = n;
    }

    public final void addException(@NotNull TraceEventFormatException e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!this.exceptions.containsKey(Reflection.getOrCreateKotlinClass(e.getClass()))) {
            ((Map)this.exceptions).put(Reflection.getOrCreateKotlinClass(e.getClass()), new ConcurrentLinkedQueue());
        }
        ConcurrentLinkedQueue<TraceEventFormatException> concurrentLinkedQueue = this.exceptions.get(Reflection.getOrCreateKotlinClass(e.getClass()));
        Intrinsics.checkNotNull(concurrentLinkedQueue);
        concurrentLinkedQueue.add(e);
    }

    public final void addContainerFailed(@NotNull EventTraceToolWindowUi.EventTraceFileContainer e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!this.eventTraceContainerFailed.containsKey(Reflection.getOrCreateKotlinClass(e.getClass()))) {
            ((Map)this.eventTraceContainerFailed).put(Reflection.getOrCreateKotlinClass(e.getClass()), new ConcurrentLinkedQueue());
        }
        ConcurrentLinkedQueue<EventTraceToolWindowUi.EventTraceFileContainer> concurrentLinkedQueue = this.eventTraceContainerFailed.get(Reflection.getOrCreateKotlinClass(e.getClass()));
        Intrinsics.checkNotNull(concurrentLinkedQueue);
        concurrentLinkedQueue.add(e);
    }

    public final int typesOfExceptions() {
        return this.exceptions.size();
    }

    public final boolean isSuccessful() {
        return this.exceptions.size() == 0 && this.eventTraceContainerFailed.size() == 0;
    }

    @Nullable
    public final ConcurrentLinkedQueue<TraceEventFormatException> get(@NotNull KClass<? extends TraceEventFormatException> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        return this.exceptions.get(clazz);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String toString() {
        String string;
        if (this.isSuccessful()) {
            String string2 = CLionProfilingBundle.message("profiler.eventtracer.resultlogger.successful", new Object[0]);
            Intrinsics.checkNotNull((Object)string2);
            string = string2;
        } else {
            void var1_2;
            ArrayList<CallSite> list;
            String string3 = CLionProfilingBundle.message("profiler.eventtracer.resultlogger.warnings", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
            Object message = string3;
            if (!((Map)this.exceptions).isEmpty()) {
                list = new ArrayList<CallSite>();
                for (Map.Entry p : ((Map)this.exceptions).entrySet()) {
                    if (((ConcurrentLinkedQueue)p.getValue()).size() == 0) continue;
                    list.add((CallSite)((Object)(((ConcurrentLinkedQueue)p.getValue()).size() + " " + ((TraceEventFormatException)CollectionsKt.first((Iterable)((Iterable)p.getValue()))).shortMessage())));
                }
                message = (String)message + " " + CollectionsKt.joinToString$default((Iterable)list, null, null, null, (int)0, null, null, (int)63, null);
            }
            if (!((Map)this.eventTraceContainerFailed).isEmpty()) {
                list = new ArrayList();
                for (Map.Entry p : ((Map)this.eventTraceContainerFailed).entrySet()) {
                    if (((ConcurrentLinkedQueue)p.getValue()).size() == 0) continue;
                    list.add((CallSite)((Object)(p.getValue() + " " + ((EventTraceToolWindowUi.EventTraceFileContainer)CollectionsKt.first((Iterable)((Iterable)p.getValue()))).shortMessage())));
                }
                message = (String)message + " " + CollectionsKt.joinToString$default((Iterable)list, null, null, null, (int)0, null, null, (int)63, null);
            }
            string = var1_2;
        }
        return string;
    }
}

