/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.profiling.eventtrace.intervals;

import com.intellij.clion.profiling.CLionProfilingBundle;
import com.intellij.clion.profiling.eventtrace.intervals.GoogleTraceIntervalEvent;
import com.intellij.clion.profiling.eventtrace.intervals.TraceLineIntervalEvent;
import com.intellij.execution.filters.Filter;
import com.intellij.ide.nls.NlsMessages;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignY;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.RowLayout;
import com.intellij.util.ui.HTMLEditorKitBuilder;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001Bg\u0012\n\b\u0001\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0001\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\u0014\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\b\u0010%\u001a\u00020\u0003H\u0016J\r\u0010&\u001a\u00070\u0003\u00a2\u0006\u0002\b'H\u0016J\"\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010+2\u000e\u0010,\u001a\n\u0012\u0004\u0012\u00020.\u0018\u00010-H\u0016R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0007\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0017R\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0017R\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0017R\u001f\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0016\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u0017\"\u0004\b#\u0010$\u00a8\u0006/"}, d2={"Lcom/intellij/clion/profiling/eventtrace/intervals/GoogleTraceIntervalEvent;", "Lcom/intellij/clion/profiling/eventtrace/intervals/TraceLineIntervalEvent;", "name", "", "cat", "start", "", "end", "pid", "tid", "args", "", "", "color", "Ljava/awt/Color;", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "<init>", "(Ljava/lang/String;Ljava/lang/String;JJJJLjava/util/Map;Ljava/awt/Color;Ljava/util/concurrent/TimeUnit;)V", "getName", "()Ljava/lang/String;", "getCat", "getStart", "()J", "getEnd", "getPid", "getTid", "getArgs", "()Ljava/util/Map;", "getColor", "()Ljava/awt/Color;", "getTimeUnit", "()Ljava/util/concurrent/TimeUnit;", "duration", "getDuration", "setDuration", "(J)V", "toShortString", "toString", "Lcom/intellij/openapi/util/NlsSafe;", "toLabel", "Ljavax/swing/JComponent;", "filter", "Lcom/intellij/execution/filters/Filter;", "hyperLinkCreator", "Lkotlin/Function0;", "Ljavax/swing/event/HyperlinkListener;", "intellij.clion.profiling"})
public final class GoogleTraceIntervalEvent
implements TraceLineIntervalEvent {
    @Nullable
    private final String name;
    @Nullable
    private final String cat;
    private final long start;
    private final long end;
    private final long pid;
    private final long tid;
    @Nullable
    private final Map<String, Object> args;
    @Nullable
    private final Color color;
    @NotNull
    private final TimeUnit timeUnit;
    private long duration;

    public GoogleTraceIntervalEvent(@NlsSafe @Nullable String name, @NlsSafe @Nullable String cat, long start2, long end, long pid, long tid, @Nullable Map<String, ? extends Object> args, @Nullable Color color, @NotNull TimeUnit timeUnit) {
        Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"timeUnit");
        this.name = name;
        this.cat = cat;
        this.start = start2;
        this.end = end;
        this.pid = pid;
        this.tid = tid;
        this.args = args;
        this.color = color;
        this.timeUnit = timeUnit;
        this.duration = this.getEnd() - this.getStart();
    }

    @Nullable
    public final String getName() {
        return this.name;
    }

    @Nullable
    public final String getCat() {
        return this.cat;
    }

    @Override
    public long getStart() {
        return this.start;
    }

    @Override
    public long getEnd() {
        return this.end;
    }

    public final long getPid() {
        return this.pid;
    }

    public final long getTid() {
        return this.tid;
    }

    @Nullable
    public final Map<String, Object> getArgs() {
        return this.args;
    }

    @Override
    @Nullable
    public Color getColor() {
        return this.color;
    }

    @Override
    @NotNull
    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    @Override
    public long getDuration() {
        return this.duration;
    }

    @Override
    public void setDuration(long l) {
        this.duration = l;
    }

    @Override
    @NotNull
    public String toShortString() {
        String string = this.name;
        if (string == null) {
            string = "";
        }
        return string;
    }

    @Override
    @NotNull
    public String toString() {
        HtmlBuilder sb = new HtmlBuilder();
        if (this.name != null) {
            sb.append((HtmlChunk)HtmlChunk.raw((String)CLionProfilingBundle.message("profiler.eventtracer.name", new Object[0])).bold()).nbsp().append(String.valueOf(this.name)).br();
        }
        if (this.cat != null) {
            sb.append((HtmlChunk)HtmlChunk.raw((String)CLionProfilingBundle.message("profiler.eventtracer.cat", new Object[0])).bold()).nbsp().append(String.valueOf(this.cat)).br();
        }
        sb.append((HtmlChunk)HtmlChunk.raw((String)CLionProfilingBundle.message("profiler.eventtracer.duration", new Object[0])).bold()).nbsp().append(new NlsMessages.NlsDurationFormatter().setNarrow(false).setDurationTimeUnit(this.getTimeUnit()).formatDuration(this.getDuration())).br();
        sb.append((HtmlChunk)HtmlChunk.raw((String)CLionProfilingBundle.message("profiler.eventtracer.pid", new Object[0])).bold()).nbsp().append(this.pid + " ").br();
        sb.append((HtmlChunk)HtmlChunk.raw((String)CLionProfilingBundle.message("profiler.eventtracer.tid", new Object[0])).bold()).nbsp().append(String.valueOf(this.tid)).br();
        String string = sb.wrapWithHtmlBody().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    @NotNull
    public JComponent toLabel(@Nullable Filter filter, @Nullable Function0<? extends HyperlinkListener> hyperLinkCreator) {
        JBScrollPane jBScrollPane;
        Function2 functor = GoogleTraceIntervalEvent::toLabel$lambda$0;
        Function1 bolder = arg_0 -> GoogleTraceIntervalEvent.toLabel$lambda$1(functor, arg_0);
        Function1 textual = GoogleTraceIntervalEvent::toLabel$lambda$2;
        Function2 link = GoogleTraceIntervalEvent::toLabel$lambda$3;
        Function1 argumentLabel2 = GoogleTraceIntervalEvent::toLabel$lambda$4;
        Function1 argumentLink2 = arg_0 -> GoogleTraceIntervalEvent.toLabel$lambda$5(link, hyperLinkCreator, arg_0);
        DialogPanel real = BuilderKt.panel(arg_0 -> GoogleTraceIntervalEvent.toLabel$lambda$6(this, bolder, textual, filter, argumentLabel2, argumentLink2, arg_0));
        JBScrollPane $this$toLabel_u24lambda_u247 = jBScrollPane = new JBScrollPane((Component)real, 20, 31);
        boolean bl = false;
        $this$toLabel_u24lambda_u247.setBorder((Border)new JBEmptyBorder(UIUtil.PANEL_REGULAR_INSETS));
        return (JComponent)jBScrollPane;
    }

    private static final String toLabel$lambda$0(String it, Function1 functor) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Intrinsics.checkNotNullParameter((Object)functor, (String)"functor");
        HtmlBuilder htmlBuilder = new HtmlBuilder();
        HtmlChunk htmlChunk = HtmlChunk.raw((String)it);
        Intrinsics.checkNotNullExpressionValue((Object)htmlChunk, (String)"raw(...)");
        return htmlBuilder.append((HtmlChunk)functor.invoke((Object)htmlChunk)).wrapWithHtmlBody().toString();
    }

    private static final String toLabel$lambda$1(Function2 $functor, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (String)$functor.invoke((Object)it, GoogleTraceIntervalEvent::toLabel$lambda$1$0);
    }

    private static final HtmlChunk.Element toLabel$lambda$1$0(HtmlChunk $this$functor) {
        Intrinsics.checkNotNullParameter((Object)$this$functor, (String)"$this$functor");
        HtmlChunk.Element element = $this$functor.bold();
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"bold(...)");
        return element;
    }

    private static final String toLabel$lambda$2(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new HtmlBuilder().append(it).wrapWithHtmlBody().toString();
    }

    private static final String toLabel$lambda$3(String link, String text) {
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return new HtmlBuilder().appendLink(link, text).wrapWithHtmlBody().toString();
    }

    private static final toLabel.argumentLabel.1.1 toLabel$lambda$4(String it) {
        JEditorPane jEditorPane;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        JEditorPane $this$toLabel_u24lambda_u244_u240 = jEditorPane = new JEditorPane(){};
        boolean bl = false;
        $this$toLabel_u24lambda_u244_u240.setEditorKit(new HTMLEditorKitBuilder().withWordWrapViewFactory().build());
        $this$toLabel_u24lambda_u244_u240.setText(it);
        $this$toLabel_u24lambda_u244_u240.setOpaque(false);
        $this$toLabel_u24lambda_u244_u240.setMargin((Insets)JBInsets.emptyInsets());
        $this$toLabel_u24lambda_u244_u240.setEditable(false);
        return jEditorPane;
    }

    private static final toLabel.argumentLink.1.1 toLabel$lambda$5(Function2 $link, Function0 $hyperLinkCreator, String it) {
        HTMLEditorKit hTMLEditorKit;
        JEditorPane jEditorPane;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        JEditorPane $this$toLabel_u24lambda_u245_u240 = jEditorPane = new JEditorPane(){};
        boolean bl = false;
        HTMLEditorKit hTMLEditorKit2 = hTMLEditorKit = new HTMLEditorKitBuilder().withWordWrapViewFactory().build();
        JEditorPane jEditorPane2 = $this$toLabel_u24lambda_u245_u240;
        boolean bl2 = false;
        Function0 function0 = $hyperLinkCreator;
        Intrinsics.checkNotNull((Object)function0);
        $this$toLabel_u24lambda_u245_u240.addHyperlinkListener((HyperlinkListener)function0.invoke());
        jEditorPane2.setEditorKit(hTMLEditorKit);
        $this$toLabel_u24lambda_u245_u240.setText((String)$link.invoke((Object)it, (Object)it));
        $this$toLabel_u24lambda_u245_u240.setOpaque(false);
        $this$toLabel_u24lambda_u245_u240.setMargin((Insets)JBInsets.emptyInsets());
        $this$toLabel_u24lambda_u245_u240.setEditable(false);
        return jEditorPane;
    }

    private static final Unit toLabel$lambda$6(GoogleTraceIntervalEvent this$0, Function1 $bolder, Function1 $textual, Filter $filter, Function1 $argumentLabel, Function1 $argumentLink, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.group$default((Panel)$this$panel, null, (boolean)false, arg_0 -> GoogleTraceIntervalEvent.toLabel$lambda$6$0(this$0, $bolder, $textual, arg_0), (int)3, null);
        if (this$0.args != null) {
            Panel.group$default((Panel)$this$panel, (String)CLionProfilingBundle.message("profiler.eventtracer.args", new Object[0]), (boolean)false, arg_0 -> GoogleTraceIntervalEvent.toLabel$lambda$6$1(this$0, $bolder, $filter, $argumentLabel, $argumentLink, arg_0), (int)2, null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit toLabel$lambda$6$0(GoogleTraceIntervalEvent this$0, Function1 $bolder, Function1 $textual, Panel $this$group) {
        Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
        if (this$0.name != null) {
            String string = CLionProfilingBundle.message("profiler.eventtracer.name", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            $this$group.row((String)$bolder.invoke((Object)string), arg_0 -> GoogleTraceIntervalEvent.toLabel$lambda$6$0$0($textual, this$0, arg_0));
        }
        if (this$0.cat != null) {
            String string = CLionProfilingBundle.message("profiler.eventtracer.cat", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            $this$group.row((String)$bolder.invoke((Object)string), arg_0 -> GoogleTraceIntervalEvent.toLabel$lambda$6$0$1($textual, this$0, arg_0));
        }
        String string = CLionProfilingBundle.message("profiler.eventtracer.duration", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$group.row((String)$bolder.invoke((Object)string), arg_0 -> GoogleTraceIntervalEvent.toLabel$lambda$6$0$2($textual, this$0, arg_0));
        String string2 = CLionProfilingBundle.message("profiler.eventtracer.pid", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        $this$group.row((String)$bolder.invoke((Object)string2), arg_0 -> GoogleTraceIntervalEvent.toLabel$lambda$6$0$3($textual, this$0, arg_0));
        String string3 = CLionProfilingBundle.message("profiler.eventtracer.tid", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        $this$group.row((String)$bolder.invoke((Object)string3), arg_0 -> GoogleTraceIntervalEvent.toLabel$lambda$6$0$4($textual, this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit toLabel$lambda$6$0$0(Function1 $textual, GoogleTraceIntervalEvent this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label((String)$textual.invoke((Object)String.valueOf(this$0.name)));
        return Unit.INSTANCE;
    }

    private static final Unit toLabel$lambda$6$0$1(Function1 $textual, GoogleTraceIntervalEvent this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label((String)$textual.invoke((Object)String.valueOf(this$0.cat)));
        return Unit.INSTANCE;
    }

    private static final Unit toLabel$lambda$6$0$2(Function1 $textual, GoogleTraceIntervalEvent this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = new NlsMessages.NlsDurationFormatter().setNarrow(false).setDurationTimeUnit(this$0.getTimeUnit()).formatDuration(this$0.getDuration());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatDuration(...)");
        $this$row.label((String)$textual.invoke((Object)string));
        return Unit.INSTANCE;
    }

    private static final Unit toLabel$lambda$6$0$3(Function1 $textual, GoogleTraceIntervalEvent this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label((String)$textual.invoke((Object)(this$0.pid + " ")));
        return Unit.INSTANCE;
    }

    private static final Unit toLabel$lambda$6$0$4(Function1 $textual, GoogleTraceIntervalEvent this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label((String)$textual.invoke((Object)(this$0.tid + " ")));
        return Unit.INSTANCE;
    }

    private static final Unit toLabel$lambda$6$1(GoogleTraceIntervalEvent this$0, Function1 $bolder, Filter $filter, Function1 $argumentLabel, Function1 $argumentLink, Panel $this$group) {
        Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
        for (Map.Entry<String, Object> arg : this$0.args.entrySet()) {
            Panel.row$default((Panel)$this$group, null, arg_0 -> GoogleTraceIntervalEvent.toLabel$lambda$6$1$0($bolder, arg, $filter, $argumentLabel, $argumentLink, arg_0), (int)1, null).layout(RowLayout.LABEL_ALIGNED);
        }
        return Unit.INSTANCE;
    }

    private static final Unit toLabel$lambda$6$1$0(Function1 $bolder, Map.Entry $arg, Filter $filter, Function1 $argumentLabel, Function1 $argumentLink, Row $this$row) {
        Filter.Result filterResult;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label((String)$bolder.invoke((Object)($arg.getKey() + ":"))).align((Align)AlignY.TOP.INSTANCE).gap(RightGap.SMALL);
        Cell cell = $filter == null ? $this$row.cell((JComponent)$argumentLabel.invoke((Object)$arg.getValue().toString())) : ((filterResult = $filter.applyFilter($arg.getValue().toString(), $arg.getValue().toString().length())) == null || filterResult.getFirstHyperlinkInfo() == null ? $this$row.cell((JComponent)$argumentLabel.invoke((Object)$arg.getValue().toString())).applyToComponent(arg_0 -> GoogleTraceIntervalEvent.toLabel$lambda$6$1$0$0($arg, arg_0)) : $this$row.cell((JComponent)$argumentLink.invoke((Object)$arg.getValue().toString())).applyToComponent(arg_0 -> GoogleTraceIntervalEvent.toLabel$lambda$6$1$0$1($arg, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit toLabel$lambda$6$1$0$0(Map.Entry $arg, JEditorPane $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.getAccessibleContext().setAccessibleName((String)$arg.getKey());
        return Unit.INSTANCE;
    }

    private static final Unit toLabel$lambda$6$1$0$1(Map.Entry $arg, JEditorPane $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.getAccessibleContext().setAccessibleName((String)$arg.getKey());
        return Unit.INSTANCE;
    }
}

