/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.profiling.eventtrace.intervals;

import com.intellij.clion.profiling.eventtrace.abstractevent.TraceTimeEvent;
import com.intellij.clion.profiling.eventtrace.event.CompleteGoogleTraceEvent;
import com.intellij.clion.profiling.eventtrace.event.DurationGoogleTraceEvent;
import com.intellij.clion.profiling.eventtrace.event.InstantGoogleTraceEvent;
import com.intellij.clion.profiling.eventtrace.exception.IncompleteDurationEventException;
import com.intellij.clion.profiling.eventtrace.intervals.GoogleTraceIntervalEvent;
import com.intellij.clion.profiling.eventtrace.intervals.TraceEventLineInterval;
import com.intellij.clion.profiling.eventtrace.parser.IteratorCombinatorParser;
import com.intellij.clion.profiling.eventtrace.parser.events.GoogleTraceEventParser;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B'\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u0017\u001a\u00020\bH\u0002J\u001c\u0010\u0018\u001a\u00020\b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u00162\b\u0010\u001a\u001a\u0004\u0018\u00010\bH\u0002J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0016\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\"R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\b0\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010#\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020%\u0012\u0004\u0012\u00020&0$\u00a2\u0006\u0002\b'8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R3\u0010*\u001a!\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020%\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010+0$\u00a2\u0006\u0002\b'8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010)\u00a8\u0006-"}, d2={"Lcom/intellij/clion/profiling/eventtrace/intervals/EventToTreeGoogleEventParser;", "Lcom/intellij/clion/profiling/eventtrace/parser/IteratorCombinatorParser;", "Lcom/intellij/clion/profiling/eventtrace/abstractevent/TraceTimeEvent;", "Lcom/intellij/clion/profiling/eventtrace/intervals/TraceEventLineInterval;", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "colors", "", "Lcom/intellij/ui/JBColor;", "googleTraceEventParser", "Lcom/intellij/clion/profiling/eventtrace/parser/events/GoogleTraceEventParser;", "<init>", "(Ljava/util/concurrent/TimeUnit;[Lcom/intellij/ui/JBColor;Lcom/intellij/clion/profiling/eventtrace/parser/events/GoogleTraceEventParser;)V", "getTimeUnit", "()Ljava/util/concurrent/TimeUnit;", "setTimeUnit", "(Ljava/util/concurrent/TimeUnit;)V", "[Lcom/intellij/ui/JBColor;", "countColor", "", "nameColor", "", "", "generateNewColor", "getColor", "name", "color", "getInstance", "Lcom/intellij/clion/profiling/eventtrace/intervals/GoogleTraceIntervalEvent;", "event", "Lcom/intellij/clion/profiling/eventtrace/event/CompleteGoogleTraceEvent;", "eventStart", "Lcom/intellij/clion/profiling/eventtrace/event/DurationGoogleTraceEvent;", "eventEnd", "Lcom/intellij/clion/profiling/eventtrace/event/InstantGoogleTraceEvent;", "enter", "Lkotlin/Function1;", "", "", "Lkotlin/ExtensionFunctionType;", "getEnter", "()Lkotlin/jvm/functions/Function1;", "apply", "", "getApply", "intellij.clion.profiling"})
@SourceDebugExtension(value={"SMAP\nEventToTreeGoogleEventParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EventToTreeGoogleEventParser.kt\ncom/intellij/clion/profiling/eventtrace/intervals/EventToTreeGoogleEventParser\n+ 2 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n*L\n1#1,156:1\n32#2,2:157\n*S KotlinDebug\n*F\n+ 1 EventToTreeGoogleEventParser.kt\ncom/intellij/clion/profiling/eventtrace/intervals/EventToTreeGoogleEventParser\n*L\n135#1:157,2\n*E\n"})
public final class EventToTreeGoogleEventParser
extends IteratorCombinatorParser<TraceTimeEvent, TraceEventLineInterval> {
    @NotNull
    private TimeUnit timeUnit;
    @NotNull
    private final JBColor[] colors;
    @NotNull
    private final GoogleTraceEventParser googleTraceEventParser;
    private int countColor;
    @NotNull
    private final Map<String, JBColor> nameColor;

    public EventToTreeGoogleEventParser(@NotNull TimeUnit timeUnit, @NotNull JBColor[] colors, @NotNull GoogleTraceEventParser googleTraceEventParser) {
        Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"timeUnit");
        Intrinsics.checkNotNullParameter((Object)colors, (String)"colors");
        Intrinsics.checkNotNullParameter((Object)googleTraceEventParser, (String)"googleTraceEventParser");
        this.timeUnit = timeUnit;
        this.colors = colors;
        this.googleTraceEventParser = googleTraceEventParser;
        this.nameColor = new HashMap();
    }

    public /* synthetic */ EventToTreeGoogleEventParser(TimeUnit timeUnit, JBColor[] jBColorArray, GoogleTraceEventParser googleTraceEventParser, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            JBColor[] jBColorArray2 = new JBColor[2];
            Intrinsics.checkNotNullExpressionValue((Object)JBColor.ORANGE, (String)"ORANGE");
            Intrinsics.checkNotNullExpressionValue((Object)JBColor.YELLOW, (String)"YELLOW");
            jBColorArray = jBColorArray2;
        }
        this(timeUnit, jBColorArray, googleTraceEventParser);
    }

    @NotNull
    public final TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public final void setTimeUnit(@NotNull TimeUnit timeUnit) {
        Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"<set-?>");
        this.timeUnit = timeUnit;
    }

    private final JBColor generateNewColor() {
        this.countColor = (this.countColor + 1) % this.colors.length;
        return this.colors[this.countColor];
    }

    private final JBColor getColor(String name, JBColor color) {
        JBColor jBColor = color;
        if (jBColor == null) {
            if (name != null) {
                JBColor newColor = this.nameColor.get(name);
                if (newColor == null) {
                    this.nameColor.put(name, this.generateNewColor());
                }
                JBColor jBColor2 = this.nameColor.get(name);
                Intrinsics.checkNotNull((Object)jBColor2);
                return jBColor2;
            }
            jBColor = this.generateNewColor();
        }
        return jBColor;
    }

    @NotNull
    public final GoogleTraceIntervalEvent getInstance(@NotNull CompleteGoogleTraceEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String string = event.getName();
        String string2 = event.getCat();
        long l = event.getTs();
        long l2 = event.getTs() + event.getDur();
        Long l3 = event.getPart().get("pid");
        Intrinsics.checkNotNull((Object)l3);
        long l4 = ((Number)l3).longValue();
        Long l5 = event.getPart().get("tid");
        Intrinsics.checkNotNull((Object)l5);
        return new GoogleTraceIntervalEvent(string, string2, l, l2, l4, ((Number)l5).longValue(), event.getArgs(), (Color)this.getColor(event.getName(), event.getColor()), this.timeUnit);
    }

    @NotNull
    public final GoogleTraceIntervalEvent getInstance(@NotNull DurationGoogleTraceEvent eventStart, @NotNull DurationGoogleTraceEvent eventEnd) {
        Intrinsics.checkNotNullParameter((Object)eventStart, (String)"eventStart");
        Intrinsics.checkNotNullParameter((Object)eventEnd, (String)"eventEnd");
        Long l = eventStart.getPart().get("pid");
        Intrinsics.checkNotNull((Object)l);
        long l2 = ((Number)l).longValue();
        Long l3 = eventEnd.getPart().get("pid");
        Intrinsics.checkNotNull((Object)l3);
        if (l2 != ((Number)l3).longValue()) {
            throw new IllegalArgumentException("Can't get start and end event with different pid");
        }
        Long l4 = eventStart.getPart().get("tid");
        Intrinsics.checkNotNull((Object)l4);
        long l5 = ((Number)l4).longValue();
        Long l6 = eventEnd.getPart().get("tid");
        Intrinsics.checkNotNull((Object)l6);
        if (l5 != ((Number)l6).longValue()) {
            throw new IllegalArgumentException("Can't get start and end event with different tid");
        }
        String string = eventStart.getName();
        String string2 = eventStart.getCat();
        long l7 = eventStart.getTs();
        long l8 = eventEnd.getTs();
        Long l9 = eventStart.getPart().get("pid");
        Intrinsics.checkNotNull((Object)l9);
        long l10 = ((Number)l9).longValue();
        Long l11 = eventStart.getPart().get("tid");
        Intrinsics.checkNotNull((Object)l11);
        return new GoogleTraceIntervalEvent(string, string2, l7, l8, l10, ((Number)l11).longValue(), eventStart.getArgs(), (Color)this.getColor(eventStart.getName(), eventStart.getColor()), this.timeUnit);
    }

    @NotNull
    public final GoogleTraceIntervalEvent getInstance(@NotNull InstantGoogleTraceEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String string = event.getName();
        String string2 = event.getCat();
        long l = event.getTs();
        long l2 = event.getTs() + 1L;
        Long l3 = event.getPart().get("pid");
        Intrinsics.checkNotNull((Object)l3);
        long l4 = ((Number)l3).longValue();
        Long l5 = event.getPart().get("tid");
        Intrinsics.checkNotNull((Object)l5);
        return new GoogleTraceIntervalEvent(string, string2, l, l2, l4, ((Number)l5).longValue(), event.getArgs(), (Color)this.getColor(event.getName(), event.getColor()), this.timeUnit);
    }

    @Override
    @NotNull
    public Function1<Iterator<? extends TraceTimeEvent>, Boolean> getEnter() {
        return EventToTreeGoogleEventParser::_get_enter_$lambda$0;
    }

    @Override
    @NotNull
    public Function1<Iterator<? extends TraceTimeEvent>, List<TraceEventLineInterval>> getApply() {
        return arg_0 -> EventToTreeGoogleEventParser._get_apply_$lambda$0(this, arg_0);
    }

    private static final boolean _get_enter_$lambda$0(Iterator iterator) {
        Intrinsics.checkNotNullParameter((Object)iterator, (String)"<this>");
        return true;
    }

    private static final List _get_apply_$lambda$0(EventToTreeGoogleEventParser this$0, Iterator iterator) {
        Intrinsics.checkNotNullParameter((Object)iterator, (String)"<this>");
        List list = new ArrayList();
        ListIterator<TraceEventLineInterval> iterator2 = list.listIterator();
        Deque openEvents = new LinkedList();
        Iterator $this$forEach$iv = iterator;
        boolean $i$f$forEach = false;
        Iterator iterator3 = $this$forEach$iv;
        while (iterator3.hasNext()) {
            Object element$iv = iterator3.next();
            TraceTimeEvent it = (TraceTimeEvent)element$iv;
            boolean bl = false;
            TraceTimeEvent traceTimeEvent = it;
            if (traceTimeEvent instanceof DurationGoogleTraceEvent) {
                String string = ((DurationGoogleTraceEvent)it).getPh();
                if (Intrinsics.areEqual((Object)string, (Object)"B")) {
                    openEvents.add(it);
                    continue;
                }
                if (!Intrinsics.areEqual((Object)string, (Object)"E")) continue;
                if (openEvents.isEmpty()) {
                    throw new IncompleteDurationEventException();
                }
                DurationGoogleTraceEvent previous = (DurationGoogleTraceEvent)openEvents.removeLast();
                Intrinsics.checkNotNull((Object)previous);
                iterator2.add(new TraceEventLineInterval(this$0.getInstance(previous, (DurationGoogleTraceEvent)it)));
                continue;
            }
            if (traceTimeEvent instanceof CompleteGoogleTraceEvent) {
                iterator2.add(new TraceEventLineInterval(this$0.getInstance((CompleteGoogleTraceEvent)it)));
                continue;
            }
            if (traceTimeEvent instanceof InstantGoogleTraceEvent) {
                iterator2.add(new TraceEventLineInterval(this$0.getInstance((InstantGoogleTraceEvent)it)));
                continue;
            }
            throw new IllegalStateException("Unsupported type of event: " + it);
        }
        return list;
    }
}

