/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cidr.profiling.valgrind;

import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ValgrindSettings", storages={@Storage(value="other.xml")})
public class ValgrindSettings
implements PersistentStateComponent<ValgrindSettings> {
    @NotNull
    private String myValgrindPath;
    @NotNull
    private String myAnalysisOptions;
    @NotNull
    private List<String> mySuppressionFiles;

    public ValgrindSettings() {
        File detectedValgrindExecutable = PathEnvironmentVariableUtil.findInPath((String)"valgrind");
        this.myValgrindPath = detectedValgrindExecutable != null ? detectedValgrindExecutable.getPath() : "";
        this.myAnalysisOptions = ValgrindSettings.getDefaultAnalysisOptions();
        this.mySuppressionFiles = Collections.emptyList();
    }

    @Nullable
    public ValgrindSettings getState() {
        return this;
    }

    public void loadState(@NotNull ValgrindSettings state) {
        if (state == null) {
            ValgrindSettings.$$$reportNull$$$0(0);
        }
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
    }

    @NotNull
    public static ValgrindSettings getInstance() {
        ValgrindSettings valgrindSettings = (ValgrindSettings)ApplicationManager.getApplication().getService(ValgrindSettings.class);
        if (valgrindSettings == null) {
            ValgrindSettings.$$$reportNull$$$0(1);
        }
        return valgrindSettings;
    }

    @NlsSafe
    @NotNull
    public synchronized String getValgrindPath() {
        String string = this.myValgrindPath;
        if (string == null) {
            ValgrindSettings.$$$reportNull$$$0(2);
        }
        return string;
    }

    public synchronized void setValgrindPath(@NotNull String valgrindPath) {
        if (valgrindPath == null) {
            ValgrindSettings.$$$reportNull$$$0(3);
        }
        this.myValgrindPath = valgrindPath;
    }

    @NotNull
    public synchronized String getAnalysisOptions() {
        String string = this.myAnalysisOptions;
        if (string == null) {
            ValgrindSettings.$$$reportNull$$$0(4);
        }
        return string;
    }

    public synchronized void setAnalysisOptions(@NotNull String analysisOptions) {
        if (analysisOptions == null) {
            ValgrindSettings.$$$reportNull$$$0(5);
        }
        this.myAnalysisOptions = analysisOptions;
    }

    @NotNull
    public synchronized List<String> getSuppressionFiles() {
        List<String> list = this.mySuppressionFiles;
        if (list == null) {
            ValgrindSettings.$$$reportNull$$$0(6);
        }
        return list;
    }

    public synchronized void setSuppressionFiles(@NotNull List<String> suppressionFiles) {
        if (suppressionFiles == null) {
            ValgrindSettings.$$$reportNull$$$0(7);
        }
        this.mySuppressionFiles = List.copyOf(suppressionFiles);
    }

    @NlsSafe
    @NotNull
    public static String getDefaultAnalysisOptions() {
        return "--leak-check=full --leak-resolution=med --track-origins=yes --vgdb=no";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/cidr/profiling/valgrind/ValgrindSettings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valgrindPath";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "analysisOptions";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suppressionFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/cidr/profiling/valgrind/ValgrindSettings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getValgrindPath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnalysisOptions";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuppressionFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setValgrindPath";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setAnalysisOptions";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setSuppressionFiles";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4, 6 -> new IllegalStateException(string);
        };
    }
}

