/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cidr.profiling.valgrind;

import com.intellij.cidr.profiling.memory.MemoryProfileEnvironment;
import com.intellij.cidr.profiling.memory.MemoryProfileTreeDataModel;
import com.intellij.cidr.profiling.memory.error.MemoryProfileError;
import com.intellij.cidr.profiling.memory.error.MemoryProfileFrame;
import com.intellij.cidr.profiling.memory.error.MemoryProfileProblemDescription;
import com.intellij.cidr.profiling.memory.error.MemoryProfileStack;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ValgrindHandler
extends DefaultHandler {
    private static final Logger LOG = Logger.getInstance(ValgrindHandler.class);
    @NlsSafe
    private static final String ERROR_ELEMENT = "error";
    @NlsSafe
    private static final String KIND_ELEMENT = "kind";
    @NlsSafe
    private static final String WHAT_ELEMENT = "what";
    @NlsSafe
    private static final String XWHAT_ELEMENT = "xwhat";
    @NlsSafe
    private static final String STACK_ELEMENT = "stack";
    @NlsSafe
    private static final String FRAME_ELEMENT = "frame";
    @NlsSafe
    private static final String IP_ELEMENT = "ip";
    @NlsSafe
    private static final String OBJ_ELEMENT = "obj";
    @NlsSafe
    private static final String FN_ELEMENT = "fn";
    @NlsSafe
    private static final String DIR_ELEMENT = "dir";
    @NlsSafe
    private static final String FILE_ELEMENT = "file";
    @NlsSafe
    private static final String LINE_ELEMENT = "line";
    @NlsSafe
    private static final String TEXT_ELEMENT = "text";
    @NlsSafe
    private static final String AUXWHAT_ELEMENT = "auxwhat";
    @NlsSafe
    private static final String XAUXWHAT_ELEMENT = "xauxwhat";
    @NlsSafe
    private static final String SUPPRESSION_ELEMENT = "suppression";
    @NlsSafe
    private static final String RAW_TEXT_ELEMENT = "rawtext";
    @NlsSafe
    private static final String CDATA_BEGIN = "<![CDATA[";
    @NlsSafe
    private static final String CDATA_END = "]]>";
    @NotNull
    private final MemoryProfileTreeDataModel myModel;
    private final MemoryProfileEnvironment myEnvironment;
    private boolean myInsideErrorElement;
    private boolean myInsideXWhatElement;
    private boolean myInsideSuppression;
    private MemoryProfileError myCurrentError;
    private StringBuilder myElementText;

    public ValgrindHandler(@NotNull MemoryProfileTreeDataModel model, @NotNull MemoryProfileEnvironment environment) {
        if (model == null) {
            ValgrindHandler.$$$reportNull$$$0(0);
        }
        if (environment == null) {
            ValgrindHandler.$$$reportNull$$$0(1);
        }
        this.myModel = model;
        this.myEnvironment = environment;
        this.myInsideErrorElement = false;
        this.myInsideXWhatElement = false;
        this.myInsideSuppression = false;
        this.myCurrentError = null;
        this.myElementText = null;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals(ERROR_ELEMENT)) {
            this.myInsideErrorElement = true;
            this.startNewError();
            this.clearTextBuffer();
            return;
        }
        if (!this.myInsideErrorElement) {
            return;
        }
        if (qName.equals(XWHAT_ELEMENT) || qName.equals(XAUXWHAT_ELEMENT)) {
            this.myInsideXWhatElement = true;
        }
        switch (qName) {
            case "what": 
            case "xwhat": 
            case "auxwhat": 
            case "xauxwhat": {
                this.myCurrentError.getProblemDescriptions().add(new MemoryProfileProblemDescription(""));
                break;
            }
            case "stack": {
                if (!this.myCurrentError.getProblemDescriptions().isEmpty() && this.getCurrentProblemDescription().getStack().isEmpty()) break;
                this.myCurrentError.getProblemDescriptions().add(new MemoryProfileProblemDescription(""));
                break;
            }
            case "frame": {
                this.getCurrentStack().pushFrame(new MemoryProfileFrame());
                break;
            }
            case "suppression": {
                this.myInsideSuppression = true;
            }
        }
        this.clearTextBuffer();
    }

    @Override
    public void characters(char[] ch, int start2, int length) throws SAXException {
        if (this.myInsideErrorElement) {
            this.myElementText.append(ch, start2, length);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (!this.myInsideErrorElement) {
            this.clearTextBuffer();
            return;
        }
        if (this.myInsideSuppression) {
            if (qName.equals(SUPPRESSION_ELEMENT)) {
                this.myInsideSuppression = false;
            } else if (qName.equals(RAW_TEXT_ELEMENT)) {
                String rawText = this.myElementText.toString();
                this.myCurrentError.setSuppression(ValgrindHandler.removeCDataFromRawText(rawText));
            }
            this.clearTextBuffer();
            return;
        }
        if (this.myInsideXWhatElement) {
            if (qName.equals(TEXT_ELEMENT)) {
                this.getCurrentProblemDescription().appendText(this.myElementText.toString());
            } else if (qName.equals(XWHAT_ELEMENT) || qName.equals(XAUXWHAT_ELEMENT)) {
                this.myInsideXWhatElement = false;
            }
        } else {
            switch (qName) {
                case "error": {
                    this.myInsideErrorElement = false;
                    MemoryProfileError error = this.myCurrentError;
                    LOG.debug("Adding error to model: " + error.getKind());
                    ApplicationManager.getApplication().invokeLater(() -> this.myModel.addError(error));
                    break;
                }
                case "kind": {
                    this.myCurrentError.setKind(this.myElementText.toString());
                    break;
                }
                case "what": 
                case "auxwhat": {
                    this.getCurrentProblemDescription().appendText(this.myElementText.toString());
                    break;
                }
                case "ip": {
                    this.getCurrentFrame().setInstructionPointer(this.myElementText.toString());
                    break;
                }
                case "obj": {
                    this.getCurrentFrame().setBinary(this.toLocalPath(this.myElementText.toString()));
                    break;
                }
                case "fn": {
                    this.getCurrentFrame().setFunction(this.myElementText.toString());
                    break;
                }
                case "dir": {
                    this.getCurrentFrame().setDirectory(this.toLocalPath(this.myElementText.toString()));
                    this.getCurrentFrame().setResolvedLocalDirectory(this.myEnvironment.tryResolvePath(this.myElementText.toString()));
                    break;
                }
                case "file": {
                    this.getCurrentFrame().setFile(this.myElementText.toString());
                    break;
                }
                case "line": {
                    this.getCurrentFrame().setLine(this.myElementText.toString());
                }
            }
        }
        this.clearTextBuffer();
    }

    @NotNull
    private MemoryProfileProblemDescription getCurrentProblemDescription() {
        List<MemoryProfileProblemDescription> problemDescriptions = this.myCurrentError.getProblemDescriptions();
        LOG.assertTrue(!problemDescriptions.isEmpty());
        MemoryProfileProblemDescription memoryProfileProblemDescription = problemDescriptions.get(problemDescriptions.size() - 1);
        if (memoryProfileProblemDescription == null) {
            ValgrindHandler.$$$reportNull$$$0(2);
        }
        return memoryProfileProblemDescription;
    }

    @NotNull
    private MemoryProfileStack getCurrentStack() {
        MemoryProfileStack memoryProfileStack = this.getCurrentProblemDescription().getStack();
        if (memoryProfileStack == null) {
            ValgrindHandler.$$$reportNull$$$0(3);
        }
        return memoryProfileStack;
    }

    @NotNull
    private String toLocalPath(@NotNull String path) {
        if (path == null) {
            ValgrindHandler.$$$reportNull$$$0(4);
        }
        String string = this.myEnvironment.toLocalPath(path);
        if (string == null) {
            ValgrindHandler.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    private MemoryProfileFrame getCurrentFrame() {
        MemoryProfileFrame memoryProfileFrame = this.getCurrentStack().getOutermostFrame();
        if (memoryProfileFrame == null) {
            ValgrindHandler.$$$reportNull$$$0(6);
        }
        return memoryProfileFrame;
    }

    private void startNewError() {
        this.myCurrentError = new MemoryProfileError();
    }

    private void clearTextBuffer() {
        this.myElementText = new StringBuilder();
    }

    private static String removeCDataFromRawText(@NotNull String rawText) {
        if (rawText == null) {
            ValgrindHandler.$$$reportNull$$$0(7);
        }
        StringBuilder filteredText = new StringBuilder();
        int restIndex = 0;
        int beginIndex = rawText.indexOf(CDATA_BEGIN);
        while (beginIndex != -1) {
            int endIndex = rawText.indexOf(CDATA_END, beginIndex);
            LOG.assertTrue(endIndex != -1);
            filteredText.append(rawText, beginIndex + CDATA_BEGIN.length(), endIndex);
            restIndex = endIndex + CDATA_END.length();
            beginIndex = rawText.indexOf(CDATA_BEGIN, restIndex);
        }
        if (restIndex < rawText.length()) {
            filteredText.append(rawText, restIndex, rawText.length());
        }
        return filteredText.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/cidr/profiling/valgrind/ValgrindHandler";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/cidr/profiling/valgrind/ValgrindHandler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentProblemDescription";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentStack";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "toLocalPath";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentFrame";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "toLocalPath";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removeCDataFromRawText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 5, 6 -> new IllegalStateException(string);
        };
    }
}

