/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cidr.profiling.valgrind;

import com.intellij.cidr.profiling.CidrProfilingBundle;
import com.intellij.cidr.profiling.valgrind.ValgrindSettings;
import com.intellij.ide.util.BrowseFilesListener;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.CommonActionsPanel;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BottomGap;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListModel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0010\u001a\u00020\rH\u0016J\r\u0010\u0011\u001a\u00070\r\u00a2\u0006\u0002\b\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0018H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\u0011\u0010\u001c\u001a\u00020\r*\u00070\r\u00a2\u0006\u0002\b\u0012H\u0003J\b\u0010\u001d\u001a\u00020\u0018H\u0002J\b\u0010\u001e\u001a\u00020\rH\u0016R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\r\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/cidr/profiling/valgrind/ValgrindConfigurable;", "Lcom/intellij/openapi/options/SearchableConfigurable;", "<init>", "()V", "mySettings", "Lcom/intellij/cidr/profiling/valgrind/ValgrindSettings;", "Lorg/jetbrains/annotations/NotNull;", "myValgrindPathTextFieldWithBrowseButton", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "myCommandLineEditor", "Lcom/intellij/ui/RawCommandLineEditor;", "mySuppressionListModel", "Ljavax/swing/DefaultListModel;", "", "mySuppressionFiles", "", "getId", "getDisplayName", "Lorg/jetbrains/annotations/Nls;", "createComponent", "Ljavax/swing/JComponent;", "isModified", "", "apply", "", "reset", "createSuppressionFilesPanel", "Ljavax/swing/JPanel;", "withTrailingColon", "resetSuppressionFilesModel", "getHelpTopic", "intellij.cidr.profiling"})
public final class ValgrindConfigurable
implements SearchableConfigurable {
    @NotNull
    private final ValgrindSettings mySettings;
    @NotNull
    private TextFieldWithBrowseButton myValgrindPathTextFieldWithBrowseButton;
    @NotNull
    private final RawCommandLineEditor myCommandLineEditor;
    @Nullable
    private DefaultListModel<String> mySuppressionListModel;
    @NotNull
    private List<String> mySuppressionFiles;

    public ValgrindConfigurable() {
        ValgrindSettings valgrindSettings = ValgrindSettings.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)valgrindSettings, (String)"getInstance(...)");
        this.mySettings = valgrindSettings;
        this.myValgrindPathTextFieldWithBrowseButton = new TextFieldWithBrowseButton();
        this.myCommandLineEditor = new RawCommandLineEditor();
        this.mySuppressionFiles = new ArrayList(this.mySettings.getSuppressionFiles());
    }

    @NotNull
    public String getId() {
        return "dynamic.analysis.tools.valgrind";
    }

    @NotNull
    public String getDisplayName() {
        String string = CidrProfilingBundle.message("dynamic.analysis.tools.valgrind.configurable.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public JComponent createComponent() {
        this.myValgrindPathTextFieldWithBrowseButton.setText(this.mySettings.getValgrindPath());
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileOrExecutableAppDescriptor().withTitle(CidrProfilingBundle.message("valgrind.configurable.executable.dialog.title", new Object[0]));
        BrowseFilesListener listener = new BrowseFilesListener(this.myValgrindPathTextFieldWithBrowseButton.getTextField(), descriptor);
        this.myValgrindPathTextFieldWithBrowseButton.addActionListener((ActionListener)listener);
        return (JComponent)BuilderKt.panel(arg_0 -> ValgrindConfigurable.createComponent$lambda$0(this, arg_0));
    }

    public boolean isModified() {
        return !Intrinsics.areEqual((Object)this.myValgrindPathTextFieldWithBrowseButton.getText(), (Object)this.mySettings.getValgrindPath()) || !Intrinsics.areEqual((Object)this.myCommandLineEditor.getText(), (Object)this.mySettings.getAnalysisOptions()) || !Intrinsics.areEqual(this.mySuppressionFiles, this.mySettings.getSuppressionFiles());
    }

    public void apply() throws ConfigurationException {
        this.mySettings.setValgrindPath(this.myValgrindPathTextFieldWithBrowseButton.getText());
        this.mySettings.setAnalysisOptions(this.myCommandLineEditor.getText());
        this.mySettings.setSuppressionFiles(this.mySuppressionFiles);
    }

    public void reset() {
        this.myValgrindPathTextFieldWithBrowseButton.setText(this.mySettings.getValgrindPath());
        this.myCommandLineEditor.setText(this.mySettings.getAnalysisOptions());
        this.mySuppressionFiles = new ArrayList(this.mySettings.getSuppressionFiles());
        this.resetSuppressionFilesModel();
    }

    private final JPanel createSuppressionFilesPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.mySuppressionListModel = new DefaultListModel();
        for (String suppressionFile : this.mySuppressionFiles) {
            DefaultListModel<String> defaultListModel = this.mySuppressionListModel;
            Intrinsics.checkNotNull(defaultListModel);
            defaultListModel.addElement(suppressionFile);
        }
        DefaultListModel<String> defaultListModel = this.mySuppressionListModel;
        Intrinsics.checkNotNull(defaultListModel);
        JBList suppressionFilesList = new JBList((ListModel)defaultListModel);
        suppressionFilesList.getEmptyText().setText(CidrProfilingBundle.message("valgrind.configurable.no.suppression.files", new Object[0]));
        suppressionFilesList.setSelectionMode(0);
        suppressionFilesList.setVisibleRowCount(5);
        String[] stringArray = new String[]{CommonActionsPanel.Buttons.ADD.getText(), CommonActionsPanel.Buttons.REMOVE.getText()};
        ToolbarDecorator toolbarDecorator = ToolbarDecorator.createDecorator((JList)((JList)suppressionFilesList)).setAddAction(arg_0 -> ValgrindConfigurable.createSuppressionFilesPanel$lambda$0(this, arg_0)).setRemoveAction(arg_0 -> ValgrindConfigurable.createSuppressionFilesPanel$lambda$1(suppressionFilesList, this, arg_0)).setButtonComparator(stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)toolbarDecorator, (String)"setButtonComparator(...)");
        ToolbarDecorator decorator = toolbarDecorator;
        decorator.setToolbarPosition(ActionToolbarPosition.RIGHT);
        String string = CidrProfilingBundle.message("valgrind.configurable.add.suppression.files.label", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        panel.add((Component)new JLabel(this.withTrailingColon(string)), "North");
        panel.add((Component)decorator.createPanel(), "Center");
        return panel;
    }

    @Nls
    private final String withTrailingColon(String $this$withTrailingColon) {
        return $this$withTrailingColon + ":";
    }

    private final void resetSuppressionFilesModel() {
        DefaultListModel<String> defaultListModel = this.mySuppressionListModel;
        Intrinsics.checkNotNull(defaultListModel);
        defaultListModel.removeAllElements();
        for (String suppressionFile : this.mySuppressionFiles) {
            DefaultListModel<String> defaultListModel2 = this.mySuppressionListModel;
            Intrinsics.checkNotNull(defaultListModel2);
            defaultListModel2.addElement(suppressionFile);
        }
    }

    @NotNull
    public String getHelpTopic() {
        return "Valgrind";
    }

    private static final Unit createComponent$lambda$0(ValgrindConfigurable this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        String string = CidrProfilingBundle.message("valgrind.configurable.executable.label", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$panel.row(this$0.withTrailingColon(string), arg_0 -> ValgrindConfigurable.createComponent$lambda$0$0(this$0, arg_0)).bottomGap(BottomGap.SMALL);
        String string2 = CidrProfilingBundle.message("valgrind.confugurable.analysisOptions.label", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        $this$panel.row(this$0.withTrailingColon(string2), arg_0 -> ValgrindConfigurable.createComponent$lambda$0$1(this$0, arg_0)).bottomGap(BottomGap.MEDIUM);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> ValgrindConfigurable.createComponent$lambda$0$2(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit createComponent$lambda$0$0(ValgrindConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.myValgrindPathTextFieldWithBrowseButton).align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit createComponent$lambda$0$1(ValgrindConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Cell.comment$default((Cell)$this$row.cell((JComponent)this$0.myCommandLineEditor), (String)CidrProfilingBundle.message("valgrind.argument.hint", new Object[0]), (int)0, null, (int)6, null).align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit createComponent$lambda$0$2(ValgrindConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.createSuppressionFilesPanel()).align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final void createSuppressionFilesPanel$lambda$0(ValgrindConfigurable this$0, AnActionButton it) {
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileDescriptor();
        FileChooser.chooseFiles((FileChooserDescriptor)descriptor, null, null, arg_0 -> ValgrindConfigurable.createSuppressionFilesPanel$lambda$0$1(arg_0 -> ValgrindConfigurable.createSuppressionFilesPanel$lambda$0$0(this$0, arg_0), arg_0));
    }

    private static final Unit createSuppressionFilesPanel$lambda$0$0(ValgrindConfigurable this$0, List files) {
        Intrinsics.checkNotNullParameter((Object)files, (String)"files");
        String string = ((VirtualFile)files.get(0)).getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String filePath = string;
        DefaultListModel<String> defaultListModel = this$0.mySuppressionListModel;
        Intrinsics.checkNotNull(defaultListModel);
        defaultListModel.addElement(filePath);
        this$0.mySuppressionFiles.add(filePath);
        return Unit.INSTANCE;
    }

    private static final void createSuppressionFilesPanel$lambda$0$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void createSuppressionFilesPanel$lambda$1(JBList $suppressionFilesList, ValgrindConfigurable this$0, AnActionButton it) {
        int selectedIndex = $suppressionFilesList.getSelectedIndex();
        DefaultListModel<String> defaultListModel = this$0.mySuppressionListModel;
        Intrinsics.checkNotNull(defaultListModel);
        defaultListModel.remove(selectedIndex);
        this$0.mySuppressionFiles.remove(selectedIndex);
    }
}

