/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cidr.profiling.valgrind;

import com.intellij.cidr.profiling.valgrind.ValgrindSettings;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public class ValgrindCommandLineParametersBuilder {
    @NotNull
    public List<String> build(@NotNull String outputFile) {
        if (outputFile == null) {
            ValgrindCommandLineParametersBuilder.$$$reportNull$$$0(0);
        }
        ValgrindSettings settings = ValgrindSettings.getInstance();
        List<String> list = this.build(settings.getAnalysisOptions(), settings.getSuppressionFiles(), outputFile);
        if (list == null) {
            ValgrindCommandLineParametersBuilder.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public List<String> build(@NotNull String analysisOptions, @NotNull List<String> suppressionFiles, @NotNull String outputFile) {
        if (analysisOptions == null) {
            ValgrindCommandLineParametersBuilder.$$$reportNull$$$0(2);
        }
        if (suppressionFiles == null) {
            ValgrindCommandLineParametersBuilder.$$$reportNull$$$0(3);
        }
        if (outputFile == null) {
            ValgrindCommandLineParametersBuilder.$$$reportNull$$$0(4);
        }
        List<Pair<@NlsSafe String, @NlsSafe String>> predefinedOptions = Arrays.asList(Pair.create((Object)"--tool", (Object)"memcheck"), Pair.create((Object)"--xml", (Object)"yes"), Pair.create((Object)"--xml-file", (Object)outputFile), Pair.create((Object)"--gen-suppressions", (Object)"all"));
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.addAll(ContainerUtil.map(predefinedOptions, pair -> ValgrindCommandLineParametersBuilder.createParameter((String)pair.first, (String)pair.second)));
        parameters.addAll(ValgrindCommandLineParametersBuilder.filterAnalysisOptions(analysisOptions, predefinedOptions));
        parameters.addAll(ValgrindCommandLineParametersBuilder.getSuppressionFiles(suppressionFiles));
        ArrayList<String> arrayList = parameters;
        if (arrayList == null) {
            ValgrindCommandLineParametersBuilder.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    public boolean tryAppend(@NotNull @NlsSafe String parameterName, @NotNull @NlsSafe String parameterValue, @NotNull List<String> parameters) {
        if (parameterName == null) {
            ValgrindCommandLineParametersBuilder.$$$reportNull$$$0(6);
        }
        if (parameterValue == null) {
            ValgrindCommandLineParametersBuilder.$$$reportNull$$$0(7);
        }
        if (parameters == null) {
            ValgrindCommandLineParametersBuilder.$$$reportNull$$$0(8);
        }
        for (String oldParameter : parameters) {
            int equalityIndex = oldParameter.indexOf("=");
            if (equalityIndex == -1) continue;
            String existParameterName = oldParameter.substring(0, equalityIndex);
            String existParameterValue = oldParameter.substring(equalityIndex + 1);
            if (!existParameterName.equals(parameterName)) continue;
            return existParameterValue.equals(parameterValue);
        }
        parameters.add(ValgrindCommandLineParametersBuilder.createParameter(parameterName, parameterValue));
        return true;
    }

    @NotNull
    private static String createParameter(@NotNull String parameterName, @NotNull String parameterValue) {
        if (parameterName == null) {
            ValgrindCommandLineParametersBuilder.$$$reportNull$$$0(9);
        }
        if (parameterValue == null) {
            ValgrindCommandLineParametersBuilder.$$$reportNull$$$0(10);
        }
        String string = parameterName + "=" + parameterValue;
        if (string == null) {
            ValgrindCommandLineParametersBuilder.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    private static @Unmodifiable List<String> filterAnalysisOptions(@NotNull String analysisOptions, @NotNull List<Pair<String, String>> predefinedOptions) {
        if (analysisOptions == null) {
            ValgrindCommandLineParametersBuilder.$$$reportNull$$$0(12);
        }
        if (predefinedOptions == null) {
            ValgrindCommandLineParametersBuilder.$$$reportNull$$$0(13);
        }
        List predefinedParameters = ContainerUtil.map(predefinedOptions, option -> (String)option.first);
        List parameters = ParametersListUtil.parse((String)analysisOptions);
        List list = ContainerUtil.filter((Collection)parameters, parameter -> !ContainerUtil.exists((Iterable)predefinedParameters, predefinedParameter -> parameter.startsWith((String)predefinedParameter)));
        if (list == null) {
            ValgrindCommandLineParametersBuilder.$$$reportNull$$$0(14);
        }
        return list;
    }

    @NotNull
    private static @Unmodifiable List<String> getSuppressionFiles(@NotNull List<String> suppressionFiles) {
        if (suppressionFiles == null) {
            ValgrindCommandLineParametersBuilder.$$$reportNull$$$0(15);
        }
        List list = ContainerUtil.map(suppressionFiles, suppressionFile -> "--suppressions=" + suppressionFile);
        if (list == null) {
            ValgrindCommandLineParametersBuilder.$$$reportNull$$$0(16);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 5, 11, 14, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputFile";
                break;
            }
            case 1: 
            case 5: 
            case 11: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/cidr/profiling/valgrind/ValgrindCommandLineParametersBuilder";
                break;
            }
            case 2: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "analysisOptions";
                break;
            }
            case 3: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suppressionFiles";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterName";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterValue";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predefinedOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/cidr/profiling/valgrind/ValgrindCommandLineParametersBuilder";
                break;
            }
            case 1: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "build";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createParameter";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "filterAnalysisOptions";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuppressionFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 1: 
            case 5: 
            case 11: 
            case 14: 
            case 16: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "tryAppend";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createParameter";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "filterAnalysisOptions";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressionFiles";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 5, 11, 14, 16 -> new IllegalStateException(string);
        };
    }
}

