/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.resharper.cpp.lexer;

import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerPosition;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.tree.IElementType;
import com.intellij.resharper.cpp.lexer.CachingLexerKt;
import com.intellij.resharper.cpp.lexer.CachingLexerPosition;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003./0B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0007J(\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0007H\u0016J\b\u0010\u0018\u001a\u00020\u0007H\u0016J\n\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0007H\u0016J\b\u0010\u001c\u001a\u00020\u0007H\u0016J\b\u0010\u001d\u001a\u00020\u0010H\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u001fH\u0016J\b\u0010\"\u001a\u00020\u0014H\u0016J\b\u0010#\u001a\u00020\u0007H\u0016J\u000e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0007J\u000e\u0010\u001d\u001a\u00020\u00102\u0006\u0010'\u001a\u00020\u0007J\u0006\u0010+\u001a\u00020\u0007J\b\u0010,\u001a\u00020-H\u0016R\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010(\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b)\u0010*\u00a8\u00061"}, d2={"Lcom/intellij/resharper/cpp/lexer/CachingLexer;", "Lcom/intellij/lexer/Lexer;", "lexer", "<init>", "(Lcom/intellij/lexer/Lexer;)V", "myLexer", "myCurrentCachedTokenIndex", "", "myTokens", "Lcom/intellij/resharper/cpp/lexer/CachingLexer$IArrayOfTokens;", "myCurrentCachedToken", "Lcom/intellij/resharper/cpp/lexer/CachingLexer$TokenProperties;", "tokensOrThrow", "getTokensOrThrow", "()Lcom/intellij/resharper/cpp/lexer/CachingLexer$IArrayOfTokens;", "setCurrentToken", "", "tokenNum", "start", "buffer", "", "startOffset", "endOffset", "initialState", "getState", "getTokenType", "Lcom/intellij/psi/tree/IElementType;", "getTokenStart", "getTokenEnd", "advance", "getCurrentPosition", "Lcom/intellij/lexer/LexerPosition;", "restore", "position", "getBufferSequence", "getBufferEnd", "findTokenAt", "", "pos", "delta", "currentRawPosition", "getCurrentRawPosition", "()I", "calculateTokensCount", "toString", "", "IArrayOfTokens", "TokenProperties", "LazyArrayOfTokens", "intellij.resharper.cpp.lexer"})
public final class CachingLexer
extends Lexer {
    @NotNull
    private Lexer myLexer;
    private int myCurrentCachedTokenIndex;
    @Nullable
    private IArrayOfTokens myTokens;
    @Nullable
    private TokenProperties myCurrentCachedToken;

    public CachingLexer(@NotNull Lexer lexer) {
        Intrinsics.checkNotNullParameter((Object)lexer, (String)"lexer");
        this.myLexer = lexer;
    }

    private final IArrayOfTokens getTokensOrThrow() {
        IArrayOfTokens iArrayOfTokens = this.myTokens;
        if (iArrayOfTokens == null) {
            throw new IllegalStateException("Not started".toString());
        }
        return iArrayOfTokens;
    }

    public final void setCurrentToken(int tokenNum) {
        this.myCurrentCachedTokenIndex = tokenNum;
        if (tokenNum < 0) {
            this.myCurrentCachedToken = null;
            return;
        }
        IArrayOfTokens tokens = this.getTokensOrThrow();
        TokenProperties token = tokens.tryGetToken(tokenNum);
        if (token != null) {
            this.myCurrentCachedToken = token;
            return;
        }
        int tokenCount = tokens.calculateTokensCount();
        if (tokenNum > tokenCount) {
            this.myCurrentCachedToken = null;
        } else {
            int n;
            boolean bl;
            boolean bl2 = bl = this.myCurrentCachedTokenIndex == tokenCount;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            if (this.myCurrentCachedTokenIndex == 0) {
                n = 0;
            } else {
                TokenProperties tokenProperties = tokens.tryGetToken(this.myCurrentCachedTokenIndex - 1);
                Intrinsics.checkNotNull((Object)tokenProperties);
                n = tokenProperties.getEnd();
            }
            int endMarker = n;
            this.myCurrentCachedToken = new TokenProperties(endMarker, endMarker, null, 0);
        }
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.myLexer.start(buffer, startOffset, endOffset, initialState);
        this.myTokens = new LazyArrayOfTokens(this.myLexer);
        this.setCurrentToken(0);
    }

    public int getState() {
        return 0;
    }

    @Nullable
    public IElementType getTokenType() {
        TokenProperties tokenProperties = this.myCurrentCachedToken;
        return tokenProperties != null ? tokenProperties.getTokenType() : null;
    }

    public int getTokenStart() {
        TokenProperties tokenProperties = this.myCurrentCachedToken;
        return tokenProperties != null ? tokenProperties.getStart() : -1;
    }

    public int getTokenEnd() {
        TokenProperties tokenProperties = this.myCurrentCachedToken;
        return tokenProperties != null ? tokenProperties.getEnd() : -1;
    }

    public void advance() {
        this.setCurrentToken(this.myCurrentCachedTokenIndex + 1);
    }

    @NotNull
    public LexerPosition getCurrentPosition() {
        return new CachingLexerPosition(this.myCurrentCachedTokenIndex);
    }

    public void restore(@NotNull LexerPosition position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        CachingLexerPosition cfr_ignored_0 = (CachingLexerPosition)position;
        this.setCurrentToken(((CachingLexerPosition)position).getOffset());
    }

    @NotNull
    public CharSequence getBufferSequence() {
        CharSequence charSequence = this.myLexer.getBufferSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getBufferSequence(...)");
        return charSequence;
    }

    public int getBufferEnd() {
        return this.myLexer.getBufferEnd();
    }

    public final boolean findTokenAt(int pos) {
        this.setCurrentToken(this.getTokensOrThrow().findTokenAt(pos));
        return this.getTokenType() != null;
    }

    public final void advance(int delta) {
        this.setCurrentToken(this.myCurrentCachedTokenIndex + delta);
    }

    public final int getCurrentRawPosition() {
        return this.myCurrentCachedTokenIndex;
    }

    public final int calculateTokensCount() {
        return this.getTokensOrThrow().calculateTokensCount();
    }

    @NotNull
    public String toString() {
        Object object = this.getTokenType();
        if (object == null || (object = object.toString()) == null) {
            object = "<null>";
        }
        Object tokenType = object;
        return (String)tokenType + " @ " + this.getTokenStart() + "-" + this.getTokenEnd();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0003H&J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/intellij/resharper/cpp/lexer/CachingLexer$IArrayOfTokens;", "", "calculateTokensCount", "", "tryGetToken", "Lcom/intellij/resharper/cpp/lexer/CachingLexer$TokenProperties;", "index", "findTokenAt", "pos", "intellij.resharper.cpp.lexer"})
    public static interface IArrayOfTokens {
        public int calculateTokensCount();

        @Nullable
        public TokenProperties tryGetToken(int var1);

        public int findTokenAt(int var1);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\nH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\nH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0010H\u0002J)\u0010\u0014\u001a\u00020\u0010*\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00100\u0017H\u0082\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/resharper/cpp/lexer/CachingLexer$LazyArrayOfTokens;", "Lcom/intellij/resharper/cpp/lexer/CachingLexer$IArrayOfTokens;", "lexer", "Lcom/intellij/lexer/Lexer;", "<init>", "(Lcom/intellij/lexer/Lexer;)V", "tokens", "", "Lcom/intellij/resharper/cpp/lexer/CachingLexer$TokenProperties;", "calculateTokensCount", "", "tryGetToken", "index", "findTokenAt", "pos", "generateAllTokens", "", "hasNextToken", "", "generateNextToken", "measureTime", "Lcom/intellij/openapi/diagnostic/Logger;", "lazyMessage", "Lkotlin/Function0;", "", "block", "intellij.resharper.cpp.lexer"})
    @SourceDebugExtension(value={"SMAP\nCachingLexer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CachingLexer.kt\ncom/intellij/resharper/cpp/lexer/CachingLexer$LazyArrayOfTokens\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,209:1\n182#1,14:210\n196#1,3:227\n201#1,2:231\n182#1,14:233\n196#1,3:250\n201#1,2:254\n182#1,14:256\n196#1,3:273\n201#1,2:277\n60#2,3:224\n64#2:230\n60#2,3:247\n64#2:253\n60#2,3:270\n64#2:276\n60#2,5:279\n*S KotlinDebug\n*F\n+ 1 CachingLexer.kt\ncom/intellij/resharper/cpp/lexer/CachingLexer$LazyArrayOfTokens\n*L\n132#1:210,14\n132#1:227,3\n132#1:231,2\n144#1:233,14\n144#1:250,3\n144#1:254,2\n167#1:256,14\n167#1:273,3\n167#1:277,2\n132#1:224,3\n132#1:230\n144#1:247,3\n144#1:253\n167#1:270,3\n167#1:276\n195#1:279,5\n*E\n"})
    private static final class LazyArrayOfTokens
    implements IArrayOfTokens {
        @NotNull
        private final Lexer lexer;
        @NotNull
        private final List<TokenProperties> tokens;

        public LazyArrayOfTokens(@NotNull Lexer lexer) {
            Intrinsics.checkNotNullParameter((Object)lexer, (String)"lexer");
            this.lexer = lexer;
            this.tokens = new ArrayList();
        }

        @Override
        public int calculateTokensCount() {
            this.generateAllTokens();
            return this.tokens.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        @Nullable
        public TokenProperties tryGetToken(int index) {
            void this_$iv;
            LazyArrayOfTokens lazyArrayOfTokens = this;
            Logger $this$measureTime$iv = CachingLexerKt.access$getLOG();
            boolean $i$f$measureTime = false;
            if (!$this$measureTime$iv.isDebugEnabled()) {
                boolean bl = false;
                while (index >= this.tokens.size()) {
                    if (!this.hasNextToken()) return (TokenProperties)CollectionsKt.getOrNull(this.tokens, (int)index);
                    this.generateNextToken();
                }
                return (TokenProperties)CollectionsKt.getOrNull(this.tokens, (int)index);
            }
            int tokenCountBefore$iv = this_$iv.tokens.size();
            TokenProperties tokenProperties = (TokenProperties)CollectionsKt.lastOrNull(this_$iv.tokens);
            int lastTokenEndBefore$iv = tokenProperties != null ? tokenProperties.getEnd() : 0;
            long startTime$iv = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
            try {
                boolean bl = false;
                while (index >= this.tokens.size() && this.hasNextToken()) {
                    this.generateNextToken();
                }
            }
            catch (Throwable throwable) {
                long endTime$iv = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
                int tokenCountAfter$iv = this_$iv.tokens.size();
                if (tokenCountAfter$iv == tokenCountBefore$iv) throw throwable;
                TokenProperties tokenProperties2 = (TokenProperties)CollectionsKt.lastOrNull(this_$iv.tokens);
                int lastTokenEndAfter$iv = tokenProperties2 != null ? tokenProperties2.getEnd() : 0;
                Logger $this$debug_u24default$iv$iv = $this$measureTime$iv;
                Object e$iv$iv = null;
                boolean $i$f$debug = false;
                if (!$this$debug_u24default$iv$iv.isDebugEnabled()) throw throwable;
                Logger logger = $this$debug_u24default$iv$iv;
                boolean bl = false;
                boolean bl4 = false;
                logger.debug("tryGetTokenProperties(index=" + index + ")" + " took " + Duration.toString-impl((long)TimeSource.Monotonic.ValueTimeMark.minus-6eNON_k((long)endTime$iv, (long)startTime$iv)) + ". Tokens count: " + tokenCountBefore$iv + " -> " + tokenCountAfter$iv + ". Last offset: " + lastTokenEndBefore$iv + " -> " + lastTokenEndAfter$iv, (Throwable)e$iv$iv);
                throw throwable;
            }
            long endTime$iv = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
            int tokenCountAfter$iv = this_$iv.tokens.size();
            if (tokenCountAfter$iv == tokenCountBefore$iv) return (TokenProperties)CollectionsKt.getOrNull(this.tokens, (int)index);
            TokenProperties tokenProperties3 = (TokenProperties)CollectionsKt.lastOrNull(this_$iv.tokens);
            int lastTokenEndAfter$iv = tokenProperties3 != null ? tokenProperties3.getEnd() : 0;
            Logger $this$debug_u24default$iv$iv = $this$measureTime$iv;
            Throwable e$iv$iv = null;
            boolean $i$f$debug = false;
            if (!$this$debug_u24default$iv$iv.isDebugEnabled()) return (TokenProperties)CollectionsKt.getOrNull(this.tokens, (int)index);
            Logger logger = $this$debug_u24default$iv$iv;
            boolean bl2 = false;
            boolean bl3 = false;
            logger.debug("tryGetTokenProperties(index=" + index + ")" + " took " + Duration.toString-impl((long)TimeSource.Monotonic.ValueTimeMark.minus-6eNON_k((long)endTime$iv, (long)startTime$iv)) + ". Tokens count: " + tokenCountBefore$iv + " -> " + tokenCountAfter$iv + ". Last offset: " + lastTokenEndBefore$iv + " -> " + lastTokenEndAfter$iv, e$iv$iv);
            return (TokenProperties)CollectionsKt.getOrNull(this.tokens, (int)index);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public int findTokenAt(int pos) {
            boolean bl;
            long startTime$iv;
            int lastTokenEndBefore$iv;
            int tokenCountBefore$iv;
            void this_$iv;
            Logger $this$measureTime$iv;
            block8: {
                int n;
                block7: {
                    if (!this.tokens.isEmpty()) {
                        if (pos < ((TokenProperties)CollectionsKt.last(this.tokens)).getEnd()) return CollectionsKt.binarySearch$default(this.tokens, (int)0, (int)0, arg_0 -> LazyArrayOfTokens.findTokenAt$lambda$2(pos, arg_0), (int)3, null);
                    }
                    LazyArrayOfTokens lazyArrayOfTokens = this;
                    $this$measureTime$iv = CachingLexerKt.access$getLOG();
                    boolean $i$f$measureTime = false;
                    if (!$this$measureTime$iv.isDebugEnabled()) {
                        boolean bl2 = false;
                        while (this.hasNextToken()) {
                            this.generateNextToken();
                            if (pos < ((TokenProperties)CollectionsKt.last(this.tokens)).getEnd()) return CollectionsKt.getLastIndex(this.tokens);
                        }
                        return -1;
                    }
                    tokenCountBefore$iv = this_$iv.tokens.size();
                    TokenProperties tokenProperties = (TokenProperties)CollectionsKt.lastOrNull(this_$iv.tokens);
                    lastTokenEndBefore$iv = tokenProperties != null ? tokenProperties.getEnd() : 0;
                    startTime$iv = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
                    try {
                        boolean bl3 = false;
                        while (this.hasNextToken()) {
                            this.generateNextToken();
                            if (pos >= ((TokenProperties)CollectionsKt.last(this.tokens)).getEnd()) continue;
                            n = CollectionsKt.getLastIndex(this.tokens);
                            break block7;
                        }
                        break block8;
                    }
                    catch (Throwable throwable) {
                        long endTime$iv = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
                        int tokenCountAfter$iv = this_$iv.tokens.size();
                        if (tokenCountAfter$iv == tokenCountBefore$iv) throw throwable;
                        TokenProperties tokenProperties2 = (TokenProperties)CollectionsKt.lastOrNull(this_$iv.tokens);
                        int lastTokenEndAfter$iv = tokenProperties2 != null ? tokenProperties2.getEnd() : 0;
                        Logger $this$debug_u24default$iv$iv = $this$measureTime$iv;
                        Object e$iv$iv = null;
                        boolean $i$f$debug = false;
                        if (!$this$debug_u24default$iv$iv.isDebugEnabled()) throw throwable;
                        Logger logger = $this$debug_u24default$iv$iv;
                        boolean bl4 = false;
                        bl = false;
                        logger.debug("findTokenAt(pos=" + pos + ")" + " took " + Duration.toString-impl((long)TimeSource.Monotonic.ValueTimeMark.minus-6eNON_k((long)endTime$iv, (long)startTime$iv)) + ". Tokens count: " + tokenCountBefore$iv + " -> " + tokenCountAfter$iv + ". Last offset: " + lastTokenEndBefore$iv + " -> " + lastTokenEndAfter$iv, (Throwable)e$iv$iv);
                        throw throwable;
                    }
                }
                long l = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
                int n2 = this_$iv.tokens.size();
                if (n2 == tokenCountBefore$iv) return n;
                TokenProperties tokenProperties = (TokenProperties)CollectionsKt.lastOrNull(this_$iv.tokens);
                int n3 = tokenProperties != null ? tokenProperties.getEnd() : 0;
                Logger logger = $this$measureTime$iv;
                Throwable throwable = null;
                if (!logger.isDebugEnabled()) return n;
                Logger logger2 = logger;
                logger2.debug("findTokenAt(pos=" + pos + ")" + " took " + Duration.toString-impl((long)TimeSource.Monotonic.ValueTimeMark.minus-6eNON_k((long)l, (long)startTime$iv)) + ". Tokens count: " + tokenCountBefore$iv + " -> " + n2 + ". Last offset: " + lastTokenEndBefore$iv + " -> " + n3, throwable);
                return n;
            }
            long endTime$iv = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
            int tokenCountAfter$iv = this_$iv.tokens.size();
            if (tokenCountAfter$iv == tokenCountBefore$iv) return -1;
            TokenProperties tokenProperties = (TokenProperties)CollectionsKt.lastOrNull(this_$iv.tokens);
            int lastTokenEndAfter$iv = tokenProperties != null ? tokenProperties.getEnd() : 0;
            Logger $this$debug_u24default$iv$iv = $this$measureTime$iv;
            Throwable e$iv$iv = null;
            boolean $i$f$debug = false;
            if (!$this$debug_u24default$iv$iv.isDebugEnabled()) return -1;
            Logger logger = $this$debug_u24default$iv$iv;
            boolean bl5 = false;
            bl = false;
            logger.debug("findTokenAt(pos=" + pos + ")" + " took " + Duration.toString-impl((long)TimeSource.Monotonic.ValueTimeMark.minus-6eNON_k((long)endTime$iv, (long)startTime$iv)) + ". Tokens count: " + tokenCountBefore$iv + " -> " + tokenCountAfter$iv + ". Last offset: " + lastTokenEndBefore$iv + " -> " + lastTokenEndAfter$iv, e$iv$iv);
            return -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private final void generateAllTokens() {
            void this_$iv;
            LazyArrayOfTokens lazyArrayOfTokens = this;
            Logger $this$measureTime$iv = CachingLexerKt.access$getLOG();
            boolean $i$f$measureTime = false;
            if (!$this$measureTime$iv.isDebugEnabled()) {
                boolean bl = false;
                while (this.hasNextToken()) {
                    this.generateNextToken();
                }
                return;
            }
            int tokenCountBefore$iv = this_$iv.tokens.size();
            TokenProperties tokenProperties = (TokenProperties)CollectionsKt.lastOrNull(this_$iv.tokens);
            int lastTokenEndBefore$iv = tokenProperties != null ? tokenProperties.getEnd() : 0;
            long startTime$iv = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
            try {
                boolean bl = false;
                while (this.hasNextToken()) {
                    this.generateNextToken();
                }
            }
            catch (Throwable throwable) {
                long endTime$iv = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
                int tokenCountAfter$iv = this_$iv.tokens.size();
                if (tokenCountAfter$iv == tokenCountBefore$iv) throw throwable;
                TokenProperties tokenProperties2 = (TokenProperties)CollectionsKt.lastOrNull(this_$iv.tokens);
                int lastTokenEndAfter$iv = tokenProperties2 != null ? tokenProperties2.getEnd() : 0;
                Logger $this$debug_u24default$iv$iv = $this$measureTime$iv;
                Object e$iv$iv = null;
                boolean $i$f$debug = false;
                if (!$this$debug_u24default$iv$iv.isDebugEnabled()) throw throwable;
                Logger logger = $this$debug_u24default$iv$iv;
                boolean bl = false;
                boolean bl4 = false;
                logger.debug("generateAllTokens()" + " took " + Duration.toString-impl((long)TimeSource.Monotonic.ValueTimeMark.minus-6eNON_k((long)endTime$iv, (long)startTime$iv)) + ". Tokens count: " + tokenCountBefore$iv + " -> " + tokenCountAfter$iv + ". Last offset: " + lastTokenEndBefore$iv + " -> " + lastTokenEndAfter$iv, (Throwable)e$iv$iv);
                throw throwable;
            }
            long endTime$iv = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
            int tokenCountAfter$iv = this_$iv.tokens.size();
            if (tokenCountAfter$iv == tokenCountBefore$iv) return;
            TokenProperties tokenProperties3 = (TokenProperties)CollectionsKt.lastOrNull(this_$iv.tokens);
            int lastTokenEndAfter$iv = tokenProperties3 != null ? tokenProperties3.getEnd() : 0;
            Logger $this$debug_u24default$iv$iv = $this$measureTime$iv;
            Throwable e$iv$iv = null;
            boolean $i$f$debug = false;
            if (!$this$debug_u24default$iv$iv.isDebugEnabled()) return;
            Logger logger = $this$debug_u24default$iv$iv;
            boolean bl2 = false;
            boolean bl3 = false;
            logger.debug("generateAllTokens()" + " took " + Duration.toString-impl((long)TimeSource.Monotonic.ValueTimeMark.minus-6eNON_k((long)endTime$iv, (long)startTime$iv)) + ". Tokens count: " + tokenCountBefore$iv + " -> " + tokenCountAfter$iv + ". Last offset: " + lastTokenEndBefore$iv + " -> " + lastTokenEndAfter$iv, e$iv$iv);
        }

        private final boolean hasNextToken() {
            return this.lexer.getTokenType() != null;
        }

        private final void generateNextToken() {
            this.tokens.add(new TokenProperties(this.lexer.getTokenStart(), this.lexer.getTokenEnd(), this.lexer.getTokenType(), this.lexer.getState()));
            this.lexer.advance();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void measureTime(Logger $this$measureTime, Function0<String> lazyMessage, Function0<Unit> block) {
            boolean $i$f$measureTime = false;
            if (!$this$measureTime.isDebugEnabled()) {
                block.invoke();
                return;
            }
            int tokenCountBefore = this.tokens.size();
            TokenProperties tokenProperties = (TokenProperties)CollectionsKt.lastOrNull(this.tokens);
            int lastTokenEndBefore = tokenProperties != null ? tokenProperties.getEnd() : 0;
            long startTime = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
            try {
                block.invoke();
            }
            catch (Throwable throwable) {
                InlineMarker.finallyStart((int)1);
                long endTime = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
                int tokenCountAfter = this.tokens.size();
                if (tokenCountAfter != tokenCountBefore) {
                    TokenProperties tokenProperties2 = (TokenProperties)CollectionsKt.lastOrNull(this.tokens);
                    int lastTokenEndAfter = tokenProperties2 != null ? tokenProperties2.getEnd() : 0;
                    Logger $this$debug_u24default$iv = $this$measureTime;
                    Object e$iv = null;
                    boolean $i$f$debug = false;
                    if ($this$debug_u24default$iv.isDebugEnabled()) {
                        Logger logger = $this$debug_u24default$iv;
                        boolean bl = false;
                        logger.debug(lazyMessage.invoke() + " took " + Duration.toString-impl((long)TimeSource.Monotonic.ValueTimeMark.minus-6eNON_k((long)endTime, (long)startTime)) + ". Tokens count: " + tokenCountBefore + " -> " + tokenCountAfter + ". Last offset: " + lastTokenEndBefore + " -> " + lastTokenEndAfter, (Throwable)e$iv);
                    }
                }
                InlineMarker.finallyEnd((int)1);
                throw throwable;
            }
            InlineMarker.finallyStart((int)1);
            long endTime = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
            int tokenCountAfter = this.tokens.size();
            if (tokenCountAfter != tokenCountBefore) {
                TokenProperties tokenProperties3 = (TokenProperties)CollectionsKt.lastOrNull(this.tokens);
                int lastTokenEndAfter = tokenProperties3 != null ? tokenProperties3.getEnd() : 0;
                Logger $this$debug_u24default$iv = $this$measureTime;
                Throwable e$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    Logger logger = $this$debug_u24default$iv;
                    boolean bl = false;
                    logger.debug(lazyMessage.invoke() + " took " + Duration.toString-impl((long)TimeSource.Monotonic.ValueTimeMark.minus-6eNON_k((long)endTime, (long)startTime)) + ". Tokens count: " + tokenCountBefore + " -> " + tokenCountAfter + ". Last offset: " + lastTokenEndBefore + " -> " + lastTokenEndAfter, e$iv);
                }
            }
            InlineMarker.finallyEnd((int)1);
        }

        private static final int findTokenAt$lambda$2(int $pos, TokenProperties it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return $pos < it.getStart() ? 1 : ($pos >= it.getEnd() ? -1 : 0);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J3\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000b\u00a8\u0006\u001b"}, d2={"Lcom/intellij/resharper/cpp/lexer/CachingLexer$TokenProperties;", "", "start", "", "end", "tokenType", "Lcom/intellij/psi/tree/IElementType;", "lexerState", "<init>", "(IILcom/intellij/psi/tree/IElementType;I)V", "getStart", "()I", "getEnd", "getTokenType", "()Lcom/intellij/psi/tree/IElementType;", "getLexerState", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.resharper.cpp.lexer"})
    public static final class TokenProperties {
        private final int start;
        private final int end;
        @Nullable
        private final IElementType tokenType;
        private final int lexerState;

        public TokenProperties(int start, int end, @Nullable IElementType tokenType, int lexerState) {
            this.start = start;
            this.end = end;
            this.tokenType = tokenType;
            this.lexerState = lexerState;
        }

        public final int getStart() {
            return this.start;
        }

        public final int getEnd() {
            return this.end;
        }

        @Nullable
        public final IElementType getTokenType() {
            return this.tokenType;
        }

        public final int getLexerState() {
            return this.lexerState;
        }

        public final int component1() {
            return this.start;
        }

        public final int component2() {
            return this.end;
        }

        @Nullable
        public final IElementType component3() {
            return this.tokenType;
        }

        public final int component4() {
            return this.lexerState;
        }

        @NotNull
        public final TokenProperties copy(int start, int end, @Nullable IElementType tokenType, int lexerState) {
            return new TokenProperties(start, end, tokenType, lexerState);
        }

        public static /* synthetic */ TokenProperties copy$default(TokenProperties tokenProperties, int n, int n2, IElementType iElementType, int n3, int n4, Object object) {
            if ((n4 & 1) != 0) {
                n = tokenProperties.start;
            }
            if ((n4 & 2) != 0) {
                n2 = tokenProperties.end;
            }
            if ((n4 & 4) != 0) {
                iElementType = tokenProperties.tokenType;
            }
            if ((n4 & 8) != 0) {
                n3 = tokenProperties.lexerState;
            }
            return tokenProperties.copy(n, n2, iElementType, n3);
        }

        @NotNull
        public String toString() {
            return "TokenProperties(start=" + this.start + ", end=" + this.end + ", tokenType=" + this.tokenType + ", lexerState=" + this.lexerState + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.start);
            result = result * 31 + Integer.hashCode(this.end);
            result = result * 31 + (this.tokenType == null ? 0 : this.tokenType.hashCode());
            result = result * 31 + Integer.hashCode(this.lexerState);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TokenProperties)) {
                return false;
            }
            TokenProperties tokenProperties = (TokenProperties)other;
            if (this.start != tokenProperties.start) {
                return false;
            }
            if (this.end != tokenProperties.end) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.tokenType, (Object)tokenProperties.tokenType)) {
                return false;
            }
            return this.lexerState == tokenProperties.lexerState;
        }
    }
}

