/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rider.rdclient.dotnet.spellchecker.rename;

import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.spellchecker.SpellCheckerManager;
import com.jetbrains.rdclient.actions.base.BackendActionDelegationKt;
import com.jetbrains.rider.intentions.altEnter.IntelliJBulbMenuModel;
import com.jetbrains.rider.settings.RdClientDotnetBundle;
import com.jetbrains.rider.spellChecker.rename.RiderGrammarAndSpellingDataKeys;
import icons.SpellcheckerIcons;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\rH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/rider/rdclient/dotnet/spellchecker/rename/BackendRenameTo;", "Lcom/intellij/codeInspection/LocalQuickFix;", "Lcom/intellij/openapi/util/Iconable;", "Lcom/intellij/codeInsight/intention/PriorityAction;", "<init>", "()V", "getFamilyName", "", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "previewDescriptor", "getIcon", "Ljavax/swing/Icon;", "flags", "", "getPriority", "Lcom/intellij/codeInsight/intention/PriorityAction$Priority;", "intellij.rider.rdclient.dotnet.spellchecker"})
public final class BackendRenameTo
implements LocalQuickFix,
Iconable,
PriorityAction {
    @NotNull
    public String getFamilyName() {
        return RdClientDotnetBundle.INSTANCE.message("spellchecker.rename.to", new Object[0]);
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        PsiFile psiFile = descriptor.getPsiElement().getContainingFile();
        if (psiFile == null) {
            throw new AssertionError((Object)"file != null");
        }
        PsiFile file = psiFile;
        FileEditor selectedEditor = FileEditorManager.getInstance((Project)project).getSelectedEditor(file.getVirtualFile());
        if (!(selectedEditor instanceof TextEditor)) {
            return;
        }
        Editor editor = ((TextEditor)selectedEditor).getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
        Editor editor2 = editor;
        Integer initialOffset = (Integer)editor2.getUserData(IntelliJBulbMenuModel.Companion.getBEFORE_INTENTION_CARET_OFFSET());
        if (initialOffset != null) {
            editor2.getCaretModel().getCurrentCaret().moveToOffset(initialOffset.intValue());
        }
        PsiElement identifierToken = descriptor.getPsiElement().findElementAt(descriptor.getTextRangeInElement().getStartOffset());
        SpellCheckerManager spellCheckerManager = SpellCheckerManager.Companion.getInstance(project);
        Object object = identifierToken;
        if (object == null || (object = object.getText()) == null) {
            object = "";
        }
        List suggestions = spellCheckerManager.getSuggestions((String)object);
        DataContext dataContext = SimpleDataContext.builder().add(CommonDataKeys.EDITOR, (Object)editor2).add(CommonDataKeys.PROJECT, (Object)project).add(RiderGrammarAndSpellingDataKeys.INSTANCE.getFIX_TYPO_WITH_RENAME_DATA(), (Object)suggestions).build();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"build(...)");
        DataContext dataContext2 = dataContext;
        AnActionEvent anActionEvent = AnActionEvent.createFromDataContext((String)"unknown", null, (DataContext)dataContext2);
        Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"createFromDataContext(...)");
        AnActionEvent event = anActionEvent;
        BackendActionDelegationKt.backendActionPerformed((String)"RenameElement", (AnActionEvent)event);
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)previewDescriptor, (String)"previewDescriptor");
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
        return intentionPreviewInfo;
    }

    @NotNull
    public Icon getIcon(int flags) {
        Icon icon = SpellcheckerIcons.Spellcheck;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Spellcheck");
        return icon;
    }

    @NotNull
    public PriorityAction.Priority getPriority() {
        return PriorityAction.Priority.TOP;
    }
}

