/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.awt.plot.component;

import com.github.weisj.jsvg.SVGDocument;
import com.github.weisj.jsvg.parser.SVGLoader;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.awt.plot.component.PlotPanelToolbar;
import org.jetbrains.letsPlot.core.plot.builder.interact.tools.DefaultFigureToolsController;
import org.jetbrains.letsPlot.core.plot.builder.interact.tools.FigureModel;
import org.jetbrains.letsPlot.core.plot.builder.interact.tools.ToggleTool;
import org.jetbrains.letsPlot.core.plot.builder.interact.tools.ToggleToolView;
import org.jetbrains.letsPlot.core.plot.builder.interact.tools.ToolSpecs;
import org.jetbrains.letsPlot.core.plot.builder.interact.tools.res.ToolbarIcons;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J.\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J2\u0010\u0014\u001a\u00020\u000e2\b\u0010\u0015\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\nH\u0002J\u001c\u0010\u0019\u001a\u00020\f2\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0002J\b\u0010\u001d\u001a\u00020\fH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/letsPlot/awt/plot/component/PlotPanelToolbar;", "Ljavax/swing/JPanel;", "figureModel", "Lorg/jetbrains/letsPlot/core/plot/builder/interact/tools/FigureModel;", "(Lorg/jetbrains/letsPlot/core/plot/builder/interact/tools/FigureModel;)V", "controller", "Lorg/jetbrains/letsPlot/core/plot/builder/interact/tools/DefaultFigureToolsController;", "colorToHex", "", "color", "Ljava/awt/Color;", "createStyledButton", "Ljavax/swing/JButton;", "normalIcon", "Ljavax/swing/Icon;", "hoverIcon", "toolTipText", "selected", "Lkotlin/Function0;", "", "createSvgIcon", "svgString", "size", "Ljava/awt/Dimension;", "backgroundColor", "createToolButton", "toolSpec", "", "", "resetButton", "Companion", "platf-awt"})
@SourceDebugExtension(value={"SMAP\nPlotPanelToolbar.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlotPanelToolbar.kt\norg/jetbrains/letsPlot/awt/plot/component/PlotPanelToolbar\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,264:1\n1855#2,2:265\n*S KotlinDebug\n*F\n+ 1 PlotPanelToolbar.kt\norg/jetbrains/letsPlot/awt/plot/component/PlotPanelToolbar\n*L\n79#1:265,2\n*E\n"})
public final class PlotPanelToolbar
extends JPanel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DefaultFigureToolsController controller;
    public static final int TOOLBAR_HEIGHT = 33;
    @NotNull
    private static final Dimension BUTTON_DIM = new Dimension(22, 22);
    @NotNull
    private static final Color C_BACKGR = new Color(247, 248, 250);
    @NotNull
    private static final Color C_STROKE = new Color(110, 110, 110);
    @NotNull
    private static final Color C_BACKGR_HOVER = new Color(218, 219, 221);
    @NotNull
    private static final Color C_BACKGR_SEL = new Color(69, 114, 232);
    private static final Color C_STROKE_SEL = Color.WHITE;
    private static final int ALPHA = 204;
    @NotNull
    private static final Color C_BACKGR_TRANSPARENT = new Color(RangesKt.coerceIn((int)((int)(((double)C_BACKGR.getRed() - 51.0) * 255.0 / (double)204)), (int)0, (int)255), RangesKt.coerceIn((int)((int)(((double)C_BACKGR.getGreen() - 51.0) * 255.0 / (double)204)), (int)0, (int)255), RangesKt.coerceIn((int)((int)(((double)C_BACKGR.getBlue() - 51.0) * 255.0 / (double)204)), (int)0, (int)255), 204);

    public PlotPanelToolbar(@NotNull FigureModel figureModel) {
        Intrinsics.checkNotNullParameter((Object)figureModel, (String)"figureModel");
        this.controller = new DefaultFigureToolsController(figureModel, (Function1<? super String, Unit>)((Function1)controller.1.INSTANCE));
        this.setLayout(new FlowLayout(1, 0, 2));
        this.setPreferredSize(new Dimension(this.getPreferredSize().width, 33));
        this.setMinimumSize(new Dimension(this.getMinimumSize().width, 33));
        this.setMaximumSize(new Dimension(this.getMaximumSize().width, 33));
        this.setOpaque(false);
        Serializable serializable = new FlowLayout(1, 6, 0);
        Serializable $this$_init__u24lambda_u240 = serializable = new JPanel((FlowLayout)serializable){

            protected void paintComponent(@NotNull Graphics g) {
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                Graphics graphics = g.create();
                Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
                Graphics2D g2 = (Graphics2D)graphics;
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setColor(PlotPanelToolbar.access$getC_BACKGR_TRANSPARENT$cp());
                g2.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), 16, 16);
                g2.setColor(new Color(200, 200, 200));
                g2.setStroke(new BasicStroke(1.0f));
                g2.drawRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, 16, 16);
                g2.dispose();
            }
        };
        boolean bl = false;
        ((JComponent)$this$_init__u24lambda_u240).setOpaque(false);
        ((JComponent)$this$_init__u24lambda_u240).setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        Serializable innerContainer2 = serializable;
        serializable = new Map[]{ToolSpecs.INSTANCE.getPAN_TOOL_SPEC(), ToolSpecs.INSTANCE.getBBOX_ZOOM_TOOL_SPEC(), ToolSpecs.INSTANCE.getCBOX_ZOOM_TOOL_SPEC()};
        Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])serializable);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map it = (Map)element$iv;
            boolean bl2 = false;
            JButton button2 = this.createToolButton(it);
            ((Container)innerContainer2).add(button2);
        }
        ((Container)innerContainer2).add(this.resetButton());
        this.add((Component)innerContainer2);
        figureModel.onToolEvent((Function1<? super Map<String, ? extends Object>, Unit>)((Function1)new Function1<Map<String, ? extends Object>, Unit>(){

            public final void invoke(@NotNull Map<String, ? extends Object> event) {
                Intrinsics.checkNotNullParameter(event, (String)"event");
                controller.handleToolFeedback(event);
            }
        }));
    }

    private final JButton createToolButton(Map<String, ? extends Object> toolSpec) {
        ToggleTool tool = new ToggleTool(toolSpec);
        Object object = toolSpec.get("icon");
        String iconSvg = object instanceof String ? (String)object : null;
        Icon normalIcon = PlotPanelToolbar.createSvgIcon$default(this, iconSvg, null, C_STROKE, new Color(0, 0, 0, 0), 2, null);
        Icon hoverIcon = PlotPanelToolbar.createSvgIcon$default(this, iconSvg, null, C_STROKE, C_BACKGR_HOVER, 2, null);
        Color color = C_STROKE_SEL;
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"C_STROKE_SEL");
        Icon selectedIcon = PlotPanelToolbar.createSvgIcon$default(this, iconSvg, null, color, C_BACKGR_SEL, 2, null);
        JButton button2 = this.createStyledButton(normalIcon, hoverIcon, tool.getLabel(), (Function0<Boolean>)((Function0)new Function0<Boolean>(tool){
            final /* synthetic */ ToggleTool $tool;
            {
                this.$tool = $tool;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return this.$tool.getActive();
            }
        }));
        ToggleToolView view2 = new ToggleToolView(button2, selectedIcon, normalIcon){
            final /* synthetic */ JButton $button;
            final /* synthetic */ Icon $selectedIcon;
            final /* synthetic */ Icon $normalIcon;
            {
                this.$button = $button;
                this.$selectedIcon = $selectedIcon;
                this.$normalIcon = $normalIcon;
            }

            public void setState(boolean selected) {
                this.$button.setIcon(selected ? this.$selectedIcon : this.$normalIcon);
            }

            public void onAction(@NotNull Function0<Unit> handler2) {
                Intrinsics.checkNotNullParameter(handler2, (String)"handler");
                this.$button.addActionListener(arg_0 -> createToolButton.view.1.onAction$lambda$0(handler2, arg_0));
            }

            private static final void onAction$lambda$0(Function0 $handler, ActionEvent it) {
                Intrinsics.checkNotNullParameter((Object)$handler, (String)"$handler");
                $handler.invoke();
            }
        };
        this.controller.registerTool(tool, view2);
        return button2;
    }

    private final JButton resetButton() {
        Icon normalIcon = PlotPanelToolbar.createSvgIcon$default(this, ToolbarIcons.INSTANCE.getRESET(), null, C_STROKE, new Color(0, 0, 0, 0), 2, null);
        Icon hoverIcon = PlotPanelToolbar.createSvgIcon$default(this, ToolbarIcons.INSTANCE.getRESET(), null, C_STROKE, C_BACKGR_HOVER, 2, null);
        JButton button2 = this.createStyledButton(normalIcon, hoverIcon, "Reset", (Function0<Boolean>)((Function0)resetButton.button.1.INSTANCE));
        button2.addActionListener(arg_0 -> PlotPanelToolbar.resetButton$lambda$2(this, arg_0));
        return button2;
    }

    private final JButton createStyledButton(Icon normalIcon, Icon hoverIcon, String toolTipText, Function0<Boolean> selected) {
        JButton jButton;
        JButton $this$createStyledButton_u24lambda_u243 = jButton = new JButton();
        boolean bl = false;
        $this$createStyledButton_u24lambda_u243.setText("");
        $this$createStyledButton_u24lambda_u243.setToolTipText(toolTipText);
        $this$createStyledButton_u24lambda_u243.setIcon(normalIcon);
        $this$createStyledButton_u24lambda_u243.setBorderPainted(false);
        $this$createStyledButton_u24lambda_u243.setFocusPainted(false);
        $this$createStyledButton_u24lambda_u243.setContentAreaFilled(false);
        $this$createStyledButton_u24lambda_u243.setRolloverEnabled(false);
        $this$createStyledButton_u24lambda_u243.setPreferredSize(BUTTON_DIM);
        $this$createStyledButton_u24lambda_u243.setMinimumSize(BUTTON_DIM);
        $this$createStyledButton_u24lambda_u243.setMaximumSize(BUTTON_DIM);
        $this$createStyledButton_u24lambda_u243.setOpaque(false);
        $this$createStyledButton_u24lambda_u243.addMouseListener(new MouseAdapter(selected, $this$createStyledButton_u24lambda_u243, hoverIcon, normalIcon){
            final /* synthetic */ Function0<Boolean> $selected;
            final /* synthetic */ JButton $this_apply;
            final /* synthetic */ Icon $hoverIcon;
            final /* synthetic */ Icon $normalIcon;
            {
                this.$selected = $selected;
                this.$this_apply = $receiver;
                this.$hoverIcon = $hoverIcon;
                this.$normalIcon = $normalIcon;
            }

            public void mouseEntered(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (!((Boolean)this.$selected.invoke()).booleanValue()) {
                    this.$this_apply.setIcon(this.$hoverIcon);
                }
            }

            public void mouseExited(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (!((Boolean)this.$selected.invoke()).booleanValue()) {
                    this.$this_apply.setIcon(this.$normalIcon);
                }
            }
        });
        return jButton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Icon createSvgIcon(String svgString, Dimension size2, Color color, Color backgroundColor) {
        BufferedImage bufferedImage = new BufferedImage(PlotPanelToolbar.BUTTON_DIM.width, PlotPanelToolbar.BUTTON_DIM.height, 2);
        Graphics2D graphics = bufferedImage.createGraphics();
        try {
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Color color2 = backgroundColor;
            if (color2 == null) {
                color2 = C_BACKGR;
            }
            graphics.setColor(color2);
            graphics.fillRoundRect(0, 0, PlotPanelToolbar.BUTTON_DIM.width, PlotPanelToolbar.BUTTON_DIM.height, 8, 8);
            String string = svgString;
            if (string != null) {
                String svg = string;
                boolean bl = false;
                try {
                    Unit unit;
                    SVGDocument document;
                    String coloredSvg;
                    SVGLoader loader = new SVGLoader();
                    String string2 = coloredSvg = StringsKt.replace$default((String)svg, (String)"stroke=\"none\"", (String)("stroke=\"none\" fill=\"" + this.colorToHex(color) + '\"'), (boolean)false, (int)4, null);
                    Charset charset = Charsets.UTF_8;
                    byte[] byArray = string2.getBytes(charset);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(byArray);
                    SVGDocument sVGDocument = document = loader.load(inputStream);
                    if (sVGDocument != null) {
                        SVGDocument it = sVGDocument;
                        boolean bl2 = false;
                        int iconX = (PlotPanelToolbar.BUTTON_DIM.width - size2.width) / 2;
                        int iconY = (PlotPanelToolbar.BUTTON_DIM.height - size2.height) / 2;
                        graphics.translate(iconX, iconY);
                        it.render(null, graphics, null);
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    Unit unit2 = unit;
                }
                catch (Exception e) {
                    Unit unit = Unit.INSTANCE;
                }
            }
        }
        finally {
            graphics.dispose();
        }
        return new ImageIcon(bufferedImage);
    }

    static /* synthetic */ Icon createSvgIcon$default(PlotPanelToolbar plotPanelToolbar, String string, Dimension dimension, Color color, Color color2, int n, Object object) {
        if ((n & 2) != 0) {
            dimension = new Dimension(16, 16);
        }
        if ((n & 4) != 0) {
            color = C_STROKE;
        }
        if ((n & 8) != 0) {
            color2 = null;
        }
        return plotPanelToolbar.createSvgIcon(string, dimension, color, color2);
    }

    private final String colorToHex(Color color) {
        String string = "#%02x%02x%02x";
        Object[] objectArray = new Object[]{color.getRed(), color.getGreen(), color.getBlue()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    private static final void resetButton$lambda$2(PlotPanelToolbar this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.controller.resetFigure(true);
    }

    public static final /* synthetic */ Color access$getC_BACKGR_TRANSPARENT$cp() {
        return C_BACKGR_TRANSPARENT;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u0010*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/letsPlot/awt/plot/component/PlotPanelToolbar$Companion;", "", "()V", "ALPHA", "", "BUTTON_DIM", "Ljava/awt/Dimension;", "getBUTTON_DIM", "()Ljava/awt/Dimension;", "C_BACKGR", "Ljava/awt/Color;", "C_BACKGR_HOVER", "C_BACKGR_SEL", "C_BACKGR_TRANSPARENT", "C_STROKE", "C_STROKE_SEL", "kotlin.jvm.PlatformType", "TOOLBAR_HEIGHT", "platf-awt"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Dimension getBUTTON_DIM() {
            return BUTTON_DIM;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

