/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.meson.toolwindow.tree;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectModelBuildableElement;
import com.intellij.openapi.util.Version;
import com.intellij.task.ProjectTask;
import com.intellij.task.impl.ProjectModelBuildTaskImpl;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.tree.TreeUtil;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.build.tasks.CidrCleanTaskImpl;
import com.jetbrains.cidr.meson.MesonWorkspace;
import com.jetbrains.cidr.meson.bundle.MesonBundle;
import com.jetbrains.cidr.meson.execution.build.MesonBuildAllConfiguration;
import com.jetbrains.cidr.meson.execution.build.MesonBuildConfiguration;
import com.jetbrains.cidr.meson.execution.build.MesonBuildTarget;
import com.jetbrains.cidr.meson.execution.build.MesonBuildTargetConfiguration;
import com.jetbrains.cidr.meson.fus.MesonToolwindowUsagesCollector;
import com.jetbrains.cidr.meson.instance.MesonCommand;
import com.jetbrains.cidr.meson.project.MesonModelManager;
import com.jetbrains.cidr.meson.toolwindow.tree.MesonCommandsCustomRunCommand;
import com.jetbrains.cidr.meson.toolwindow.tree.MesonCommandsTreeAction;
import com.jetbrains.cidr.meson.toolwindow.tree.MesonCommandsTreeActionProjectTask;
import com.jetbrains.cidr.meson.toolwindow.tree.MesonCommandsTreeKt;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ,\u0010\u0010\u001a\u00020\r*\u00020\t2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0016\u0010\u0018\u001a\u00020\r*\u00020\t2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J\u0016\u0010\u001b\u001a\u00020\r*\u00020\t2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J\u001e\u0010\u001c\u001a\u00020\r*\u00020\t2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001d\u001a\u00020\u0017H\u0002J\u001e\u0010\u001e\u001a\u00020\r*\u00020\t2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001d\u001a\u00020\u0017H\u0002J\u001e\u0010\u001f\u001a\u00020\r*\u00020\t2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001d\u001a\u00020\u0017H\u0002J\u0016\u0010 \u001a\u00020\r*\u00020\t2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J\u0006\u0010!\u001a\u00020\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/jetbrains/cidr/meson/toolwindow/tree/MesonCommandsTree;", "Lcom/intellij/ui/treeStructure/Tree;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "root", "Ljavax/swing/tree/DefaultMutableTreeNode;", "targetsUpdateLock", "Ljava/util/concurrent/locks/ReentrantLock;", "updateCurrentTargets", "", "newState", "Lcom/jetbrains/cidr/meson/project/MesonModelManager$State;", "addBuildTargetNodes", "targetBuildTargets", "", "Lcom/jetbrains/cidr/meson/execution/build/MesonBuildTargetConfiguration;", "buildAllConfiguration", "Lcom/jetbrains/cidr/meson/execution/build/MesonBuildAllConfiguration;", "newMesonVersion", "Lcom/intellij/openapi/util/Version;", "addCleanNode", "configuration", "Lcom/jetbrains/cidr/meson/execution/build/MesonBuildConfiguration;", "addConfigureNode", "addDistNode", "mesonVersion", "addInstallNode", "addSubprojectsNode", "addTestNode", "callCurrentAction", "intellij.clion.meson"})
@SourceDebugExtension(value={"SMAP\nMesonCommandsTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MesonCommandsTree.kt\ncom/jetbrains/cidr/meson/toolwindow/tree/MesonCommandsTree\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,512:1\n1374#2:513\n1460#2,5:514\n808#2,11:519\n295#2,2:530\n1869#2,2:532\n*S KotlinDebug\n*F\n+ 1 MesonCommandsTree.kt\ncom/jetbrains/cidr/meson/toolwindow/tree/MesonCommandsTree\n*L\n83#1:513\n83#1:514,5\n84#1:519,11\n85#1:530,2\n132#1:532,2\n*E\n"})
public final class MesonCommandsTree
extends Tree {
    @NotNull
    private final Project project;
    @NotNull
    private final DefaultMutableTreeNode root;
    @NotNull
    private final ReentrantLock targetsUpdateLock;

    public MesonCommandsTree(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super((TreeNode)new DefaultMutableTreeNode());
        this.project = project;
        Object object = this.getModel().getRoot();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
        this.root = (DefaultMutableTreeNode)object;
        this.setRootVisible(false);
        this.setCellRenderer((TreeCellRenderer)new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
                if (!(value instanceof DefaultMutableTreeNode)) {
                    return;
                }
                Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
                if (!(userObject instanceof MesonCommandsTreeAction)) {
                    return;
                }
                this.setIcon(((MesonCommandsTreeAction)userObject).getIcon());
                this.setToolTipText(((MesonCommandsTreeAction)userObject).getTooltip());
                this.setEnabled(((MesonCommandsTreeAction)userObject).isEnabled());
                this.append(((MesonCommandsTreeAction)userObject).getText());
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e.getKeyCode() == 10) {
                    this.callCurrentAction();
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(e)) {
                    this.callCurrentAction();
                }
            }
        });
        TreeUtil.expandAll((JTree)((JTree)((Object)this)));
        TreeModel treeModel = this.getModel();
        Intrinsics.checkNotNull((Object)treeModel, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultTreeModel");
        ((DefaultTreeModel)treeModel).nodeStructureChanged(this.root);
        this.targetsUpdateLock = new ReentrantLock();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    /*
     * WARNING - void declaration
     */
    public final void updateCurrentTargets(@NotNull MesonModelManager.State newState) {
        Object v0;
        List targetsBuildConfigurations;
        List buildConfigurations;
        block3: {
            void $this$filterIsInstanceTo$iv$iv;
            void $this$flatMapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
            Iterable $this$flatMap$iv = newState.getTargets();
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                MesonBuildTarget it = (MesonBuildTarget)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = it.getBuildConfigurations();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            buildConfigurations = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
            Iterable $this$filterIsInstance$iv = buildConfigurations;
            boolean $i$f$filterIsInstance = false;
            destination$iv$iv = $this$filterIsInstance$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof MesonBuildTargetConfiguration)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            targetsBuildConfigurations = (List)destination$iv$iv2;
            Iterable $this$firstOrNull$iv = buildConfigurations;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                MesonBuildConfiguration it = (MesonBuildConfiguration)element$iv;
                boolean bl = false;
                if (!(it instanceof MesonBuildAllConfiguration)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        MesonBuildAllConfiguration buildAllConfiguration = v0;
        MesonBuildConfiguration randomConfiguration = (MesonBuildConfiguration)CollectionsKt.firstOrNull((List)buildConfigurations);
        ActionsKt.runInEdt$default(null, () -> MesonCommandsTree.updateCurrentTargets$lambda$2(this, targetsBuildConfigurations, buildAllConfiguration, newState, randomConfiguration), (int)1, null);
    }

    private final void addBuildTargetNodes(DefaultMutableTreeNode $this$addBuildTargetNodes, List<MesonBuildTargetConfiguration> targetBuildTargets, MesonBuildAllConfiguration buildAllConfiguration, Version newMesonVersion) {
        boolean isEnabledCompile = newMesonVersion.compareTo(MesonCommand.Compile.Companion.getSINCE()) >= 0;
        DefaultMutableTreeNode targetsNode = new DefaultMutableTreeNode();
        String string = MesonBundle.INSTANCE.message("toolwindow.nodes.build.node.text", new Object[0]);
        Icon icon = AllIcons.Nodes.CompiledClassesFolder;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"CompiledClassesFolder");
        targetsNode.setUserObject(new MesonCommandsTreeAction(string, icon, MesonBundle.INSTANCE.message("toolwindow.nodes.build.node.description", new Object[0]), isEnabledCompile, null, 16, null));
        $this$addBuildTargetNodes.add(targetsNode);
        if (buildAllConfiguration != null) {
            DefaultMutableTreeNode newBuildAllConfiguration = new DefaultMutableTreeNode();
            String newBuildAllConfigurationCommandLine = MesonCommandsTreeKt.access$getNlsCommandLine(new MesonCommand.Compile(null, CollectionsKt.emptyList(), 1, null));
            String string2 = MesonBundle.INSTANCE.message("toolwindow.nodes.build.all.node.text", new Object[0]);
            Icon icon2 = AllIcons.Toolwindows.ToolWindowBuild;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"ToolWindowBuild");
            newBuildAllConfiguration.setUserObject(new MesonCommandsTreeActionProjectTask(string2, icon2, newBuildAllConfigurationCommandLine, isEnabledCompile, (ProjectTask)new ProjectModelBuildTaskImpl((ProjectModelBuildableElement)buildAllConfiguration, true), MesonToolwindowUsagesCollector.ToolwindowAction.BUILD));
            targetsNode.add(newBuildAllConfiguration);
        }
        Iterable $this$forEach$iv = targetBuildTargets;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MesonBuildTargetConfiguration target = (MesonBuildTargetConfiguration)element$iv;
            boolean bl = false;
            boolean isEnabledTargetsCompile = newMesonVersion.compareTo(MesonCommand.Compile.Companion.getTARGETS_SELECT_SINCE()) >= 0;
            DefaultMutableTreeNode newNode = new DefaultMutableTreeNode();
            String newBuildAllConfigurationCommandLine = MesonCommandsTreeKt.access$getNlsCommandLine(new MesonCommand.Compile(target.getTargetName(), CollectionsKt.emptyList()));
            Object[] objectArray = new Object[]{target.getTargetName()};
            String string3 = MesonBundle.INSTANCE.message("toolwindow.nodes.build.target.node.text", objectArray);
            Icon icon3 = AllIcons.Toolwindows.ToolWindowBuild;
            Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"ToolWindowBuild");
            newNode.setUserObject(new MesonCommandsTreeActionProjectTask(string3, icon3, newBuildAllConfigurationCommandLine, isEnabledTargetsCompile, (ProjectTask)new ProjectModelBuildTaskImpl((ProjectModelBuildableElement)target, true), MesonToolwindowUsagesCollector.ToolwindowAction.BUILD));
            targetsNode.add(newNode);
        }
    }

    private final void addCleanNode(DefaultMutableTreeNode $this$addCleanNode, MesonBuildConfiguration configuration) {
        if (configuration == null) {
            return;
        }
        DefaultMutableTreeNode cleanAllNode = new DefaultMutableTreeNode();
        String parametersList = MesonCommandsTreeKt.access$getNlsCommandLine(MesonCommand.Clean.INSTANCE);
        String string = MesonBundle.INSTANCE.message("toolwindow.nodes.clean.node.text", new Object[0]);
        Icon icon = AllIcons.Actions.GC;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"GC");
        cleanAllNode.setUserObject(new MesonCommandsTreeActionProjectTask(string, icon, parametersList, false, (ProjectTask)new CidrCleanTaskImpl((CidrBuildConfiguration)configuration), MesonToolwindowUsagesCollector.ToolwindowAction.CLEAN, 8, null));
        $this$addCleanNode.add(cleanAllNode);
    }

    private final void addConfigureNode(DefaultMutableTreeNode $this$addConfigureNode, MesonBuildConfiguration configuration) {
        if (configuration == null) {
            return;
        }
        DefaultMutableTreeNode configureNode = new DefaultMutableTreeNode();
        String string = MesonBundle.INSTANCE.message("toolwindow.nodes.configure.node.text", new Object[0]);
        Icon icon = AllIcons.General.GearPlain;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"GearPlain");
        configureNode.setUserObject(new MesonCommandsTreeAction(string, icon, MesonBundle.INSTANCE.message("toolwindow.nodes.configure.node.description", new Object[0]), false, null, 24, null));
        $this$addConfigureNode.add(configureNode);
        String string2 = MesonBundle.INSTANCE.message("toolwindow.nodes.configure.autofeature.node.text", new Object[0]);
        Icon icon2 = AllIcons.Diff.MagicResolve;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"MagicResolve");
        String string3 = MesonBundle.INSTANCE.message("toolwindow.nodes.configure.autofeature.node.description", new Object[0]);
        EnumEntries<MesonCommand.Configure.AutoFeatures> enumEntries = MesonCommand.Configure.AutoFeatures.getEntries();
        Function1 function1 = MesonCommandsTree::addConfigureNode$lambda$0;
        Function1 function12 = MesonCommandsTree::addConfigureNode$lambda$1;
        Icon icon3 = AllIcons.Diff.MagicResolve;
        Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"MagicResolve");
        MesonCommandsTree.addConfigureNode$createNodeWithConfigureType(configureNode, configuration, MesonToolwindowUsagesCollector.ToolwindowAction.AUTO_FEATURES, string2, icon2, string3, enumEntries, function1, function12, icon3, MesonCommandsTree::addConfigureNode$lambda$2, MesonCommandsTree::addConfigureNode$lambda$3);
        String string4 = MesonBundle.INSTANCE.message("toolwindow.nodes.configure.backend.node.text", new Object[0]);
        Icon icon4 = AllIcons.Nodes.Related;
        Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"Related");
        String string5 = MesonBundle.INSTANCE.message("toolwindow.nodes.configure.backend.node.description", new Object[0]);
        EnumEntries<MesonCommand.Configure.BackendType> enumEntries2 = MesonCommand.Configure.BackendType.getEntries();
        Function1 function13 = MesonCommandsTree::addConfigureNode$lambda$4;
        Function1 function14 = MesonCommandsTree::addConfigureNode$lambda$5;
        Icon icon5 = AllIcons.Nodes.Related;
        Intrinsics.checkNotNullExpressionValue((Object)icon5, (String)"Related");
        MesonCommandsTree.addConfigureNode$createNodeWithConfigureType(configureNode, configuration, MesonToolwindowUsagesCollector.ToolwindowAction.BACKEND, string4, icon4, string5, enumEntries2, function13, function14, icon5, MesonCommandsTree::addConfigureNode$lambda$6, MesonCommandsTree::addConfigureNode$lambda$7);
        String string6 = MesonBundle.INSTANCE.message("toolwindow.nodes.configure.buildtype.node.text", new Object[0]);
        Icon icon6 = AllIcons.Actions.Compile;
        Intrinsics.checkNotNullExpressionValue((Object)icon6, (String)"Compile");
        String string7 = MesonBundle.INSTANCE.message("toolwindow.nodes.configure.buildtype.node.description", new Object[0]);
        EnumEntries<MesonCommand.Configure.BuildType> enumEntries3 = MesonCommand.Configure.BuildType.getEntries();
        Function1 function15 = MesonCommandsTree::addConfigureNode$lambda$8;
        Function1 function16 = MesonCommandsTree::addConfigureNode$lambda$9;
        Icon icon7 = AllIcons.Actions.Compile;
        Intrinsics.checkNotNullExpressionValue((Object)icon7, (String)"Compile");
        MesonCommandsTree.addConfigureNode$createNodeWithConfigureType(configureNode, configuration, MesonToolwindowUsagesCollector.ToolwindowAction.BUILD_TYPE, string6, icon6, string7, enumEntries3, function15, function16, icon7, MesonCommandsTree::addConfigureNode$lambda$10, MesonCommandsTree::addConfigureNode$lambda$11);
        String string8 = MesonBundle.INSTANCE.message("toolwindow.nodes.configure.defaultlibrary.node.text", new Object[0]);
        Icon icon8 = AllIcons.Nodes.PpLib;
        Intrinsics.checkNotNullExpressionValue((Object)icon8, (String)"PpLib");
        String string9 = MesonBundle.INSTANCE.message("toolwindow.nodes.configure.defaultlibrary.node.description", new Object[0]);
        EnumEntries<MesonCommand.Configure.DefaultLibraryType> enumEntries4 = MesonCommand.Configure.DefaultLibraryType.getEntries();
        Function1 function17 = MesonCommandsTree::addConfigureNode$lambda$12;
        Function1 function18 = MesonCommandsTree::addConfigureNode$lambda$13;
        Icon icon9 = AllIcons.Nodes.PpLib;
        Intrinsics.checkNotNullExpressionValue((Object)icon9, (String)"PpLib");
        MesonCommandsTree.addConfigureNode$createNodeWithConfigureType(configureNode, configuration, MesonToolwindowUsagesCollector.ToolwindowAction.DEFAULT_LIBRARY, string8, icon8, string9, enumEntries4, function17, function18, icon9, MesonCommandsTree::addConfigureNode$lambda$14, MesonCommandsTree::addConfigureNode$lambda$15);
        String string10 = MesonBundle.INSTANCE.message("toolwindow.nodes.configure.optimization.node.text", new Object[0]);
        Icon icon10 = AllIcons.Javaee.PersistenceEntity;
        Intrinsics.checkNotNullExpressionValue((Object)icon10, (String)"PersistenceEntity");
        String string11 = MesonBundle.INSTANCE.message("toolwindow.nodes.configure.optimization.node.description", new Object[0]);
        EnumEntries<MesonCommand.Configure.OptimizationLevel> enumEntries5 = MesonCommand.Configure.OptimizationLevel.getEntries();
        Function1 function19 = MesonCommandsTree::addConfigureNode$lambda$16;
        Function1 function110 = MesonCommandsTree::addConfigureNode$lambda$17;
        Icon icon11 = AllIcons.Javaee.PersistenceEntity;
        Intrinsics.checkNotNullExpressionValue((Object)icon11, (String)"PersistenceEntity");
        MesonCommandsTree.addConfigureNode$createNodeWithConfigureType(configureNode, configuration, MesonToolwindowUsagesCollector.ToolwindowAction.OPTIMIZATION_LEVEL, string10, icon10, string11, enumEntries5, function19, function110, icon11, MesonCommandsTree::addConfigureNode$lambda$18, MesonCommandsTree::addConfigureNode$lambda$19);
        String string12 = MesonBundle.INSTANCE.message("toolwindow.nodes.configure.warnlevel.node.text", new Object[0]);
        Icon icon12 = AllIcons.Actions.Colors;
        Intrinsics.checkNotNullExpressionValue((Object)icon12, (String)"Colors");
        String string13 = MesonBundle.INSTANCE.message("toolwindow.nodes.configure.warnlevel.node.description", new Object[0]);
        EnumEntries<MesonCommand.Configure.WarningLevel> enumEntries6 = MesonCommand.Configure.WarningLevel.getEntries();
        Function1 function111 = MesonCommandsTree::addConfigureNode$lambda$20;
        Function1 function112 = MesonCommandsTree::addConfigureNode$lambda$21;
        Icon icon13 = AllIcons.Actions.Colors;
        Intrinsics.checkNotNullExpressionValue((Object)icon13, (String)"Colors");
        MesonCommandsTree.addConfigureNode$createNodeWithConfigureType(configureNode, configuration, MesonToolwindowUsagesCollector.ToolwindowAction.WARNING_LEVEL, string12, icon12, string13, enumEntries6, function111, function112, icon13, MesonCommandsTree::addConfigureNode$lambda$22, MesonCommandsTree::addConfigureNode$lambda$23);
        DefaultMutableTreeNode werrorNode = new DefaultMutableTreeNode();
        configureNode.add(werrorNode);
        MesonCommand.Configure command = new MesonCommand.Configure().withWerror();
        String commandLine = MesonCommandsTreeKt.access$getNlsCommandLine(command);
        String string14 = MesonBundle.INSTANCE.message("toolwindow.nodes.configure.werror.node.text", new Object[0]);
        Icon icon14 = AllIcons.General.InspectionsMixed;
        Intrinsics.checkNotNullExpressionValue((Object)icon14, (String)"InspectionsMixed");
        werrorNode.setUserObject(new MesonCommandsCustomRunCommand(string14, icon14, commandLine, true, configuration, MesonToolwindowUsagesCollector.ToolwindowAction.THREAT_WARNINGS_AS_ERRORS, MesonBundle.INSTANCE.message("toolwindow.nodes.configure.werror.node.werror.task.name", new Object[0]), null, MesonBundle.INSTANCE.message("toolwindow.nodes.configure.werror.node.werror.progress.title", new Object[0]), commandLine, null, command, 1024, null));
    }

    private final void addDistNode(DefaultMutableTreeNode $this$addDistNode, MesonBuildConfiguration configuration, Version mesonVersion) {
        if (configuration == null) {
            return;
        }
        boolean isEnabledDist = mesonVersion.compareTo(MesonCommand.Dist.INSTANCE.getSINCE()) >= 0;
        DefaultMutableTreeNode distCommandNode = new DefaultMutableTreeNode();
        $this$addDistNode.add(distCommandNode);
        MesonCommand.Dist command = MesonCommand.Dist.INSTANCE;
        String commandLine = MesonCommandsTreeKt.access$getNlsCommandLine(command);
        String string = MesonBundle.INSTANCE.message("toolwindow.nodes.dist.node.text", new Object[0]);
        Icon icon = AllIcons.Nodes.PpLibFolder;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"PpLibFolder");
        distCommandNode.setUserObject(new MesonCommandsCustomRunCommand(string, icon, commandLine, isEnabledDist, configuration, MesonToolwindowUsagesCollector.ToolwindowAction.CREATE_RELEASE_ARCHIVE, MesonBundle.INSTANCE.message("toolwindow.nodes.dist.node.dist.task.name", new Object[0]), null, MesonBundle.INSTANCE.message("toolwindow.nodes.dist.node.dist.progress.title", new Object[0]), commandLine, null, command, 1024, null));
    }

    private final void addInstallNode(DefaultMutableTreeNode $this$addInstallNode, MesonBuildConfiguration configuration, Version mesonVersion) {
        if (configuration == null) {
            return;
        }
        boolean isEnabledInstall = mesonVersion.compareTo(MesonCommand.Install.Companion.getSINCE()) >= 0;
        DefaultMutableTreeNode installMainNode = new DefaultMutableTreeNode();
        $this$addInstallNode.add(installMainNode);
        String string = MesonBundle.INSTANCE.message("toolwindow.nodes.install.node.text", new Object[0]);
        Icon icon = AllIcons.Actions.Install;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Install");
        installMainNode.setUserObject(new MesonCommandsTreeAction(string, icon, MesonBundle.INSTANCE.message("toolwindow.nodes.install.node.description", new Object[0]), isEnabledInstall, null, 16, null));
        DefaultMutableTreeNode simpleInstallNode = new DefaultMutableTreeNode();
        installMainNode.add(simpleInstallNode);
        MesonCommand.Install simpleInstallCommand = new MesonCommand.Install();
        String simpleInstallCommandLine = MesonCommandsTreeKt.access$getNlsCommandLine(simpleInstallCommand);
        String string2 = MesonBundle.INSTANCE.message("toolwindow.nodes.install.node.install.node.text", new Object[0]);
        Icon icon2 = AllIcons.Actions.Install;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Install");
        simpleInstallNode.setUserObject(new MesonCommandsCustomRunCommand(string2, icon2, simpleInstallCommandLine, isEnabledInstall, configuration, MesonToolwindowUsagesCollector.ToolwindowAction.INSTALL, MesonBundle.INSTANCE.message("toolwindow.nodes.install.node.install.task.name", new Object[0]), null, MesonBundle.INSTANCE.message("toolwindow.nodes.install.node.install.progress.title", new Object[0]), simpleInstallCommandLine, null, simpleInstallCommand, 1024, null));
        DefaultMutableTreeNode noRebuildInstallNode = new DefaultMutableTreeNode();
        installMainNode.add(noRebuildInstallNode);
        MesonCommand.Install noRebuildInstallCommand = new MesonCommand.Install().withNoRebuild();
        String noRebuildInstallCommandLine = MesonCommandsTreeKt.access$getNlsCommandLine(noRebuildInstallCommand);
        String string3 = MesonBundle.INSTANCE.message("toolwindow.nodes.install.node.installnorebuild.node.text", new Object[0]);
        Icon icon3 = AllIcons.Actions.Install;
        Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"Install");
        noRebuildInstallNode.setUserObject(new MesonCommandsCustomRunCommand(string3, icon3, noRebuildInstallCommandLine, isEnabledInstall, configuration, MesonToolwindowUsagesCollector.ToolwindowAction.INSTALL, MesonBundle.INSTANCE.message("toolwindow.nodes.install.node.installnorebuild.task.name", new Object[0]), null, MesonBundle.INSTANCE.message("toolwindow.nodes.install.node.installnorebuild.progress.title", new Object[0]), noRebuildInstallCommandLine, null, noRebuildInstallCommand, 1024, null));
        DefaultMutableTreeNode onlyChangesInstallNode = new DefaultMutableTreeNode();
        installMainNode.add(onlyChangesInstallNode);
        MesonCommand.Install onlyChangesInstallCommand = new MesonCommand.Install().withOnlyChanged();
        String onlyChangesInstallCommandLine = MesonCommandsTreeKt.access$getNlsCommandLine(onlyChangesInstallCommand);
        String string4 = MesonBundle.INSTANCE.message("toolwindow.nodes.install.node.installonlychanges.node.text", new Object[0]);
        Icon icon4 = AllIcons.Actions.Install;
        Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"Install");
        onlyChangesInstallNode.setUserObject(new MesonCommandsCustomRunCommand(string4, icon4, onlyChangesInstallCommandLine, isEnabledInstall, configuration, MesonToolwindowUsagesCollector.ToolwindowAction.INSTALL, MesonBundle.INSTANCE.message("toolwindow.nodes.install.node.installonlychanges.task.name", new Object[0]), null, MesonBundle.INSTANCE.message("toolwindow.nodes.install.node.installonlychanges.progress.title", new Object[0]), onlyChangesInstallCommandLine, null, onlyChangesInstallCommand, 1024, null));
    }

    private final void addSubprojectsNode(DefaultMutableTreeNode $this$addSubprojectsNode, MesonBuildConfiguration configuration, Version mesonVersion) {
        if (configuration == null) {
            return;
        }
        Path baseDir = MesonWorkspace.Companion.getInstance(this.project).getProjectPath();
        boolean isEnabled = mesonVersion.compareTo(MesonCommand.Subprojects.INSTANCE.getSINCE()) >= 0;
        DefaultMutableTreeNode subprojectsNode = new DefaultMutableTreeNode();
        $this$addSubprojectsNode.add(subprojectsNode);
        String string = MesonBundle.INSTANCE.message("toolwindow.nodes.subprojects.node.text", new Object[0]);
        Icon icon = AllIcons.Hierarchy.Subtypes;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Subtypes");
        subprojectsNode.setUserObject(new MesonCommandsTreeAction(string, icon, MesonBundle.INSTANCE.message("toolwindow.nodes.subprojects.node.description", new Object[0]), isEnabled, null, 16, null));
        DefaultMutableTreeNode updateSubprojectsNode = new DefaultMutableTreeNode();
        subprojectsNode.add(updateSubprojectsNode);
        MesonCommand.Subprojects.Update updateSubprojectsCommand = MesonCommand.Subprojects.Update.INSTANCE;
        String updateCommandLine = MesonCommandsTreeKt.access$getNlsCommandLine(updateSubprojectsCommand);
        String string2 = MesonBundle.INSTANCE.message("toolwindow.nodes.subprojects.node.update.node.text", new Object[0]);
        Icon icon2 = AllIcons.Ide.Notification.PluginUpdate;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"PluginUpdate");
        updateSubprojectsNode.setUserObject(new MesonCommandsCustomRunCommand(string2, icon2, updateCommandLine, isEnabled, configuration, MesonToolwindowUsagesCollector.ToolwindowAction.SUBPROJECTS, MesonBundle.INSTANCE.message("toolwindow.nodes.subprojects.node.update.task.name", new Object[0]), null, MesonBundle.INSTANCE.message("toolwindow.nodes.subprojects.node.update.progress.title", new Object[0]), updateCommandLine, baseDir, updateSubprojectsCommand));
        DefaultMutableTreeNode downloadSubprojectsNode = new DefaultMutableTreeNode();
        subprojectsNode.add(downloadSubprojectsNode);
        MesonCommand.Subprojects.Download downloadSubprojectsCommand = MesonCommand.Subprojects.Download.INSTANCE;
        String downloadCommandLine = MesonCommandsTreeKt.access$getNlsCommandLine(downloadSubprojectsCommand);
        String string3 = MesonBundle.INSTANCE.message("toolwindow.nodes.subprojects.node.download.node.text", new Object[0]);
        Icon icon3 = AllIcons.Actions.Download;
        Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"Download");
        downloadSubprojectsNode.setUserObject(new MesonCommandsCustomRunCommand(string3, icon3, downloadCommandLine, isEnabled, configuration, MesonToolwindowUsagesCollector.ToolwindowAction.SUBPROJECTS, MesonBundle.INSTANCE.message("toolwindow.nodes.subprojects.node.download.task.name", new Object[0]), null, MesonBundle.INSTANCE.message("toolwindow.nodes.subprojects.node.download.progress.title", new Object[0]), downloadCommandLine, baseDir, downloadSubprojectsCommand));
        DefaultMutableTreeNode purgeSubprojectsNode = new DefaultMutableTreeNode();
        subprojectsNode.add(purgeSubprojectsNode);
        MesonCommand.Subprojects.Purge purgeSubprojectsCommand = MesonCommand.Subprojects.Purge.INSTANCE;
        String purgeCommandLine = MesonCommandsTreeKt.access$getNlsCommandLine(purgeSubprojectsCommand);
        String string4 = MesonBundle.INSTANCE.message("toolwindow.nodes.subprojects.node.purge.node.text", new Object[0]);
        Icon icon4 = AllIcons.Vcs.Remove;
        Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"Remove");
        purgeSubprojectsNode.setUserObject(new MesonCommandsCustomRunCommand(string4, icon4, purgeCommandLine, isEnabled, configuration, MesonToolwindowUsagesCollector.ToolwindowAction.SUBPROJECTS, MesonBundle.INSTANCE.message("toolwindow.nodes.subprojects.node.purge.task.name", new Object[0]), null, MesonBundle.INSTANCE.message("toolwindow.nodes.subprojects.node.purge.progress.title", new Object[0]), purgeCommandLine, baseDir, purgeSubprojectsCommand));
    }

    private final void addTestNode(DefaultMutableTreeNode $this$addTestNode, MesonBuildConfiguration configuration) {
        if (configuration == null) {
            return;
        }
        DefaultMutableTreeNode testNode = new DefaultMutableTreeNode();
        $this$addTestNode.add(testNode);
        MesonCommand.Test command = MesonCommand.Test.INSTANCE;
        String commandCommandLine = MesonCommandsTreeKt.access$getNlsCommandLine(command);
        String string = MesonBundle.INSTANCE.message("toolwindow.nodes.test.node.text", new Object[0]);
        Icon icon = AllIcons.Scope.Tests;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Tests");
        testNode.setUserObject(new MesonCommandsCustomRunCommand(string, icon, commandCommandLine, true, configuration, MesonToolwindowUsagesCollector.ToolwindowAction.TEST, MesonBundle.INSTANCE.message("toolwindow.nodes.test.node.test.task.name", new Object[0]), null, MesonBundle.INSTANCE.message("toolwindow.nodes.test.node.test.progress.title", new Object[0]), commandCommandLine, null, command, 1024, null));
    }

    public final void callCurrentAction() {
        TreePath treePath = this.getSelectionPath();
        if (treePath == null) {
            return;
        }
        TreePath selected = treePath;
        Object object = selected.getLastPathComponent();
        DefaultMutableTreeNode defaultMutableTreeNode = object instanceof DefaultMutableTreeNode ? (DefaultMutableTreeNode)object : null;
        if (defaultMutableTreeNode == null) {
            return;
        }
        DefaultMutableTreeNode cell = defaultMutableTreeNode;
        Object object2 = cell.getUserObject();
        MesonCommandsTreeAction mesonCommandsTreeAction = object2 instanceof MesonCommandsTreeAction ? (MesonCommandsTreeAction)object2 : null;
        if (mesonCommandsTreeAction == null) {
            return;
        }
        MesonCommandsTreeAction actionInfo = mesonCommandsTreeAction;
        if (!actionInfo.isEnabled()) {
            return;
        }
        Function1<Project, Unit> function1 = actionInfo.getAction();
        if (function1 == null) {
            return;
        }
        Function1<Project, Unit> action = function1;
        action.invoke((Object)this.project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit updateCurrentTargets$lambda$2(MesonCommandsTree this$0, List $targetsBuildConfigurations, MesonBuildAllConfiguration $buildAllConfiguration, MesonModelManager.State $newState, MesonBuildConfiguration $randomConfiguration) {
        Lock lock = this$0.targetsUpdateLock;
        lock.lock();
        try {
            boolean bl = false;
            this$0.root.removeAllChildren();
            this$0.addBuildTargetNodes(this$0.root, $targetsBuildConfigurations, $buildAllConfiguration, $newState.getVersion());
            this$0.addCleanNode(this$0.root, $randomConfiguration);
            this$0.addConfigureNode(this$0.root, $randomConfiguration);
            this$0.addDistNode(this$0.root, $randomConfiguration, $newState.getVersion());
            this$0.addInstallNode(this$0.root, $randomConfiguration, $newState.getVersion());
            this$0.addSubprojectsNode(this$0.root, $randomConfiguration, $newState.getVersion());
            this$0.addTestNode(this$0.root, $randomConfiguration);
            TreeModel treeModel = this$0.getModel();
            Intrinsics.checkNotNull((Object)treeModel, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultTreeModel");
            ((DefaultTreeModel)treeModel).nodeStructureChanged(this$0.root);
            TreeUtil.expand((JTree)((JTree)((Object)this$0)), (int)2);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        return Unit.INSTANCE;
    }

    private static final <T extends Enum<T>> void addConfigureNode$createNodeWithConfigureType(DefaultMutableTreeNode configureNode, MesonBuildConfiguration $configuration, MesonToolwindowUsagesCollector.ToolwindowAction taskType, String mainNodeText, Icon mainNodeIcon, String mainNodeDescription, EnumEntries<T> enumEntries, Function1<? super T, ? extends MesonCommand> commandGet, Function1<? super T, String> commandNodeText, Icon commandNodeIcon, Function1<? super T, String> taskName, Function1<? super T, String> progressTitle) {
        DefaultMutableTreeNode mainNode = new DefaultMutableTreeNode();
        mainNode.setUserObject(new MesonCommandsTreeAction(mainNodeText, mainNodeIcon, mainNodeDescription, false, null, 24, null));
        configureNode.add(mainNode);
        for (Enum entry : enumEntries) {
            DefaultMutableTreeNode commandNode = new DefaultMutableTreeNode();
            mainNode.add(commandNode);
            MesonCommand command = (MesonCommand)commandGet.invoke((Object)entry);
            String parametersList = MesonCommandsTreeKt.access$getNlsCommandLine(command);
            commandNode.setUserObject(new MesonCommandsCustomRunCommand((String)commandNodeText.invoke((Object)entry), commandNodeIcon, parametersList, true, $configuration, taskType, (String)taskName.invoke((Object)entry), null, (String)progressTitle.invoke((Object)entry), parametersList, null, command, 1024, null));
        }
    }

    private static final MesonCommand addConfigureNode$lambda$0(MesonCommand.Configure.AutoFeatures it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return new MesonCommand.Configure().withAutoFeatures(it);
    }

    private static final String addConfigureNode$lambda$1(MesonCommand.Configure.AutoFeatures it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        Object[] objectArray = new Object[]{it.getConsoleString()};
        return MesonBundle.INSTANCE.message("toolwindow.nodes.configure.autofeature.feature.node.text", objectArray);
    }

    private static final String addConfigureNode$lambda$2(MesonCommand.Configure.AutoFeatures it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        Object[] objectArray = new Object[]{it.getConsoleString()};
        return MesonBundle.INSTANCE.message("toolwindow.nodes.configure.autofeature.feature.task.name", objectArray);
    }

    private static final String addConfigureNode$lambda$3(MesonCommand.Configure.AutoFeatures it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        Object[] objectArray = new Object[]{it.getConsoleString()};
        return MesonBundle.INSTANCE.message("toolwindow.nodes.configure.autofeature.feature.progress.title", objectArray);
    }

    private static final MesonCommand addConfigureNode$lambda$4(MesonCommand.Configure.BackendType it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return new MesonCommand.Configure().withBackend(it);
    }

    private static final String addConfigureNode$lambda$5(MesonCommand.Configure.BackendType it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        Object[] objectArray = new Object[]{it.getConsoleString()};
        return MesonBundle.INSTANCE.message("toolwindow.nodes.configure.backend.node.backend.node.text", objectArray);
    }

    private static final String addConfigureNode$lambda$6(MesonCommand.Configure.BackendType it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        Object[] objectArray = new Object[]{it.getConsoleString()};
        return MesonBundle.INSTANCE.message("toolwindow.nodes.configure.backend.node.backend.task.name", objectArray);
    }

    private static final String addConfigureNode$lambda$7(MesonCommand.Configure.BackendType it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        Object[] objectArray = new Object[]{it.getConsoleString()};
        return MesonBundle.INSTANCE.message("toolwindow.nodes.configure.backend.node.backend.progress.title", objectArray);
    }

    private static final MesonCommand addConfigureNode$lambda$8(MesonCommand.Configure.BuildType it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return new MesonCommand.Configure().withBuildType(it);
    }

    private static final String addConfigureNode$lambda$9(MesonCommand.Configure.BuildType it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        Object[] objectArray = new Object[]{it.getConsoleString()};
        return MesonBundle.INSTANCE.message("toolwindow.nodes.configure.buildtype.node.buildtype.node.text", objectArray);
    }

    private static final String addConfigureNode$lambda$10(MesonCommand.Configure.BuildType it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        Object[] objectArray = new Object[]{it.getConsoleString()};
        return MesonBundle.INSTANCE.message("toolwindow.nodes.configure.buildtype.node.buildtype.task.name", objectArray);
    }

    private static final String addConfigureNode$lambda$11(MesonCommand.Configure.BuildType it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        Object[] objectArray = new Object[]{it.getConsoleString()};
        return MesonBundle.INSTANCE.message("toolwindow.nodes.configure.buildtype.node.buildtype.progress.title", objectArray);
    }

    private static final MesonCommand addConfigureNode$lambda$12(MesonCommand.Configure.DefaultLibraryType it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return new MesonCommand.Configure().withDefaultLibrary(it);
    }

    private static final String addConfigureNode$lambda$13(MesonCommand.Configure.DefaultLibraryType it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        Object[] objectArray = new Object[]{it.getConsoleString()};
        return MesonBundle.INSTANCE.message("toolwindow.nodes.configure.defaultlibrary.node.defaultlibrary.node.text", objectArray);
    }

    private static final String addConfigureNode$lambda$14(MesonCommand.Configure.DefaultLibraryType it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        Object[] objectArray = new Object[]{it.getConsoleString()};
        return MesonBundle.INSTANCE.message("toolwindow.nodes.configure.defaultlibrary.node.defaultlibrary.task.name", objectArray);
    }

    private static final String addConfigureNode$lambda$15(MesonCommand.Configure.DefaultLibraryType it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        Object[] objectArray = new Object[]{it.getConsoleString()};
        return MesonBundle.INSTANCE.message("toolwindow.nodes.configure.defaultlibrary.node.defaultlibrary.progress.title", objectArray);
    }

    private static final MesonCommand addConfigureNode$lambda$16(MesonCommand.Configure.OptimizationLevel it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return new MesonCommand.Configure().withOptimizationLevel(it);
    }

    private static final String addConfigureNode$lambda$17(MesonCommand.Configure.OptimizationLevel it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        Object[] objectArray = new Object[]{it.getConsoleString()};
        return MesonBundle.INSTANCE.message("toolwindow.nodes.configure.optimization.node.optimization.node.text", objectArray);
    }

    private static final String addConfigureNode$lambda$18(MesonCommand.Configure.OptimizationLevel it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        Object[] objectArray = new Object[]{it.getConsoleString()};
        return MesonBundle.INSTANCE.message("toolwindow.nodes.configure.optimization.node.optimization.task.name", objectArray);
    }

    private static final String addConfigureNode$lambda$19(MesonCommand.Configure.OptimizationLevel it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        Object[] objectArray = new Object[]{it.getConsoleString()};
        return MesonBundle.INSTANCE.message("toolwindow.nodes.configure.optimization.node.optimization.progress.title", objectArray);
    }

    private static final MesonCommand addConfigureNode$lambda$20(MesonCommand.Configure.WarningLevel it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return new MesonCommand.Configure().withWarningLevel(it);
    }

    private static final String addConfigureNode$lambda$21(MesonCommand.Configure.WarningLevel it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        Object[] objectArray = new Object[]{it.getConsoleString()};
        return MesonBundle.INSTANCE.message("toolwindow.nodes.configure.warnlevel.node.warnlevel.node.text", objectArray);
    }

    private static final String addConfigureNode$lambda$22(MesonCommand.Configure.WarningLevel it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        Object[] objectArray = new Object[]{it.getConsoleString()};
        return MesonBundle.INSTANCE.message("toolwindow.nodes.configure.warnlevel.node.warnlevel.task.name", objectArray);
    }

    private static final String addConfigureNode$lambda$23(MesonCommand.Configure.WarningLevel it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        Object[] objectArray = new Object[]{it.getConsoleString()};
        return MesonBundle.INSTANCE.message("toolwindow.nodes.configure.warnlevel.node.warnlevel.progress.title", objectArray);
    }
}

