/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.meson.project.resolver.model;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Version;
import com.jetbrains.cidr.meson.bundle.MesonBundle;
import com.jetbrains.cidr.meson.project.resolver.MesonModelException;
import com.jetbrains.cidr.meson.project.resolver.model.MesonInfo;
import com.jetbrains.cidr.meson.project.resolver.model.MesonInfoCore;
import com.jetbrains.cidr.meson.project.resolver.model.MesonIntroCompilers;
import com.jetbrains.cidr.meson.project.resolver.model.MesonIntroTargets;
import com.jetbrains.cidr.meson.project.resolver.model.MesonIntrospection;
import java.io.IOException;
import java.nio.file.Path;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0013H\u0002\u001a\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0013H\u0002\u001a\u001e\u0010\u0019\u001a\u0002H\u001a\"\u0006\b\u0000\u0010\u001a\u0018\u00012\u0006\u0010\u001b\u001a\u00020\u0011H\u0082\b\u00a2\u0006\u0002\u0010\u001c\u001a \u0010\u001d\u001a\u0004\u0018\u0001H\u001a\"\u0006\b\u0000\u0010\u001a\u0018\u00012\u0006\u0010\u001b\u001a\u00020\u0011H\u0082\b\u00a2\u0006\u0002\u0010\u001c\u001a\u0015\u0010\u001e\u001a\u00070\t\u00a2\u0006\u0002\b\u001f2\u0006\u0010\u001b\u001a\u00020\u0011H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001b\u0010\u0002\u001a\u00020\u00038BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\u0004\u0010\u0005\"\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getObjectMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "objectMapper$delegate", "Lkotlin/Lazy;", "MESON_INFO_FILE_NAME", "", "INTRO_TARGETS_FILE_NAME", "INTRO_COMPILERS_FILE_NAME", "INTROSPECTION_VERSION", "Lcom/intellij/openapi/util/Version;", "checkIntrospectionVersion", "", "directory", "Ljava/nio/file/Path;", "parseMesonInfo", "Lcom/jetbrains/cidr/meson/project/resolver/model/MesonInfo;", "parseMesonTargets", "Lcom/jetbrains/cidr/meson/project/resolver/model/MesonIntroTargets;", "mesonInfo", "parseMesonCompilers", "Lcom/jetbrains/cidr/meson/project/resolver/model/MesonIntroCompilers;", "parseIntrospection", "T", "file", "(Ljava/nio/file/Path;)Ljava/lang/Object;", "parseOptionalIntrospection", "readFile", "Lorg/jetbrains/annotations/NonNls;", "intellij.clion.meson"})
@SourceDebugExtension(value={"SMAP\nMesonIntrospection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MesonIntrospection.kt\ncom/jetbrains/cidr/meson/project/resolver/model/MesonIntrospectionKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,154:1\n132#1,2:155\n132#1,2:157\n132#1,2:160\n137#1,2:162\n132#1,10:164\n132#1,2:174\n1#2:159\n13#3:176\n*S KotlinDebug\n*F\n+ 1 MesonIntrospection.kt\ncom/jetbrains/cidr/meson/project/resolver/model/MesonIntrospectionKt\n*L\n86#1:155,2\n100#1:157,2\n114#1:160,2\n128#1:162,2\n128#1:164,10\n138#1:174,2\n16#1:176\n*E\n"})
public final class MesonIntrospectionKt {
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Lazy objectMapper$delegate;
    @NotNull
    private static final String MESON_INFO_FILE_NAME = "meson-info.json";
    @NotNull
    private static final String INTRO_TARGETS_FILE_NAME = "intro-targets.json";
    @NotNull
    private static final String INTRO_COMPILERS_FILE_NAME = "intro-compilers.json";
    @NotNull
    private static final Version INTROSPECTION_VERSION;

    private static final ObjectMapper getObjectMapper() {
        Lazy lazy = objectMapper$delegate;
        return (ObjectMapper)lazy.getValue();
    }

    private static final void checkIntrospectionVersion(Path directory) throws MesonModelException {
        Path file = directory.resolve(MESON_INFO_FILE_NAME);
        Intrinsics.checkNotNull((Object)file);
        Path file$iv = file;
        boolean $i$f$parseIntrospection = false;
        String json$iv = MesonIntrospectionKt.readFile(file$iv);
        MesonInfoCore mesonInfoCore = (MesonInfoCore)MesonIntrospectionKt.getObjectMapper().readValue(json$iv, MesonInfoCore.class);
        if (!Intrinsics.areEqual((Object)mesonInfoCore.getIntrospection().getVersion(), (Object)INTROSPECTION_VERSION)) {
            Object[] objectArray = new Object[]{mesonInfoCore.getIntrospection().getVersion(), INTROSPECTION_VERSION};
            throw new MesonModelException(MesonBundle.INSTANCE.message("model.unsupported.introspection.version.error", objectArray), null, 2, null);
        }
    }

    private static final MesonInfo parseMesonInfo(Path directory) throws MesonModelException {
        Path file = directory.resolve(MESON_INFO_FILE_NAME);
        Intrinsics.checkNotNull((Object)file);
        Path file$iv = file;
        boolean $i$f$parseIntrospection = false;
        String json$iv = MesonIntrospectionKt.readFile(file$iv);
        MesonInfo mesonInfo = (MesonInfo)MesonIntrospectionKt.getObjectMapper().readValue(json$iv, MesonInfo.class);
        if (mesonInfo.getError()) {
            throw new MesonModelException(MesonBundle.INSTANCE.message("model.error.happened.during.reload.error", new Object[0]), null, 2, null);
        }
        return mesonInfo;
    }

    private static final MesonIntroTargets parseMesonTargets(Path directory, MesonInfo mesonInfo) throws MesonModelException {
        CharSequence charSequence;
        CharSequence charSequence2 = mesonInfo.getIntrospection().getInformation().getTargetsFile();
        if (StringsKt.isBlank((CharSequence)charSequence2)) {
            boolean bl = false;
            charSequence = INTRO_TARGETS_FILE_NAME;
        } else {
            charSequence = charSequence2;
        }
        String fileName = (String)charSequence;
        Path file = directory.resolve(fileName);
        Intrinsics.checkNotNull((Object)file);
        Path file$iv = file;
        boolean $i$f$parseIntrospection = false;
        String json$iv = MesonIntrospectionKt.readFile(file$iv);
        return (MesonIntroTargets)MesonIntrospectionKt.getObjectMapper().readValue(json$iv, MesonIntroTargets.class);
    }

    private static final MesonIntroCompilers parseMesonCompilers(Path directory, MesonInfo mesonInfo) throws MesonModelException {
        Object object;
        CharSequence charSequence = mesonInfo.getIntrospection().getInformation().getCompilersFile();
        String fileName = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? mesonInfo.getIntrospection().getInformation().getCompilersFile() : INTRO_COMPILERS_FILE_NAME;
        Path file = directory.resolve(fileName);
        Intrinsics.checkNotNull((Object)file);
        Path file$iv = file;
        boolean $i$f$parseOptionalIntrospection = false;
        try {
            Path file$iv$iv = file$iv;
            boolean $i$f$parseIntrospection = false;
            String json$iv$iv = MesonIntrospectionKt.readFile(file$iv$iv);
            object = MesonIntrospectionKt.getObjectMapper().readValue(json$iv$iv, MesonIntroCompilers.class);
        }
        catch (Exception e$iv) {
            object = null;
        }
        return (MesonIntroCompilers)object;
    }

    private static final /* synthetic */ <T> T parseIntrospection(Path file) {
        boolean $i$f$parseIntrospection = false;
        String json = MesonIntrospectionKt.readFile(file);
        ObjectMapper objectMapper = MesonIntrospectionKt.getObjectMapper();
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return (T)objectMapper.readValue(json, Object.class);
    }

    private static final /* synthetic */ <T> T parseOptionalIntrospection(Path file) {
        Object object;
        boolean $i$f$parseOptionalIntrospection = false;
        try {
            Path file$iv = file;
            boolean $i$f$parseIntrospection = false;
            String json$iv = MesonIntrospectionKt.readFile(file$iv);
            ObjectMapper objectMapper = MesonIntrospectionKt.getObjectMapper();
            Intrinsics.reifiedOperationMarker((int)4, (String)"T?");
            object = objectMapper.readValue(json$iv, Object.class);
        }
        catch (Exception e) {
            object = null;
        }
        return (T)object;
    }

    private static final String readFile(Path file) throws MesonModelException {
        try {
            return PathsKt.readText$default((Path)file, null, (int)1, null);
        }
        catch (IOException ex) {
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)file.getFileName(), (String)"getFileName(...)");
            throw new MesonModelException(MesonBundle.INSTANCE.message("model.cant.read.file.error", objectArray), ex);
        }
    }

    private static final ObjectMapper objectMapper_delegate$lambda$0() {
        ObjectMapper mapper = ExtensionsKt.jacksonObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return mapper;
    }

    public static final /* synthetic */ void access$checkIntrospectionVersion(Path directory) {
        MesonIntrospectionKt.checkIntrospectionVersion(directory);
    }

    public static final /* synthetic */ MesonInfo access$parseMesonInfo(Path directory) {
        return MesonIntrospectionKt.parseMesonInfo(directory);
    }

    public static final /* synthetic */ MesonIntroTargets access$parseMesonTargets(Path directory, MesonInfo mesonInfo) {
        return MesonIntrospectionKt.parseMesonTargets(directory, mesonInfo);
    }

    public static final /* synthetic */ MesonIntroCompilers access$parseMesonCompilers(Path directory, MesonInfo mesonInfo) {
        return MesonIntrospectionKt.parseMesonCompilers(directory, mesonInfo);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(MesonIntrospection.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        objectMapper$delegate = LazyKt.lazy(MesonIntrospectionKt::objectMapper_delegate$lambda$0);
        INTROSPECTION_VERSION = new Version(1, 0, 0);
    }
}

