/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.meson;

import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManager;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.jetbrains.cidr.cpp.external.system.CLionExternalUtilKt;
import com.jetbrains.cidr.external.system.workspace.ExternalWorkspace;
import com.jetbrains.cidr.meson.MesonUtilKt;
import com.jetbrains.cidr.meson.MesonWorkspace;
import com.jetbrains.cidr.meson.settings.MesonProjectSettings;
import com.jetbrains.cidr.meson.settings.MesonSettings;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u0010\u0010\b\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u000e\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bJ\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u00122\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0016\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\u0017\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0007H\u0007J\u0018\u0010\u0018\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u0007H\u0007\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/cidr/meson/MesonUtil;", "", "<init>", "()V", "isMesonOptionsFile", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isMesonFile", "isMesonProject", "project", "Lcom/intellij/openapi/project/Project;", "linkedProjectSettings", "", "Lcom/jetbrains/cidr/meson/settings/MesonProjectSettings;", "projectPath", "", "findMesonFiles", "", "findMesonFile", "markProjectDirty", "", "markAllMesonProjectsDirty", "linkMesonProject", "changeLinkedProjectPath", "newProjectPath", "intellij.clion.meson"})
@SourceDebugExtension(value={"SMAP\nMesonUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MesonUtil.kt\ncom/jetbrains/cidr/meson/MesonUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,99:1\n1563#2:100\n1634#2,3:101\n1617#2,9:105\n1869#2:114\n1870#2:116\n1626#2:117\n1617#2,9:118\n1869#2:127\n1870#2:129\n1626#2:130\n1869#2,2:131\n1#3:104\n1#3:115\n1#3:128\n*S KotlinDebug\n*F\n+ 1 MesonUtil.kt\ncom/jetbrains/cidr/meson/MesonUtil\n*L\n44#1:100\n44#1:101,3\n53#1:105,9\n53#1:114\n53#1:116\n53#1:117\n54#1:118,9\n54#1:127\n54#1:129\n54#1:130\n67#1:131,2\n53#1:115\n54#1:128\n*E\n"})
public final class MesonUtil {
    @NotNull
    public static final MesonUtil INSTANCE = new MesonUtil();

    private MesonUtil() {
    }

    public final boolean isMesonOptionsFile(@Nullable VirtualFile file) {
        if (file == null || file.isDirectory()) {
            return false;
        }
        return StringUtil.equalsIgnoreCase((CharSequence)file.getName(), (CharSequence)"meson.options") || StringUtil.equalsIgnoreCase((CharSequence)file.getName(), (CharSequence)"meson_options.txt");
    }

    public final boolean isMesonFile(@Nullable VirtualFile file) {
        return file != null && !file.isDirectory() && StringUtil.equalsIgnoreCase((CharSequence)file.getName(), (CharSequence)"meson.build");
    }

    public final boolean isMesonProject(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return !this.linkedProjectSettings(project).isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<MesonProjectSettings> linkedProjectSettings(@NotNull Project project) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Collection collection = MesonSettings.Companion.getInstance(project).getLinkedProjectsSettings();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getLinkedProjectsSettings(...)");
        Iterable $this$map$iv = collection;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MesonProjectSettings mesonProjectSettings = (MesonProjectSettings)((Object)item$iv$iv);
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type com.jetbrains.cidr.meson.settings.MesonProjectSettings");
            collection2.add(it);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final MesonProjectSettings linkedProjectSettings(@NotNull Project project, @NotNull String projectPath) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
            Iterable iterable = this.linkedProjectSettings(project);
            for (Object t : iterable) {
                MesonProjectSettings it = (MesonProjectSettings)((Object)t);
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getExternalProjectPath(), (Object)projectPath)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final List<VirtualFile> findMesonFiles(Project project) {
        String it$iv$iv;
        boolean bl;
        Object it;
        boolean bl2;
        Object element$iv$iv;
        Object element$iv$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.linkedProjectSettings(project);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterable $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv$iv = element$iv$iv$iv = iterator.next();
            bl2 = false;
            it = (MesonProjectSettings)((Object)element$iv$iv);
            boolean bl3 = false;
            if (it.getExternalProjectPath() == null) continue;
            bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        $i$f$mapNotNull = false;
        $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv$iv = element$iv$iv$iv = iterator.next();
            bl2 = false;
            it = (String)element$iv$iv;
            boolean bl4 = false;
            if (VfsUtil.findFileByIoFile((File)new File((String)it, "meson.build"), (boolean)false) == null) continue;
            bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final VirtualFile findMesonFile(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return (VirtualFile)CollectionsKt.firstOrNull(this.findMesonFiles(project));
    }

    public final void markProjectDirty(@NotNull Project project, @NotNull String projectPath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        ExternalProjectsManager.getInstance((Project)project).getExternalProjectsWatcher().markDirty(projectPath);
    }

    public final void markAllMesonProjectsDirty(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Iterable $this$forEach$iv = this.linkedProjectSettings(project);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MesonProjectSettings it = (MesonProjectSettings)((Object)element$iv);
            boolean bl = false;
            ExternalProjectsManager.getInstance((Project)project).getExternalProjectsWatcher().markDirty(it.getExternalProjectPath());
        }
    }

    @RequiresEdt
    public final void linkMesonProject(@NotNull Project project, @NotNull VirtualFile projectPath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        MesonProjectSettings settings = MesonProjectSettings.Companion.default();
        settings.setExternalProjectPath(projectPath.getPath());
        MesonWorkspace workspace = MesonWorkspace.Companion.getInstance(project);
        CLionExternalUtilKt.linkExternalProject((Project)project, (ProjectSystemId)MesonUtilKt.getID(), (ExternalProjectSettings)settings, (ExternalWorkspace)workspace);
    }

    @RequiresEdt
    public final void changeLinkedProjectPath(@NotNull Project project, @NotNull VirtualFile newProjectPath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)newProjectPath, (String)"newProjectPath");
        MesonWorkspace workspace = MesonWorkspace.Companion.getInstance(project);
        CLionExternalUtilKt.changeLinkedExternalProjectPath((Project)project, (ProjectSystemId)MesonUtilKt.getID(), (VirtualFile)newProjectPath, (ExternalWorkspace)workspace);
    }
}

