/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeTextBuilder;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptSingleType;
import com.intellij.lang.javascript.psi.types.JSEvaluableType;
import com.intellij.lang.javascript.psi.types.JSLiteralType;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.primitives.JSSymbolType;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import java.text.CharacterIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSUniqueSymbolTypeImpl
extends JSSymbolType
implements JSEvaluableType,
JSLiteralType {
    private final boolean myCanBeWidened;

    public JSUniqueSymbolTypeImpl(@NotNull JSTypeSource source, @NotNull JSTypeContext staticOrInstance, boolean canBeWidened) {
        if (source == null) {
            JSUniqueSymbolTypeImpl.$$$reportNull$$$0(0);
        }
        if (staticOrInstance == null) {
            JSUniqueSymbolTypeImpl.$$$reportNull$$$0(1);
        }
        super(true, source, staticOrInstance);
        this.myCanBeWidened = canBeWidened;
    }

    JSUniqueSymbolTypeImpl(@NotNull JSTypeSource typeSource, @NotNull CharacterIterator inputStream) {
        if (typeSource == null) {
            JSUniqueSymbolTypeImpl.$$$reportNull$$$0(2);
        }
        if (inputStream == null) {
            JSUniqueSymbolTypeImpl.$$$reportNull$$$0(3);
        }
        super(typeSource, inputStream);
        this.myCanBeWidened = JSTypeSerializer.readBoolean(inputStream);
    }

    @Override
    public void serialize(@NotNull StringBuilder outputStream) {
        if (outputStream == null) {
            JSUniqueSymbolTypeImpl.$$$reportNull$$$0(4);
        }
        super.serialize(outputStream);
        JSTypeSerializer.writeBoolean(this.myCanBeWidened, outputStream);
    }

    @Nullable
    public JSFieldVariable getElement() {
        PsiElement sourceElement = this.getSource().getSourceElement();
        if (sourceElement instanceof JSFieldVariable && ((JSFieldVariable)sourceElement).isConst()) {
            return (JSFieldVariable)sourceElement;
        }
        if (!(sourceElement instanceof TypeScriptSingleType)) {
            return null;
        }
        PsiElement parent = sourceElement.getParent();
        if (!(parent instanceof JSFieldVariable)) {
            return null;
        }
        return (JSFieldVariable)parent;
    }

    @Override
    protected void buildTypeTextImpl(@NotNull JSType.TypeTextFormat format, @NotNull JSTypeTextBuilder builder) {
        if (format == null) {
            JSUniqueSymbolTypeImpl.$$$reportNull$$$0(5);
        }
        if (builder == null) {
            JSUniqueSymbolTypeImpl.$$$reportNull$$$0(6);
        }
        if (format == JSType.TypeTextFormat.RESOLVED) {
            super.buildTypeTextImpl(format, builder);
            return;
        }
        JSFieldVariable parent = this.getElement();
        if (parent == null) {
            builder.append("symbol");
            return;
        }
        if (format == JSType.TypeTextFormat.PRESENTABLE) {
            builder.append("unique symbol (for '" + parent.getQualifiedName() + "' in " + parent.getContainingFile().getName() + ")");
            return;
        }
        builder.append("typeof " + parent.getName());
    }

    @Override
    @NotNull
    public String getPrimitiveTypeText() {
        return "unique symbol";
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        if (elementType == null) {
            JSUniqueSymbolTypeImpl.$$$reportNull$$$0(7);
        }
        if (processingContext == null) {
            JSUniqueSymbolTypeImpl.$$$reportNull$$$0(8);
        }
        if (this.isSourceStrict() && elementType.isSourceStrict()) {
            return elementType == this;
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    @Override
    public boolean isEquivalentToWithSameClass(@NotNull JSType jsType, ProcessingContext processingContext, boolean allowResolve) {
        if (jsType == null) {
            JSUniqueSymbolTypeImpl.$$$reportNull$$$0(9);
        }
        if (this.isSourceStrict() && jsType.isSourceStrict()) {
            return jsType == this;
        }
        return super.isEquivalentToWithSameClass(jsType, processingContext, allowResolve);
    }

    @Override
    @NotNull
    public JSType widen(boolean allowResolve) {
        JSType jSType = this.asPrimitiveType();
        if (jSType == null) {
            JSUniqueSymbolTypeImpl.$$$reportNull$$$0(10);
        }
        return jSType;
    }

    @Override
    public boolean allowWidening() {
        return this.myCanBeWidened;
    }

    @Override
    @NotNull
    public JSLiteralType copyWithAllowWidening(boolean allowWidening) {
        if (allowWidening == this.myCanBeWidened) {
            JSUniqueSymbolTypeImpl jSUniqueSymbolTypeImpl = this;
            if (jSUniqueSymbolTypeImpl == null) {
                JSUniqueSymbolTypeImpl.$$$reportNull$$$0(11);
            }
            return jSUniqueSymbolTypeImpl;
        }
        return new JSUniqueSymbolTypeImpl(this.getSource(), this.getTypeContext(), allowWidening);
    }

    @Override
    @NotNull
    public JSType asPrimitiveType() {
        return new JSSymbolType(true, this.getSource(), this.getTypeContext());
    }

    @Override
    @NotNull
    protected JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            JSUniqueSymbolTypeImpl.$$$reportNull$$$0(12);
        }
        if (!source.isStrict()) {
            return new JSUniqueSymbolTypeImpl(source, this.getTypeContext(), this.allowWidening());
        }
        JSUniqueSymbolTypeImpl jSUniqueSymbolTypeImpl = this;
        if (jSUniqueSymbolTypeImpl == null) {
            JSUniqueSymbolTypeImpl.$$$reportNull$$$0(13);
        }
        return jSUniqueSymbolTypeImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 11, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "staticOrInstance";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSource";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsType";
                break;
            }
            case 10: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSUniqueSymbolTypeImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSUniqueSymbolTypeImpl";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "widen";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithAllowWidening";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithNewSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeTextImpl";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToWithSameClass";
                break;
            }
            case 10: 
            case 11: 
            case 13: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 11, 13 -> new IllegalStateException(string);
        };
    }
}

