/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.headerRoots;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public final class HeadersSearchPath {
    private static final int KIND = 7;
    private static final int RECURSIVE = 8;
    private static final int PREFER_QUOTES = 16;
    @NlsSafe
    @NotNull
    private final String myPath;
    private final int myFlags;

    public HeadersSearchPath(@NlsSafe @NotNull String path, int flags) {
        if (path == null) {
            HeadersSearchPath.$$$reportNull$$$0(0);
        }
        this.myPath = path;
        this.myFlags = flags;
    }

    public HeadersSearchPath(@NotNull File file, boolean recursive, @NotNull Kind kind) {
        if (file == null) {
            HeadersSearchPath.$$$reportNull$$$0(1);
        }
        if (kind == null) {
            HeadersSearchPath.$$$reportNull$$$0(2);
        }
        this(file.getPath(), recursive, kind, false);
    }

    public HeadersSearchPath(@NlsSafe @NotNull String path, boolean recursive, @NotNull Kind kind) {
        if (path == null) {
            HeadersSearchPath.$$$reportNull$$$0(3);
        }
        if (kind == null) {
            HeadersSearchPath.$$$reportNull$$$0(4);
        }
        this(path, recursive, kind, false);
    }

    public HeadersSearchPath(@NlsSafe @NotNull String path, boolean recursive, @NotNull Kind kind, boolean preferQuotes) {
        if (path == null) {
            HeadersSearchPath.$$$reportNull$$$0(5);
        }
        if (kind == null) {
            HeadersSearchPath.$$$reportNull$$$0(6);
        }
        this(path, (recursive ? 8 : 0) | (preferQuotes ? 16 : 0) | kind.ordinal());
    }

    @NotNull
    public static HeadersSearchPath includes(@NlsSafe @NotNull String path) {
        if (path == null) {
            HeadersSearchPath.$$$reportNull$$$0(7);
        }
        return new HeadersSearchPath(path, false, Kind.SYSTEM);
    }

    @NotNull
    public static HeadersSearchPath includes(@NotNull File file) {
        if (file == null) {
            HeadersSearchPath.$$$reportNull$$$0(8);
        }
        return HeadersSearchPath.includes(file.getPath());
    }

    @NotNull
    public static HeadersSearchPath userIncludes(@NlsSafe @NotNull String path) {
        if (path == null) {
            HeadersSearchPath.$$$reportNull$$$0(9);
        }
        return new HeadersSearchPath(path, false, Kind.USER);
    }

    @NotNull
    public static HeadersSearchPath builtInIncludes(@NotNull File file) {
        if (file == null) {
            HeadersSearchPath.$$$reportNull$$$0(10);
        }
        return HeadersSearchPath.builtInIncludes(file.getPath());
    }

    @NotNull
    public static HeadersSearchPath builtInIncludes(@NlsSafe @NotNull String path) {
        if (path == null) {
            HeadersSearchPath.$$$reportNull$$$0(11);
        }
        return new HeadersSearchPath(path, false, Kind.BUILTIN);
    }

    @NotNull
    public static HeadersSearchPath userIncludes(@NotNull File file) {
        if (file == null) {
            HeadersSearchPath.$$$reportNull$$$0(12);
        }
        return HeadersSearchPath.userIncludes(file.getPath());
    }

    @NotNull
    public static HeadersSearchPath frameworks(@NlsSafe @NotNull String path) {
        if (path == null) {
            HeadersSearchPath.$$$reportNull$$$0(13);
        }
        return new HeadersSearchPath(path, false, Kind.FRAMEWORK);
    }

    @NotNull
    public static HeadersSearchPath frameworks(@NotNull File file) {
        if (file == null) {
            HeadersSearchPath.$$$reportNull$$$0(14);
        }
        return HeadersSearchPath.frameworks(file.getPath());
    }

    @NlsSafe
    @NotNull
    public String getPath() {
        String string = this.myPath;
        if (string == null) {
            HeadersSearchPath.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NlsSafe
    @NotNull
    public String getUrl() {
        String string = VfsUtilCore.pathToUrl((String)this.myPath);
        if (string == null) {
            HeadersSearchPath.$$$reportNull$$$0(16);
        }
        return string;
    }

    public boolean isRecursive() {
        return (this.myFlags & 8) != 0;
    }

    @NotNull
    public Kind getKind() {
        Kind kind = Kind.fromInt(this.myFlags & 7);
        if (kind == null) {
            HeadersSearchPath.$$$reportNull$$$0(17);
        }
        return kind;
    }

    public boolean isBuiltInHeaders() {
        return this.getKind() == Kind.BUILTIN;
    }

    public boolean isFrameworksSearchPath() {
        return this.getKind() == Kind.FRAMEWORK || this.getKind() == Kind.USER_FRAMEWORK;
    }

    public int getFlags() {
        return this.myFlags;
    }

    public boolean preferQuotes() {
        return (this.myFlags & 0x10) != 0;
    }

    public boolean isAncestorOf(@NotNull VirtualFile file, boolean checkRecursive) {
        if (file == null) {
            HeadersSearchPath.$$$reportNull$$$0(18);
        }
        return FileUtil.pathsEqual((String)this.getPath(), (String)file.getParent().getPath()) || (this.isRecursive() || !checkRecursive) && FileUtil.isAncestor((String)this.getPath(), (String)file.getPath(), (boolean)true);
    }

    @NotNull
    public HeadersSearchPath createNonRecursiveChildPath(@NlsSafe @NotNull String path) {
        if (path == null) {
            HeadersSearchPath.$$$reportNull$$$0(19);
        }
        if (!this.isRecursive()) {
            HeadersSearchPath headersSearchPath = this;
            if (headersSearchPath == null) {
                HeadersSearchPath.$$$reportNull$$$0(20);
            }
            return headersSearchPath;
        }
        return new HeadersSearchPath(path, this.getFlags() ^ 8);
    }

    public String toString() {
        return "HeadersSearchPath{" + this.myPath + ", " + this.getKind().toString() + ", " + (this.isRecursive() ? "recursive" : "non-recursive") + (this.isFrameworksSearchPath() ? ", frameworks" : "") + (this.isBuiltInHeaders() ? ", builtin" : "") + (this.preferQuotes() ? ", prefer quotes" : "") + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HeadersSearchPath that = (HeadersSearchPath)o;
        if (this.myFlags != that.myFlags) {
            return false;
        }
        return FileUtil.pathsEqual((String)this.myPath, (String)that.myPath);
    }

    public int hashCode() {
        int result = FileUtil.pathHashCode((String)this.myPath);
        result = 31 * result + this.myFlags;
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 15, 16, 17, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/workspace/headerRoots/HeadersSearchPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/workspace/headerRoots/HeadersSearchPath";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrl";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createNonRecursiveChildPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "includes";
                break;
            }
            case 9: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "userIncludes";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "builtInIncludes";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "frameworks";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 20: {
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isAncestorOf";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createNonRecursiveChildPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 15, 16, 17, 20 -> new IllegalStateException(string);
        };
    }

    public static enum Kind {
        SYSTEM,
        USER,
        FRAMEWORK,
        USER_FRAMEWORK,
        BUILTIN;


        @NotNull
        public String toString() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 4 -> "builtin";
                case 0 -> "system";
                case 1 -> "user";
                case 3 -> "user_framework";
                case 2 -> "framework";
            };
        }

        public boolean isSystem() {
            return this == BUILTIN || this == SYSTEM || this == FRAMEWORK;
        }

        public boolean isUser() {
            return this == USER || this == USER_FRAMEWORK;
        }

        public boolean isFramework() {
            return this == FRAMEWORK || this == USER_FRAMEWORK;
        }

        @NotNull
        public static Kind fromInt(int kindFlags) {
            Kind kind = switch (kindFlags) {
                case 1 -> USER;
                case 2 -> FRAMEWORK;
                case 3 -> USER_FRAMEWORK;
                case 4 -> BUILTIN;
                default -> SYSTEM;
            };
            if (kind == null) {
                Kind.$$$reportNull$$$0(0);
            }
            return kind;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/workspace/headerRoots/HeadersSearchPath$Kind", "fromInt"));
        }
    }

    @FunctionalInterface
    public static interface FilePointerFactory {
        @NotNull
        public VirtualFilePointer create(@NlsSafe @NotNull String var1);
    }
}

