/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.compiler;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.lang.workspace.compiler.CidrProjectModelBundle;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompiler;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerResolver;
import com.jetbrains.cidr.lang.workspace.compiler.OCOptionsFilteringCapable;
import com.jetbrains.cidr.lang.workspace.compiler.TempFilesPool;
import com.jetbrains.cidr.lang.workspace.compiler.UnknownCompilerKind;
import java.io.File;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public abstract class OCCompilerBase
implements OCCompiler,
OCOptionsFilteringCapable {
    public static final Logger LOG = Logger.getInstance((String)("#" + OCCompilerBase.class.getPackage().getName()));
    private static boolean ourEmulateCompilerWarning = false;
    private static final CompilerRunner DEFAULT_RUNNER;
    @NotNull
    protected static volatile CompilerRunner outCompilerRunner;
    @NotNull
    protected final File myExecutable;
    @NotNull
    protected final File myWorkingDirectory;
    @NotNull
    protected final CidrToolEnvironment myEnvironment;
    @NotNull
    protected final TempFilesPool myTempFilesPool;

    @NotNull
    public static OCCompiler getCompilerInstance(@NotNull Project project, @NotNull OCCompilerKind compilerKind, @NotNull File compilerExecutable, @NotNull File compilerWorkingDirectory, @NotNull CidrToolEnvironment environment, @NotNull TempFilesPool tempFilesPool) {
        if (project == null) {
            OCCompilerBase.$$$reportNull$$$0(0);
        }
        if (compilerKind == null) {
            OCCompilerBase.$$$reportNull$$$0(1);
        }
        if (compilerExecutable == null) {
            OCCompilerBase.$$$reportNull$$$0(2);
        }
        if (compilerWorkingDirectory == null) {
            OCCompilerBase.$$$reportNull$$$0(3);
        }
        if (environment == null) {
            OCCompilerBase.$$$reportNull$$$0(4);
        }
        if (tempFilesPool == null) {
            OCCompilerBase.$$$reportNull$$$0(5);
        }
        if (compilerKind == UnknownCompilerKind.INSTANCE) {
            compilerKind = OCCompilerResolver.resolve(project, environment.getHostMachine().getPath(compilerExecutable.getPath(), new String[0]), environment);
        }
        OCCompiler oCCompiler = compilerKind.getCompilerInstance(project, compilerExecutable, compilerWorkingDirectory, environment, tempFilesPool);
        if (oCCompiler == null) {
            OCCompilerBase.$$$reportNull$$$0(6);
        }
        return oCCompiler;
    }

    @Nullable
    public static OCLanguageKind resolveLanguage(@NotNull OCCompilerKind compilerKind, @NotNull List<String> switches) {
        if (compilerKind == null) {
            OCCompilerBase.$$$reportNull$$$0(7);
        }
        if (switches == null) {
            OCCompilerBase.$$$reportNull$$$0(8);
        }
        return compilerKind.resolveLanguage(switches);
    }

    @TestOnly
    public static void setCompilerRunnerInTests(@Nullable CompilerRunner runner) {
        outCompilerRunner = runner == null ? DEFAULT_RUNNER : runner;
    }

    @TestOnly
    public static void setCompilerErrorInTests(boolean emulate) {
        OCCompilerBase.setCompilerRunnerInTests(!emulate ? null : new CompilerRunner(){

            @Override
            @NotNull
            public ProcessOutput run(@NotNull GeneralCommandLine cl, @NotNull CidrToolEnvironment env) {
                if (cl == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (env == null) {
                    1.$$$reportNull$$$0(1);
                }
                ProcessOutput output = new ProcessOutput(2);
                output.appendStderr("Emulated compiler error");
                ProcessOutput processOutput = output;
                if (processOutput == null) {
                    1.$$$reportNull$$$0(2);
                }
                return processOutput;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "cl";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "env";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerBase$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerBase$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "run";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "run";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        });
    }

    @TestOnly
    public static void setCompilerWarningInTests(boolean emulate) {
        ourEmulateCompilerWarning = emulate;
    }

    public OCCompilerBase(@NotNull File executable, @NotNull File workingDirectory, @NotNull CidrToolEnvironment env, @NotNull TempFilesPool tempFilesPool) {
        if (executable == null) {
            OCCompilerBase.$$$reportNull$$$0(9);
        }
        if (workingDirectory == null) {
            OCCompilerBase.$$$reportNull$$$0(10);
        }
        if (env == null) {
            OCCompilerBase.$$$reportNull$$$0(11);
        }
        if (tempFilesPool == null) {
            OCCompilerBase.$$$reportNull$$$0(12);
        }
        this.myExecutable = executable;
        this.myWorkingDirectory = workingDirectory;
        this.myEnvironment = env;
        this.myTempFilesPool = tempFilesPool;
    }

    @NotNull
    public File getExecutable() {
        File file = this.myExecutable;
        if (file == null) {
            OCCompilerBase.$$$reportNull$$$0(13);
        }
        return file;
    }

    @Nullable
    protected String doReadVersion(@NotNull List<String> arguments, Function<? super ProcessOutput, String> versionParser) {
        ProcessOutput output;
        if (arguments == null) {
            OCCompilerBase.$$$reportNull$$$0(14);
        }
        GeneralCommandLine cl = new GeneralCommandLine();
        cl.setExePath(this.myExecutable.getPath());
        cl.addParameters(arguments);
        cl.getEnvironment().put("LC_ALL", "C");
        try {
            this.myEnvironment.prepare(cl, CidrToolEnvironment.PrepareFor.BUILD);
            output = outCompilerRunner.run(cl, this.myEnvironment);
            if (output.isTimeout()) {
                throw new ExecutionException(CidrProjectModelBundle.message("dialog.message.process.timed.out", new Object[0]));
            }
        }
        catch (ExecutionException e) {
            LOG.info("Cannot read compiler version: " + cl.getCommandLineString(), (Throwable)e);
            return null;
        }
        String result = (String)versionParser.fun((Object)output);
        if (result == null) {
            LOG.info("Cannot read compiler version: " + cl.getCommandLineString() + "\n" + output.getStderr() + "\n" + output.getStdout());
        }
        return result;
    }

    protected static void checkCompilerOutput(@NotNull ProcessOutput output, @NotNull String userFriendlyCommandLine) throws ExecutionException {
        if (output == null) {
            OCCompilerBase.$$$reportNull$$$0(15);
        }
        if (userFriendlyCommandLine == null) {
            OCCompilerBase.$$$reportNull$$$0(16);
        }
        if (output.isTimeout()) {
            throw OCCompilerBase.throwCompilerTimeout(userFriendlyCommandLine);
        }
        if (output.getExitCode() != 0) {
            throw OCCompilerBase.throwCompilerError(output, userFriendlyCommandLine);
        }
    }

    protected static ExecutionException throwCompilerTimeout(@NotNull String userFriendlyCommandLine) throws ExecutionException {
        if (userFriendlyCommandLine == null) {
            OCCompilerBase.$$$reportNull$$$0(17);
        }
        throw new ExecutionException(CidrProjectModelBundle.message("dialog.message.compiler.command.timed.out", userFriendlyCommandLine));
    }

    protected static ExecutionException throwCompilerError(@NotNull ProcessOutput output, @NotNull String userFriendlyCommandLine) throws ExecutionException {
        if (output == null) {
            OCCompilerBase.$$$reportNull$$$0(18);
        }
        if (userFriendlyCommandLine == null) {
            OCCompilerBase.$$$reportNull$$$0(19);
        }
        String message = CidrProjectModelBundle.message("dialog.message.compiler.exited.with.error.code", output.getExitCode(), userFriendlyCommandLine, output.getStderr(), output.getStdout());
        throw new ExecutionException(StringUtil.first((String)message, (int)0x100000, (boolean)true));
    }

    protected static boolean collectOptionsToSkip(@NotNull @NotNull List<@NotNull String> lines, @NotNull @NotNull Set<? super @NotNull String> skipOptions, @NotNull @NotNull List<? super @NotNull String> warnLog, Pattern ... errorPatterns) {
        if (lines == null) {
            OCCompilerBase.$$$reportNull$$$0(20);
        }
        if (skipOptions == null) {
            OCCompilerBase.$$$reportNull$$$0(21);
        }
        if (warnLog == null) {
            OCCompilerBase.$$$reportNull$$$0(22);
        }
        boolean hasNewSkipOptions = false;
        block0: for (String eachError : lines) {
            eachError = eachError.trim();
            for (Pattern rule : errorPatterns) {
                Matcher badOptionOrSwitch = OCCompilerBase.matchSafely(rule, eachError);
                if (!badOptionOrSwitch.matches()) continue;
                hasNewSkipOptions |= skipOptions.add(badOptionOrSwitch.group(1));
                warnLog.add(badOptionOrSwitch.group(0));
                continue block0;
            }
        }
        return hasNewSkipOptions;
    }

    protected static void addEmulatedWarning(@NotNull List<? super String> warnLog) {
        if (warnLog == null) {
            OCCompilerBase.$$$reportNull$$$0(23);
        }
        if (ourEmulateCompilerWarning) {
            assert (ApplicationManager.getApplication().isUnitTestMode()) : "called outside of unit tests";
            warnLog.add("Emulated compiler warning");
        }
    }

    @NotNull
    protected static Matcher matchSafely(Pattern pattern, String eachLine) {
        Matcher matcher;
        try {
            matcher = pattern.matcher(eachLine);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Error in regexp: `" + pattern.pattern() + "` line: `" + eachLine + "`", e);
        }
        if (matcher == null) {
            OCCompilerBase.$$$reportNull$$$0(24);
        }
        return matcher;
    }

    protected void logCompilerOutput(@NotNull String commandLineString, @NotNull ProcessOutput output) {
        if (commandLineString == null) {
            OCCompilerBase.$$$reportNull$$$0(25);
        }
        if (output == null) {
            OCCompilerBase.$$$reportNull$$$0(26);
        }
        if (LOG.isDebugEnabled()) {
            @NonNls String dbg = "Compiler finished `" + commandLineString + "` with exit code " + output.getExitCode();
            if (output.getExitCode() != 0 || LOG.isTraceEnabled()) {
                dbg = dbg + ":\n>>>>>>>>>>>>>>>>>>>>>>>>>>>>>";
                if (LOG.isTraceEnabled()) {
                    dbg = dbg + "\nStdout:\n " + output.getStdout();
                }
                dbg = dbg + "\nStderr:\n " + output.getStderr() + "\n<<<<<<<<<<<<<<<<<<<<<<<<<<<<<\n";
            }
            LOG.debug(dbg);
        }
    }

    static {
        outCompilerRunner = DEFAULT_RUNNER = new CompilerRunner();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 13, 24 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilerKind";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilerExecutable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilerWorkingDirectory";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tempFilesPool";
                break;
            }
            case 6: 
            case 13: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerBase";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switches";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executable";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirectory";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 15: 
            case 18: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 16: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userFriendlyCommandLine";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "skipOptions";
                break;
            }
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "warnLog";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLineString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerBase";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompilerInstance";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutable";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "matchSafely";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCompilerInstance";
                break;
            }
            case 6: 
            case 13: 
            case 24: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "resolveLanguage";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "doReadVersion";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "checkCompilerOutput";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "throwCompilerTimeout";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "throwCompilerError";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "collectOptionsToSkip";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addEmulatedWarning";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "logCompilerOutput";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 13, 24 -> new IllegalStateException(string);
        };
    }

    public static class CompilerRunner {
        @NotNull
        public ProcessOutput run(@NotNull GeneralCommandLine cl, @NotNull CidrToolEnvironment env) throws ExecutionException {
            ProgressIndicator indicator;
            if (cl == null) {
                CompilerRunner.$$$reportNull$$$0(0);
            }
            if (env == null) {
                CompilerRunner.$$$reportNull$$$0(1);
            }
            if ((indicator = ProgressManager.getInstance().getProgressIndicator()) == null) {
                indicator = new EmptyProgressIndicator();
            }
            ProcessOutput output = env.getHostMachine().runProcess(cl, indicator, CompilerRunner.getTimeout());
            ProgressManager.checkCanceled();
            ProcessOutput processOutput = output;
            if (processOutput == null) {
                CompilerRunner.$$$reportNull$$$0(2);
            }
            return processOutput;
        }

        private static int getTimeout() {
            return AdvancedSettings.getInt((String)"cidr.workspace.compiler.timeout") * 1000;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cl";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "env";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerBase$CompilerRunner";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerBase$CompilerRunner";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "run";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "run";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

