/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.compiler;

import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.cidr.lang.workspace.compiler.Command;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerBase;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u0012\u000b\u0010\u0007\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u000e\u0010\u0010\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006H\u00c6\u0003J\u000e\u0010\u0011\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006H\u00c6\u0003J1\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\r\b\u0002\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00062\r\b\u0002\u0010\u0007\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u0007\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\r\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/cidr/lang/workspace/compiler/GCCCompilerFeature;", "", "command", "Lcom/jetbrains/cidr/lang/workspace/compiler/Command;", "key", "", "Lorg/jetbrains/annotations/NonNls;", "value", "<init>", "(Lcom/jetbrains/cidr/lang/workspace/compiler/Command;Ljava/lang/String;Ljava/lang/String;)V", "getCommand", "()Lcom/jetbrains/cidr/lang/workspace/compiler/Command;", "getKey", "()Ljava/lang/String;", "getValue", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "Parser", "intellij.cidr.projectModel"})
@SourceDebugExtension(value={"SMAP\nGCCCompilerFeature.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GCCCompilerFeature.kt\ncom/jetbrains/cidr/lang/workspace/compiler/GCCCompilerFeature\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,73:1\n13#2:74\n*S KotlinDebug\n*F\n+ 1 GCCCompilerFeature.kt\ncom/jetbrains/cidr/lang/workspace/compiler/GCCCompilerFeature\n*L\n17#1:74\n*E\n"})
public final class GCCCompilerFeature {
    @NotNull
    public static final Parser Parser = new Parser(null);
    @NotNull
    private final Command command;
    @NotNull
    private final String key;
    @NotNull
    private final String value;
    @NotNull
    private static final Logger LOGGER;
    @Language(value="RegExp")
    @NonNls
    @NotNull
    private static final String COMMAND = "(?<command>\\w+?)";
    @Language(value="RegExp")
    @NonNls
    @NotNull
    private static final String KEY = "(?<key>[^=]+?)";
    @Language(value="RegExp")
    @NonNls
    @NotNull
    private static final String VALUE = "(?<value>.+?)";
    @NotNull
    private static final Regex COMMAND_PATTERN;

    public GCCCompilerFeature(@NotNull Command command, @NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)((Object)command), (String)"command");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.command = command;
        this.key = key;
        this.value = value;
    }

    @NotNull
    public final Command getCommand() {
        return this.command;
    }

    @NotNull
    public final String getKey() {
        return this.key;
    }

    @NotNull
    public final String getValue() {
        return this.value;
    }

    @NotNull
    public final Command component1() {
        return this.command;
    }

    @NotNull
    public final String component2() {
        return this.key;
    }

    @NotNull
    public final String component3() {
        return this.value;
    }

    @NotNull
    public final GCCCompilerFeature copy(@NotNull Command command, @NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)((Object)command), (String)"command");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return new GCCCompilerFeature(command, key, value);
    }

    public static /* synthetic */ GCCCompilerFeature copy$default(GCCCompilerFeature gCCCompilerFeature, Command command, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            command = gCCCompilerFeature.command;
        }
        if ((n & 2) != 0) {
            string = gCCCompilerFeature.key;
        }
        if ((n & 4) != 0) {
            string2 = gCCCompilerFeature.value;
        }
        return gCCCompilerFeature.copy(command, string, string2);
    }

    @NotNull
    public String toString() {
        return "GCCCompilerFeature(command=" + this.command + ", key=" + this.key + ", value=" + this.value + ")";
    }

    public int hashCode() {
        int result = this.command.hashCode();
        result = result * 31 + this.key.hashCode();
        result = result * 31 + this.value.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GCCCompilerFeature)) {
            return false;
        }
        GCCCompilerFeature gCCCompilerFeature = (GCCCompilerFeature)other;
        if (this.command != gCCCompilerFeature.command) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.key, (Object)gCCCompilerFeature.key)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.value, (Object)gCCCompilerFeature.value);
    }

    @JvmStatic
    @Nullable
    public static final GCCCompilerFeature parse(@NotNull String line) {
        return Parser.parse(line);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(OCCompilerBase.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOGGER = logger;
        COMMAND_PATTERN = new Regex("^\\h*\\{\\h*int\\h+(?:__attribute__\\h*\\(\\h*\\(\\h*unused\\h*\\)\\h*\\))?\\h*\\Q____CIDR_command_\\E(?<command>\\w+?)\\h*,\\h*\\Q____CIDR_command_\\E(?<key>[^=]+?)\\h*=\\h*\\(\\h*(?:\\(\\h*void\\h*\\))?\\h*(?<value>.+?)\\h*,\\h*0\\h*\\)\\h*;\\h*}\\h*$");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\r\u001a\u0004\u0018\u00010\u000e2\u000b\u0010\u000f\u001a\u00070\u0007\u00a2\u0006\u0002\b\u0010H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0002X\u0083T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00078\u0002X\u0083T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00078\u0002X\u0083T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\f\u0010\u0003\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/cidr/lang/workspace/compiler/GCCCompilerFeature$Parser;", "", "<init>", "()V", "LOGGER", "Lcom/intellij/openapi/diagnostic/Logger;", "COMMAND", "", "KEY", "VALUE", "COMMAND_PATTERN", "Lkotlin/text/Regex;", "getCOMMAND_PATTERN$annotations", "parse", "Lcom/jetbrains/cidr/lang/workspace/compiler/GCCCompilerFeature;", "line", "Lorg/jetbrains/annotations/NonNls;", "intellij.cidr.projectModel"})
    public static final class Parser {
        private Parser() {
        }

        private static /* synthetic */ void getCOMMAND_PATTERN$annotations() {
        }

        @JvmStatic
        @Nullable
        public final GCCCompilerFeature parse(@NotNull String line) {
            Command command;
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            MatchResult matchResult = COMMAND_PATTERN.matchEntire((CharSequence)line);
            if (matchResult == null || (matchResult = matchResult.getDestructured()) == null) {
                return null;
            }
            MatchResult matchResult2 = matchResult;
            String rawCommand = (String)matchResult2.getMatch().getGroupValues().get(1);
            String key = (String)matchResult2.getMatch().getGroupValues().get(2);
            String value = (String)matchResult2.getMatch().getGroupValues().get(3);
            try {
                command = Command.valueOf(rawCommand);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LOGGER.error("Unexpected command: " + rawCommand + " (matched line: " + line + ")");
                return null;
            }
            Command command2 = command;
            return new GCCCompilerFeature(command2, key, value);
        }

        public /* synthetic */ Parser(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

