/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.compiler;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.system.OS;
import com.jetbrains.cidr.EscapeUtil;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageStandard;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.lang.workspace.compiler.CidrProjectModelBundle;
import com.jetbrains.cidr.lang.workspace.compiler.Command;
import com.jetbrains.cidr.lang.workspace.compiler.CompilerInfo;
import com.jetbrains.cidr.lang.workspace.compiler.CompilerSpecificSwitchBuilder;
import com.jetbrains.cidr.lang.workspace.compiler.GCCCompilerFeature;
import com.jetbrains.cidr.lang.workspace.compiler.GCCCompilerInfoQueryBuilder;
import com.jetbrains.cidr.lang.workspace.compiler.GCCCompilerKt;
import com.jetbrains.cidr.lang.workspace.compiler.GCCCompilerOutputSections;
import com.jetbrains.cidr.lang.workspace.compiler.GCCCompilerUtilsKt;
import com.jetbrains.cidr.lang.workspace.compiler.GCCOptionsFilter;
import com.jetbrains.cidr.lang.workspace.compiler.GCCPatterns;
import com.jetbrains.cidr.lang.workspace.compiler.GCCResponseFileShortener;
import com.jetbrains.cidr.lang.workspace.compiler.GCCSwitchBuilder;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerBase;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerCommandLineShortener;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import com.jetbrains.cidr.lang.workspace.compiler.OCOptionsFilter;
import com.jetbrains.cidr.lang.workspace.compiler.OCResponseFileShortener;
import com.jetbrains.cidr.lang.workspace.compiler.TempFilesPool;
import com.jetbrains.cidr.lang.workspace.compiler.modules.CXXModule;
import com.jetbrains.cidr.lang.workspace.compiler.modules.JSONKt;
import com.jetbrains.cidr.lang.workspace.compiler.modules.LibCXXModuleSchema;
import com.jetbrains.cidr.lang.workspace.compiler.modules.LocalArguments;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchPath;
import com.jetbrains.cidr.lang.workspace.moduleRoots.ModuleSearchPath;
import com.jetbrains.cidr.system.HostMachine;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\b\u0016\u0018\u0000 K2\u00020\u0001:\u0001KB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eJ\b\u0010\u000f\u001a\u00020\u0010H\u0014J\b\u0010\u0011\u001a\u00020\u0012H\u0014J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J2\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00030\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\f0\u001a2\u0006\u0010\u001c\u001a\u00020\f2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\f0\u001eH\u0002J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00030\u001a2\u0006\u0010 \u001a\u00020\u0003H\u0002J-\u0010!\u001a\u0004\u0018\u00010\u00032\u000b\u0010\u001c\u001a\u00070\f\u00a2\u0006\u0002\b\"2\u0006\u0010 \u001a\u00020\u00032\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\f0\u001eH\u0002J\u0010\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\fH\u0002J\u001b\u0010%\u001a\u00070\f\u00a2\u0006\u0002\b\"2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\f0\u001aH\u0002J0\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00062\u0006\u0010*\u001a\u00020\u00182\u0006\u0010+\u001a\u00020\f2\u000e\u0010\u001d\u001a\n\u0012\u0006\b\u0000\u0012\u00020\f0\u001eH\u0017J(\u0010'\u001a\u00020(2\u0006\u0010*\u001a\u00020\u00182\u0006\u0010+\u001a\u00020\f2\u000e\u0010\u001d\u001a\n\u0012\u0006\b\u0000\u0012\u00020\f0\u001eH\u0016J\b\u0010,\u001a\u00020-H\u0014JN\u0010.\u001a\u00020(2\u0006\u0010*\u001a\u00020\u00182\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\f002\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u0002022\u0006\u00104\u001a\u0002052\u0006\u0010+\u001a\u00020\f2\u000e\u0010\u001d\u001a\n\u0012\u0006\b\u0000\u0012\u00020\f0\u001eH\u0002J&\u00106\u001a\b\u0012\u0004\u0012\u0002070\u001a2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u00108\u001a\u000205H\u0002J\u0018\u00109\u001a\u0002052\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=H\u0002J\u0016\u0010>\u001a\u00020?2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\f0@H\u0016J\u001a\u0010A\u001a\u00070\f\u00a2\u0006\u0002\b\"2\u000b\u0010B\u001a\u00070\f\u00a2\u0006\u0002\b\"H\u0014J\u001d\u0010C\u001a\u00070\f\u00a2\u0006\u0002\b\"2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\fH\u0002J=\u0010D\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0E0\u001a*\b\u0012\u0004\u0012\u00020\f0\u001a2\u0012\u0010F\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0G\"\u00020\fH\u0002\u00a2\u0006\u0002\u0010HJ,\u0010I\u001a\b\u0012\u0004\u0012\u00020\f0\u001a2\f\u0010J\u001a\b\u0012\u0004\u0012\u00020\f0\u001a2\u0006\u0010)\u001a\u00020\u00062\u0006\u0010\u0004\u001a\u00020\u0003H\u0002\u00a8\u0006L"}, d2={"Lcom/jetbrains/cidr/lang/workspace/compiler/GCCCompiler;", "Lcom/jetbrains/cidr/lang/workspace/compiler/OCCompilerBase;", "executable", "Ljava/io/File;", "workingDirectory", "env", "Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;", "tempFilesPool", "Lcom/jetbrains/cidr/lang/workspace/compiler/TempFilesPool;", "<init>", "(Ljava/io/File;Ljava/io/File;Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;Lcom/jetbrains/cidr/lang/workspace/compiler/TempFilesPool;)V", "readVersion", "", "versionPattern", "Ljava/util/regex/Pattern;", "getSwitchBuilder", "Lcom/jetbrains/cidr/lang/workspace/compiler/CompilerSpecificSwitchBuilder;", "getCompilerSwitchesFormat", "Lcom/jetbrains/cidr/lang/toolchains/CidrCompilerSwitches$Format;", "collectInfo", "Lcom/jetbrains/cidr/lang/workspace/compiler/CompilerInfo;", "languageKind", "Lcom/jetbrains/cidr/lang/OCLanguageKind;", "originalSwitches", "Lcom/jetbrains/cidr/lang/toolchains/CidrCompilerSwitches;", "getForcedHeaders", "", "switches", "preprocessed", "warnLog", "", "tryExtractOriginalPrecompiledHeadersFromCMakeGeneratedFile", "pch", "extractOriginalPrecompiledHeaderFile", "Lorg/jetbrains/annotations/NonNls;", "unescapeAndPreparePath", "path", "buildFeaturesCheckText", "switchesList", "runGCC", "Lcom/intellij/execution/process/ProcessOutput;", "environment", "options", "fileText", "getCommandLineShortener", "Lcom/jetbrains/cidr/lang/workspace/compiler/OCCompilerCommandLineShortener;", "tryRunGCC", "skipOptions", "", "optionsRetriesNumber", "", "timeoutsNumber", "skipResponseFile", "", "collectModuleSearchPaths", "Lcom/jetbrains/cidr/lang/workspace/moduleRoots/ModuleSearchPath;", "isClang", "checkIncludeDirsInBaseDir", "module", "Lcom/jetbrains/cidr/lang/workspace/compiler/modules/CXXModule;", "hostBaseDir", "Ljava/nio/file/Path;", "createOptionsFilter", "Lcom/jetbrains/cidr/lang/workspace/compiler/OCOptionsFilter;", "", "adjustArgument", "arg", "preparePath", "flagValuesIntroducedBy", "Lkotlin/Pair;", "flagStarters", "", "(Ljava/util/List;[Ljava/lang/String;)Ljava/util/List;", "extractNonBuiltinSearchPaths", "rawSwitches", "Companion", "intellij.cidr.projectModel"})
@SourceDebugExtension(value={"SMAP\nGCCCompiler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GCCCompiler.kt\ncom/jetbrains/cidr/lang/workspace/compiler/GCCCompiler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 Json.kt\nkotlinx/serialization/json/Json\n+ 7 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,972:1\n774#2:973\n865#2,2:974\n1563#2:976\n1634#2,3:977\n1761#2,3:984\n1563#2:988\n1634#2,3:989\n1563#2:992\n1634#2,3:993\n1617#2,9:996\n1869#2:1005\n1870#2:1009\n1626#2:1010\n1563#2:1011\n1634#2,3:1012\n183#3,2:980\n18#4:982\n1#5:983\n1#5:1008\n222#6:987\n12970#7,2:1006\n*S KotlinDebug\n*F\n+ 1 GCCCompiler.kt\ncom/jetbrains/cidr/lang/workspace/compiler/GCCCompiler\n*L\n400#1:973\n400#1:974,2\n412#1:976\n412#1:977,3\n555#1:984,3\n753#1:988\n753#1:989,3\n766#1:992\n766#1:993,3\n799#1:996,9\n799#1:1005\n799#1:1009\n799#1:1010\n828#1:1011\n828#1:1012,3\n500#1:980,2\n514#1:982\n799#1:1008\n731#1:987\n801#1:1006,2\n*E\n"})
public class GCCCompiler
extends OCCompilerBase {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public GCCCompiler(@NotNull File executable, @NotNull File workingDirectory, @NotNull CidrToolEnvironment env, @NotNull TempFilesPool tempFilesPool) {
        Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        Intrinsics.checkNotNullParameter((Object)tempFilesPool, (String)"tempFilesPool");
        super(executable, workingDirectory, env, tempFilesPool);
    }

    @Nullable
    public final String readVersion(@NotNull Pattern versionPattern) {
        Intrinsics.checkNotNullParameter((Object)versionPattern, (String)"versionPattern");
        return this.doReadVersion(CollectionsKt.listOf((Object)"--version"), (Function<? super ProcessOutput, String>)((Function)arg_0 -> GCCCompiler.readVersion$lambda$1(arg_0 -> GCCCompiler.readVersion$lambda$0(versionPattern, arg_0), arg_0)));
    }

    @NotNull
    protected CompilerSpecificSwitchBuilder getSwitchBuilder() {
        return new GCCSwitchBuilder(null, 1, null);
    }

    @NotNull
    protected CidrCompilerSwitches.Format getCompilerSwitchesFormat() {
        return CidrCompilerSwitches.Format.GCC_RESPONSE_FILE;
    }

    @Override
    @NotNull
    public CompilerInfo collectInfo(@NotNull OCLanguageKind languageKind, @NotNull CidrCompilerSwitches originalSwitches) throws ExecutionException {
        CidrCompilerSwitches cidrCompilerSwitches;
        Intrinsics.checkNotNullParameter((Object)languageKind, (String)"languageKind");
        Intrinsics.checkNotNullParameter((Object)originalSwitches, (String)"originalSwitches");
        List warnLog = new ArrayList();
        try {
            cidrCompilerSwitches = originalSwitches.expandResponseFiles(this.myWorkingDirectory, this.myEnvironment, this.getCompilerSwitchesFormat());
        }
        catch (IOException e) {
            String string = originalSwitches.getCommandLineString(this.getCompilerSwitchesFormat());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCommandLineString(...)");
            String commandLineStr = string;
            Object[] objectArray = new Object[]{commandLineStr};
            throw new ExecutionException(CidrProjectModelBundle.message("cannot.expand.response.files.error.message", objectArray), (Throwable)e);
        }
        CidrCompilerSwitches cidrCompilerSwitches2 = cidrCompilerSwitches;
        Intrinsics.checkNotNull((Object)cidrCompilerSwitches2);
        CidrCompilerSwitches switches = cidrCompilerSwitches2;
        List<String> list = switches.getList(CidrCompilerSwitches.Format.RAW);
        Intrinsics.checkNotNullExpressionValue(list, (String)"getList(...)");
        List<String> switchesAsList = list;
        CidrToolEnvironment cidrToolEnvironment = this.myEnvironment;
        Intrinsics.checkNotNullExpressionValue((Object)cidrToolEnvironment, (String)"myEnvironment");
        File file = this.myWorkingDirectory;
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"myWorkingDirectory");
        List<String> nonBuiltinSearchPaths = this.extractNonBuiltinSearchPaths(switchesAsList, cidrToolEnvironment, file);
        CompilerSpecificSwitchBuilder switchBuilder = this.getSwitchBuilder().withLanguageKind(languageKind).withSwitches(switches);
        if (Registry.Companion.is("cidr.compiler.gcc.fpch.preprocess", true)) {
            switchBuilder.withWritePchPreprocess();
        }
        switchBuilder.withSwitch("-v").withWritePreprocessorDefines().withSwitch("-E").withMacro("___CIDR_DEFINITIONS_END");
        String featureChecksText = this.buildFeaturesCheckText(switchesAsList);
        CidrCompilerSwitches requestSwitches = switchBuilder.build();
        ProcessOutput output = this.runGCC(requestSwitches, featureChecksText, warnLog);
        String string = output.getStdout();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStdout(...)");
        GCCCompilerOutputSections sections = Companion.splitOutput(string, warnLog);
        Pair<List<String>, Map<OCCompilerFeatures.Type<?>, Object>> pair = Companion.collectDefinitionsAndFeatures(sections, warnLog, languageKind);
        List defines = (List)pair.component1();
        Map features = (Map)pair.component2();
        boolean isClang = GCCCompilerKt.access$isClang(defines);
        Set switchesAsSet = CollectionsKt.toSet((Iterable)switchesAsList);
        GCCCompilerKt.access$collectDiagnostics(switchesAsSet, isClang, features);
        GCCCompilerKt.access$collectFeatureFlags(switchesAsSet, features);
        if (!features.containsKey(OCCompilerFeatures.Feature.CXX_ALTERNATIVE_OPERATORS)) {
            features.put(OCCompilerFeatures.Feature.CXX_ALTERNATIVE_OPERATORS, GCCCompilerKt.access$isCpp(defines));
        }
        boolean shouldEnableFrameworksWorkaround = this.myEnvironment.getHostMachine().getOS() == OS.macOS && !isClang;
        CidrToolEnvironment cidrToolEnvironment2 = this.myEnvironment;
        Intrinsics.checkNotNullExpressionValue((Object)cidrToolEnvironment2, (String)"myEnvironment");
        File file2 = this.myWorkingDirectory;
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"myWorkingDirectory");
        List<HeadersSearchPath> headersSearchPaths = Companion.collectHeaderSearchPaths(output, shouldEnableFrameworksWorkaround, cidrToolEnvironment2, file2, true, nonBuiltinSearchPaths, isClang);
        List<File> forcedHeaders = this.getForcedHeaders(switchesAsList, sections.getPreprocessed(), warnLog);
        OCCompilerBase.addEmulatedWarning(warnLog);
        CidrToolEnvironment cidrToolEnvironment3 = this.myEnvironment;
        Intrinsics.checkNotNullExpressionValue((Object)cidrToolEnvironment3, (String)"myEnvironment");
        List<ModuleSearchPath> moduleSearchPaths = this.collectModuleSearchPaths(cidrToolEnvironment3, languageKind, isClang);
        return new CompilerInfo(switches, defines, features, headersSearchPaths, forcedHeaders, CollectionsKt.emptyList(), warnLog, output.getExitCode(), moduleSearchPaths);
    }

    /*
     * WARNING - void declaration
     */
    private final List<File> getForcedHeaders(List<String> switches, String preprocessed, List<String> warnLog) {
        void $this$mapTo$iv$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = switches;
        boolean $i$f$filter22 = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo22 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it, (Object)"-Xclang"))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List args = (List)destination$iv$iv;
        String[] $i$f$filter22 = new String[]{"--include=", "--imacros=", "-include", "--include", "-imacros", "--imacros", "-FI"};
        List<Pair<String, String>> interestingFlags = this.flagValuesIntroducedBy(args, $i$f$filter22);
        Iterable $this$map$iv = interestingFlags;
        boolean $i$f$map = false;
        Iterable $i$f$filterTo22 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            CidrToolEnvironment cidrToolEnvironment = this.myEnvironment;
            Intrinsics.checkNotNullExpressionValue((Object)cidrToolEnvironment, (String)"myEnvironment");
            collection.add(this.preparePath(cidrToolEnvironment, this.adjustArgument((String)it.getSecond())));
        }
        List pchPaths = (List)destination$iv$iv2;
        boolean isFirst = true;
        Set result = new LinkedHashSet();
        for (String path : pchPaths) {
            File adjustedPCH;
            List<File> headers;
            File foundPath = new File(path);
            if (foundPath.exists() && !((Collection)(headers = this.tryExtractOriginalPrecompiledHeadersFromCMakeGeneratedFile(foundPath))).isEmpty()) {
                result.add(foundPath);
                result.addAll((Collection)headers);
                continue;
            }
            File file = !foundPath.exists() || foundPath.isDirectory() ? (isFirst ? this.extractOriginalPrecompiledHeaderFile(preprocessed, foundPath, warnLog) : null) : (adjustedPCH = foundPath);
            if (adjustedPCH != null) {
                result.add(adjustedPCH);
            }
            isFirst = false;
        }
        return (List)new SmartList((Collection)result);
    }

    private final List<File> tryExtractOriginalPrecompiledHeadersFromCMakeGeneratedFile(File pch) {
        try {
            String string = FileUtil.loadFile((File)pch);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"loadFile(...)");
            String text = string;
            if (!StringsKt.contains$default((CharSequence)text, (CharSequence)"generated by CMake", (boolean)false, (int)2, null)) {
                return CollectionsKt.emptyList();
            }
            Matcher matcher = OCCompilerBase.matchSafely(GCCPatterns.INSTANCE.getINCLUDE_HEADER_PATTERN(), text);
            Intrinsics.checkNotNullExpressionValue((Object)matcher, (String)"matchSafely(...)");
            Matcher matcher2 = matcher;
            Stream<MatchResult> stream = matcher2.results();
            Intrinsics.checkNotNullExpressionValue(stream, (String)"results(...)");
            return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)StreamsKt.asSequence(stream), arg_0 -> GCCCompiler.tryExtractOriginalPrecompiledHeadersFromCMakeGeneratedFile$lambda$0(this, arg_0)));
        }
        catch (IOException e) {
            OCCompilerBase.LOG.debug((Throwable)e);
            return CollectionsKt.emptyList();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final File extractOriginalPrecompiledHeaderFile(String preprocessed, File pch, List<String> warnLog) {
        File dependencyFile;
        Object[] objectArray;
        boolean isGCC;
        block15: {
            isGCC = StringsKt.contains$default((CharSequence)preprocessed, (CharSequence)"#pragma GCC pch_preprocess", (boolean)false, (int)2, null);
            if (!isGCC) {
                Matcher matcher = OCCompilerBase.matchSafely(GCCPatterns.INSTANCE.getINCLUDE_FILE_PATTERN(), preprocessed);
                Intrinsics.checkNotNullExpressionValue((Object)matcher, (String)"matchSafely(...)");
                Matcher includeFileMatcher = matcher;
                if (includeFileMatcher.find()) {
                    String string = includeFileMatcher.group(1);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
                    return this.unescapeAndPreparePath(string);
                }
                Matcher matcher2 = OCCompilerBase.matchSafely(GCCPatterns.INSTANCE.getINCLUDE_FILE_FROM_SYSROOT_PATTERN(), preprocessed);
                Intrinsics.checkNotNullExpressionValue((Object)matcher2, (String)"matchSafely(...)");
                Matcher includeFileFromSysrootMatcher = matcher2;
                if (includeFileFromSysrootMatcher.find()) {
                    Object v6;
                    block14: {
                        void $this$firstOrNull$iv;
                        String fileName = pch.getName();
                        Stream<MatchResult> stream = includeFileFromSysrootMatcher.results();
                        Intrinsics.checkNotNullExpressionValue(stream, (String)"results(...)");
                        objectArray = SequencesKt.map((Sequence)StreamsKt.asSequence(stream), arg_0 -> GCCCompiler.extractOriginalPrecompiledHeaderFile$lambda$0(this, arg_0));
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            File it = (File)element$iv;
                            boolean bl = false;
                            String string = it.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                            CharSequence charSequence = string;
                            Intrinsics.checkNotNull((Object)fileName);
                            if (!StringsKt.contains$default((CharSequence)charSequence, (CharSequence)fileName, (boolean)false, (int)2, null)) continue;
                            v6 = element$iv;
                            break block14;
                        }
                        v6 = null;
                    }
                    File firstMatch = v6;
                    if (firstMatch != null) {
                        return firstMatch;
                    }
                }
            }
            if (!pch.isDirectory()) {
                v7 = new File(pch.getAbsolutePath() + ".d");
            } else {
                File[] $this$orEmpty$iv = pch.listFiles();
                boolean $i$f$orEmpty22 = false;
                File[] fileArray = $this$orEmpty$iv;
                if ($this$orEmpty$iv == null) {
                    fileArray = new File[]{};
                }
                File[] $i$f$orEmpty22 = fileArray;
                int $this$firstOrNull$iv = $i$f$orEmpty22.length;
                for (int firstMatch = 0; firstMatch < $this$firstOrNull$iv; ++firstMatch) {
                    File file;
                    File it = file = $i$f$orEmpty22[firstMatch];
                    boolean bl = false;
                    String string = it.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    if (!StringsKt.endsWith$default((String)string, (String)".d", (boolean)false, (int)2, null)) continue;
                    v7 = file;
                    break block15;
                }
                v7 = dependencyFile = null;
            }
        }
        if (dependencyFile != null && dependencyFile.exists()) {
            try {
                String string = FileUtil.loadFile((File)dependencyFile);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"loadFile(...)");
                String data = string;
                Matcher matcher = OCCompilerBase.matchSafely(GCCPatterns.INSTANCE.getDEPENDENCY_PATTERN(), data);
                Intrinsics.checkNotNullExpressionValue((Object)matcher, (String)"matchSafely(...)");
                Matcher dependency = matcher;
                if (dependency.find()) {
                    String string2 = dependency.group(1);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"group(...)");
                    String path = StringsKt.replace$default((String)string2, (String)"\\ ", (String)" ", (boolean)false, (int)4, null);
                    CidrToolEnvironment cidrToolEnvironment = this.myEnvironment;
                    Intrinsics.checkNotNullExpressionValue((Object)cidrToolEnvironment, (String)"myEnvironment");
                    File result = new File(this.preparePath(cidrToolEnvironment, path));
                    return result.exists() ? result : null;
                }
            }
            catch (IOException iOException) {
                objectArray = new Object[]{dependencyFile};
                String string = CidrProjectModelBundle.message("dependency.file.corrupted.error.message", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                String warn = string;
                warnLog.add(warn);
                return null;
            }
        }
        if (isGCC) {
            Object[] objectArray2 = new Object[]{pch};
            String string = CidrProjectModelBundle.message("cannot.get.the.original.file.name.of.the.precompiled.header", objectArray2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String warn = string;
            warnLog.add(warn);
        }
        return null;
    }

    private final File unescapeAndPreparePath(String path) {
        String string = EscapeUtil.unescapeAnsiStringCharacters((String)path);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"unescapeAnsiStringCharacters(...)");
        String unescaped = string;
        CidrToolEnvironment cidrToolEnvironment = this.myEnvironment;
        Intrinsics.checkNotNullExpressionValue((Object)cidrToolEnvironment, (String)"myEnvironment");
        String preparedPath = this.preparePath(cidrToolEnvironment, unescaped);
        return new File(preparedPath);
    }

    private final String buildFeaturesCheckText(List<String> switchesList) {
        boolean bl;
        StringBuilder $this$buildFeaturesCheckText_u24lambda_u240;
        StringBuilder stringBuilder;
        block3: {
            $this$buildFeaturesCheckText_u24lambda_u240 = stringBuilder = new StringBuilder();
            boolean bl2 = false;
            $this$buildFeaturesCheckText_u24lambda_u240.append("void ____CIDR_command() {").append('\n');
            $this$buildFeaturesCheckText_u24lambda_u240.append("#define ___CIDR_FEATURES_START").append('\n');
            Iterable $this$any$iv = switchesList;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl3 = false;
                    if (!StringsKt.startsWith$default((String)it, (String)"-D__FILE_NAME__=", (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        boolean hasFileName = bl;
        new GCCCompilerInfoQueryBuilder($this$buildFeaturesCheckText_u24lambda_u240).appendCompilerInfoQueries(!hasFileName);
        $this$buildFeaturesCheckText_u24lambda_u240.append("} /* ____CIDR_command() */").append('\n');
        return stringBuilder.toString();
    }

    @Deprecated(message="Use {@link GCCCompiler.runGCC(CidrCompilerSwitches, String, MutableList<in String>)} instead", replaceWith=@ReplaceWith(expression="runGCC(options, fileText, warnLog)", imports={}))
    @ApiStatus.ScheduledForRemoval
    @NotNull
    public ProcessOutput runGCC(@NotNull CidrToolEnvironment environment, @NotNull CidrCompilerSwitches options, @NotNull String fileText, @NotNull List<? super String> warnLog) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)fileText, (String)"fileText");
        Intrinsics.checkNotNullParameter(warnLog, (String)"warnLog");
        return this.runGCC(options, fileText, warnLog);
    }

    @NotNull
    public ProcessOutput runGCC(@NotNull CidrCompilerSwitches options, @NotNull String fileText, @NotNull List<? super String> warnLog) throws ExecutionException {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)fileText, (String)"fileText");
        Intrinsics.checkNotNullParameter(warnLog, (String)"warnLog");
        Object[] objectArray = new String[]{"-fdiagnostics-format", "-imacros", "-"};
        Set skipOptions = SetsKt.mutableSetOf((Object[])objectArray);
        return this.tryRunGCC(options, skipOptions, 0, 0, false, fileText, warnLog);
    }

    @NotNull
    protected OCCompilerCommandLineShortener getCommandLineShortener() {
        return new GCCResponseFileShortener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ProcessOutput tryRunGCC(CidrCompilerSwitches options, Set<String> skipOptions, int optionsRetriesNumber, int timeoutsNumber, boolean skipResponseFile, String fileText, List<? super String> warnLog) throws ExecutionException {
        ProcessOutput processOutput;
        CidrCompilerSwitches filteredOptions = this.filterOptions(options, skipOptions);
        Path responseFile = null;
        Path bodyFile = null;
        String gccPath = this.myExecutable.getPath();
        HostMachine host = this.myEnvironment.getHostMachine();
        Path path = host.getTempDirectory();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getTempDirectory(...)");
        Path tmpDir = path;
        String clCommandLineString = null;
        String userFriendlySwitches = null;
        try {
            try {
                bodyFile = this.myTempFilesPool.writeToTempFile(host, fileText, tmpDir, "compiler-file", "");
            }
            catch (IOException e) {
                throw new ExecutionException(CidrProjectModelBundle.message("unable.to.create.temporary.file", new Object[0]), (Throwable)e);
            }
            String[] stringArray = new String[]{gccPath};
            GeneralCommandLine cl = new GeneralCommandLine(stringArray);
            this.myEnvironment.prepare(cl, CidrToolEnvironment.PrepareFor.BUILD);
            cl.withWorkingDirectory(this.myWorkingDirectory.toPath());
            Map map = cl.getEnvironment();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getEnvironment(...)");
            Map clEnvironment = map;
            clEnvironment.put("LC_ALL", "C");
            clEnvironment.keySet().removeAll(GCCCompilerKt.access$getSkipEnvironment$p());
            cl.addParameters(filteredOptions.getList(CidrCompilerSwitches.Format.RAW));
            String string = cl.getParametersList().getParametersString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getParametersString(...)");
            String string2 = Matcher.quoteReplacement(" -D___CIDR_DEFINITIONS_END");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"quoteReplacement(...)");
            userFriendlySwitches = StringsKt.replaceFirst$default((String)string, (String)string2, (String)"", (boolean)false, (int)4, null);
            if (!skipResponseFile) {
                OCCompilerCommandLineShortener oCCompilerCommandLineShortener = this.getCommandLineShortener();
                CidrToolEnvironment cidrToolEnvironment = this.myEnvironment;
                Intrinsics.checkNotNullExpressionValue((Object)cidrToolEnvironment, (String)"myEnvironment");
                TempFilesPool tempFilesPool = this.myTempFilesPool;
                Intrinsics.checkNotNullExpressionValue((Object)tempFilesPool, (String)"myTempFilesPool");
                cl = oCCompilerCommandLineShortener.shorten(cl, cidrToolEnvironment, tempFilesPool);
                responseFile = OCResponseFileShortener.Companion.getResponseFile((UserDataHolder)cl);
            }
            String[] stringArray2 = new String[]{this.myEnvironment.toEnvPath(((Object)bodyFile.toAbsolutePath()).toString())};
            cl.addParameters(stringArray2);
            String string3 = cl.getCommandLineString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getCommandLineString(...)");
            clCommandLineString = string3;
            if (OCCompilerBase.LOG.isDebugEnabled()) {
                OCCompilerBase.LOG.debug("Running compiler: " + clCommandLineString + "\nArguments file contents: " + filteredOptions);
            }
            processOutput = OCCompilerBase.outCompilerRunner.run(cl, this.myEnvironment);
            if (bodyFile != null) {
                this.myTempFilesPool.delete(bodyFile);
            }
            if (responseFile != null) {
                this.myTempFilesPool.delete(responseFile);
            }
        }
        catch (Throwable throwable) {
            if (bodyFile != null) {
                this.myTempFilesPool.delete(bodyFile);
            }
            if (responseFile != null) {
                this.myTempFilesPool.delete(responseFile);
            }
            throw throwable;
        }
        ProcessOutput processOutput2 = processOutput;
        Intrinsics.checkNotNull((Object)processOutput2);
        ProcessOutput output = processOutput2;
        this.logCompilerOutput(clCommandLineString, output);
        String userFriendlyCommandLine = gccPath + " " + userFriendlySwitches;
        if (output.isTimeout()) {
            if (timeoutsNumber < 1) {
                OCCompilerBase.LOG.debug("Trying to run compiler after timeout");
                return this.tryRunGCC(options, skipOptions, optionsRetriesNumber, timeoutsNumber + 1, skipResponseFile, fileText, warnLog);
            }
            ExecutionException executionException = OCCompilerBase.throwCompilerTimeout(userFriendlyCommandLine);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)executionException), (String)"throwCompilerTimeout(...)");
            throw (Throwable)executionException;
        }
        if (output.getExitCode() != 0) {
            if (!skipResponseFile && responseFile != null) {
                String string = output.getStderr();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStderr(...)");
                if (StringsKt.contains$default((CharSequence)string, (CharSequence)("@" + this.myEnvironment.toEnvPath(((Object)responseFile).toString())), (boolean)false, (int)2, null)) {
                    OCCompilerBase.LOG.debug("Trying to run compiler without a @response file");
                    return this.tryRunGCC(options, skipOptions, optionsRetriesNumber, timeoutsNumber, true, fileText, warnLog);
                }
            }
            if (optionsRetriesNumber < 2) {
                List list = output.getStderrLines();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getStderrLines(...)");
                if (Companion.collectSkipOptionsGcc(list, skipOptions, warnLog)) {
                    if (OCCompilerBase.LOG.isDebugEnabled()) {
                        OCCompilerBase.LOG.debug("Trying to run compiler with skipped options: " + CollectionsKt.joinToString$default((Iterable)skipOptions, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
                    }
                    return this.tryRunGCC(options, skipOptions, optionsRetriesNumber + 1, timeoutsNumber, skipResponseFile, fileText, warnLog);
                }
            }
            if (!GCCCompilerKt.access$allowResultsWithError(output)) {
                ExecutionException executionException = OCCompilerBase.throwCompilerError(output, userFriendlyCommandLine);
                Intrinsics.checkNotNullExpressionValue((Object)((Object)executionException), (String)"throwCompilerError(...)");
                throw (Throwable)executionException;
            }
        }
        return output;
    }

    /*
     * Unable to fully structure code
     */
    private final List<ModuleSearchPath> collectModuleSearchPaths(CidrToolEnvironment env, OCLanguageKind languageKind, boolean isClang) {
        if (!(languageKind.isCpp() && isClang && Registry.Companion.is("cidr.compiler.info.std.modules.search"))) {
            return CollectionsKt.emptyList();
        }
        var5_4 = Registry.Companion.stringValue("cidr.compiler.info.std.modules.json.path");
        if (var5_4.length() == 0) {
            $i$a$-ifEmpty-GCCCompiler$collectModuleSearchPaths$relativePathToJson$1 = false;
            v0 = "libc++.modules.json";
        } else {
            v0 = var5_4;
        }
        relativePathToJson = (String)v0;
        hostAbsolutePathToJson = null;
        try {
            var8_9 = new String[]{this.myExecutable.getPath()};
            v1 = new GeneralCommandLine(var8_9);
            var8_9 = new String[]{"--print-file-name", relativePathToJson};
            v2 = v1.withParameters(var8_9);
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"withParameters(...)");
            cl = v2;
            v3 = OCCompilerBase.outCompilerRunner.run(cl, env);
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"run(...)");
            output = v3;
            v4 = output.getStdout();
            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getStdout(...)");
            hostAbsolutePathToJson = StringsKt.trim((CharSequence)v4).toString();
        }
        catch (ExecutionException <unused var>) {
            OCCompilerBase.LOG.info("libc++.modules.json was not found.");
            return CollectionsKt.emptyList();
        }
        v5 = env.getHostMachine().toCanonicalPath(CollectionsKt.listOf((Object)hostAbsolutePathToJson), true);
        Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"toCanonicalPath(...)");
        canonicalPath = ArraysKt.toList((Object[])v5);
        v6 = env.getHostMachine().resolveAndCache(canonicalPath);
        Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"resolveAndCache(...)");
        localAbsolutePathToJson = GCCCompilerUtilsKt.toPathSafe((String)CollectionsKt.firstOrNull((List)v6));
        if (localAbsolutePathToJson == null || !Files.exists(localAbsolutePathToJson, new LinkOption[0])) {
            OCCompilerBase.LOG.info("libc++.modules.json was not found.");
            return CollectionsKt.emptyList();
        }
        v7 = (String)CollectionsKt.firstOrNull((List)canonicalPath);
        if (v7 != null) {
            it = v7;
            $i$a$-let-GCCCompiler$collectModuleSearchPaths$hostBaseModulesDir$1 = false;
            v8 = OSAgnosticPathUtil.getParent((String)it);
        } else {
            v8 = hostBaseModulesDir = null;
        }
        if (hostBaseModulesDir == null) {
            OCCompilerBase.LOG.info("Can not find parent directory of libc++.modules.json.");
            return CollectionsKt.emptyList();
        }
        parsedModules = null;
        try {
            var10_15 = JSONKt.getJSON();
            v9 = Files.readString(localAbsolutePathToJson);
            Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"readString(...)");
            string$iv = v9;
            $i$f$decodeFromString = false;
            this_$iv.getSerializersModule();
            parsedModules = (LibCXXModuleSchema)this_$iv.decodeFromString((DeserializationStrategy)LibCXXModuleSchema.Companion.serializer(), string$iv);
        }
        catch (IOException e) {
            OCCompilerBase.LOG.warn((Throwable)e);
        }
        catch (SerializationException e) {
            OCCompilerBase.LOG.warn((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            OCCompilerBase.LOG.warn((Throwable)e);
        }
        if (parsedModules == null) {
            OCCompilerBase.LOG.warn("Failed to parse " + localAbsolutePathToJson + ".");
            return CollectionsKt.emptyList();
        }
        externalIncludeDirs = false;
        $this$map$iv = parsedModules.getModules();
        $i$f$map = false;
        var14_21 = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            var19_26 = (CXXModule)item$iv$iv;
            var22_29 = destination$iv$iv;
            $i$a$-map-GCCCompiler$collectModuleSearchPaths$sourcePaths$1 = false;
            v10 = path = OSAgnosticPathUtil.isAbsolute((String)module.getSourcePath()) != false ? Path.of(module.getSourcePath(), new String[0]) : Path.of(hostBaseModulesDir, new String[0]).resolve(module.getSourcePath());
            if (externalIncludeDirs) ** GOTO lbl-1000
            v11 = path.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"getParent(...)");
            if (this.checkIncludeDirsInBaseDir((CXXModule)module, v11)) lbl-1000:
            // 2 sources

            {
                v12 = true;
            } else {
                v12 = false;
            }
            externalIncludeDirs = v12;
            var22_29.add(path);
        }
        sourcePaths = (List)destination$iv$iv;
        if (externalIncludeDirs) {
            OCCompilerBase.LOG.warn("External included directories in libc++.modules.json are not supported.");
        }
        $this$map$iv = sourcePaths;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            module = (Path)item$iv$iv;
            var22_29 = destination$iv$iv;
            $i$a$-map-GCCCompiler$collectModuleSearchPaths$2 = false;
            Intrinsics.checkNotNull((Object)it);
            var22_29.add(new ModuleSearchPath((Path)it));
        }
        return (List)destination$iv$iv;
    }

    private final boolean checkIncludeDirsInBaseDir(CXXModule module, Path hostBaseDir) {
        Object object = module.getLocalArguments();
        if (object == null || (object = ((LocalArguments)object).getSystemIncludeDirectories()) == null) {
            return false;
        }
        Object systemIncludeDirectories = object;
        Iterator iterator = systemIncludeDirectories.iterator();
        while (iterator.hasNext()) {
            String includedDir = (String)iterator.next();
            Path absoluteIncludedDirPath = OSAgnosticPathUtil.isAbsolute((String)includedDir) ? Path.of(includedDir, new String[0]) : hostBaseDir.resolve(includedDir);
            if (!absoluteIncludedDirPath.normalize().startsWith(hostBaseDir)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public OCOptionsFilter createOptionsFilter(@NotNull Set<String> skipOptions) {
        Intrinsics.checkNotNullParameter(skipOptions, (String)"skipOptions");
        return new GCCOptionsFilter(skipOptions);
    }

    @NotNull
    protected String adjustArgument(@NotNull String arg) {
        Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
        return arg;
    }

    private final String preparePath(CidrToolEnvironment env, String path) {
        String string = FileUtil.toCanonicalPath((String)env.toLocalPath(this.myWorkingDirectory, path));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toCanonicalPath(...)");
        return string;
    }

    /*
     * Unable to fully structure code
     */
    private final List<Pair<String, String>> flagValuesIntroducedBy(List<String> $this$flagValuesIntroducedBy, String ... flagStarters) {
        $this$mapNotNull$iv = (Iterable)CollectionsKt.getIndices((Collection)$this$flagValuesIntroducedBy);
        $i$f$mapNotNull = false;
        var5_5 = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        var10_10 = $this$forEach$iv$iv$iv.iterator();
        while (var10_10.hasNext()) {
            block6: {
                element$iv$iv = element$iv$iv$iv = ((IntIterator)var10_10).nextInt();
                $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                it = element$iv$iv;
                $i$a$-mapNotNull-GCCCompiler$flagValuesIntroducedBy$1 = false;
                flag = this.adjustArgument($this$flagValuesIntroducedBy.get(it));
                $this$any$iv = flagStarters;
                $i$f$any = 0;
                var20_22 = $this$any$iv.length;
                for (var19_21 = 0; var19_21 < var20_22; ++var19_21) {
                    f = element$iv = $this$any$iv[var19_21];
                    $i$a$-any-GCCCompiler$flagValuesIntroducedBy$1$1 = false;
                    if (!Intrinsics.areEqual((Object)f, (Object)flag)) continue;
                    v0 = true;
                    break block6;
                }
                v0 = false;
            }
            if (!v0) ** GOTO lbl-1000
            $this$any$iv = ((Collection)$this$flagValuesIntroducedBy).size();
            $i$f$any = it + 1;
            v1 = 0 <= $i$f$any ? $i$f$any < $this$any$iv : false;
            if (v1) {
                flagValue = this.adjustArgument($this$flagValuesIntroducedBy.get(it + 1));
                v2 = new Pair((Object)flag, (Object)flagValue);
            } else if (((CharSequence)(prefix = GCCCompilerKt.access$findAnyPrefix(flag, Arrays.copyOf(flagStarters, flagStarters.length)))).length() == 0) {
                v2 = null;
            } else {
                adjustedArg = this.adjustArgument(StringsKt.removePrefix((String)flag, (CharSequence)prefix));
                v2 = new Pair((Object)prefix, (Object)adjustedArg);
            }
            if (v2 == null) continue;
            it$iv$iv = v2;
            $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> extractNonBuiltinSearchPaths(List<String> rawSwitches, CidrToolEnvironment environment, File workingDirectory) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object object = new String[]{"-I"};
        object = this.flagValuesIntroducedBy(rawSwitches, (String)object);
        boolean $i$f$map = false;
        void var7_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(environment.toLocalPath(workingDirectory, (String)it.getSecond()));
        }
        List searchPaths = (List)destination$iv$iv;
        Object[] objectArray = environment.getHostMachine().toCanonicalPath(searchPaths, true);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"toCanonicalPath(...)");
        Object[] canonicalSearchPaths = objectArray;
        return ArraysKt.toList((Object[])canonicalSearchPaths);
    }

    private static final String readVersion$lambda$0(Pattern $versionPattern, ProcessOutput it) {
        Object v1;
        block1: {
            List list = it.getStdoutLines();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getStdoutLines(...)");
            Iterable iterable = list;
            for (Object t : iterable) {
                String line = (String)t;
                boolean bl = false;
                CharSequence charSequence = line;
                if (!(!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) && $versionPattern.matcher(line).matches())) continue;
                v1 = t;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    private static final String readVersion$lambda$1(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final File tryExtractOriginalPrecompiledHeadersFromCMakeGeneratedFile$lambda$0(GCCCompiler this$0, MatchResult it) {
        String string = it.group(1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
        return this$0.unescapeAndPreparePath(string);
    }

    private static final File extractOriginalPrecompiledHeaderFile$lambda$0(GCCCompiler this$0, MatchResult it) {
        String string = it.group(1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
        return this$0.unescapeAndPreparePath(string);
    }

    @JvmStatic
    @NotNull
    public static final String getLanguageOption(@NotNull OCLanguageKind kind) {
        return Companion.getLanguageOption(kind);
    }

    @JvmStatic
    @VisibleForTesting
    public static final boolean collectSkipOptionsGcc(@NotNull List<String> lines, @NotNull Set<? super String> skipOptions, @NotNull List<? super String> warnLog) {
        return Companion.collectSkipOptionsGcc(lines, skipOptions, warnLog);
    }

    @JvmStatic
    @NotNull
    public static final List<String> getClangTestMacros() {
        return Companion.getClangTestMacros();
    }

    @JvmStatic
    @NotNull
    public static final List<String> getGCCBuiltInFunctionMacros() {
        return Companion.getGCCBuiltInFunctionMacros();
    }

    @JvmStatic
    @VisibleForTesting
    @NotNull
    public static final List<HeadersSearchPath> collectHeaderSearchPaths(@NotNull ProcessOutput output, boolean enableFrameworksWorkaround, @NotNull CidrToolEnvironment environment, @NotNull File workingDirectory, boolean hasBuiltInSearchPaths, @NotNull List<String> nonBuiltinSearchPaths, boolean isClang) {
        return Companion.collectHeaderSearchPaths(output, enableFrameworksWorkaround, environment, workingDirectory, hasBuiltInSearchPaths, nonBuiltinSearchPaths, isClang);
    }

    @JvmStatic
    @VisibleForTesting
    @NotNull
    public static final GCCCompilerOutputSections splitOutput(@NotNull String output, @NotNull List<String> warnLog) {
        return Companion.splitOutput(output, warnLog);
    }

    @JvmStatic
    @VisibleForTesting
    @NotNull
    public static final Pair<List<String>, Map<OCCompilerFeatures.Type<?>, Object>> collectDefinitionsAndFeatures(@NotNull GCCCompilerOutputSections output, @NotNull List<String> warnLog, @NotNull OCLanguageKind languageKind) {
        return Companion.collectDefinitionsAndFeatures(output, warnLog, languageKind);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J6\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b2\u000e\u0010\f\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00050\r2\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00050\u000fH\u0007J\u0013\u0010\u0010\u001a\r\u0012\t\u0012\u00070\u0005\u00a2\u0006\u0002\b\u00110\u000bH\u0007J\u0013\u0010\u0012\u001a\r\u0012\t\u0012\u00070\u0005\u00a2\u0006\u0002\b\u00110\u000bH\u0007JL\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\t2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b2\u0006\u0010\u001e\u001a\u00020\tH\u0007J\u001e\u0010\u001f\u001a\u00020 2\u0006\u0010\u0015\u001a\u00020\u00052\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000fH\u0007J\u0018\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\"H\u0002JH\u0010%\u001a$\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u000b\u0012\u0014\u0012\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030(\u0012\u0004\u0012\u00020\u00010'0&2\u0006\u0010\u0015\u001a\u00020 2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000f2\u0006\u0010)\u001a\u00020\u0007H\u0007\u00a8\u0006*"}, d2={"Lcom/jetbrains/cidr/lang/workspace/compiler/GCCCompiler$Companion;", "", "<init>", "()V", "getLanguageOption", "", "kind", "Lcom/jetbrains/cidr/lang/OCLanguageKind;", "collectSkipOptionsGcc", "", "lines", "", "skipOptions", "", "warnLog", "", "getClangTestMacros", "Lorg/jetbrains/annotations/NonNls;", "getGCCBuiltInFunctionMacros", "collectHeaderSearchPaths", "Lcom/jetbrains/cidr/lang/workspace/headerRoots/HeadersSearchPath;", "output", "Lcom/intellij/execution/process/ProcessOutput;", "enableFrameworksWorkaround", "environment", "Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;", "workingDirectory", "Ljava/io/File;", "hasBuiltInSearchPaths", "nonBuiltinSearchPaths", "isClang", "splitOutput", "Lcom/jetbrains/cidr/lang/workspace/compiler/GCCCompilerOutputSections;", "findStartOfCurrentLine", "", "inp", "from", "collectDefinitionsAndFeatures", "Lkotlin/Pair;", "", "Lcom/jetbrains/cidr/lang/workspace/compiler/OCCompilerFeatures$Type;", "languageKind", "intellij.cidr.projectModel"})
    @SourceDebugExtension(value={"SMAP\nGCCCompiler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GCCCompiler.kt\ncom/jetbrains/cidr/lang/workspace/compiler/GCCCompiler$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,972:1\n774#2:973\n865#2,2:974\n*S KotlinDebug\n*F\n+ 1 GCCCompiler.kt\ncom/jetbrains/cidr/lang/workspace/compiler/GCCCompiler$Companion\n*L\n236#1:973\n236#1:974,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final String getLanguageOption(@NotNull OCLanguageKind kind) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            if (kind instanceof CLanguageKind) {
                return switch (WhenMappings.$EnumSwitchMapping$0[((CLanguageKind)kind).ordinal()]) {
                    case 1 -> "-xc";
                    case 2 -> "-xobjective-c";
                    case 3 -> "-xc++";
                    case 4 -> "-xobjective-c++";
                    default -> throw new NoWhenBranchMatchedException();
                };
            }
            return "";
        }

        @JvmStatic
        @VisibleForTesting
        public final boolean collectSkipOptionsGcc(@NotNull List<String> lines, @NotNull Set<? super String> skipOptions, @NotNull List<? super String> warnLog) {
            Intrinsics.checkNotNullParameter(lines, (String)"lines");
            Intrinsics.checkNotNullParameter(skipOptions, (String)"skipOptions");
            Intrinsics.checkNotNullParameter(warnLog, (String)"warnLog");
            Pattern[] patternArray = GCCPatterns.INSTANCE.getBAD_SWITCH_FILTER_RULES();
            return OCCompilerBase.collectOptionsToSkip(lines, skipOptions, warnLog, Arrays.copyOf(patternArray, patternArray.length));
        }

        @JvmStatic
        @NotNull
        public final List<String> getClangTestMacros() {
            return GCCCompilerKt.access$getCLANG_TEST_MACROS$p();
        }

        @JvmStatic
        @NotNull
        public final List<String> getGCCBuiltInFunctionMacros() {
            return GCCCompilerKt.access$getGCC_BUILT_IN_FUNCTION_MACROS$p();
        }

        @JvmStatic
        @VisibleForTesting
        @NotNull
        public final List<HeadersSearchPath> collectHeaderSearchPaths(@NotNull ProcessOutput output, boolean enableFrameworksWorkaround, @NotNull CidrToolEnvironment environment, @NotNull File workingDirectory, boolean hasBuiltInSearchPaths, @NotNull List<String> nonBuiltinSearchPaths, boolean isClang) {
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
            Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
            Intrinsics.checkNotNullParameter(nonBuiltinSearchPaths, (String)"nonBuiltinSearchPaths");
            boolean withFrameworkWorkaround = enableFrameworksWorkaround;
            List headersSearchPaths = new ArrayList();
            List additionalFrameworks = new ArrayList();
            HeadersSearchPath clangSelectedGCCInstallation = null;
            HeadersSearchPath.Kind kind = null;
            block10: for (String each : output.getStderrLines()) {
                String current;
                Intrinsics.checkNotNull((Object)each);
                switch (current = ((Object)StringsKt.trim((CharSequence)each)).toString()) {
                    case "#include \"...\" search starts here:": {
                        kind = HeadersSearchPath.Kind.USER;
                        continue block10;
                    }
                    case "#include <...> search starts here:": {
                        kind = HeadersSearchPath.Kind.SYSTEM;
                        continue block10;
                    }
                    case "End of search list.": {
                        break block10;
                    }
                    default: {
                        String canonicalPath;
                        if (isClang && StringsKt.startsWith$default((String)current, (String)"Selected GCC installation: ", (boolean)false, (int)2, null)) {
                            String gccInstallIncludePath;
                            String includePath;
                            String installPath = StringsKt.substringAfter$default((String)current, (String)"Selected GCC installation: ", null, (int)2, null);
                            String[] stringArray = new String[]{installPath, "include"};
                            Intrinsics.checkNotNullExpressionValue((Object)FileUtil.join((String[])stringArray), (String)"join(...)");
                            if (GCCCompilerKt.access$convertToCanonicalIncludePath(includePath, environment, workingDirectory) == null) continue block10;
                            clangSelectedGCCInstallation = new HeadersSearchPath(gccInstallIncludePath, false, HeadersSearchPath.Kind.BUILTIN);
                            continue block10;
                        }
                        if (kind == null) continue block10;
                        String trimmed = StringsKt.removeSuffix((String)current, (CharSequence)" (framework directory)");
                        boolean isFramework = false;
                        if (!Intrinsics.areEqual((Object)current, (Object)trimmed)) {
                            current = trimmed;
                            isFramework = true;
                            withFrameworkWorkaround = false;
                        } else {
                            current = StringsKt.removeSuffix((String)current, (CharSequence)" (headermap)");
                        }
                        if (((CharSequence)(current = ((Object)StringsKt.trim((CharSequence)current)).toString())).length() == 0 || GCCCompilerKt.access$convertToCanonicalIncludePath(current, environment, workingDirectory) == null) continue block10;
                        boolean isBuiltIn = hasBuiltInSearchPaths && kind.isSystem() && !isFramework && !nonBuiltinSearchPaths.contains(canonicalPath);
                        HeadersSearchPath.Kind currentKind = isBuiltIn ? HeadersSearchPath.Kind.BUILTIN : (isFramework ? (kind == HeadersSearchPath.Kind.USER ? HeadersSearchPath.Kind.USER_FRAMEWORK : HeadersSearchPath.Kind.FRAMEWORK) : kind);
                        headersSearchPaths.add(new HeadersSearchPath(canonicalPath, false, currentKind));
                        if (!withFrameworkWorkaround) continue block10;
                        currentKind = kind == HeadersSearchPath.Kind.USER ? HeadersSearchPath.Kind.USER_FRAMEWORK : HeadersSearchPath.Kind.FRAMEWORK;
                        additionalFrameworks.add(new HeadersSearchPath(canonicalPath, false, currentKind));
                        continue block10;
                    }
                }
            }
            if (withFrameworkWorkaround) {
                headersSearchPaths.addAll(additionalFrameworks);
            }
            UtilKt.addIfNotNull((List)headersSearchPaths, clangSelectedGCCInstallation);
            return headersSearchPaths;
        }

        @JvmStatic
        @VisibleForTesting
        @NotNull
        public final GCCCompilerOutputSections splitOutput(@NotNull String output, @NotNull List<String> warnLog) {
            GCCCompilerOutputSections gCCCompilerOutputSections;
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            Intrinsics.checkNotNullParameter(warnLog, (String)"warnLog");
            int definesEnd = StringsKt.indexOf$default((CharSequence)output, (String)"___CIDR_DEFINITIONS_END", (int)0, (boolean)false, (int)6, null);
            int featuresStart = StringsKt.indexOf$default((CharSequence)output, (String)"___CIDR_FEATURES_START", (int)0, (boolean)false, (int)6, null);
            if (definesEnd >= 0 && featuresStart >= 0) {
                int definesLineStart = this.findStartOfCurrentLine(output, definesEnd);
                String string = output.substring(0, definesLineStart);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String defines = string;
                int featuresLineStart = this.findStartOfCurrentLine(output, featuresStart);
                String string2 = output.substring(definesEnd + 23 + 1, featuresLineStart);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                String preprocessed = string2;
                String string3 = output.substring(featuresStart + 22 + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                String featureChecks = string3;
                String[] stringArray = StringUtil.splitByLines((String)defines);
                Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"splitByLines(...)");
                gCCCompilerOutputSections = new GCCCompilerOutputSections(ArraysKt.toList((Object[])stringArray), preprocessed, featureChecks);
            } else {
                String string = CidrProjectModelBundle.message("unexpected.compiler.output.error.message", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                String unexpectedCompilerOutput = string;
                String string4 = CidrProjectModelBundle.message("possibly.unsupported.compiler.error.message", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
                String maybeUnsupportedCompiler = string4;
                warnLog.add(unexpectedCompilerOutput + "\n" + maybeUnsupportedCompiler);
                OCCompilerBase.LOG.warn("Unexpected compiler output: CIDR_DEFINITIONS_END=" + definesEnd + " CIDR_FEATURES_START=" + featuresStart);
                String[] stringArray = StringUtil.splitByLines((String)output);
                Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"splitByLines(...)");
                gCCCompilerOutputSections = new GCCCompilerOutputSections(ArraysKt.toList((Object[])stringArray), "", "");
            }
            return gCCCompilerOutputSections;
        }

        private final int findStartOfCurrentLine(String inp, int from) {
            for (int i = from; 0 < i; --i) {
                if (!StringUtil.isLineBreak((char)inp.charAt(i - 1))) continue;
                return i;
            }
            return 0;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @VisibleForTesting
        @NotNull
        public final Pair<List<String>, Map<OCCompilerFeatures.Type<?>, Object>> collectDefinitionsAndFeatures(@NotNull GCCCompilerOutputSections output, @NotNull List<String> warnLog, @NotNull OCLanguageKind languageKind) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            Intrinsics.checkNotNullParameter(warnLog, (String)"warnLog");
            Intrinsics.checkNotNullParameter((Object)languageKind, (String)"languageKind");
            Map cidrFeatures = new LinkedHashMap();
            String[] stringArray = (String[])output.getDefines();
            boolean $i$f$filter = false;
            void var8_7 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                String line = ((Object)StringsKt.trim((CharSequence)it)).toString();
                if (!(StringsKt.startsWith$default((String)line, (String)"#define ", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)line, (String)"#undef ", (boolean)false, (int)2, null))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List defines = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
            if (GCCCompilerKt.access$isClang(defines)) {
                defines.addAll((Collection)this.getClangTestMacros());
            }
            String[] stringArray2 = StringUtil.splitByLines((String)output.getFeatureChecks());
            Intrinsics.checkNotNullExpressionValue((Object)stringArray2, (String)"splitByLines(...)");
            for (String eachLine : stringArray2) {
                GCCCompilerFeature gCCCompilerFeature;
                Intrinsics.checkNotNull((Object)eachLine);
                if (GCCCompilerFeature.Parser.parse(eachLine) == null) continue;
                Command command = gCCCompilerFeature.component1();
                String key = gCCCompilerFeature.component2();
                String value = gCCCompilerFeature.component3();
                try {
                    switch (WhenMappings.$EnumSwitchMapping$1[command.ordinal()]) {
                        case 1: {
                            try {
                                cidrFeatures.put(OCCompilerFeatures.TypeSize.valueOf(key), Short.parseShort(value));
                                Unit unit = Unit.INSTANCE;
                            }
                            catch (NumberFormatException numberFormatException) {
                                Object[] objectArray = new Object[]{key, value};
                                Boolean bl = warnLog.add(CidrProjectModelBundle.message("cannot.determine.type.size.for.key.value", objectArray) + "\n" + CidrProjectModelBundle.message("possibly.unsupported.compiler.error.message", new Object[0]));
                            }
                            break;
                        }
                        case 2: {
                            cidrFeatures.put(OCCompilerFeatures.TypeTrait.valueOf(key), Intrinsics.areEqual((Object)value, (Object)"1"));
                            break;
                        }
                        case 3: {
                            cidrFeatures.put(OCCompilerFeatures.Feature.valueOf(key), Intrinsics.areEqual((Object)value, (Object)"1"));
                            break;
                        }
                        case 4: {
                            if (StringsKt.startsWith$default((String)key, (String)"__CIDR_macro_", (boolean)false, (int)2, null)) {
                                String realName = StringsKt.substringAfter$default((String)key, (String)"__CIDR_macro", null, (int)2, null);
                                v1 = defines.add("#define " + realName + " " + value);
                            } else if (StringsKt.startsWith$default((String)key, (String)"__CIDR_builtin_", (boolean)false, (int)2, null)) {
                                String realName = StringsKt.substringAfter$default((String)key, (String)"__CIDR_builtin", null, (int)2, null) + "(x)";
                                v1 = defines.add("#define " + realName + " " + realName);
                            } else if (Intrinsics.areEqual((Object)key, (Object)"__objc_yes") || Intrinsics.areEqual((Object)key, (Object)"__objc_no")) {
                                int valueLength = value.length();
                                if (valueLength != 0 && value.charAt(0) == '\"' && value.charAt(valueLength - 1) == '\"') {
                                    String string = value.substring(1, valueLength - 1);
                                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                                    v1 = defines.add("#define " + key + " " + string);
                                } else {
                                    v1 = defines.add("#define " + key + " " + value);
                                }
                            } else {
                                v1 = defines.add("#define " + key + " " + value);
                            }
                            break;
                        }
                        case 5: {
                            OCLanguageStandard langStd = Intrinsics.areEqual((Object)key, (Object)"STANDARD_CPP") ? OCLanguageStandard.Companion.getCppStandard(value) : OCLanguageStandard.Companion.getCStandard(value);
                            cidrFeatures.put(OCCompilerFeatures.LANGUAGE_STANDARD, langStd);
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Object[] objectArray = new Object[]{eachLine};
                    warnLog.add(CidrProjectModelBundle.message("invalid.query.message", objectArray));
                }
                if (cidrFeatures.containsKey(OCCompilerFeatures.LANGUAGE_STANDARD)) continue;
                OCLanguageStandard fallbackLanguageStd = languageKind.isCpp() ? OCLanguageStandard.CPP98 : OCLanguageStandard.C89;
                cidrFeatures.put(OCCompilerFeatures.LANGUAGE_STANDARD, fallbackLanguageStd);
            }
            defines.add("#define __extension__");
            defines.addAll((Collection)this.getGCCBuiltInFunctionMacros());
            return new Pair((Object)defines, (Object)cidrFeatures);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;
            public static final /* synthetic */ int[] $EnumSwitchMapping$1;

            static {
                int[] nArray = new int[CLanguageKind.values().length];
                try {
                    nArray[CLanguageKind.C.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[CLanguageKind.OBJ_C.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[CLanguageKind.CPP.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[CLanguageKind.OBJ_CPP.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
                nArray = new int[Command.values().length];
                try {
                    nArray[Command.SET_TYPE_SIZE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Command.SET_TYPE_TRAIT.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Command.SET_FEATURE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Command.ADD_DEFINITION.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Command.SET_LANGUAGE_STANDARD.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$1 = nArray;
            }
        }
    }
}

