/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.compiler;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessOutput;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.lang.workspace.compiler.ClangClOptionsFilter;
import com.jetbrains.cidr.lang.workspace.compiler.ClangClSwitchBuilder;
import com.jetbrains.cidr.lang.workspace.compiler.CompilerSpecificSwitchBuilder;
import com.jetbrains.cidr.lang.workspace.compiler.GCCCompiler;
import com.jetbrains.cidr.lang.workspace.compiler.MSVCResponseFileShortener;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerCommandLineShortener;
import com.jetbrains.cidr.lang.workspace.compiler.OCOptionsFilter;
import com.jetbrains.cidr.lang.workspace.compiler.TempFilesPool;
import java.io.File;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0014J\b\u0010\r\u001a\u00020\u000eH\u0014J\u0015\u0010\u000f\u001a\u00070\u0010\u00a2\u0006\u0002\b\u00112\u0006\u0010\u0012\u001a\u00020\u0010H\u0014J\b\u0010\u0013\u001a\u00020\u0014H\u0014J(\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00102\u000e\u0010\u001a\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00100\u001bH\u0016J\u0016\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00100\u001fH\u0016\u00a8\u0006 "}, d2={"Lcom/jetbrains/cidr/lang/workspace/compiler/ClangClCompiler;", "Lcom/jetbrains/cidr/lang/workspace/compiler/GCCCompiler;", "executable", "Ljava/io/File;", "workingDirectory", "env", "Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;", "tempFilesPool", "Lcom/jetbrains/cidr/lang/workspace/compiler/TempFilesPool;", "<init>", "(Ljava/io/File;Ljava/io/File;Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;Lcom/jetbrains/cidr/lang/workspace/compiler/TempFilesPool;)V", "getSwitchBuilder", "Lcom/jetbrains/cidr/lang/workspace/compiler/CompilerSpecificSwitchBuilder;", "getCompilerSwitchesFormat", "Lcom/jetbrains/cidr/lang/toolchains/CidrCompilerSwitches$Format;", "adjustArgument", "", "Lorg/jetbrains/annotations/NonNls;", "arg", "getCommandLineShortener", "Lcom/jetbrains/cidr/lang/workspace/compiler/OCCompilerCommandLineShortener;", "runGCC", "Lcom/intellij/execution/process/ProcessOutput;", "options", "Lcom/jetbrains/cidr/lang/toolchains/CidrCompilerSwitches;", "fileText", "warnLog", "", "createOptionsFilter", "Lcom/jetbrains/cidr/lang/workspace/compiler/OCOptionsFilter;", "skipOptions", "", "intellij.cidr.projectModel"})
public final class ClangClCompiler
extends GCCCompiler {
    public ClangClCompiler(@NotNull File executable, @NotNull File workingDirectory, @NotNull CidrToolEnvironment env, @NotNull TempFilesPool tempFilesPool) {
        Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        Intrinsics.checkNotNullParameter((Object)tempFilesPool, (String)"tempFilesPool");
        super(executable, workingDirectory, env, tempFilesPool);
    }

    @Override
    @NotNull
    protected CompilerSpecificSwitchBuilder getSwitchBuilder() {
        return new ClangClSwitchBuilder(null, 1, null);
    }

    @Override
    @NotNull
    protected CidrCompilerSwitches.Format getCompilerSwitchesFormat() {
        return CidrCompilerSwitches.Format.MSVC_RESPONSE_FILE;
    }

    @Override
    @NotNull
    protected String adjustArgument(@NotNull String arg) {
        Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
        String trimmed = StringsKt.removePrefix((String)arg, (CharSequence)"/clang:");
        if (StringsKt.startsWith$default((CharSequence)trimmed, (char)'/', (boolean)false, (int)2, null)) {
            String string = trimmed.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            return "-" + string;
        }
        return trimmed;
    }

    @Override
    @NotNull
    protected OCCompilerCommandLineShortener getCommandLineShortener() {
        return new MSVCResponseFileShortener();
    }

    @Override
    @NotNull
    public ProcessOutput runGCC(@NotNull CidrCompilerSwitches options, @NotNull String fileText, @NotNull List<? super String> warnLog) throws ExecutionException {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)fileText, (String)"fileText");
        Intrinsics.checkNotNullParameter(warnLog, (String)"warnLog");
        Set skipOptions = SetsKt.setOf((Object)"/WX");
        return super.runGCC(this.filterOptions(options, skipOptions), fileText, warnLog);
    }

    @Override
    @NotNull
    public OCOptionsFilter createOptionsFilter(@NotNull Set<String> skipOptions) {
        Intrinsics.checkNotNullParameter(skipOptions, (String)"skipOptions");
        return new ClangClOptionsFilter(skipOptions);
    }
}

