/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace;

import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.workspace.OCResolveConfigurationImpl;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceImplUtilKt;
import com.jetbrains.cidr.lang.workspace.WorkspaceStateHolder;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 /2\u00020\u0001:\u0003-./B)\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0016\u0010\u0004\u001a\u0012\u0012\b\u0012\u00060\u0006j\u0002`\u0007\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\u0012\u0010!\u001a\u00020\"2\n\u0010#\u001a\u00060$j\u0002`%J\u000e\u0010&\u001a\u00020\"2\u0006\u0010'\u001a\u00020\u0019J\u001d\u0010(\u001a\u00020\u00192\u0010\b\u0002\u0010)\u001a\n\u0012\u0004\u0012\u00020+\u0018\u00010*\u00a2\u0006\u0002\u0010,R!\u0010\u0004\u001a\u0012\u0012\b\u0012\u00060\u0006j\u0002`\u0007\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000e0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 \u00a8\u00060"}, d2={"Lcom/jetbrains/cidr/lang/workspace/StateHolder;", "", "timestamp", "", "workspaceStates", "", "", "Lcom/jetbrains/cidr/lang/workspace/Key;", "Lcom/jetbrains/cidr/lang/workspace/WorkspaceStateHolder;", "<init>", "(JLjava/util/Map;)V", "getWorkspaceStates", "()Ljava/util/Map;", "configurationIds", "Lcom/jetbrains/cidr/lang/workspace/OCResolveConfigurationImpl;", "getConfigurationIds", "configurations", "", "getConfigurations", "()Ljava/util/List;", "stateCacheValidationInfo", "Lcom/jetbrains/cidr/lang/workspace/StateHolder$StateCacheValidationInfo;", "getTimestamp", "()J", "isStateCacheValid", "", "()Z", "cache", "Lcom/jetbrains/cidr/lang/workspace/StateHolder$SourceFilesCache;", "getCache", "()Lcom/jetbrains/cidr/lang/workspace/StateHolder$SourceFilesCache;", "setCache", "(Lcom/jetbrains/cidr/lang/workspace/StateHolder$SourceFilesCache;)V", "dump", "", "out", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "markStateCacheValid", "isValid", "buildOrUpdateFilesCache", "updatedPointersOrNullToRebuild", "", "Lcom/intellij/openapi/vfs/pointers/VirtualFilePointer;", "([Lcom/intellij/openapi/vfs/pointers/VirtualFilePointer;)Z", "StateCacheValidationInfo", "SourceFilesCache", "Companion", "intellij.cidr.projectModel"})
@SourceDebugExtension(value={"SMAP\nOCWorkspaceImplState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OCWorkspaceImplState.kt\ncom/jetbrains/cidr/lang/workspace/StateHolder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,494:1\n1803#2,3:495\n1869#2,2:498\n1563#2:500\n1634#2,3:501\n*S KotlinDebug\n*F\n+ 1 OCWorkspaceImplState.kt\ncom/jetbrains/cidr/lang/workspace/StateHolder\n*L\n43#1:495,3\n100#1:498,2\n134#1:500\n134#1:501,3\n*E\n"})
public final class StateHolder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, WorkspaceStateHolder> workspaceStates;
    @NotNull
    private final Map<String, OCResolveConfigurationImpl> configurationIds;
    @NotNull
    private volatile StateCacheValidationInfo stateCacheValidationInfo;
    @NotNull
    private volatile SourceFilesCache cache;
    @NotNull
    private static final StateHolder EMPTY;

    /*
     * WARNING - void declaration
     */
    private StateHolder(long timestamp, Map<String, WorkspaceStateHolder> workspaceStates) {
        void $this$fold$iv;
        this.workspaceStates = workspaceStates;
        this.stateCacheValidationInfo = new StateCacheValidationInfo(true, timestamp);
        Iterable iterable = this.workspaceStates.values();
        int initial$iv = 0;
        boolean $i$f$fold = false;
        int accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void state;
            WorkspaceStateHolder workspaceStateHolder = (WorkspaceStateHolder)element$iv;
            int acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = acc + state.getConfigurations().size();
        }
        int requiredCapacity = accumulator$iv;
        LinkedHashMap builder = new LinkedHashMap(requiredCapacity);
        for (WorkspaceStateHolder state : this.workspaceStates.values()) {
            for (OCResolveConfigurationImpl configuration : state.getConfigurations()) {
                StateHolder.Companion.checkAndAdd(builder, configuration);
            }
        }
        Map map = Collections.unmodifiableMap(builder);
        Intrinsics.checkNotNullExpressionValue(map, (String)"unmodifiableMap(...)");
        this.configurationIds = map;
        this.cache = new SourceFilesCache(CollectionsKt.emptyList());
    }

    @NotNull
    public final Map<String, WorkspaceStateHolder> getWorkspaceStates() {
        return this.workspaceStates;
    }

    @NotNull
    public final Map<String, OCResolveConfigurationImpl> getConfigurationIds() {
        return this.configurationIds;
    }

    @NotNull
    public final List<OCResolveConfigurationImpl> getConfigurations() {
        return CollectionsKt.toList((Iterable)this.configurationIds.values());
    }

    public final long getTimestamp() {
        return this.stateCacheValidationInfo.getTimestamp();
    }

    public final boolean isStateCacheValid() {
        return this.stateCacheValidationInfo.isValid();
    }

    @NotNull
    public final SourceFilesCache getCache() {
        return this.cache;
    }

    public final void setCache(@NotNull SourceFilesCache sourceFilesCache) {
        Intrinsics.checkNotNullParameter((Object)sourceFilesCache, (String)"<set-?>");
        this.cache = sourceFilesCache;
    }

    public final void dump(@NotNull Appendable out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Iterable $this$forEach$iv = this.workspaceStates.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WorkspaceStateHolder it = (WorkspaceStateHolder)element$iv;
            boolean bl = false;
            it.dump(out);
        }
    }

    public final void markStateCacheValid(boolean isValid) {
        this.stateCacheValidationInfo = StateCacheValidationInfo.copy$default(this.stateCacheValidationInfo, isValid, 0L, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean buildOrUpdateFilesCache(@Nullable VirtualFilePointer[] updatedPointersOrNullToRebuild) {
        void $this$mapTo$iv$iv;
        if (updatedPointersOrNullToRebuild != null && updatedPointersOrNullToRebuild.length == 0) {
            return false;
        }
        if (OCWorkspaceImplUtilKt.getLOG().isDebugEnabled()) {
            VirtualFilePointer[] virtualFilePointerArray;
            if (updatedPointersOrNullToRebuild == null) {
                OCWorkspaceImplUtilKt.getLOG().debug("Rebuilding files cache");
            }
            if (!((virtualFilePointerArray = updatedPointersOrNullToRebuild) == null || virtualFilePointerArray.length == 0)) {
                Object pointers = CollectionsKt.joinToString$default((Iterable)ArraysKt.take((Object[])updatedPointersOrNullToRebuild, (int)5), (CharSequence)"\n", null, null, (int)0, null, StateHolder::buildOrUpdateFilesCache$lambda$0, (int)30, null);
                if (updatedPointersOrNullToRebuild.length > 5) {
                    pointers = (String)pointers + (updatedPointersOrNullToRebuild.length - 5) + " more...";
                }
                OCWorkspaceImplUtilKt.getLOG().debug("Updating cache for VFS pointers:\n  " + (String)pointers);
            }
        }
        this.cache = new SourceFilesCache(this.getConfigurations());
        Iterable $this$map$iv = this.getConfigurations();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            OCResolveConfigurationImpl oCResolveConfigurationImpl = (OCResolveConfigurationImpl)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.updateFilesCache(updatedPointersOrNullToRebuild, null));
        }
        return CollectionsKt.any((Iterable)((List)destination$iv$iv));
    }

    public static /* synthetic */ boolean buildOrUpdateFilesCache$default(StateHolder stateHolder, VirtualFilePointer[] virtualFilePointerArray, int n, Object object) {
        if ((n & 1) != 0) {
            virtualFilePointerArray = null;
        }
        return stateHolder.buildOrUpdateFilesCache(virtualFilePointerArray);
    }

    private static final CharSequence buildOrUpdateFilesCache$lambda$0(VirtualFilePointer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.toString();
    }

    public /* synthetic */ StateHolder(long timestamp, Map workspaceStates, DefaultConstructorMarker $constructor_marker) {
        this(timestamp, workspaceStates);
    }

    static {
        ImmutableMap immutableMap = ImmutableMap.of();
        Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"of(...)");
        EMPTY = new StateHolder(0L, (Map)immutableMap);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0016\u0010\u000b\u001a\u0012\u0012\b\u0012\u00060\rj\u0002`\u000e\u0012\u0004\u0012\u00020\u000f0\fH\u0000\u00a2\u0006\u0002\b\u0010J$\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0015H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/cidr/lang/workspace/StateHolder$Companion;", "", "<init>", "()V", "EMPTY", "Lcom/jetbrains/cidr/lang/workspace/StateHolder;", "getEMPTY", "()Lcom/jetbrains/cidr/lang/workspace/StateHolder;", "newStateWith", "timestamp", "", "unmodifiableWorkspaceStates", "", "", "Lcom/jetbrains/cidr/lang/workspace/Key;", "Lcom/jetbrains/cidr/lang/workspace/WorkspaceStateHolder;", "newStateWith$intellij_cidr_projectModel", "checkAndAdd", "", "builder", "", "Lcom/jetbrains/cidr/lang/workspace/OCResolveConfigurationImpl;", "configuration", "intellij.cidr.projectModel"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final StateHolder getEMPTY() {
            return EMPTY;
        }

        @NotNull
        public final StateHolder newStateWith$intellij_cidr_projectModel(long timestamp, @NotNull Map<String, WorkspaceStateHolder> unmodifiableWorkspaceStates) {
            Intrinsics.checkNotNullParameter(unmodifiableWorkspaceStates, (String)"unmodifiableWorkspaceStates");
            Map<String, WorkspaceStateHolder> map = Map.copyOf(unmodifiableWorkspaceStates);
            Intrinsics.checkNotNullExpressionValue(map, (String)"copyOf(...)");
            return new StateHolder(timestamp, map, null);
        }

        private final void checkAndAdd(Map<String, OCResolveConfigurationImpl> builder, OCResolveConfigurationImpl configuration) {
            OCResolveConfigurationImpl existing = builder.putIfAbsent(configuration.getUniqueId(), configuration);
            if (existing != null) {
                throw new IllegalStateException("Conflicting resolve configurations with same id from different model sources. First seen <" + existing.getDisplayName() + ">, discarded <" + configuration.getDisplayName() + ">.");
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u001d\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bRq\u0010\f\u001ab\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0004 \u000f*\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\t0\t \u000f*/\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0004 \u000f*\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\t0\t0\u0011\u00a2\u0006\u0002\b\u00100\r\u00a2\u0006\u0002\b\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/cidr/lang/workspace/StateHolder$SourceFilesCache;", "", "configurations", "", "Lcom/jetbrains/cidr/lang/workspace/OCResolveConfigurationImpl;", "<init>", "(Ljava/util/List;)V", "idsToConfigurations", "Lit/unimi/dsi/fastutil/ints/Int2ObjectOpenHashMap;", "", "getIdsToConfigurations", "()Lit/unimi/dsi/fastutil/ints/Int2ObjectOpenHashMap;", "urlsToConfigurations", "", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "", "getUrlsToConfigurations", "()Ljava/util/Map;", "intellij.cidr.projectModel"})
    @SourceDebugExtension(value={"SMAP\nOCWorkspaceImplState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OCWorkspaceImplState.kt\ncom/jetbrains/cidr/lang/workspace/StateHolder$SourceFilesCache\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,494:1\n1869#2,2:495\n1869#2,2:497\n*S KotlinDebug\n*F\n+ 1 OCWorkspaceImplState.kt\ncom/jetbrains/cidr/lang/workspace/StateHolder$SourceFilesCache\n*L\n62#1:495,2\n80#1:497,2\n*E\n"})
    public static final class SourceFilesCache {
        @NotNull
        private final Int2ObjectOpenHashMap<List<OCResolveConfigurationImpl>> idsToConfigurations;
        @NotNull
        private final Map<String, List<OCResolveConfigurationImpl>> urlsToConfigurations;

        public SourceFilesCache(@NotNull List<OCResolveConfigurationImpl> configurations) {
            Intrinsics.checkNotNullParameter(configurations, (String)"configurations");
            this.idsToConfigurations = new Int2ObjectOpenHashMap();
            Map map = CollectionFactory.createFilePathMap();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"createFilePathMap(...)");
            this.urlsToConfigurations = map;
            ArrayList<List<OCResolveConfigurationImpl>> listsToTrim = new ArrayList<List<OCResolveConfigurationImpl>>();
            Iterable $this$forEach$iv = configurations;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                OCResolveConfigurationImpl config = (OCResolveConfigurationImpl)element$iv;
                boolean bl = false;
                for (VirtualFilePointer eachSourcePointer : config.getData$intellij_cidr_projectModel().getSourcesData().keySet()) {
                    String url;
                    Intrinsics.checkNotNullExpressionValue((Object)eachSourcePointer.getUrl(), (String)"getUrl(...)");
                    List<OCResolveConfigurationImpl> fileConfigs = null;
                    fileConfigs = this.urlsToConfigurations.get(url);
                    if (fileConfigs == null) {
                        fileConfigs = new ArrayList<OCResolveConfigurationImpl>();
                        listsToTrim.add(fileConfigs);
                        this.urlsToConfigurations.put(url, fileConfigs);
                        if (eachSourcePointer.getFile() != null) {
                            VirtualFile it;
                            boolean bl2 = false;
                            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type com.intellij.openapi.vfs.VirtualFileWithId");
                            List cfr_ignored_0 = (List)this.idsToConfigurations.put(((VirtualFileWithId)it).getId(), fileConfigs);
                        }
                    }
                    fileConfigs.add(config);
                }
            }
            $this$forEach$iv = listsToTrim;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ArrayList it = (ArrayList)element$iv;
                boolean bl = false;
                it.trimToSize();
            }
            this.idsToConfigurations.trim();
            CollectionFactory.trimMap(this.urlsToConfigurations);
            IntIterator intIterator = ((IntSet)this.idsToConfigurations.keySet()).iterator();
            Intrinsics.checkNotNullExpressionValue((Object)intIterator, (String)"iterator(...)");
            IntIterator keys = intIterator;
            while (keys.hasNext()) {
                int key = keys.nextInt();
                this.idsToConfigurations.put(key, (Object)ContainerUtil.unmodifiableOrEmptyList((List)((List)this.idsToConfigurations.get(key))));
            }
            for (Map.Entry<String, List<OCResolveConfigurationImpl>> each : this.urlsToConfigurations.entrySet()) {
                each.setValue(ContainerUtil.unmodifiableOrEmptyList(each.getValue()));
            }
        }

        @NotNull
        public final Int2ObjectOpenHashMap<List<OCResolveConfigurationImpl>> getIdsToConfigurations() {
            return this.idsToConfigurations;
        }

        @NotNull
        public final Map<String, List<OCResolveConfigurationImpl>> getUrlsToConfigurations() {
            return this.urlsToConfigurations;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u00032\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/cidr/lang/workspace/StateHolder$StateCacheValidationInfo;", "", "isValid", "", "timestamp", "", "<init>", "(ZJ)V", "()Z", "getTimestamp", "()J", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.cidr.projectModel"})
    private static final class StateCacheValidationInfo {
        private final boolean isValid;
        private final long timestamp;

        public StateCacheValidationInfo(boolean isValid, long timestamp) {
            this.isValid = isValid;
            this.timestamp = timestamp;
        }

        public final boolean isValid() {
            return this.isValid;
        }

        public final long getTimestamp() {
            return this.timestamp;
        }

        public final boolean component1() {
            return this.isValid;
        }

        public final long component2() {
            return this.timestamp;
        }

        @NotNull
        public final StateCacheValidationInfo copy(boolean isValid, long timestamp) {
            return new StateCacheValidationInfo(isValid, timestamp);
        }

        public static /* synthetic */ StateCacheValidationInfo copy$default(StateCacheValidationInfo stateCacheValidationInfo, boolean bl, long l, int n, Object object) {
            if ((n & 1) != 0) {
                bl = stateCacheValidationInfo.isValid;
            }
            if ((n & 2) != 0) {
                l = stateCacheValidationInfo.timestamp;
            }
            return stateCacheValidationInfo.copy(bl, l);
        }

        @NotNull
        public String toString() {
            return "StateCacheValidationInfo(isValid=" + this.isValid + ", timestamp=" + this.timestamp + ")";
        }

        public int hashCode() {
            int result = Boolean.hashCode(this.isValid);
            result = result * 31 + Long.hashCode(this.timestamp);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof StateCacheValidationInfo)) {
                return false;
            }
            StateCacheValidationInfo stateCacheValidationInfo = (StateCacheValidationInfo)other;
            if (this.isValid != stateCacheValidationInfo.isValid) {
                return false;
            }
            return this.timestamp == stateCacheValidationInfo.timestamp;
        }
    }
}

