/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.LightVirtualFile;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculatorBase;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCResolveConfigurations;
import com.jetbrains.cidr.lang.workspace.ShowCompilerInfoForFile$CompilerInfoForFileData$;
import com.jetbrains.cidr.lang.workspace.ShowCompilerInfoForFile$HeaderSearchPath$;
import com.jetbrains.cidr.lang.workspace.ShowCompilerInfoForFileKt;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.internal.LinkedHashMapSerializer;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import kotlinx.serialization.internal.StringSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001:\u0003\u001e\u001f B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001c\u0010\u0011\u001a\u00020\u00052\n\u0010\u0012\u001a\u00060\u0013j\u0002`\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J$\u0010\u0015\u001a\u0016\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u00162\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0019H\u0002\u00a8\u0006!"}, d2={"Lcom/jetbrains/cidr/lang/workspace/ShowCompilerInfoForFile;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "generateCompilerInfoReport", "", "info", "Lcom/jetbrains/cidr/lang/workspace/ShowCompilerInfoForFile$CompilerInfoForFileData;", "context", "Lcom/jetbrains/cidr/lang/workspace/ShowCompilerInfoForFile$Context;", "appendAdditionalCompilerInfo", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getProjectAndFile", "Lkotlin/Triple;", "Lcom/intellij/openapi/project/Project;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/psi/PsiFile;", "getContext", "isHeaderOrSourceFile", "", "file", "Context", "CompilerInfoForFileData", "HeaderSearchPath", "intellij.cidr.projectModel"})
@SourceDebugExtension(value={"SMAP\nShowCompilerInfoForFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShowCompilerInfoForFile.kt\ncom/jetbrains/cidr/lang/workspace/ShowCompilerInfoForFile\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,161:1\n1869#2,2:162\n1#3:164\n*S KotlinDebug\n*F\n+ 1 ShowCompilerInfoForFile.kt\ncom/jetbrains/cidr/lang/workspace/ShowCompilerInfoForFile\n*L\n56#1:162,2\n*E\n"})
public class ShowCompilerInfoForFile
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setEnabledAndVisible(this.getProjectAndFile(e) != null);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Context context = this.getContext(e);
        if (context == null) {
            return;
        }
        Context context2 = context;
        CompilerInfoForFileData info = ShowCompilerInfoForFileKt.collectCompilerInfo(context2);
        String compilerInfoReport = this.generateCompilerInfoReport(info, context2);
        LightVirtualFile infoFile = new LightVirtualFile("Compiler Info for '" + info.getFileName() + "' in '" + info.getConfigurationDisplayName() + "'", (FileType)PlainTextFileType.INSTANCE, (CharSequence)compilerInfoReport);
        FileEditorManager.getInstance((Project)context2.getProject()).openFile((VirtualFile)infoFile, false);
    }

    private final String generateCompilerInfoReport(CompilerInfoForFileData info, Context context) {
        StringBuilder builder = new StringBuilder();
        builder.append("Compiler info for '" + info.getFileName() + "' in configuration '" + info.getConfigurationDisplayName() + "' for language " + info.getLanguageKind() + "\n");
        builder.append("\nCompiler kind: " + info.getCompilerKind() + " path: " + info.getCompilerExecutable() + "\n");
        this.appendAdditionalCompilerInfo(builder, context);
        builder.append("\nCompiler switches:\n");
        List<String> switches = info.getCompilerSwitches();
        if (switches == null) {
            builder.append("\nnull\n");
        } else {
            Iterable $this$forEach$iv = switches;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                builder.append("\t").append(it).append("\n");
            }
        }
        builder.append("\nCompiler info:\n");
        builder.append("\nDefines:\n");
        for (String preprocessorDefine : info.getPreprocessorDefines()) {
            builder.append(preprocessorDefine).append('\n');
        }
        builder.append("\nFeatures:\n").append(CollectionsKt.joinToString$default((Iterable)info.getCompilerFeatures().entrySet(), (CharSequence)"\n", null, null, (int)0, null, ShowCompilerInfoForFile::generateCompilerInfoReport$lambda$1, (int)30, null));
        builder.append("\n\nImplicit includes:\n" + CollectionsKt.joinToString$default((Iterable)info.getImplicitIncludes(), (CharSequence)"\n", null, null, (int)0, null, ShowCompilerInfoForFile::generateCompilerInfoReport$lambda$2, (int)30, null));
        builder.append("\n\nHeader Search paths:\n" + CollectionsKt.joinToString$default((Iterable)info.getHeaderSearchPaths(), (CharSequence)"\n", null, null, (int)0, null, ShowCompilerInfoForFile::generateCompilerInfoReport$lambda$3, (int)30, null));
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    protected void appendAdditionalCompilerInfo(@NotNull StringBuilder builder, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
    }

    private final Triple<Project, VirtualFile, PsiFile> getProjectAndFile(AnActionEvent e) {
        Project project = AnAction.getEventProject((AnActionEvent)e);
        if (project == null) {
            return null;
        }
        Project project2 = project;
        VirtualFile virtualFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile file = virtualFile;
        PsiFile psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        if (psiFile == null) {
            return null;
        }
        PsiFile psiFile2 = psiFile;
        if (!this.isHeaderOrSourceFile(psiFile2)) {
            return null;
        }
        return new Triple((Object)project2, (Object)file, (Object)psiFile2);
    }

    private final Context getContext(AnActionEvent e) {
        Triple<Project, VirtualFile, PsiFile> triple = this.getProjectAndFile(e);
        if (triple == null) {
            return null;
        }
        Triple<Project, VirtualFile, PsiFile> triple2 = triple;
        Project project = (Project)triple2.component1();
        VirtualFile file = (VirtualFile)triple2.component2();
        PsiFile psiFile = (PsiFile)triple2.component3();
        OCResolveConfiguration oCResolveConfiguration = OCResolveConfigurations.getPreselectedConfiguration(psiFile.getVirtualFile(), project);
        if (oCResolveConfiguration == null) {
            return null;
        }
        OCResolveConfiguration configuration = oCResolveConfiguration;
        OCLanguageKind oCLanguageKind = OCLanguageKindCalculatorBase.tryPsiFile((PsiFile)psiFile);
        if (oCLanguageKind == null) {
            return null;
        }
        OCLanguageKind kind = oCLanguageKind;
        return new Context(project, file, kind, configuration);
    }

    private final boolean isHeaderOrSourceFile(PsiFile file) {
        return OCFileTypeHelpers.isHeaderFile((PsiFile)file) || OCFileTypeHelpers.isSourceFile((PsiFile)file);
    }

    private static final CharSequence generateCompilerInfoReport$lambda$1(Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "\t" + it.getKey() + "=" + it.getValue();
    }

    private static final CharSequence generateCompilerInfoReport$lambda$2(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "\t" + it;
    }

    /*
     * WARNING - void declaration
     */
    private static final CharSequence generateCompilerInfoReport$lambda$3(HeaderSearchPath it) {
        Object object;
        String string;
        String string2;
        block3: {
            block2: {
                void f;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                string2 = it.getTypeName();
                string = it.isUser() ? "(user)" : "";
                object = it.getVirtualFile();
                if (object == null) break block2;
                String string3 = object;
                String string4 = string;
                String string5 = string2;
                boolean bl = false;
                String string6 = ": " + (String)f;
                string2 = string5;
                string = string4;
                String string7 = string6;
                object = string7;
                if (string7 != null) break block3;
            }
            object = "";
        }
        return "\t" + string2 + string + (String)object;
    }

    @Serializable
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 =2\u00020\u0001:\u0002<=B\u007f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u0012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\f\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\t\u00a2\u0006\u0004\b\u0010\u0010\u0011B\u00a3\u0001\b\u0010\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\t\u0012\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\t\u0012\u0014\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010\f\u0012\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\t\u0012\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\t\u0012\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u00a2\u0006\u0004\b\u0010\u0010\u0016J\t\u0010$\u001a\u00020\u0003H\u00c6\u0003J\t\u0010%\u001a\u00020\u0003H\u00c6\u0003J\t\u0010&\u001a\u00020\u0003H\u00c6\u0003J\t\u0010'\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010(\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0011\u0010)\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\tH\u00c6\u0003J\u000f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00030\tH\u00c6\u0003J\u0015\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\fH\u00c6\u0003J\u000f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00030\tH\u00c6\u0003J\u000f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u000f0\tH\u00c6\u0003J\u0095\u0001\u0010.\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00032\u0010\b\u0002\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\t2\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\t2\u0014\b\u0002\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\f2\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\t2\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\tH\u00c6\u0001J\u0013\u0010/\u001a\u0002002\b\u00101\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00102\u001a\u00020\u0013H\u00d6\u0001J\t\u00103\u001a\u00020\u0003H\u00d6\u0001J%\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\u00002\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:H\u0001\u00a2\u0006\u0002\b;R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0018R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0018R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0018R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0018R\u0019\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001eR\u001d\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u001eR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u001e\u00a8\u0006>"}, d2={"Lcom/jetbrains/cidr/lang/workspace/ShowCompilerInfoForFile$CompilerInfoForFileData;", "", "fileName", "", "configurationDisplayName", "languageKind", "compilerKind", "compilerExecutable", "compilerSwitches", "", "preprocessorDefines", "compilerFeatures", "", "implicitIncludes", "headerSearchPaths", "Lcom/jetbrains/cidr/lang/workspace/ShowCompilerInfoForFile$HeaderSearchPath;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/util/List;Ljava/util/Map;Ljava/util/List;Ljava/util/List;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/util/List;Ljava/util/Map;Ljava/util/List;Ljava/util/List;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getFileName", "()Ljava/lang/String;", "getConfigurationDisplayName", "getLanguageKind", "getCompilerKind", "getCompilerExecutable", "getCompilerSwitches", "()Ljava/util/List;", "getPreprocessorDefines", "getCompilerFeatures", "()Ljava/util/Map;", "getImplicitIncludes", "getHeaderSearchPaths", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "copy", "equals", "", "other", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$intellij_cidr_projectModel", "$serializer", "Companion", "intellij.cidr.projectModel"})
    public static final class CompilerInfoForFileData {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String fileName;
        @NotNull
        private final String configurationDisplayName;
        @NotNull
        private final String languageKind;
        @NotNull
        private final String compilerKind;
        @Nullable
        private final String compilerExecutable;
        @Nullable
        private final List<String> compilerSwitches;
        @NotNull
        private final List<String> preprocessorDefines;
        @NotNull
        private final Map<String, String> compilerFeatures;
        @NotNull
        private final List<String> implicitIncludes;
        @NotNull
        private final List<HeaderSearchPath> headerSearchPaths;
        @JvmField
        @NotNull
        private static final Lazy<KSerializer<Object>>[] $childSerializers;

        public CompilerInfoForFileData(@NotNull String fileName, @NotNull String configurationDisplayName, @NotNull String languageKind, @NotNull String compilerKind, @Nullable String compilerExecutable, @Nullable List<String> compilerSwitches, @NotNull List<String> preprocessorDefines, @NotNull Map<String, String> compilerFeatures, @NotNull List<String> implicitIncludes, @NotNull List<HeaderSearchPath> headerSearchPaths) {
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            Intrinsics.checkNotNullParameter((Object)configurationDisplayName, (String)"configurationDisplayName");
            Intrinsics.checkNotNullParameter((Object)languageKind, (String)"languageKind");
            Intrinsics.checkNotNullParameter((Object)compilerKind, (String)"compilerKind");
            Intrinsics.checkNotNullParameter(preprocessorDefines, (String)"preprocessorDefines");
            Intrinsics.checkNotNullParameter(compilerFeatures, (String)"compilerFeatures");
            Intrinsics.checkNotNullParameter(implicitIncludes, (String)"implicitIncludes");
            Intrinsics.checkNotNullParameter(headerSearchPaths, (String)"headerSearchPaths");
            this.fileName = fileName;
            this.configurationDisplayName = configurationDisplayName;
            this.languageKind = languageKind;
            this.compilerKind = compilerKind;
            this.compilerExecutable = compilerExecutable;
            this.compilerSwitches = compilerSwitches;
            this.preprocessorDefines = preprocessorDefines;
            this.compilerFeatures = compilerFeatures;
            this.implicitIncludes = implicitIncludes;
            this.headerSearchPaths = headerSearchPaths;
        }

        @NotNull
        public final String getFileName() {
            return this.fileName;
        }

        @NotNull
        public final String getConfigurationDisplayName() {
            return this.configurationDisplayName;
        }

        @NotNull
        public final String getLanguageKind() {
            return this.languageKind;
        }

        @NotNull
        public final String getCompilerKind() {
            return this.compilerKind;
        }

        @Nullable
        public final String getCompilerExecutable() {
            return this.compilerExecutable;
        }

        @Nullable
        public final List<String> getCompilerSwitches() {
            return this.compilerSwitches;
        }

        @NotNull
        public final List<String> getPreprocessorDefines() {
            return this.preprocessorDefines;
        }

        @NotNull
        public final Map<String, String> getCompilerFeatures() {
            return this.compilerFeatures;
        }

        @NotNull
        public final List<String> getImplicitIncludes() {
            return this.implicitIncludes;
        }

        @NotNull
        public final List<HeaderSearchPath> getHeaderSearchPaths() {
            return this.headerSearchPaths;
        }

        @NotNull
        public final String component1() {
            return this.fileName;
        }

        @NotNull
        public final String component2() {
            return this.configurationDisplayName;
        }

        @NotNull
        public final String component3() {
            return this.languageKind;
        }

        @NotNull
        public final String component4() {
            return this.compilerKind;
        }

        @Nullable
        public final String component5() {
            return this.compilerExecutable;
        }

        @Nullable
        public final List<String> component6() {
            return this.compilerSwitches;
        }

        @NotNull
        public final List<String> component7() {
            return this.preprocessorDefines;
        }

        @NotNull
        public final Map<String, String> component8() {
            return this.compilerFeatures;
        }

        @NotNull
        public final List<String> component9() {
            return this.implicitIncludes;
        }

        @NotNull
        public final List<HeaderSearchPath> component10() {
            return this.headerSearchPaths;
        }

        @NotNull
        public final CompilerInfoForFileData copy(@NotNull String fileName, @NotNull String configurationDisplayName, @NotNull String languageKind, @NotNull String compilerKind, @Nullable String compilerExecutable, @Nullable List<String> compilerSwitches, @NotNull List<String> preprocessorDefines, @NotNull Map<String, String> compilerFeatures, @NotNull List<String> implicitIncludes, @NotNull List<HeaderSearchPath> headerSearchPaths) {
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            Intrinsics.checkNotNullParameter((Object)configurationDisplayName, (String)"configurationDisplayName");
            Intrinsics.checkNotNullParameter((Object)languageKind, (String)"languageKind");
            Intrinsics.checkNotNullParameter((Object)compilerKind, (String)"compilerKind");
            Intrinsics.checkNotNullParameter(preprocessorDefines, (String)"preprocessorDefines");
            Intrinsics.checkNotNullParameter(compilerFeatures, (String)"compilerFeatures");
            Intrinsics.checkNotNullParameter(implicitIncludes, (String)"implicitIncludes");
            Intrinsics.checkNotNullParameter(headerSearchPaths, (String)"headerSearchPaths");
            return new CompilerInfoForFileData(fileName, configurationDisplayName, languageKind, compilerKind, compilerExecutable, compilerSwitches, preprocessorDefines, compilerFeatures, implicitIncludes, headerSearchPaths);
        }

        public static /* synthetic */ CompilerInfoForFileData copy$default(CompilerInfoForFileData compilerInfoForFileData, String string, String string2, String string3, String string4, String string5, List list, List list2, Map map, List list3, List list4, int n, Object object) {
            if ((n & 1) != 0) {
                string = compilerInfoForFileData.fileName;
            }
            if ((n & 2) != 0) {
                string2 = compilerInfoForFileData.configurationDisplayName;
            }
            if ((n & 4) != 0) {
                string3 = compilerInfoForFileData.languageKind;
            }
            if ((n & 8) != 0) {
                string4 = compilerInfoForFileData.compilerKind;
            }
            if ((n & 0x10) != 0) {
                string5 = compilerInfoForFileData.compilerExecutable;
            }
            if ((n & 0x20) != 0) {
                list = compilerInfoForFileData.compilerSwitches;
            }
            if ((n & 0x40) != 0) {
                list2 = compilerInfoForFileData.preprocessorDefines;
            }
            if ((n & 0x80) != 0) {
                map = compilerInfoForFileData.compilerFeatures;
            }
            if ((n & 0x100) != 0) {
                list3 = compilerInfoForFileData.implicitIncludes;
            }
            if ((n & 0x200) != 0) {
                list4 = compilerInfoForFileData.headerSearchPaths;
            }
            return compilerInfoForFileData.copy(string, string2, string3, string4, string5, list, list2, map, list3, list4);
        }

        @NotNull
        public String toString() {
            return "CompilerInfoForFileData(fileName=" + this.fileName + ", configurationDisplayName=" + this.configurationDisplayName + ", languageKind=" + this.languageKind + ", compilerKind=" + this.compilerKind + ", compilerExecutable=" + this.compilerExecutable + ", compilerSwitches=" + this.compilerSwitches + ", preprocessorDefines=" + this.preprocessorDefines + ", compilerFeatures=" + this.compilerFeatures + ", implicitIncludes=" + this.implicitIncludes + ", headerSearchPaths=" + this.headerSearchPaths + ")";
        }

        public int hashCode() {
            int result = this.fileName.hashCode();
            result = result * 31 + this.configurationDisplayName.hashCode();
            result = result * 31 + this.languageKind.hashCode();
            result = result * 31 + this.compilerKind.hashCode();
            result = result * 31 + (this.compilerExecutable == null ? 0 : this.compilerExecutable.hashCode());
            result = result * 31 + (this.compilerSwitches == null ? 0 : ((Object)this.compilerSwitches).hashCode());
            result = result * 31 + ((Object)this.preprocessorDefines).hashCode();
            result = result * 31 + ((Object)this.compilerFeatures).hashCode();
            result = result * 31 + ((Object)this.implicitIncludes).hashCode();
            result = result * 31 + ((Object)this.headerSearchPaths).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CompilerInfoForFileData)) {
                return false;
            }
            CompilerInfoForFileData compilerInfoForFileData = (CompilerInfoForFileData)other;
            if (!Intrinsics.areEqual((Object)this.fileName, (Object)compilerInfoForFileData.fileName)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.configurationDisplayName, (Object)compilerInfoForFileData.configurationDisplayName)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.languageKind, (Object)compilerInfoForFileData.languageKind)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.compilerKind, (Object)compilerInfoForFileData.compilerKind)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.compilerExecutable, (Object)compilerInfoForFileData.compilerExecutable)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.compilerSwitches, compilerInfoForFileData.compilerSwitches)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.preprocessorDefines, compilerInfoForFileData.preprocessorDefines)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.compilerFeatures, compilerInfoForFileData.compilerFeatures)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.implicitIncludes, compilerInfoForFileData.implicitIncludes)) {
                return false;
            }
            return Intrinsics.areEqual(this.headerSearchPaths, compilerInfoForFileData.headerSearchPaths);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$intellij_cidr_projectModel(CompilerInfoForFileData self, CompositeEncoder output, SerialDescriptor serialDesc) {
            Lazy<KSerializer<Object>>[] lazyArray = $childSerializers;
            output.encodeStringElement(serialDesc, 0, self.fileName);
            output.encodeStringElement(serialDesc, 1, self.configurationDisplayName);
            output.encodeStringElement(serialDesc, 2, self.languageKind);
            output.encodeStringElement(serialDesc, 3, self.compilerKind);
            output.encodeNullableSerializableElement(serialDesc, 4, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.compilerExecutable);
            output.encodeNullableSerializableElement(serialDesc, 5, (SerializationStrategy)lazyArray[5].getValue(), self.compilerSwitches);
            output.encodeSerializableElement(serialDesc, 6, (SerializationStrategy)lazyArray[6].getValue(), self.preprocessorDefines);
            output.encodeSerializableElement(serialDesc, 7, (SerializationStrategy)lazyArray[7].getValue(), self.compilerFeatures);
            output.encodeSerializableElement(serialDesc, 8, (SerializationStrategy)lazyArray[8].getValue(), self.implicitIncludes);
            output.encodeSerializableElement(serialDesc, 9, (SerializationStrategy)lazyArray[9].getValue(), self.headerSearchPaths);
        }

        public /* synthetic */ CompilerInfoForFileData(int seen0, String fileName, String configurationDisplayName, String languageKind, String compilerKind, String compilerExecutable, List compilerSwitches, List preprocessorDefines, Map compilerFeatures, List implicitIncludes, List headerSearchPaths, SerializationConstructorMarker serializationConstructorMarker) {
            if (1023 != (0x3FF & seen0)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)1023, (SerialDescriptor)CompilerInfoForFileData$$serializer.INSTANCE.getDescriptor());
            }
            this.fileName = fileName;
            this.configurationDisplayName = configurationDisplayName;
            this.languageKind = languageKind;
            this.compilerKind = compilerKind;
            this.compilerExecutable = compilerExecutable;
            this.compilerSwitches = compilerSwitches;
            this.preprocessorDefines = preprocessorDefines;
            this.compilerFeatures = compilerFeatures;
            this.implicitIncludes = implicitIncludes;
            this.headerSearchPaths = headerSearchPaths;
        }

        public static final /* synthetic */ Lazy[] access$get$childSerializers$cp() {
            return $childSerializers;
        }

        static {
            Lazy[] lazyArray = new Lazy[]{null, null, null, null, null, LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> (KSerializer)new ArrayListSerializer((KSerializer)StringSerializer.INSTANCE)), LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> (KSerializer)new ArrayListSerializer((KSerializer)StringSerializer.INSTANCE)), LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> (KSerializer)new LinkedHashMapSerializer((KSerializer)StringSerializer.INSTANCE, (KSerializer)StringSerializer.INSTANCE)), LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> (KSerializer)new ArrayListSerializer((KSerializer)StringSerializer.INSTANCE)), LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> (KSerializer)new ArrayListSerializer((KSerializer)HeaderSearchPath$$serializer.INSTANCE))};
            $childSerializers = lazyArray;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/cidr/lang/workspace/ShowCompilerInfoForFile$CompilerInfoForFileData$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/jetbrains/cidr/lang/workspace/ShowCompilerInfoForFile$CompilerInfoForFileData;", "intellij.cidr.projectModel"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<CompilerInfoForFileData> serializer() {
                return (KSerializer)CompilerInfoForFileData$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\tH\u00c6\u0003J1\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006 "}, d2={"Lcom/jetbrains/cidr/lang/workspace/ShowCompilerInfoForFile$Context;", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "kind", "Lcom/jetbrains/cidr/lang/OCLanguageKind;", "configuration", "Lcom/jetbrains/cidr/lang/workspace/OCResolveConfiguration;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/jetbrains/cidr/lang/OCLanguageKind;Lcom/jetbrains/cidr/lang/workspace/OCResolveConfiguration;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getKind", "()Lcom/jetbrains/cidr/lang/OCLanguageKind;", "getConfiguration", "()Lcom/jetbrains/cidr/lang/workspace/OCResolveConfiguration;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.cidr.projectModel"})
    public static final class Context {
        @NotNull
        private final Project project;
        @NotNull
        private final VirtualFile file;
        @NotNull
        private final OCLanguageKind kind;
        @NotNull
        private final OCResolveConfiguration configuration;

        public Context(@NotNull Project project, @NotNull VirtualFile file, @NotNull OCLanguageKind kind, @NotNull OCResolveConfiguration configuration) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            this.project = project;
            this.file = file;
            this.kind = kind;
            this.configuration = configuration;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @NotNull
        public final VirtualFile getFile() {
            return this.file;
        }

        @NotNull
        public final OCLanguageKind getKind() {
            return this.kind;
        }

        @NotNull
        public final OCResolveConfiguration getConfiguration() {
            return this.configuration;
        }

        @NotNull
        public final Project component1() {
            return this.project;
        }

        @NotNull
        public final VirtualFile component2() {
            return this.file;
        }

        @NotNull
        public final OCLanguageKind component3() {
            return this.kind;
        }

        @NotNull
        public final OCResolveConfiguration component4() {
            return this.configuration;
        }

        @NotNull
        public final Context copy(@NotNull Project project, @NotNull VirtualFile file, @NotNull OCLanguageKind kind, @NotNull OCResolveConfiguration configuration) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            return new Context(project, file, kind, configuration);
        }

        public static /* synthetic */ Context copy$default(Context context, Project project, VirtualFile virtualFile, OCLanguageKind oCLanguageKind, OCResolveConfiguration oCResolveConfiguration, int n, Object object) {
            if ((n & 1) != 0) {
                project = context.project;
            }
            if ((n & 2) != 0) {
                virtualFile = context.file;
            }
            if ((n & 4) != 0) {
                oCLanguageKind = context.kind;
            }
            if ((n & 8) != 0) {
                oCResolveConfiguration = context.configuration;
            }
            return context.copy(project, virtualFile, oCLanguageKind, oCResolveConfiguration);
        }

        @NotNull
        public String toString() {
            return "Context(project=" + this.project + ", file=" + this.file + ", kind=" + this.kind + ", configuration=" + this.configuration + ")";
        }

        public int hashCode() {
            int result = this.project.hashCode();
            result = result * 31 + this.file.hashCode();
            result = result * 31 + this.kind.hashCode();
            result = result * 31 + this.configuration.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Context)) {
                return false;
            }
            Context context = (Context)other;
            if (!Intrinsics.areEqual((Object)this.project, (Object)context.project)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.file, (Object)context.file)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.kind, (Object)context.kind)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.configuration, (Object)context.configuration);
        }
    }

    @Serializable
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 #2\u00020\u0001:\u0002\"#B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0007\u0010\bB7\b\u0010\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\u0007\u0010\rJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J)\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00052\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\nH\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001J%\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0001\u00a2\u0006\u0002\b!R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0010R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000f\u00a8\u0006$"}, d2={"Lcom/jetbrains/cidr/lang/workspace/ShowCompilerInfoForFile$HeaderSearchPath;", "", "typeName", "", "isUser", "", "virtualFile", "<init>", "(Ljava/lang/String;ZLjava/lang/String;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;ZLjava/lang/String;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getTypeName", "()Ljava/lang/String;", "()Z", "getVirtualFile", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$intellij_cidr_projectModel", "$serializer", "Companion", "intellij.cidr.projectModel"})
    public static final class HeaderSearchPath {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String typeName;
        private final boolean isUser;
        @Nullable
        private final String virtualFile;

        public HeaderSearchPath(@NotNull String typeName, boolean isUser, @Nullable String virtualFile) {
            Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
            this.typeName = typeName;
            this.isUser = isUser;
            this.virtualFile = virtualFile;
        }

        @NotNull
        public final String getTypeName() {
            return this.typeName;
        }

        public final boolean isUser() {
            return this.isUser;
        }

        @Nullable
        public final String getVirtualFile() {
            return this.virtualFile;
        }

        @NotNull
        public final String component1() {
            return this.typeName;
        }

        public final boolean component2() {
            return this.isUser;
        }

        @Nullable
        public final String component3() {
            return this.virtualFile;
        }

        @NotNull
        public final HeaderSearchPath copy(@NotNull String typeName, boolean isUser, @Nullable String virtualFile) {
            Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
            return new HeaderSearchPath(typeName, isUser, virtualFile);
        }

        public static /* synthetic */ HeaderSearchPath copy$default(HeaderSearchPath headerSearchPath, String string, boolean bl, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = headerSearchPath.typeName;
            }
            if ((n & 2) != 0) {
                bl = headerSearchPath.isUser;
            }
            if ((n & 4) != 0) {
                string2 = headerSearchPath.virtualFile;
            }
            return headerSearchPath.copy(string, bl, string2);
        }

        @NotNull
        public String toString() {
            return "HeaderSearchPath(typeName=" + this.typeName + ", isUser=" + this.isUser + ", virtualFile=" + this.virtualFile + ")";
        }

        public int hashCode() {
            int result = this.typeName.hashCode();
            result = result * 31 + Boolean.hashCode(this.isUser);
            result = result * 31 + (this.virtualFile == null ? 0 : this.virtualFile.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof HeaderSearchPath)) {
                return false;
            }
            HeaderSearchPath headerSearchPath = (HeaderSearchPath)other;
            if (!Intrinsics.areEqual((Object)this.typeName, (Object)headerSearchPath.typeName)) {
                return false;
            }
            if (this.isUser != headerSearchPath.isUser) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.virtualFile, (Object)headerSearchPath.virtualFile);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$intellij_cidr_projectModel(HeaderSearchPath self, CompositeEncoder output, SerialDescriptor serialDesc) {
            output.encodeStringElement(serialDesc, 0, self.typeName);
            output.encodeBooleanElement(serialDesc, 1, self.isUser);
            output.encodeNullableSerializableElement(serialDesc, 2, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.virtualFile);
        }

        public /* synthetic */ HeaderSearchPath(int seen0, String typeName, boolean isUser, String virtualFile, SerializationConstructorMarker serializationConstructorMarker) {
            if (7 != (7 & seen0)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)7, (SerialDescriptor)HeaderSearchPath$$serializer.INSTANCE.getDescriptor());
            }
            this.typeName = typeName;
            this.isUser = isUser;
            this.virtualFile = virtualFile;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/cidr/lang/workspace/ShowCompilerInfoForFile$HeaderSearchPath$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/jetbrains/cidr/lang/workspace/ShowCompilerInfoForFile$HeaderSearchPath;", "intellij.cidr.projectModel"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<HeaderSearchPath> serializer() {
                return (KSerializer)HeaderSearchPath$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

