/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace;

import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.PluginUtils;
import com.jetbrains.cidr.lang.workspace.OCModuleMapConfigurations;
import com.jetbrains.cidr.lang.workspace.OCPCHCache;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCResolveConfigurationChooser;
import com.jetbrains.cidr.lang.workspace.OCSupportedFileChecker;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceModificationTrackers;
import com.jetbrains.cidr.lang.workspace.headerRoots.AppleFramework;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRootProcessor;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinReg;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCResolveConfigurations {
    private static boolean ourBuildHeaderSymbolsForAllConfigurations = Boolean.parseBoolean(System.getProperty("cidr.build.header.symbols.for.all.configurations"));
    private static final NotNullLazyKey<CachedValue<Map<VirtualFile, Reference<OCResolveConfiguration>>>, Project> DIR_PREFERRED_CONFIG_CACHE = NotNullLazyKey.createLazyKey((String)"DIR_PREFERRED_CONFIG_CACHE", project -> CachedValuesManager.getManager((Project)project).createCachedValue(() -> {
        if (project.isDefault()) {
            return new CachedValueProvider.Result(null, new Object[]{ModificationTracker.NEVER_CHANGED});
        }
        OCWorkspaceModificationTrackers tracker = OCWorkspace.getInstance(project).getModificationTrackers();
        return new CachedValueProvider.Result(new ConcurrentHashMap(), new Object[]{tracker.getResolveConfigurationsTracker(), tracker.getSourceFilesTracker(), tracker.getCompilerSettingsTracker()});
    }, false));

    @Nullable
    public static OCResolveConfiguration findPreselectedConfiguration(@NotNull Project project, @NotNull Collection<OCResolveConfiguration> configs, @Nullable Ref<Integer> scoreRef) {
        if (project == null) {
            OCResolveConfigurations.$$$reportNull$$$0(0);
        }
        if (configs == null) {
            OCResolveConfigurations.$$$reportNull$$$0(1);
        }
        int score = 0;
        OCResolveConfiguration result = null;
        List<OCResolveConfiguration> configurations = configs.stream().toList();
        for (OCResolveConfigurationChooser selector : OCResolveConfigurationChooser.EP_NAME.getExtensionList()) {
            result = selector.selectResolveConfiguration(project, configurations);
            ++score;
            if (result == null) continue;
            break;
        }
        if (scoreRef != null) {
            scoreRef.set((Object)score);
        }
        return result;
    }

    @NotNull
    public static Pair<OCResolveConfiguration, Boolean> findPreselectedOrSuitableConfiguration(@NotNull Project project, @NotNull Collection<OCResolveConfiguration> configs) {
        OCResolveConfiguration selectedConfiguration;
        if (project == null) {
            OCResolveConfigurations.$$$reportNull$$$0(2);
        }
        if (configs == null) {
            OCResolveConfigurations.$$$reportNull$$$0(3);
        }
        if ((selectedConfiguration = OCResolveConfigurations.findPreselectedConfiguration(project, configs, null)) != null) {
            Pair pair = Pair.create((Object)selectedConfiguration, (Object)true);
            if (pair == null) {
                OCResolveConfigurations.$$$reportNull$$$0(4);
            }
            return pair;
        }
        Pair pair = Pair.create((Object)(configs.isEmpty() ? null : Collections.min(configs)), (Object)false);
        if (pair == null) {
            OCResolveConfigurations.$$$reportNull$$$0(5);
        }
        return pair;
    }

    @Nullable
    public static OCResolveConfiguration getPreselectedConfiguration(@NotNull VirtualFile virtualFile, @NotNull Project project) {
        if (virtualFile == null) {
            OCResolveConfigurations.$$$reportNull$$$0(6);
        }
        if (project == null) {
            OCResolveConfigurations.$$$reportNull$$$0(7);
        }
        return (OCResolveConfiguration)OCResolveConfigurations.findPreselectedOrSuitableConfiguration((Project)project, OCResolveConfigurations.getAllBuildConfigurationsForIndexing((VirtualFile)virtualFile, (Project)project)).first;
    }

    @NotNull
    public static Collection<OCResolveConfiguration> getAllBuildConfigurationsOfTargetsOfFile(@NotNull VirtualFile virtualFile, @NotNull Project project) {
        Collection<OCResolveConfiguration> configOfPch;
        if (virtualFile == null) {
            OCResolveConfigurations.$$$reportNull$$$0(8);
        }
        if (project == null) {
            OCResolveConfigurations.$$$reportNull$$$0(9);
        }
        if (!(configOfPch = OCPCHCache.getBuildConfigurationByPchFile(virtualFile, project)).isEmpty()) {
            Collection<OCResolveConfiguration> collection = configOfPch;
            if (collection == null) {
                OCResolveConfigurations.$$$reportNull$$$0(10);
            }
            return collection;
        }
        List<OCResolveConfiguration> list = OCWorkspace.getInstance(project).getConfigurationsForFile(virtualFile);
        if (list == null) {
            OCResolveConfigurations.$$$reportNull$$$0(11);
        }
        return list;
    }

    @NotNull
    public static Collection<OCResolveConfiguration> getAllBuildConfigurationsForIndexing(@NotNull VirtualFile virtualFile, @NotNull Project project) {
        Collection<OCResolveConfiguration> result;
        if (virtualFile == null) {
            OCResolveConfigurations.$$$reportNull$$$0(12);
        }
        if (project == null) {
            OCResolveConfigurations.$$$reportNull$$$0(13);
        }
        if (!(result = OCResolveConfigurations.getAllBuildConfigurationsOfTargetsOfFile(virtualFile, project)).isEmpty()) {
            Collection<OCResolveConfiguration> collection = result;
            if (collection == null) {
                OCResolveConfigurations.$$$reportNull$$$0(14);
            }
            return collection;
        }
        Collection<OCResolveConfiguration> configurations = OCResolveConfigurations.getConfigurationsToIndexForHeaderFile(project, virtualFile);
        if (ourBuildHeaderSymbolsForAllConfigurations && !configurations.isEmpty()) {
            Collection<OCResolveConfiguration> collection = configurations;
            if (collection == null) {
                OCResolveConfigurations.$$$reportNull$$$0(15);
            }
            return collection;
        }
        if (configurations.isEmpty()) {
            configurations = OCWorkspace.getInstance(project).getConfigurations();
        }
        if (!Experiments.getInstance().isFeatureEnabled("cidr.resolve.configuration.discovery")) {
            List list = ContainerUtil.createMaybeSingletonList((Object)((OCResolveConfiguration)OCResolveConfigurations.findPreselectedOrSuitableConfiguration((Project)project, configurations).first));
            if (list == null) {
                OCResolveConfigurations.$$$reportNull$$$0(16);
            }
            return list;
        }
        OCResolveConfiguration preselectedConfig = OCResolveConfigurations.findPreselectedConfiguration(project, configurations, null);
        if (preselectedConfig != null) {
            Set<OCResolveConfiguration> set = Collections.singleton(preselectedConfig);
            if (set == null) {
                OCResolveConfigurations.$$$reportNull$$$0(17);
            }
            return set;
        }
        OCResolveConfiguration fromNeighbours = OCResolveConfigurations.findConfigurationFromNeighbours(virtualFile, project);
        if (fromNeighbours != null) {
            Set<OCResolveConfiguration> set = Collections.singleton(fromNeighbours);
            if (set == null) {
                OCResolveConfigurations.$$$reportNull$$$0(18);
            }
            return set;
        }
        List<OCResolveConfiguration> list = configurations.isEmpty() ? Collections.emptyList() : Collections.singletonList(Collections.min(configurations));
        if (list == null) {
            OCResolveConfigurations.$$$reportNull$$$0(19);
        }
        return list;
    }

    @Nullable
    private static OCResolveConfiguration findConfigurationFromNeighbours(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            OCResolveConfigurations.$$$reportNull$$$0(20);
        }
        if (project == null) {
            OCResolveConfigurations.$$$reportNull$$$0(21);
        }
        if (file.isDirectory()) {
            return null;
        }
        VirtualFile parentDir = file.getParent();
        if (parentDir == null) {
            return null;
        }
        Map dir2Config = (Map)((CachedValue)DIR_PREFERRED_CONFIG_CACHE.getValue((UserDataHolder)project)).getValue();
        if (dir2Config == null) {
            return null;
        }
        Reference cached = (Reference)dir2Config.get(parentDir);
        if (cached != null) {
            return (OCResolveConfiguration)cached.get();
        }
        HashMap<String, Pair> id2Config = new HashMap<String, Pair>();
        for (VirtualFile child : parentDir.getChildren()) {
            if (child.isDirectory()) continue;
            for (OCResolveConfiguration c : OCResolveConfigurations.getAllBuildConfigurationsOfTargetsOfFile(child, project)) {
                String id = c.getUniqueId();
                Pair data = (Pair)id2Config.get(id);
                if (data == null) {
                    data = Pair.create((Object)c, (Object)new AtomicInteger());
                    id2Config.put(id, data);
                }
                ((AtomicInteger)data.second).incrementAndGet();
            }
        }
        int maxCount = 0;
        OCResolveConfiguration result = null;
        for (Pair data : id2Config.values()) {
            OCResolveConfiguration c = (OCResolveConfiguration)data.first;
            int count = ((AtomicInteger)data.second).get();
            if (result == null || count > maxCount) {
                maxCount = count;
                result = c;
                continue;
            }
            if (count != maxCount || c.compareTo(result) >= 0) continue;
            result = c;
        }
        dir2Config.put(parentDir, new WeakReference<Object>(result));
        return result;
    }

    @NotNull
    private static Collection<OCResolveConfiguration> getConfigurationsToIndexForHeaderFile(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            OCResolveConfigurations.$$$reportNull$$$0(22);
        }
        if (file == null) {
            OCResolveConfigurations.$$$reportNull$$$0(23);
        }
        Collection collection = HeaderFilesToBuildSymbolsProvider.get(project).get((Object)file);
        if (collection == null) {
            OCResolveConfigurations.$$$reportNull$$$0(24);
        }
        return collection;
    }

    @ApiStatus.Internal
    public static void setBuildHeaderSymbolsForAllConfigurations(boolean buildHeaderSymbolsForAllConfigurations) {
        ourBuildHeaderSymbolsForAllConfigurations = buildHeaderSymbolsForAllConfigurations;
    }

    @NotNull
    public static Collection<VirtualFile> getHeaderFilesToBuildSymbols(@NotNull Project project) {
        if (project == null) {
            OCResolveConfigurations.$$$reportNull$$$0(25);
        }
        Set set = HeaderFilesToBuildSymbolsProvider.get(project).keySet();
        if (set == null) {
            OCResolveConfigurations.$$$reportNull$$$0(26);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 10, 11, 14, 15, 16, 17, 18, 19, 24, 26 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configs";
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/workspace/OCResolveConfigurations";
                break;
            }
            case 6: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/workspace/OCResolveConfigurations";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findPreselectedOrSuitableConfiguration";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllBuildConfigurationsOfTargetsOfFile";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllBuildConfigurationsForIndexing";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationsToIndexForHeaderFile";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeaderFilesToBuildSymbols";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findPreselectedConfiguration";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findPreselectedOrSuitableConfiguration";
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 24: 
            case 26: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPreselectedConfiguration";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getAllBuildConfigurationsOfTargetsOfFile";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getAllBuildConfigurationsForIndexing";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "findConfigurationFromNeighbours";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurationsToIndexForHeaderFile";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getHeaderFilesToBuildSymbols";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 10, 11, 14, 15, 16, 17, 18, 19, 24, 26 -> new IllegalStateException(string);
        };
    }

    public static final class HeaderFilesToBuildSymbolsProvider
    implements CachedValueProvider<MultiMap<VirtualFile, OCResolveConfiguration>> {
        @NotNull
        private static final Key<CachedValue<MultiMap<VirtualFile, OCResolveConfiguration>>> KEY = Key.create((String)"LIBRARY_FILES_KEY");
        @NotNull
        private static final NullableLazyValue<List<String>> ourWindowsKitsPath = NullableLazyValue.lazyNullable(() -> {
            ArrayList<String> windowsKitsPaths = null;
            if (SystemInfo.isWindows) {
                windowsKitsPaths = new ArrayList<String>();
                try {
                    String[] sdks;
                    for (String sdk : sdks = Advapi32Util.registryGetKeys((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)"SOFTWARE\\WOW6432Node\\Microsoft\\Microsoft SDKs\\Windows")) {
                        @Nullable String path = Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)("SOFTWARE\\WOW6432Node\\Microsoft\\Microsoft SDKs\\Windows\\" + sdk), (String)"InstallationFolder");
                        if (path == null) continue;
                        windowsKitsPaths.add(path);
                    }
                }
                catch (Win32Exception win32Exception) {
                    // empty catch block
                }
            }
            return windowsKitsPaths;
        });
        @NotNull
        private final Project myProject;
        @Nullable
        private final List<String> myWindowsKitsPaths;

        private HeaderFilesToBuildSymbolsProvider(@NotNull Project project, @Nullable List<String> windowsKitsPaths) {
            if (project == null) {
                HeaderFilesToBuildSymbolsProvider.$$$reportNull$$$0(0);
            }
            this.myProject = project;
            this.myWindowsKitsPaths = windowsKitsPaths;
        }

        private static boolean hasAnyWindowsKits(List<HeadersSearchRoot> roots) {
            for (HeadersSearchRoot root : roots) {
                VirtualFile virtualFile = root.getVirtualFile();
                if (virtualFile == null || !virtualFile.toString().contains("/Windows Kits/")) continue;
                return true;
            }
            return false;
        }

        private List<HeadersSearchRoot> filterOutWindowsRoots(List<HeadersSearchRoot> roots) {
            if (!SystemInfo.isWindows || this.myWindowsKitsPaths == null) {
                return roots;
            }
            if (this.myWindowsKitsPaths.isEmpty()) {
                return HeaderFilesToBuildSymbolsProvider.hasAnyWindowsKits(roots) ? ContainerUtil.emptyList() : roots;
            }
            ArrayList<HeadersSearchRoot> result = new ArrayList<HeadersSearchRoot>();
            for (HeadersSearchRoot curRoot : roots) {
                String path;
                VirtualFile virtualFile = curRoot.getVirtualFile();
                if (virtualFile == null || ContainerUtil.exists(this.myWindowsKitsPaths, arg_0 -> HeaderFilesToBuildSymbolsProvider.lambda$filterOutWindowsRoots$1(path = virtualFile.toNioPath().toString(), arg_0))) continue;
                result.add(curRoot);
            }
            return result;
        }

        @NotNull
        public CachedValueProvider.Result<MultiMap<VirtualFile, OCResolveConfiguration>> compute() {
            boolean skipFrameworks = !PluginUtils.hasAppCode();
            MultiMap headerConfigs = MultiMap.createSet();
            Map scannedRootHeaders = CollectionFactory.createSmallMemoryFootprintMap();
            OCModuleMapConfigurations moduleMaps = OCModuleMapConfigurations.getInstance(this.myProject);
            HashSet alreadySeenRootInConfig = new HashSet();
            for (OCResolveConfiguration config : OCWorkspace.getInstance(this.myProject).getConfigurations()) {
                ProgressManager.checkCanceled();
                alreadySeenRootInConfig.clear();
                config.getAllCompilerSettings().forEach(settings -> {
                    ProgressManager.checkCanceled();
                    List<HeadersSearchRoot> roots = this.filterOutWindowsRoots(settings.getHeadersSearchRoots().getAllRoots());
                    for (HeadersSearchRoot eachRoot : roots) {
                        ProgressManager.checkCanceled();
                        if (!alreadySeenRootInConfig.add(eachRoot)) continue;
                        if (scannedRootHeaders.containsKey((Object)eachRoot)) {
                            for (VirtualFile header2 : (Set)scannedRootHeaders.get((Object)eachRoot)) {
                                ProgressManager.checkCanceled();
                                headerConfigs.putValue((Object)header2, (Object)config);
                            }
                            continue;
                        }
                        if (skipFrameworks && moduleMaps.isFrameworkSearchRoot(eachRoot)) continue;
                        Set headers = CollectionFactory.createSmallMemoryFootprintSet();
                        HeaderFilesToBuildSymbolsProvider.processHeadersInRoot(eachRoot, moduleMaps, header -> {
                            if (OCSupportedFileChecker.isSupported(this.myProject, header) && headers.add(header)) {
                                headerConfigs.putValue(header, (Object)config);
                            }
                        });
                        scannedRootHeaders.put(eachRoot, headers);
                    }
                });
            }
            OCWorkspaceModificationTrackers trackers = OCWorkspace.getInstance(this.myProject).getModificationTrackers();
            CachedValueProvider.Result result = CachedValueProvider.Result.create((Object)(headerConfigs.isEmpty() ? MultiMap.empty() : headerConfigs), (Object[])new Object[]{trackers.getResolveConfigurationsTracker(), trackers.getSourceFilesTracker(), trackers.getCompilerSettingsTracker()});
            if (result == null) {
                HeaderFilesToBuildSymbolsProvider.$$$reportNull$$$0(1);
            }
            return result;
        }

        private static void processHeadersInRoot(@NotNull HeadersSearchRoot eachRoot, final @NotNull OCModuleMapConfigurations moduleMaps, final @NotNull Consumer<? super VirtualFile> processor) {
            if (eachRoot == null) {
                HeaderFilesToBuildSymbolsProvider.$$$reportNull$$$0(2);
            }
            if (moduleMaps == null) {
                HeaderFilesToBuildSymbolsProvider.$$$reportNull$$$0(3);
            }
            if (processor == null) {
                HeaderFilesToBuildSymbolsProvider.$$$reportNull$$$0(4);
            }
            eachRoot.processChildren(new HeadersSearchRootProcessor(){

                @Override
                @NotNull
                public HeadersSearchRootProcessor.FrameworkResult processFramework(@NotNull AppleFramework framework) {
                    if (framework == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    ProgressManager.checkCanceled();
                    List<VirtualFile> publicHeadersToInclude = moduleMaps.getPublicHeadersToInclude(framework);
                    if (publicHeadersToInclude.isEmpty()) {
                        HeadersSearchRootProcessor.FrameworkResult frameworkResult = HeadersSearchRootProcessor.FrameworkResult.PROCESS_CHILDREN;
                        if (frameworkResult == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return frameworkResult;
                    }
                    publicHeadersToInclude.forEach(processor);
                    HeadersSearchRootProcessor.FrameworkResult frameworkResult = HeadersSearchRootProcessor.FrameworkResult.SKIP_CHILDREN;
                    if (frameworkResult == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return frameworkResult;
                }

                @Override
                public boolean process(@NotNull VirtualFile file) {
                    if (file == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    ProgressManager.checkCanceled();
                    if (!file.isDirectory()) {
                        processor.accept(file);
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 1, 2 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "framework";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/jetbrains/cidr/lang/workspace/OCResolveConfigurations$HeaderFilesToBuildSymbolsProvider$1";
                            break;
                        }
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "file";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/jetbrains/cidr/lang/workspace/OCResolveConfigurations$HeaderFilesToBuildSymbolsProvider$1";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "processFramework";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "processFramework";
                            break;
                        }
                        case 1: 
                        case 2: {
                            break;
                        }
                        case 3: {
                            objectArray = objectArray;
                            objectArray[2] = "process";
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 1, 2 -> new IllegalStateException(string);
                    };
                }
            });
            moduleMaps.providePublicHeadersForRoot(eachRoot, processor);
        }

        @NotNull
        static MultiMap<VirtualFile, OCResolveConfiguration> get(@NotNull Project project) {
            if (project == null) {
                HeaderFilesToBuildSymbolsProvider.$$$reportNull$$$0(5);
            }
            CachedValuesManager cachedValuesManager = CachedValuesManager.getManager((Project)project);
            MultiMap multiMap = (MultiMap)cachedValuesManager.getCachedValue((UserDataHolder)project, KEY, (CachedValueProvider)new HeaderFilesToBuildSymbolsProvider(project, (List)ourWindowsKitsPath.getValue()), false);
            if (multiMap == null) {
                HeaderFilesToBuildSymbolsProvider.$$$reportNull$$$0(6);
            }
            return multiMap;
        }

        private static /* synthetic */ boolean lambda$filterOutWindowsRoots$1(String path, String ignoredPath) {
            return path.startsWith(ignoredPath);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/workspace/OCResolveConfigurations$HeaderFilesToBuildSymbolsProvider";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "eachRoot";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moduleMaps";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/workspace/OCResolveConfigurations$HeaderFilesToBuildSymbolsProvider";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "compute";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "get";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 6: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "processHeadersInRoot";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "get";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 6 -> new IllegalStateException(string);
            };
        }
    }
}

