/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.daemon.FileWideHighlighter;
import com.jetbrains.cidr.lang.daemon.OCCodeInsightUnavailabilityHighlighter;
import com.jetbrains.cidr.lang.daemon.OCCodeInsightUnavailableInfo;
import com.jetbrains.cidr.lang.daemon.OCFileScopeProvider;
import com.jetbrains.cidr.lang.daemon.ProjectSourceLocationKind;
import com.jetbrains.cidr.lang.workspace.OCSupportedFileChecker;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCFileWideHighlighter
implements FileWideHighlighter {
    @NotNull
    private static final Key<ProjectSourceLocationKind> SOURCE_FILE_KIND = Key.create((String)"SOURCE_FILE_KIND");

    @Override
    @Nullable
    public HighlightInfo annotate(@NotNull Project project, @NotNull PsiFile file, @NotNull ProgressIndicator progress) {
        if (project == null) {
            OCFileWideHighlighter.$$$reportNull$$$0(0);
        }
        if (file == null) {
            OCFileWideHighlighter.$$$reportNull$$$0(1);
        }
        if (progress == null) {
            OCFileWideHighlighter.$$$reportNull$$$0(2);
        }
        if (!OCSupportedFileChecker.isSupportedLanguage(file)) {
            return null;
        }
        HighlightInfo info = OCFileWideHighlighter.annotateCodeInsightUnavailable(project, file);
        if (info != null) {
            return info;
        }
        return null;
    }

    public static ProjectSourceLocationKind getSourceFileKindFast(@NotNull VirtualFile file) {
        if (file == null) {
            OCFileWideHighlighter.$$$reportNull$$$0(3);
        }
        return (ProjectSourceLocationKind)((Object)SOURCE_FILE_KIND.get((UserDataHolder)file, (Object)ProjectSourceLocationKind.UNKNOWN));
    }

    @NotNull
    public static ProjectSourceLocationKind getSourceFileKind(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            OCFileWideHighlighter.$$$reportNull$$$0(4);
        }
        if (file == null) {
            OCFileWideHighlighter.$$$reportNull$$$0(5);
        }
        ProjectSourceLocationKind kind = ProjectSourceLocationKind.UNKNOWN;
        if (file.isValid() && file instanceof VirtualFileWithId) {
            kind = OCFileScopeProvider.Companion.getProjectSourceLocationKind(project, file);
        }
        SOURCE_FILE_KIND.set((UserDataHolder)file, (Object)kind);
        ProjectSourceLocationKind projectSourceLocationKind = kind;
        if (projectSourceLocationKind == null) {
            OCFileWideHighlighter.$$$reportNull$$$0(6);
        }
        return projectSourceLocationKind;
    }

    @Nullable
    private static HighlightInfo annotateCodeInsightUnavailable(@NotNull Project project, @NotNull PsiFile file) {
        OCCodeInsightUnavailableInfo info;
        if (project == null) {
            OCFileWideHighlighter.$$$reportNull$$$0(7);
        }
        if (file == null) {
            OCFileWideHighlighter.$$$reportNull$$$0(8);
        }
        if ((info = OCCodeInsightUnavailabilityHighlighter.Companion.check(project, file)) == null) {
            return null;
        }
        TextRange range = file.getTextRange();
        HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.WARNING).range(range).fileLevelAnnotation().description(info.getMessage());
        for (IntentionAction fix : info.getFixes()) {
            builder.registerFix(fix, Collections.emptyList(), fix.getText(), range, null);
        }
        return builder.create();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/OCFileWideHighlighter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/OCFileWideHighlighter";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceFileKind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "annotate";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSourceFileKindFast";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSourceFileKind";
                break;
            }
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "annotateCodeInsightUnavailable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }
}

