/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.BaseAffectAnalyzer;
import com.intellij.database.introspection.AffectedObjectScriptedMention;
import com.intellij.database.introspection.BelongingAreaKind;
import com.intellij.database.introspection.ScriptedName;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.SearchPath;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.mssql.MsDialect;
import com.intellij.sql.psi.SqlCallStatement;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlStringLiteralExpression;
import com.intellij.sql.psi.impl.SqlNamedParameterValueExpression;
import com.intellij.util.text.StringKt;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00060\u0005R\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0014J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u000f"}, d2={"Lcom/intellij/database/dialects/mssql/MsAffectAnalyzer;", "Lcom/intellij/database/dialects/base/BaseAffectAnalyzer;", "<init>", "()V", "prepareDeterminer", "Lcom/intellij/database/dialects/base/BaseAffectAnalyzer$Determiner;", "dbms", "Lcom/intellij/database/Dbms;", "searchPath", "Lcom/intellij/database/util/SearchPath;", "determineBelongingKind", "Lcom/intellij/database/introspection/BelongingAreaKind;", "objectKind", "Lcom/intellij/database/model/ObjectKind;", "MsDeterminer", "intellij.database.dialects.mssql"})
public final class MsAffectAnalyzer
extends BaseAffectAnalyzer {
    @NotNull
    protected BaseAffectAnalyzer.Determiner prepareDeterminer(@NotNull Dbms dbms, @Nullable SearchPath searchPath) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        return (BaseAffectAnalyzer.Determiner)new MsDeterminer(searchPath);
    }

    @Nullable
    protected BelongingAreaKind determineBelongingKind(@NotNull ObjectKind objectKind) {
        Intrinsics.checkNotNullParameter((Object)objectKind, (String)"objectKind");
        ObjectKind objectKind2 = objectKind;
        return Intrinsics.areEqual((Object)objectKind2, (Object)ObjectKind.NONE) || Intrinsics.areEqual((Object)objectKind2, (Object)ObjectKind.UNKNOWN_OBJECT) || Intrinsics.areEqual((Object)objectKind2, (Object)SqlDbElementType.ANY) ? null : (Intrinsics.areEqual((Object)objectKind2, (Object)ObjectKind.DATABASE) || Intrinsics.areEqual((Object)objectKind2, (Object)ObjectKind.LOGIN) || Intrinsics.areEqual((Object)objectKind2, (Object)ObjectKind.LINKED_SERVER) || Intrinsics.areEqual((Object)objectKind2, (Object)ObjectKind.COLLATION) ? BelongingAreaKind.A_ROOT : (Intrinsics.areEqual((Object)objectKind2, (Object)ObjectKind.SCHEMA) || Intrinsics.areEqual((Object)objectKind2, (Object)ObjectKind.ROLE) || Intrinsics.areEqual((Object)objectKind2, (Object)ObjectKind.ASSEMBLY) || Intrinsics.areEqual((Object)objectKind2, (Object)ObjectKind.FILEGROUP) ? BelongingAreaKind.A_DATABASE : BelongingAreaKind.A_SCHEMA));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0011\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J$\u0010\f\u001a\u0004\u0018\u00010\r*\b\u0012\u0004\u0012\u00020\r0\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u000e\u0010\u0013\u001a\u0004\u0018\u00010\u0010*\u00020\u0014H\u0002J\u000f\u0010\u0015\u001a\u0004\u0018\u00010\u0010*\u00020\rH\u0082\u0010\u00a8\u0006\u0016"}, d2={"Lcom/intellij/database/dialects/mssql/MsAffectAnalyzer$MsDeterminer;", "Lcom/intellij/database/dialects/base/BaseAffectAnalyzer$MultiDatabaseDeterminer;", "Lcom/intellij/database/dialects/base/BaseAffectAnalyzer;", "searchPath", "Lcom/intellij/database/util/SearchPath;", "<init>", "(Lcom/intellij/database/dialects/mssql/MsAffectAnalyzer;Lcom/intellij/database/util/SearchPath;)V", "analyzeCallStatement", "", "statement", "Lcom/intellij/sql/psi/SqlCallStatement;", "handleSpRename", "getArgument", "Lcom/intellij/sql/psi/SqlExpression;", "", "name", "", "position", "", "getArgumentName", "Lcom/intellij/sql/psi/impl/SqlNamedParameterValueExpression;", "getArgumentValue", "intellij.database.dialects.mssql"})
    private final class MsDeterminer
    extends BaseAffectAnalyzer.MultiDatabaseDeterminer {
        public MsDeterminer(SearchPath searchPath) {
            super((BaseAffectAnalyzer)MsAffectAnalyzer.this, searchPath);
        }

        protected void analyzeCallStatement(@NotNull SqlCallStatement statement) {
            String name2;
            Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
            SqlReferenceExpression sqlReferenceExpression = statement.getCallableReference();
            String string = name2 = sqlReferenceExpression != null ? sqlReferenceExpression.getName() : null;
            if (name2 != null && StringsKt.equals((String)name2, (String)"sp_rename", (boolean)true)) {
                this.handleSpRename(statement);
            }
        }

        /*
         * Unable to fully structure code
         */
        private final void handleSpRename(SqlCallStatement statement) {
            block22: {
                v0 = statement.getArguments();
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getArguments(...)");
                arguments = v0;
                if (arguments.size() < 2) {
                    return;
                }
                v1 = this.getArgument(arguments, "@objname", 0);
                oldNameArg = v1 != null ? this.getArgumentValue(v1) : null;
                v2 = this.getArgument(arguments, "@newname", 1);
                v3 = newNameArg = v2 != null ? this.getArgumentValue(v2) : null;
                if (oldNameArg == null || newNameArg == null) {
                    return;
                }
                var7_5 = statement.getLanguage();
                v4 = var7_5 instanceof SqlLanguageDialect != false ? (SqlLanguageDialect)var7_5 : null;
                if (v4 == null) {
                    v4 = (SqlLanguageDialect)MsDialect.INSTANCE;
                }
                dialect = v4;
                v5 = statement.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"getProject(...)");
                project = v5;
                v6 = this.getArgument(arguments, "@objtype", 2);
                if (v6 != null && (v6 = this.getArgumentValue((SqlExpression)v6)) != null) {
                    v7 = v6.toUpperCase(Locale.ROOT);
                    v8 = v7;
                    Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"toUpperCase(...)");
                } else {
                    v8 = null;
                }
                var8_8 = objectKindStr = v8;
                if (var8_8 == null) ** GOTO lbl46
                switch (var8_8.hashCode()) {
                    case -1722875525: {
                        if (!var8_8.equals("DATABASE")) {
                            ** break;
                        }
                        break block22;
                    }
                    case 1993459542: {
                        if (var8_8.equals("COLUMN")) break;
                        ** break;
                    }
                    case 69808306: {
                        if (var8_8.equals("INDEX")) break;
                        ** break;
                    }
                    case -1970038977: {
                        if (!var8_8.equals("OBJECT")) {
                            ** break;
                        }
                        ** GOTO lbl46
                    }
                    case -1020235089: {
                        if (!var8_8.equals("USERDATATYPE")) ** break;
lbl46:
                        // 3 sources

                        Intrinsics.checkNotNull((Object)dialect);
                        v9 = BaseAffectAnalyzer.Companion.parseQualifiedIdentifier$default((BaseAffectAnalyzer.Companion)BaseAffectAnalyzer.Companion, (String)oldNameArg, (SqlLanguageDialect)dialect, (Project)project, (int)0, (int)8, null);
                        if (v9 == null) {
                            return;
                        }
                        oldQi = v9;
                        n = oldQi.size();
                        if (n == 0) {
                            return;
                        }
                        v10 = BaseAffectAnalyzer.Companion.parseQualifiedIdentifier$default((BaseAffectAnalyzer.Companion)BaseAffectAnalyzer.Companion, (String)newNameArg, (SqlLanguageDialect)dialect, (Project)project, (int)0, (int)8, null);
                        if (v10 == null) {
                            return;
                        }
                        newQi = v10;
                        if (newQi.size() != 1) {
                            return;
                        }
                        v11 = (ScriptedName)newQi.get(0);
                        v12 = ObjectKind.SCHEMA_OBJECT;
                        Intrinsics.checkNotNullExpressionValue((Object)v12, (String)"SCHEMA_OBJECT");
                        mention = AffectedObjectScriptedMention.Companion.wasRenamed(oldQi, v11, v12, BelongingAreaKind.A_SCHEMA);
                        this.acceptObject(mention);
                        ** break;
                    }
                }
                Intrinsics.checkNotNull((Object)dialect);
                v13 = BaseAffectAnalyzer.Companion.parseQualifiedIdentifier(oldNameArg, dialect, project, 1);
                if (v13 == null) {
                    return;
                }
                qi = v13;
                v14 = ObjectKind.SCHEMA_OBJECT;
                Intrinsics.checkNotNullExpressionValue((Object)v14, (String)"SCHEMA_OBJECT");
                mention = AffectedObjectScriptedMention.Companion.wasAltered(qi, v14, BelongingAreaKind.A_SCHEMA);
                this.acceptObject(mention);
                ** break;
            }
            Intrinsics.checkNotNull((Object)dialect);
            v15 = BaseAffectAnalyzer.Companion.parseQualifiedIdentifier$default((BaseAffectAnalyzer.Companion)BaseAffectAnalyzer.Companion, (String)oldNameArg, (SqlLanguageDialect)dialect, (Project)project, (int)0, (int)8, null);
            if (v15 == null) {
                return;
            }
            qi1 = v15;
            v16 = MsDialect.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)v16, (String)"INSTANCE");
            v17 = BaseAffectAnalyzer.Companion.parseQualifiedIdentifier$default((BaseAffectAnalyzer.Companion)BaseAffectAnalyzer.Companion, (String)oldNameArg, (SqlLanguageDialect)((SqlLanguageDialect)v16), (Project)project, (int)0, (int)8, null);
            if (v17 == null) {
                return;
            }
            qi2 = v17;
            if (qi1.size() != 1 || qi2.size() != 1) {
                return;
            }
            v18 = (ScriptedName)qi1.get(0);
            v19 = (ScriptedName)qi2.get(0);
            v20 = ObjectKind.DATABASE;
            Intrinsics.checkNotNullExpressionValue((Object)v20, (String)"DATABASE");
            mention = AffectedObjectScriptedMention.Companion.wasRenamed(null, null, v18, v19, v20, BelongingAreaKind.A_ROOT);
            this.acceptObject(mention);
lbl96:
            // 9 sources

        }

        private final SqlExpression getArgument(List<? extends SqlExpression> $this$getArgument, String name2, int position) {
            for (SqlExpression sqlExpression : $this$getArgument) {
                Object theName;
                Object object = sqlExpression instanceof SqlNamedParameterValueExpression ? (SqlNamedParameterValueExpression)sqlExpression : null;
                if (object == null) continue;
                if ((object = this.getArgumentName((SqlNamedParameterValueExpression)object)) == null || !StringsKt.equals((String)(theName = object), (String)name2, (boolean)true)) continue;
                return sqlExpression;
            }
            if (position < $this$getArgument.size()) {
                return $this$getArgument.get(position);
            }
            return null;
        }

        private final String getArgumentName(SqlNamedParameterValueExpression $this$getArgumentName) {
            String string = $this$getArgumentName.getName();
            if (string == null) {
                return null;
            }
            String str = string;
            return StringKt.nullize$default((String)((Object)StringsKt.trim((CharSequence)StringsKt.substringBefore((String)str, (char)'=', (String)""))).toString(), (boolean)false, (int)1, null);
        }

        private final String getArgumentValue(SqlExpression $this$getArgumentValue) {
            String string;
            block2: {
                SqlExpression sqlExpression;
                block3: {
                    MsDeterminer msDeterminer = this;
                    while (true) {
                        SqlExpression sqlExpression2;
                        if ((sqlExpression = $this$getArgumentValue) instanceof SqlStringLiteralExpression) {
                            string = ((SqlStringLiteralExpression)$this$getArgumentValue).getValue();
                            break block2;
                        }
                        if (!(sqlExpression instanceof SqlNamedParameterValueExpression)) break block3;
                        Object object = ((SqlNamedParameterValueExpression)$this$getArgumentValue).getLastChild();
                        SqlExpression sqlExpression3 = sqlExpression2 = object instanceof SqlExpression ? (SqlExpression)object : null;
                        if (sqlExpression2 == null) break;
                        object = msDeterminer;
                        SqlExpression sqlExpression4 = sqlExpression2;
                        msDeterminer = object;
                        $this$getArgumentValue = sqlExpression4;
                    }
                    string = null;
                    break block2;
                }
                string = sqlExpression instanceof SqlReferenceExpression ? (Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)((PsiElement)$this$getArgumentValue)), (Object)SqlCompositeElementTypes.SQL_SHORT_REFERENCE) ? ((SqlReferenceExpression)$this$getArgumentValue).getText() : null) : null;
            }
            return string;
        }
    }
}

