/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.coverage;

import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageLoadErrorReporter;
import com.intellij.coverage.CoverageLoadingResult;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.FailedCoverageLoadingResult;
import com.intellij.execution.configurations.RunConfiguration;
import com.jetbrains.cidr.cpp.execution.coverage.CMakeCoverageEngine;
import com.jetbrains.cidr.execution.coverage.CidrCoverageBundle;
import com.jetbrains.cidr.execution.coverage.CidrCoverageDataFileProvider;
import com.jetbrains.cidr.execution.coverage.CidrCoverageUtil;
import com.jetbrains.cidr.execution.coverage.gcov.GCovCoverageRunner;
import com.jetbrains.cidr.execution.coverage.llvm.LLVMCoverageRunner;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\b\u0010\u0007\u001a\u00020\u0005H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\"\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/cidr/cpp/execution/coverage/CMakeCoverageRunner;", "Lcom/intellij/coverage/CoverageRunner;", "<init>", "()V", "getPresentableName", "", "getDataFileExtension", "getId", "acceptsCoverageEngine", "", "engine", "Lcom/intellij/coverage/CoverageEngine;", "loadCoverageData", "Lcom/intellij/coverage/CoverageLoadingResult;", "sessionDataFile", "Ljava/io/File;", "baseCoverageSuite", "Lcom/intellij/coverage/CoverageSuite;", "reporter", "Lcom/intellij/coverage/CoverageLoadErrorReporter;", "Companion", "intellij.clion.coverage"})
public final class CMakeCoverageRunner
extends CoverageRunner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String ID;

    @NotNull
    public String getPresentableName() {
        return ID;
    }

    @NotNull
    public String getDataFileExtension() {
        return "";
    }

    @NotNull
    public String getId() {
        return ID;
    }

    public boolean acceptsCoverageEngine(@NotNull CoverageEngine engine) {
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        return engine instanceof CMakeCoverageEngine;
    }

    @NotNull
    protected CoverageLoadingResult loadCoverageData(@NotNull File sessionDataFile, @Nullable CoverageSuite baseCoverageSuite, @NotNull CoverageLoadErrorReporter reporter) {
        CidrToolEnvironment environment;
        Intrinsics.checkNotNullParameter((Object)sessionDataFile, (String)"sessionDataFile");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        RunConfiguration runConfiguration = CidrCoverageUtil.Companion.getRunConfiguration(baseCoverageSuite);
        if (runConfiguration == null) {
            return (CoverageLoadingResult)new FailedCoverageLoadingResult("No run configuration");
        }
        RunConfiguration configuration = runConfiguration;
        CidrCoverageDataFileProvider llvmDataFileProvider = CidrCoverageDataFileProvider.Companion.getInstance(configuration, "llvm-cov");
        CidrToolEnvironment cidrToolEnvironment = CidrCoverageUtil.Companion.getEnvironment(baseCoverageSuite);
        if (cidrToolEnvironment == null) {
            cidrToolEnvironment = environment = new CidrToolEnvironment();
        }
        if (llvmDataFileProvider != null && llvmDataFileProvider.isCoverageDataExist(configuration, environment)) {
            LLVMCoverageRunner lLVMCoverageRunner = (LLVMCoverageRunner)CoverageRunner.getInstance(LLVMCoverageRunner.class);
            String string = llvmDataFileProvider.getLocalCoverageDataPath(configuration);
            Intrinsics.checkNotNull((Object)string);
            return lLVMCoverageRunner.loadCoverageData(new File(string), baseCoverageSuite, reporter);
        }
        return ((GCovCoverageRunner)CoverageRunner.getInstance(GCovCoverageRunner.class)).loadCoverageData(sessionDataFile, baseCoverageSuite, reporter);
    }

    static {
        String string = CidrCoverageBundle.message((String)"gcov.llvm.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        ID = string;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/cidr/cpp/execution/coverage/CMakeCoverageRunner$Companion;", "", "<init>", "()V", "ID", "", "getID", "()Ljava/lang/String;", "intellij.clion.coverage"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getID() {
            return ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

