/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.coverage;

import com.intellij.coverage.CoverageOptionsConfigurable;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.jetbrains.cidr.cpp.cmake.CMakeBuildOptionsInstaller;
import com.jetbrains.cidr.cpp.execution.CMakeAppRunConfiguration;
import com.jetbrains.cidr.cpp.execution.CidrExecutionUtil;
import com.jetbrains.cidr.cpp.execution.coverage.CMakeCoverageBuildOptionsInstallerFactory;
import com.jetbrains.cidr.cpp.execution.coverage.CMakeCoverageUtil;
import com.jetbrains.cidr.execution.coverage.CidrCoverageBundle;
import com.jetbrains.cidr.execution.coverage.CidrCoverageErrorProcessor;
import com.jetbrains.cidr.execution.coverage.CidrCoverageLogKt;
import com.jetbrains.cidr.execution.coverage.CidrCoverageUtil;
import com.jetbrains.cidr.lang.workspace.OCRunConfiguration;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001c\u0010\b\u001a\u00020\t2\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J(\u0010\r\u001a\u00020\t2\n\u0010\u000e\u001a\u00060\u000fj\u0002`\u00102\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J)\u0010\u0011\u001a\u00020\u00052\u000b\u0010\u0012\u001a\u00070\u0013\u00a2\u0006\u0002\b\u00142\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0014\u0010\u0015\u001a\u00020\u00132\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\nH\u0003J\u0014\u0010\u0016\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\nH\u0002J\u0018\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/cidr/cpp/execution/coverage/CMakeCoverageErrorProcessor;", "Lcom/jetbrains/cidr/execution/coverage/CidrCoverageErrorProcessor;", "<init>", "()V", "isAvailable", "", "configuration", "Lcom/intellij/execution/configurations/RunConfiguration;", "onCodeCoverageNotFound", "", "Lcom/intellij/execution/configurations/RunConfigurationBase;", "project", "Lcom/intellij/openapi/project/Project;", "onException", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "tryInstallCoverageOptions", "message", "", "Lorg/jetbrains/annotations/Nls;", "getFixMessageOnCoverageNotFound", "isCTestWithLLVMCodeCoverageExecution", "rerunCoverageCallback", "isCTestExecution", "doRerunCoverageCallback", "intellij.clion.coverage"})
public final class CMakeCoverageErrorProcessor
extends CidrCoverageErrorProcessor {
    public boolean isAvailable(@NotNull RunConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        return configuration instanceof CMakeAppRunConfiguration;
    }

    public void onCodeCoverageNotFound(@NotNull RunConfigurationBase<?> configuration, @NotNull Project project) {
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!this.tryInstallCoverageOptions(this.getFixMessageOnCoverageNotFound(configuration), configuration, project)) {
            super.onCodeCoverageNotFound(configuration, project);
            return;
        }
    }

    public void onException(@NotNull Exception exception, @NotNull RunConfigurationBase<?> configuration, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (exception instanceof ExecutionException) {
            if (this.isCTestWithLLVMCodeCoverageExecution(configuration)) {
                String string = CidrCoverageBundle.message((String)"coverage.not.found.ctest.fix", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                if (this.tryInstallCoverageOptions(string, configuration, project)) {
                    return;
                }
            }
            CidrCoverageLogKt.getCidrCoverageLog().warn("Coverage failed with error", (Throwable)exception);
            Object[] objectArray = new Object[]{exception.getMessage()};
            String string = CidrCoverageBundle.message((String)"coverage.message.with.configure", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            MessageType messageType = MessageType.ERROR;
            Intrinsics.checkNotNullExpressionValue((Object)messageType, (String)"ERROR");
            CidrCoverageUtil.Companion.showBalloon(string, messageType, arg_0 -> CMakeCoverageErrorProcessor.onException$lambda$0(project, arg_0), project);
            return;
        }
        super.onException(exception, configuration, project);
    }

    private final boolean tryInstallCoverageOptions(String message, RunConfigurationBase<?> configuration, Project project) {
        CMakeCoverageBuildOptionsInstallerFactory buildOptionsInstallerFactory = new CMakeCoverageBuildOptionsInstallerFactory();
        CMakeBuildOptionsInstaller buildOptionsInstaller = buildOptionsInstallerFactory.getInstaller(configuration);
        if (buildOptionsInstaller == null || !buildOptionsInstaller.canInstall(configuration, project)) {
            return false;
        }
        MessageType messageType = MessageType.ERROR;
        Intrinsics.checkNotNullExpressionValue((Object)messageType, (String)"ERROR");
        CidrCoverageUtil.Companion.showBalloon(message, messageType, arg_0 -> CMakeCoverageErrorProcessor.tryInstallCoverageOptions$lambda$0(buildOptionsInstaller, configuration, project, this, arg_0), project);
        return true;
    }

    @Nls
    private final String getFixMessageOnCoverageNotFound(RunConfigurationBase<?> configuration) {
        if (this.isCTestWithLLVMCodeCoverageExecution(configuration)) {
            String string = CidrCoverageBundle.message((String)"coverage.not.found.ctest.fix", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
        String string = CidrCoverageBundle.message((String)"coverage.not.found.auto.fix", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isCTestWithLLVMCodeCoverageExecution(RunConfigurationBase<?> configuration) {
        if (!CMakeCoverageUtil.Companion.isCTestConfiguration((RunConfiguration)configuration)) return false;
        Intrinsics.checkNotNull(configuration, (String)"null cannot be cast to non-null type com.jetbrains.cidr.lang.workspace.OCRunConfiguration<*, *>");
        if (!CidrExecutionUtil.compiledWithCompilerSwitches((OCRunConfiguration)((OCRunConfiguration)configuration), (List)ArraysKt.toList((Object[])CMakeCoverageUtil.Companion.getLLVM_COVERAGE_OPTIONS()))) return false;
        return true;
    }

    private final void rerunCoverageCallback(RunConfiguration configuration, Project project) {
        if (this.isCTestExecution(configuration) || !this.doRerunCoverageCallback(configuration, project)) {
            String string = CidrCoverageBundle.message((String)"coverage.auto.fix.manual.execution", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            MessageType messageType = MessageType.INFO;
            Intrinsics.checkNotNullExpressionValue((Object)messageType, (String)"INFO");
            CidrCoverageUtil.Companion.showBalloon(string, messageType, null, project);
        }
    }

    private final boolean isCTestExecution(RunConfiguration configuration) {
        return Intrinsics.areEqual((Object)configuration.getType().getId(), (Object)"CTestRunConfiguration");
    }

    private final boolean doRerunCoverageCallback(RunConfiguration configuration, Project project) {
        Executor executor = ExecutorRegistry.getInstance().getExecutorById("Coverage");
        if (executor == null) {
            return false;
        }
        Executor executor2 = executor;
        ExecutionTarget executionTarget = ExecutionTargetManager.getInstance((Project)project).getActiveTarget();
        Intrinsics.checkNotNullExpressionValue((Object)executionTarget, (String)"getActiveTarget(...)");
        ExecutionTarget activeTarget = executionTarget;
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = RunManager.Companion.getInstance(project).findConfigurationByName(configuration.getName());
        if (runnerAndConfigurationSettings == null) {
            return false;
        }
        RunnerAndConfigurationSettings configurationSettings = runnerAndConfigurationSettings;
        ExecutionEnvironmentBuilder executionEnvironmentBuilder = ExecutionUtil.createEnvironment((Executor)executor2, (RunnerAndConfigurationSettings)configurationSettings);
        if (executionEnvironmentBuilder == null || (executionEnvironmentBuilder = executionEnvironmentBuilder.target(activeTarget)) == null || (executionEnvironmentBuilder = ExecutionEnvironmentBuilder.build$default((ExecutionEnvironmentBuilder)executionEnvironmentBuilder, null, (int)1, null)) == null) {
            return false;
        }
        ExecutionEnvironmentBuilder environment = executionEnvironmentBuilder;
        environment.setExecutionId(new ExecutionEnvironment().assignNewExecutionId());
        environment.getRunner().execute((ExecutionEnvironment)environment);
        return true;
    }

    private static final void onException$lambda$0(Project $project, HyperlinkEvent event) {
        if (Intrinsics.areEqual((Object)event.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) {
            ShowSettingsUtil.getInstance().showSettingsDialog($project, CoverageOptionsConfigurable.class);
        }
    }

    private static final void tryInstallCoverageOptions$lambda$0(CMakeBuildOptionsInstaller $buildOptionsInstaller, RunConfigurationBase $configuration, Project $project, CMakeCoverageErrorProcessor this$0, HyperlinkEvent event) {
        if (Intrinsics.areEqual((Object)event.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED) && !$buildOptionsInstaller.install(() -> CMakeCoverageErrorProcessor.tryInstallCoverageOptions$lambda$0$0(this$0, $configuration, $project), $configuration, $project)) {
            CidrCoverageLogKt.getCidrCoverageLog().warn("Failed to add required flags automatically");
            String string = CidrCoverageBundle.message((String)"coverage.auto.fix.failed", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            MessageType messageType = MessageType.ERROR;
            Intrinsics.checkNotNullExpressionValue((Object)messageType, (String)"ERROR");
            CidrCoverageUtil.Companion.showBalloon(string, messageType, null, $project);
        }
    }

    private static final Unit tryInstallCoverageOptions$lambda$0$0(CMakeCoverageErrorProcessor this$0, RunConfigurationBase $configuration, Project $project) {
        this$0.rerunCoverageCallback((RunConfiguration)$configuration, $project);
        return Unit.INSTANCE;
    }
}

