/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing.tcatch;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.execution.testing.CidrTestFrameworkVersion;
import com.jetbrains.cidr.execution.testing.CidrTestIndexContributor;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.execution.testing.CidrTestScopeSerialization;
import com.jetbrains.cidr.execution.testing.CidrTestUtil;
import com.jetbrains.cidr.execution.testing.tcatch.CidrCatchTestElements;
import com.jetbrains.cidr.execution.testing.tcatch.CidrCatchTestFramework;
import com.jetbrains.cidr.execution.testing.tcatch.CidrCatchTestLinker;
import com.jetbrains.cidr.lang.daemon.OCGetSymbolVisitor;
import com.jetbrains.cidr.lang.parser.OCLexerTokenTypes;
import com.jetbrains.cidr.lang.psi.OCArgumentList;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCastExpression;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCLambdaExpression;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CidrCatchTestLinks {
    @NonNls
    static final String AUTO_REG = "AutoReg";
    @NonNls
    static final String AUTO_REG_TEMPLATE_TEST_VAR = "globalRegistrar";
    @NonNls
    static final String MAKE_TEST_INVOKER = "::Catch::makeTestInvoker";
    @NonNls
    static final String NAME_AND_TAGS = "NameAndTags";
    @NonNls
    static final String NAME_AND_DESC = "NameAndDesc";
    @NonNls
    static final String[] TEMPLATE_TEST_PREFIXES = new String[]{"____C_A_T_C_H____T_E_M_P_L_A_T_E____T_E_S_T____", "C_A_T_C_H_T_E_M_P_L_A_T_E_T_E_S_T", "CATCH2_INTERNAL_TEMPLATE_TEST_"};

    @NotNull
    public static Map<String, CidrTestScopeElement> createTestLinks(@NotNull PsiFile file) {
        if (file == null) {
            CidrCatchTestLinks.$$$reportNull$$$0(0);
        }
        assert (!CidrTestIndexContributor.indexTestsByClangOnly());
        final HashMap<String, CidrTestScopeElement> links = new HashMap<String, CidrTestScopeElement>();
        final Project project = file.getProject();
        final CidrCatchTestFramework testFramework = CidrCatchTestFramework.getInstance();
        final VirtualFile virtualFile = file.getVirtualFile();
        final boolean isRoot = testFramework.isPotentialTestHolderRoot(file.getProject()).value((Object)virtualFile);
        Processor<OCSymbol> processor = new Processor<OCSymbol>(){

            public boolean process(@NotNull OCSymbol symbol) {
                if (symbol == null) {
                    1.$$$reportNull$$$0(0);
                }
                ProgressManager.checkCanceled();
                if (!isRoot && !virtualFile.equals(symbol.getContainingFile())) {
                    return true;
                }
                PsiFile psiFile = symbol.getContainingPsiFile(project);
                if (psiFile == null || testFramework.getFrameworkVersion(psiFile) == CidrTestFrameworkVersion.NOT_AVAILABLE) {
                    return true;
                }
                if (CidrTestUtil.processNamespaceRecursively((OCSymbol)symbol, (Processor)this)) {
                    return true;
                }
                OCResolveContext context = OCResolveContext.forPsi((PsiElement)psiFile);
                if (symbol instanceof OCDeclaratorSymbol && symbol.getKind() == OCSymbolKind.GLOBAL_VARIABLE) {
                    OCDeclarator declarator;
                    OCCppNamespace declContainer;
                    if (symbol.getType().getName().endsWith(CidrCatchTestLinks.AUTO_REG)) {
                        List arguments;
                        OCArgumentList argumentList;
                        final OCDeclarator declarator2 = (OCDeclarator)symbol.locateDefinition(project);
                        if (declarator2 != null && (argumentList = declarator2.getArgumentList()) != null && !(arguments = argumentList.getArguments()).isEmpty()) {
                            List invokerArguments;
                            String maybeInvoker;
                            OCExpression testRef = (OCExpression)arguments.get(0);
                            if (testRef instanceof OCCallExpression && CidrCatchTestLinks.MAKE_TEST_INVOKER.equals(maybeInvoker = CidrCatchTestLinks.getFunctionName(((OCCallExpression)testRef).getFunctionReferenceExpression())) && !(invokerArguments = ((OCCallExpression)testRef).getArgumentList().getArguments()).isEmpty()) {
                                testRef = (OCExpression)invokerArguments.get(0);
                            }
                            if (testRef instanceof OCUnaryExpression) {
                                final String testQNameDecl = CidrTestUtil.getCanonicalNameFromSymbol((OCSymbolWithQualifiedName)((OCSymbolWithQualifiedName)symbol), (OCResolveContext)context);
                                final String testQNameBody = CidrCatchTestLinks.getFunctionName(((OCUnaryExpression)testRef).getOperand());
                                final long offsetAsNaturalOrder = symbol.getComplexOffset();
                                if (testQNameBody != null || testQNameDecl != null) {
                                    argumentList.accept((PsiElementVisitor)new OCRecursiveVisitor(){

                                        public void visitCastExpression(OCCastExpression expression) {
                                            if (CidrCatchTestLinks.NAME_AND_TAGS.equals(expression.getCastType().getName())) {
                                                OCCompoundInitializer initializer = expression.getCompoundInitializer();
                                                if (initializer != null) {
                                                    CidrCatchTestLinks.checkArguments(initializer.getInitializerExpressions(), links, declarator2.getContainingFile(), testQNameBody, testQNameDecl, offsetAsNaturalOrder, false);
                                                }
                                            } else {
                                                super.visitCastExpression(expression);
                                            }
                                        }

                                        public void visitCallExpression(OCCallExpression lexpression) {
                                            OCSymbol lsymbol = OCGetSymbolVisitor.getSymbol((OCExpression)lexpression.getFunctionReferenceExpression());
                                            if (lsymbol != null && CidrCatchTestLinks.NAME_AND_DESC.equals(lsymbol.getName())) {
                                                List arguments = lexpression.getArgumentList().getArguments();
                                                CidrCatchTestLinks.checkArguments(arguments, links, declarator2.getContainingFile(), testQNameBody, testQNameDecl, offsetAsNaturalOrder, false);
                                            }
                                        }
                                    });
                                }
                            }
                        }
                    } else if (symbol.getName().startsWith(CidrCatchTestLinks.AUTO_REG_TEMPLATE_TEST_VAR) && "int".equals(symbol.getType().getName()) && (declContainer = CidrCatchTestLinks.getDeclNamespace(declarator = (OCDeclarator)symbol.locateDefinition(project))) != null) {
                        final String testQNameDecl = CidrTestUtil.getCanonicalNameFromSymbol((OCSymbolWithQualifiedName)((OCSymbolWithQualifiedName)symbol), (OCResolveContext)context);
                        final long offsetAsNaturalOrder = symbol.getComplexOffset();
                        OCExpression initializer = declarator.getInitializer();
                        if (testQNameDecl != null && initializer instanceof OCCallExpression && initializer.getFirstChild() instanceof OCLambdaExpression && initializer.getFirstChild().getLastChild() instanceof OCBlockStatement) {
                            initializer.getFirstChild().getLastChild().accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

                                public void visitElement(@NotNull PsiElement elementInLambdaBlock) {
                                    if (elementInLambdaBlock == null) {
                                        2.$$$reportNull$$$0(0);
                                    }
                                    if (OCElementUtil.getElementType((PsiElement)elementInLambdaBlock) == OCLexerTokenTypes.IDENTIFIER) {
                                        final String className = elementInLambdaBlock.getText();
                                        if (className != null && ContainerUtil.exists((Object[])TEMPLATE_TEST_PREFIXES, pre -> className.startsWith((String)pre))) {
                                            this.stopWalking();
                                            declContainer.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

                                                public void visitElement(@NotNull PsiElement elementInDeclNamespace) {
                                                    if (elementInDeclNamespace == null) {
                                                        1.$$$reportNull$$$0(0);
                                                    }
                                                    if (elementInDeclNamespace instanceof OCStructLike && className.equals(((OCStructLike)elementInDeclNamespace).getName())) {
                                                        this.stopWalking();
                                                        elementInDeclNamespace.accept((PsiElementVisitor)new OCRecursiveVisitor(){

                                                            public void visitCastExpression(OCCastExpression expression) {
                                                                if (CidrCatchTestLinks.NAME_AND_TAGS.equals(expression.getCastType().getName())) {
                                                                    OCCompoundInitializer initializer = expression.getCompoundInitializer();
                                                                    if (initializer != null) {
                                                                        CidrCatchTestLinks.checkArguments(initializer.getInitializerExpressions(), links, declarator.getContainingFile(), null, testQNameDecl, offsetAsNaturalOrder, true);
                                                                    }
                                                                } else {
                                                                    super.visitCastExpression(expression);
                                                                }
                                                            }
                                                        });
                                                    } else {
                                                        super.visitElement(elementInDeclNamespace);
                                                    }
                                                }

                                                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementInDeclNamespace", "com/jetbrains/cidr/execution/testing/tcatch/CidrCatchTestLinks$1$2$1", "visitElement"));
                                                }
                                            });
                                        }
                                    } else {
                                        super.visitElement(elementInLambdaBlock);
                                    }
                                }

                                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementInLambdaBlock", "com/jetbrains/cidr/execution/testing/tcatch/CidrCatchTestLinks$1$2", "visitElement"));
                                }
                            });
                        }
                    }
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "com/jetbrains/cidr/execution/testing/tcatch/CidrCatchTestLinks$1", "process"));
            }
        };
        ReadAction.run(() -> CidrCatchTestLinks.lambda$createTestLinks$0(file, (Processor)processor));
        HashMap<String, CidrTestScopeElement> hashMap = links;
        if (hashMap == null) {
            CidrCatchTestLinks.$$$reportNull$$$0(1);
        }
        return hashMap;
    }

    /*
     * WARNING - void declaration
     */
    private static void checkArguments(@NotNull List<OCExpression> arguments, @NotNull Map<String, CidrTestScopeElement> links, @NotNull PsiFile pfile, @Nullable String testQNameBody, @Nullable String testQNameDecl, long offsetAsNaturalOrder, boolean bl) {
        if (arguments == null) {
            CidrCatchTestLinks.$$$reportNull$$$0(2);
        }
        if (links == null) {
            CidrCatchTestLinks.$$$reportNull$$$0(3);
        }
        if (pfile == null) {
            CidrCatchTestLinks.$$$reportNull$$$0(4);
        }
        if (!arguments.isEmpty()) {
            OCExpression nameExpression = arguments.get(0);
            OCExpression maybeTags = arguments.size() > 1 ? arguments.get(1) : null;
            final Ref maybeNameRef = Ref.create();
            nameExpression.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

                public void visitElement(@NotNull PsiElement elementInNameExpression) {
                    if (elementInNameExpression == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (elementInNameExpression instanceof OCLiteralExpression) {
                        this.stopWalking();
                        maybeNameRef.set((Object)((OCLiteralExpression)elementInNameExpression));
                    } else {
                        super.visitElement(elementInNameExpression);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementInNameExpression", "com/jetbrains/cidr/execution/testing/tcatch/CidrCatchTestLinks$2", "visitElement"));
                }
            });
            OCLiteralExpression maybeName = (OCLiteralExpression)maybeNameRef.get();
            if (maybeName != null && (maybeTags == null || maybeTags instanceof OCLiteralExpression)) {
                String suiteName;
                void stripParamsInTemplateTest;
                String testWithOrWithoutParams = maybeName.getUnescapedLiteralText();
                String testName = stripParamsInTemplateTest != false ? CidrCatchTestLinker.convertTemplateTestName((String)testWithOrWithoutParams) : testWithOrWithoutParams;
                String string = suiteName = maybeTags == null ? null : ((OCLiteralExpression)maybeTags).getUnescapedLiteralText();
                if (testQNameBody != null) {
                    links.put(testQNameBody, CidrTestScopeSerialization.createTestScopeElementForCaching((String)testName, (String)suiteName, (long)offsetAsNaturalOrder, (String)testQNameBody, (PsiFile)pfile, (OCSymbolKind)OCSymbolKind.FUNCTION_DECLARATION, (Function)CidrCatchTestElements.getGenerator()));
                }
                if (testQNameDecl != null) {
                    links.put(testQNameDecl, CidrTestScopeSerialization.createTestScopeElementForCaching((String)testName, (String)suiteName, (long)offsetAsNaturalOrder, (String)testQNameDecl, (PsiFile)pfile, (OCSymbolKind)OCSymbolKind.GLOBAL_VARIABLE, (Function)CidrCatchTestElements.getGenerator()));
                }
            }
        }
    }

    @Contract(value="null -> null")
    private static OCCppNamespace getDeclNamespace(@Nullable OCDeclarator declarator) {
        if (declarator == null) {
            return null;
        }
        if (declarator.getParent() != null && declarator.getParent().getParent() instanceof OCCppNamespace) {
            return (OCCppNamespace)declarator.getParent().getParent();
        }
        return null;
    }

    @Contract(value="null -> null")
    private static String getFunctionName(@Nullable OCExpression expression) {
        OCResolveContext context;
        OCSymbol symbol;
        if (expression instanceof OCReferenceExpression && (symbol = ((OCReferenceExpression)expression).resolveToSymbol(context = OCResolveContext.forPsi((PsiElement)expression))) instanceof OCSymbolWithQualifiedName && (symbol.getKind() == OCSymbolKind.FUNCTION_DECLARATION || symbol.getKind() == OCSymbolKind.FUNCTION_PREDECLARATION)) {
            return CidrTestUtil.getCanonicalNameFromSymbol((OCSymbolWithQualifiedName)((OCSymbolWithQualifiedName)symbol), (OCResolveContext)context);
        }
        return null;
    }

    private static /* synthetic */ void lambda$createTestLinks$0(PsiFile file, Processor processor) throws RuntimeException {
        OCResolveUtil.processGlobalSymbols(null, (PsiElement)file, (Processor)processor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/testing/tcatch/CidrCatchTestLinks";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "links";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pfile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/testing/tcatch/CidrCatchTestLinks";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createTestLinks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createTestLinks";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkArguments";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

