/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n23#3:393\n23#3:394\n23#3:395\n23#3:396\n23#3:397\n23#3:398\n23#3:399\n23#3:400\n23#3:401\n23#3:402\n23#3:403\n23#3:404\n23#3:405\n23#3:406\n23#3:407\n23#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 78317111107742L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(-1617534870 + -1318, -1617534870 + -12918, (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-1617534870 + -1317, 1617534870 - 1697, (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 33047239678720L;
                thread = Thread.currentThread();
                int n2 = SshAgentIpcService.c();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (n2 != 0) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl2 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(1761318660 - 13868, 1761318660 - 14808, (int)l2) + string + WindowsNamedPipeAgentIpc.b(1761318660 - 13867, -1761318660 - -25928, (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(1761318660 - 13862, 1761318660 - 25739, (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        int n2;
        long l2;
        block14: {
            block15: {
                l2 = 134317483628144L;
                Object object = this.lock;
                synchronized (object) {
                    boolean bl;
                    n2 = SshAgentIpcService.A();
                    boolean bl2 = false;
                    try {
                        bl = this.connectionThread == null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl3 = false;
                        String string = WindowsNamedPipeAgentIpc.b(971359770 + 26517, -971359770 + -17190, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(971359770 + 26514, -971359770 + -30843, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.connectionThread = Thread.currentThread();
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    try {
                        WinNT.HANDLE hANDLE = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(971359770 + 26515, 971359770 + (char)-30464, (int)l2));
                        this.hPipe = hANDLE;
                        windowsNamedPipeAgentIpc = this;
                        if (n2 == 0) break block14;
                        if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                        }
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    throw new RuntimeException(WindowsNamedPipeAgentIpc.b(971359770 + 26504, 971359770 + 20633, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(971359770 + 26505, -971359770 + -24017, (int)l2) + ErrorToolsKt.kernel32LastError());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            this.state = NamedPipeState.Open;
            windowsNamedPipeAgentIpc = this;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
        boolean bl = false;
        try {
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(971359770 + 26502, -971359770 + -15501, (int)l2));
            logger.info(WindowsNamedPipeAgentIpc.b(971359770 + 26504, 971359770 + 20633, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(971359770 + 26503, 971359770 + (char)-26796, (int)l2));
            if (ActionTimestamp.A() != null) {
                SshAgentIpcService.A(++n2);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                int n3;
                block6: {
                    long l2 = 94779470948426L;
                    n3 = SshAgentIpcService.A();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (n3 == 0) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (n3 == 0) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        Object object;
        Object object2;
        int n2;
        long l2;
        block27: {
            block28: {
                l2 = 46137768735454L;
                this.assertConnectionThread();
                Object object3 = this.lock;
                n2 = SshAgentIpcService.A();
                synchronized (object3) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block25: {
                        block26: {
                            boolean bl2 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (n2 == 0) break block25;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block26;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1230091950 - (char)-4698, -1230091950 - -((char)-16808), (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(1230091950 - (char)-4702, 1230091950 - (char)-15215, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1230091950 - (char)-4699, -1229960880 + -((char)-8709), (int)l2) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(1230091950 - (char)-4702, 1230091950 - (char)-15215, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1230091950 - (char)-4700, 1229960880 + (char)-13578, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1230091950 - (char)-4698, -1230091950 - -((char)-16808), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(1230091950 - (char)-4702, 1230091950 - (char)-15215, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1230091950 - (char)-4701, -1229960880 + -((char)-3279), (int)l2));
                    object2 = Kernel32.INSTANCE;
                    if (n2 == 0) break block27;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block28;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n3 = Kernel32.INSTANCE.GetLastError();
                if (n3 == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl5 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1230091950 - (char)-4698, -1230091950 - -((char)-16808), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(1230091950 - (char)-4702, 1230091950 - (char)-15215, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1230091950 - (char)-4710, -1230091950 - -((char)-17268), (int)l2));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(1230091950 - (char)-4702, 1230091950 - (char)-15215, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1230091950 - (char)-4711, -1229960880 + -((char)-11063), (int)l2) + ErrorToolsKt.prettyHRESULT((int)n3)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block29: {
                block30: {
                    boolean bl6 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (n2 == 0) break block29;
                    try {
                        block31: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block30;
                            break block31;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl) {
                boolean bl7 = false;
                String string = WindowsNamedPipeAgentIpc.b(1230091950 - (char)-4702, 1230091950 - (char)-15215, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1230091950 - (char)-4700, 1229960880 + (char)-13578, (int)l2) + this.state;
                throw new IllegalArgumentException(string.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1230091950 - (char)-4698, -1230091950 - -((char)-16808), (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(1230091950 - (char)-4702, 1230091950 - (char)-15215, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1230091950 - (char)-4712, -1230091950 - -((char)-7613), (int)l2));
        long l3 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        try {
            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                final /* synthetic */ PipeReadableByteChannel $read;
                final /* synthetic */ PipeWritableByteChannel $write;
                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                private static final String[] a;
                private static final String[] b;
                {
                    this.$read = $read;
                    this.$write = $write;
                    this.this$0 = $receiver;
                }

                public InputStream getInputStream() {
                    long l2 = 106180734624449L;
                    InputStream inputStream = Channels.newInputStream(this.$read);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(-553115400 + -27574, 553115400 + (char)-27497, (int)l2));
                    return inputStream;
                }

                public OutputStream getOutputStream() {
                    long l2 = 29603342106673L;
                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(1867485360 - 14589, 1867485360 - 26853, (int)l2));
                    return outputStream;
                }

                public void close() {
                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                }

                /*
                 * Unable to fully structure code
                 */
                static {
                    block13: {
                        var5 = new String[2];
                        var3_1 = 0;
                        var2_2 = "ql\u00acl`\u0005Hy\u008f\u00f7\u00dbc\u00beZa\u00aby\u00d1\u00ef\u0014\\=\t@\u00cfB\u00c0\u0014\u001c\\l\u00c2\u008a\u0097&\u0099|QHp";
                        var4_3 = "ql\u00acl`\u0005Hy\u008f\u00f7\u00dbc\u00beZa\u00aby\u00d1\u00ef\u0014\\=\t@\u00cfB\u00c0\u0014\u001c\\l\u00c2\u008a\u0097&\u0099|QHp".length();
                        var1_4 = 19;
                        var0_5 = -1;
lbl7:
                        // 2 sources

                        while (true) {
                            continue;
                            break;
                        }
lbl9:
                        // 1 sources

                        while (true) {
                            var5[var3_1++] = new String(v0).intern();
                            if ((var0_5 += var1_4) < var4_3) {
                                var1_4 = var2_2.charAt(var0_5);
                                ** continue;
                            }
                            break block13;
                            break;
                        }
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                        v3 = v2.length;
                        var6_6 = 0;
                        v4 = 118;
                        v5 = v2;
                        v6 = v3;
                        if (v3 > 1) ** GOTO lbl67
                        do {
                            v7 = v4;
                            v5 = v5;
                            v8 = v5;
                            v9 = v4;
                            v10 = var6_6;
                            while (true) {
                                switch (var6_6 % 7) {
                                    case 0: {
                                        v11 = 7;
                                        break;
                                    }
                                    case 1: {
                                        v11 = 30;
                                        break;
                                    }
                                    case 2: {
                                        v11 = 14;
                                        break;
                                    }
                                    case 3: {
                                        v11 = 26;
                                        break;
                                    }
                                    case 4: {
                                        v11 = 123;
                                        break;
                                    }
                                    case 5: {
                                        v11 = 99;
                                        break;
                                    }
                                    default: {
                                        v11 = 69;
                                    }
                                }
                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                ++var6_6;
                                v4 = v7;
                                if (v7 != 0) break;
                                v7 = v4;
                                v5 = v5;
                                v10 = v4;
                                v8 = v5;
                                v9 = v4;
                            }
lbl67:
                            // 2 sources

                            v0 = v5;
                            v6 = v6;
                        } while (v6 > var6_6);
                        ** while (true)
                    }
                    accept.3.a = var5;
                    accept.3.b = new String[2];
                }

                private static String a(int n2, int n3, int n4) {
                    int n5 = (n2 ^ n4 ^ 0xFFFF9783) & 0xFFFF;
                    if (b[n5] == null) {
                        int n6;
                        char[] cArray = a[n5].toCharArray();
                        int n7 = switch (cArray[0] & 0xFF) {
                            case 0 -> 240;
                            case 1 -> 99;
                            case 2 -> 202;
                            case 3 -> 190;
                            case 4 -> 136;
                            case 5 -> 140;
                            case 6 -> 145;
                            case 7 -> 235;
                            case 8 -> 111;
                            case 9 -> 37;
                            case 10 -> 35;
                            case 11 -> 90;
                            case 12 -> 58;
                            case 13 -> 124;
                            case 14 -> 11;
                            case 15 -> 45;
                            case 16 -> 49;
                            case 17 -> 29;
                            case 18 -> 33;
                            case 19 -> 96;
                            case 20 -> 5;
                            case 21 -> 242;
                            case 22 -> 231;
                            case 23 -> 72;
                            case 24 -> 228;
                            case 25 -> 119;
                            case 26 -> 201;
                            case 27 -> 25;
                            case 28 -> 155;
                            case 29 -> 253;
                            case 30 -> 217;
                            case 31 -> 244;
                            case 32 -> 19;
                            case 33 -> 199;
                            case 34 -> 148;
                            case 35 -> 198;
                            case 36 -> 188;
                            case 37 -> 218;
                            case 38 -> 113;
                            case 39 -> 4;
                            case 40 -> 2;
                            case 41 -> 104;
                            case 42 -> 241;
                            case 43 -> 74;
                            case 44 -> 182;
                            case 45 -> 183;
                            case 46 -> 67;
                            case 47 -> 229;
                            case 48 -> 79;
                            case 49 -> 214;
                            case 50 -> 239;
                            case 51 -> 236;
                            case 52 -> 203;
                            case 53 -> 204;
                            case 54 -> 120;
                            case 55 -> 38;
                            case 56 -> 166;
                            case 57 -> 237;
                            case 58 -> 10;
                            case 59 -> 135;
                            case 60 -> 7;
                            case 61 -> 172;
                            case 62 -> 6;
                            case 63 -> 115;
                            case 64 -> 14;
                            case 65 -> 144;
                            case 66 -> 139;
                            case 67 -> 127;
                            case 68 -> 250;
                            case 69 -> 82;
                            case 70 -> 170;
                            case 71 -> 80;
                            case 72 -> 112;
                            case 73 -> 177;
                            case 74 -> 110;
                            case 75 -> 13;
                            case 76 -> 41;
                            case 77 -> 232;
                            case 78 -> 126;
                            case 79 -> 249;
                            case 80 -> 71;
                            case 81 -> 212;
                            case 82 -> 157;
                            case 83 -> 174;
                            case 84 -> 56;
                            case 85 -> 48;
                            case 86 -> 23;
                            case 87 -> 83;
                            case 88 -> 8;
                            case 89 -> 39;
                            case 90 -> 116;
                            case 91 -> 106;
                            case 92 -> 251;
                            case 93 -> 224;
                            case 94 -> 66;
                            case 95 -> 103;
                            case 96 -> 32;
                            case 97 -> 196;
                            case 98 -> 61;
                            case 99 -> 123;
                            case 100 -> 146;
                            case 101 -> 54;
                            case 102 -> 246;
                            case 103 -> 247;
                            case 104 -> 98;
                            case 105 -> 161;
                            case 106 -> 221;
                            case 107 -> 154;
                            case 108 -> 31;
                            case 109 -> 137;
                            case 110 -> 176;
                            case 111 -> 86;
                            case 112 -> 118;
                            case 113 -> 3;
                            case 114 -> 206;
                            case 115 -> 18;
                            case 116 -> 117;
                            case 117 -> 194;
                            case 118 -> 165;
                            case 119 -> 16;
                            case 120 -> 24;
                            case 121 -> 30;
                            case 122 -> 125;
                            case 123 -> 255;
                            case 124 -> 107;
                            case 125 -> 46;
                            case 126 -> 91;
                            case 127 -> 151;
                            case 128 -> 159;
                            case 129 -> 130;
                            case 130 -> 220;
                            case 131 -> 173;
                            case 132 -> 64;
                            case 133 -> 150;
                            case 134 -> 0;
                            case 135 -> 254;
                            case 136 -> 233;
                            case 137 -> 209;
                            case 138 -> 147;
                            case 139 -> 128;
                            case 140 -> 134;
                            case 141 -> 207;
                            case 142 -> 133;
                            case 143 -> 213;
                            case 144 -> 97;
                            case 145 -> 27;
                            case 146 -> 108;
                            case 147 -> 102;
                            case 148 -> 100;
                            case 149 -> 163;
                            case 150 -> 215;
                            case 151 -> 42;
                            case 152 -> 142;
                            case 153 -> 205;
                            case 154 -> 69;
                            case 155 -> 1;
                            case 156 -> 189;
                            case 157 -> 114;
                            case 158 -> 211;
                            case 159 -> 55;
                            case 160 -> 178;
                            case 161 -> 208;
                            case 162 -> 36;
                            case 163 -> 234;
                            case 164 -> 17;
                            case 165 -> 185;
                            case 166 -> 197;
                            case 167 -> 143;
                            case 168 -> 50;
                            case 169 -> 101;
                            case 170 -> 34;
                            case 171 -> 184;
                            case 172 -> 225;
                            case 173 -> 59;
                            case 174 -> 186;
                            case 175 -> 227;
                            case 176 -> 70;
                            case 177 -> 156;
                            case 178 -> 87;
                            case 179 -> 181;
                            case 180 -> 122;
                            case 181 -> 47;
                            case 182 -> 129;
                            case 183 -> 20;
                            case 184 -> 164;
                            case 185 -> 210;
                            case 186 -> 121;
                            case 187 -> 141;
                            case 188 -> 152;
                            case 189 -> 216;
                            case 190 -> 180;
                            case 191 -> 78;
                            case 192 -> 92;
                            case 193 -> 245;
                            case 194 -> 63;
                            case 195 -> 193;
                            case 196 -> 192;
                            case 197 -> 60;
                            case 198 -> 168;
                            case 199 -> 68;
                            case 200 -> 28;
                            case 201 -> 230;
                            case 202 -> 81;
                            case 203 -> 22;
                            case 204 -> 160;
                            case 205 -> 162;
                            case 206 -> 131;
                            case 207 -> 65;
                            case 208 -> 88;
                            case 209 -> 93;
                            case 210 -> 43;
                            case 211 -> 53;
                            case 212 -> 187;
                            case 213 -> 222;
                            case 214 -> 15;
                            case 215 -> 195;
                            case 216 -> 21;
                            case 217 -> 75;
                            case 218 -> 105;
                            case 219 -> 57;
                            case 220 -> 223;
                            case 221 -> 149;
                            case 222 -> 109;
                            case 223 -> 73;
                            case 224 -> 62;
                            case 225 -> 175;
                            case 226 -> 167;
                            case 227 -> 76;
                            case 228 -> 95;
                            case 229 -> 84;
                            case 230 -> 248;
                            case 231 -> 12;
                            case 232 -> 44;
                            case 233 -> 77;
                            case 234 -> 9;
                            case 235 -> 51;
                            case 236 -> 200;
                            case 237 -> 252;
                            case 238 -> 179;
                            case 239 -> 40;
                            case 240 -> 132;
                            case 241 -> 138;
                            case 242 -> 94;
                            case 243 -> 153;
                            case 244 -> 169;
                            case 245 -> 158;
                            case 246 -> 89;
                            case 247 -> 243;
                            case 248 -> 26;
                            case 249 -> 191;
                            case 250 -> 226;
                            case 251 -> 85;
                            case 252 -> 52;
                            case 253 -> 238;
                            case 254 -> 171;
                            default -> 219;
                        };
                        int n8 = ((n3 ^= n4) & 0xFF) - n7;
                        if (n8 < 0) {
                            n8 += 256;
                        }
                        if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                            n6 += 256;
                        }
                        int n9 = 0;
                        while (n9 < cArray.length) {
                            int n10 = n9 % 2;
                            int n11 = n9;
                            char[] cArray2 = cArray;
                            char c2 = cArray[n11];
                            if (n10 == 0) {
                                cArray2[n11] = (char)(c2 ^ n8);
                                n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                            } else {
                                cArray2[n11] = (char)(c2 ^ n6);
                                n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                            }
                            ++n9;
                        }
                        accept.3.b[n5] = new String(cArray).intern();
                    }
                    return b[n5];
                }
            };
            if (n2 == 0) {
                ActionTimestamp.A(new String[2]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 74832602796965L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    int n3 = SshAgentIpcService.c();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (n3 != 0) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1387638090 - (char)-31529, -1387638090 - -((char)-27621), (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(1387638090 - (char)-31533, 1387638090 - (char)-26140, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(1387638090 - (char)-31522, 1387638090 - 14902, (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n4 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1387638090 - (char)-31529, -1387638090 - -((char)-27621), (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(1387638090 - (char)-31533, 1387638090 - (char)-26140, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(1387638090 - (char)-31521, -1387638090 - -17861, (int)l3) + ErrorToolsKt.prettyHRESULT((int)n4));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    int n2;
                    block13: {
                        long l2 = 49268249737294L;
                        int n3 = SshAgentIpcService.A();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(679860090 + 11271, -679860090 + -32451, (int)l2));
                        n2 = n3;
                        try {
                            try {
                                try {
                                    try {
                                        if (n2 == 0 || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (n2 == 0) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(679860090 + 11272, -679860090 + -((char)-26889), (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (n2 == 0) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        int n2;
        long l2;
        block25: {
            block26: {
                l2 = 20268876401781L;
                this.assertConnectionThread();
                Object object2 = this.lock;
                synchronized (object2) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    n2 = SshAgentIpcService.A();
                                    boolean bl2 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (n2 == 0) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (n2 == 0) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(925747410 - 4399, -925747410 - -16851, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(925747410 - 4395, 925747410 - 15388, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(925747410 - 4378, 925747410 - 12818, (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(925747410 - 4395, 925747410 - 15388, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(925747410 - 4401, 925747410 + 13883, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(925747410 - 4399, -925747410 - -16851, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(925747410 - 4395, 925747410 - 15388, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(925747410 - 4379, -925747410 - -3138, (int)l2));
                    object = Kernel32.INSTANCE;
                    if (n2 == 0) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(925747410 - 4399, -925747410 - -16851, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(925747410 - 4395, 925747410 - 15388, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(925747410 - 4380, 925747410 - 14946, (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (n2 == 0) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(925747410 - 4399, -925747410 - -16851, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(925747410 - 4395, 925747410 - 15388, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(925747410 - 4381, 925747410 - 15113, (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                int n3;
                block16: {
                    l2 = 5253333384434L;
                    Object object = this.lock;
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                n3 = SshAgentIpcService.A();
                                boolean bl2 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (n3 == 0) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl3 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(588373230 - 5578, -588373230 + -6540, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(588373230 - 5582, 588373230 + 8003, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(588373230 - 5563, 588373230 + 3537, (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(588373230 - 5562, 588373230 - 15469, (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(588373230 - 5578, -588373230 + -6540, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(588373230 - 5582, 588373230 + 8003, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(588373230 - 5561, -588373230 - -15703, (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (n3 == 0) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (n3 == 0) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n4 = n2;
                    if (n4 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl4 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(588373230 - 5578, -588373230 + -6540, (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(588373230 - 5582, 588373230 + 8003, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(588373230 - 5560, -588373230 - -16516, (int)l2) + ErrorToolsKt.prettyHRESULT((int)n4));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(588373230 - 5578, -588373230 + -6540, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(588373230 - 5582, 588373230 + 8003, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(588373230 - 5559, 588373230 - 11744, (int)l2));
                    if (n3 == 0) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(588373230 - 5578, -588373230 + -6540, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(588373230 - 5582, 588373230 + 8003, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(588373230 - 5606, 588373230 + 8290, (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(588373230 - 5605, 588373230 - 3987, (int)l2));
            this.hPipe = hANDLE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[34];
                var3_1 = 0;
                var2_2 = "\r\u00e5\u00a2xh\u0088\u00e8\u008f\u0014\u00cd\u00a7\u0082\u00d7\u0092\u00f5\u0018:\u00e2\u00bf\u00b6\u00c82[g\u00b5\u0014\u0083\u00ac\u00df\u0006\\=\u0088cG\u00aa\u0018\u00e2\u0018\u0007\u0010\u00a0\u00c8\\]\u00a2.\u00b1\u008a\u00b4\u00ec\u00e5\u00c1\u00edd\u00bd\u00be\u00c1\u0006\u00c39\t-/`G'\u00bd\u00b4\u00bb\u0083\u0005\u00e9\u001e>\u0007\u008b\bs\u00abm\u00c0\u00c3\u00b9\u009bK\u0014z&\f|.\u0088\u00ba\u0002\u00d8eZ'\u00e5\u0005&\u0093.\u0094\u0012\u007f\u0005 d\u0007H\u00ac\u001e(\u008b\u0013\u00d1\u00b34\u009c\u00b8\u001f\u0086M\u0018g\u009e=\u00eb\u0017\u00b00\u00d0\u00dc\u00e4l\u00a80\u008f\u00b6i#\u00f7\u0010\u00afu\u0007\u00cbfE\u00d0o\u00eb\u00ce^\u00ec\u0003U\u001e\r\t\u00f9\u00a0,\u00a7\u00fd\u0086\u00c9C\u00c2\u0010\u0017\u008c\u0010\u00f4\u0084\u00a2\u008c\u0093`Q/\u001f-+\u00db\u00c2?\u0006\u0010\u00de\u00a2\u0007S\u008f8\fGj\u00db<\u0010k\u0003\u0018\u00c8\u00ac\u001a\u00c1\u00ef\u00b4\u00af;\u0087\u00da\u00dc\u0099\u0017\u00b9Q\u0087Zs\u0090\u0099\u00f4\u00a5\u00af\u0014\u0095\u00f3\u0092\u0012\u0094\u009cj\u00fam}\u008e \u00bc\u0096\f\u00b3|+\u0016\u00f9\u00c53\b;0d\u00b3\u00e2\u00d7\u00bf\u0086\f\u00de\u00c7\u00c8Vj\t@Z\u00d0 k5F\u00cf\u00c0\u00ea\u00b6.\u0015\u00c8\u00d9\u00c1\\C~\u008f\u00ac\u0002\u00b2\u00c9\u0099\u0096\u009f\u0094\r\u001d\u00c18aI\u000bT\u00c4:\u0017\u00cb$8~*dxy<Z}\u0090\u001dQ)\u00af\u00ab-1,F~LOw`%)\u000bK18k\u00ae\u0011F'\"\u001fc\nz\u00e1\u009e29x\u00ab\u009e\u00db\u001b\u00b5\u00e3l\u00f5F\u009bg\u007f\u00fd\u0091\u009f\u00ad/\u00ffB\u00ab\u00a0^\u00a6\u000b\u00ad?\u00a6I\u00a7\u00ea\u00f9&\u00e7\u00a3\u0087\u0015\u00b3\u00e4e1\u00d8\u008d\u00fa\u00b7\u00b9q\u0084-\u00e0\u0089\u00db\u00eeKl\u001b\u00f8D)X\u0083\u001d\u00d0r\u0014\u00a4\u00bc\u0018\u0006\u00ad\b\u007f\u008b\u00ab\u00fd\u00e1\u0012H\u00e9\u00e8;\u00fb\u00e0\u00cc\u001f\u00e9\u00cf\u00fa&ou\u009f\u00cd\u00d4\u00ce\u00a9o\u0083\u00b1\u00e0\u0007<,\u009b?\u0086\u00b4\u00a1\u0007\u0098nk\u001b\u007f\u00df\u0088(\u007f\u0085\u00b51\u00d7B\u00e6Q l\u0080s\u00f9e9\u00a3\u00b4tLf\t\u00f4\u00a8\u00d26\u00e5\u0000\u00eb\u00f0\u00c2\u00f5\u00f07\u0016_\u0018b\u00c8i\u00b6\u000fM\u0093\u00bd\u00da>S~\u00b0F\u00dd\u00ed\u0014\u00f4\u00dd\u0006\"ut\u00b8.\u00c6\u00cb2G\u00cay\u00f7\u00e77z\u00c6\r\u00a7%\nMJ\u00af\u000f\"\u00c1\u0013\u0085\u0090S\u00ff\u00f8IC\u00b9\u000e6\u00f9\u00d2\u0097\u00d3\u00fa\u00c3\u0085\u00f1{\u001b\u00c0&M\u001b\u0084\u00cb\u0083\u00d4\u0002'lbS\u0000\u00c2\u00aeM\u00b6\u00af\u0082\"~\u0007\u00ba\u00d0e/\u00dd\u008e\u00819\n\u0090\u00f5\u00c5\u0014\u00de\u00db$\u00d7\u00f1\u00d4\u0018\u00c5\u00c0\u00ab\u00b8\u0006\u0016\u00cd\u001ay\u00c6E\u00e9\u0004\rz\u00d4\u00ef\u00b5i\u00bae.\u00c2\u00e7)\u00afl\u00e3-\u00ad\u00ab_Kg\u00f8B\u00d7\u0086y\u000b\u00d8\u008b\u00c3\u00da\u0016\u0080\u00d4\u00bf\u00111\u00b3\u00cb\u00b6\u00edU6\u008a\u0091\u00ec\u00c0~\u00f5]\b\u00f7\u0091\t9\u008a4\u00fc\u00f4\"\u00be\u008c\u0091";
                var4_3 = "\r\u00e5\u00a2xh\u0088\u00e8\u008f\u0014\u00cd\u00a7\u0082\u00d7\u0092\u00f5\u0018:\u00e2\u00bf\u00b6\u00c82[g\u00b5\u0014\u0083\u00ac\u00df\u0006\\=\u0088cG\u00aa\u0018\u00e2\u0018\u0007\u0010\u00a0\u00c8\\]\u00a2.\u00b1\u008a\u00b4\u00ec\u00e5\u00c1\u00edd\u00bd\u00be\u00c1\u0006\u00c39\t-/`G'\u00bd\u00b4\u00bb\u0083\u0005\u00e9\u001e>\u0007\u008b\bs\u00abm\u00c0\u00c3\u00b9\u009bK\u0014z&\f|.\u0088\u00ba\u0002\u00d8eZ'\u00e5\u0005&\u0093.\u0094\u0012\u007f\u0005 d\u0007H\u00ac\u001e(\u008b\u0013\u00d1\u00b34\u009c\u00b8\u001f\u0086M\u0018g\u009e=\u00eb\u0017\u00b00\u00d0\u00dc\u00e4l\u00a80\u008f\u00b6i#\u00f7\u0010\u00afu\u0007\u00cbfE\u00d0o\u00eb\u00ce^\u00ec\u0003U\u001e\r\t\u00f9\u00a0,\u00a7\u00fd\u0086\u00c9C\u00c2\u0010\u0017\u008c\u0010\u00f4\u0084\u00a2\u008c\u0093`Q/\u001f-+\u00db\u00c2?\u0006\u0010\u00de\u00a2\u0007S\u008f8\fGj\u00db<\u0010k\u0003\u0018\u00c8\u00ac\u001a\u00c1\u00ef\u00b4\u00af;\u0087\u00da\u00dc\u0099\u0017\u00b9Q\u0087Zs\u0090\u0099\u00f4\u00a5\u00af\u0014\u0095\u00f3\u0092\u0012\u0094\u009cj\u00fam}\u008e \u00bc\u0096\f\u00b3|+\u0016\u00f9\u00c53\b;0d\u00b3\u00e2\u00d7\u00bf\u0086\f\u00de\u00c7\u00c8Vj\t@Z\u00d0 k5F\u00cf\u00c0\u00ea\u00b6.\u0015\u00c8\u00d9\u00c1\\C~\u008f\u00ac\u0002\u00b2\u00c9\u0099\u0096\u009f\u0094\r\u001d\u00c18aI\u000bT\u00c4:\u0017\u00cb$8~*dxy<Z}\u0090\u001dQ)\u00af\u00ab-1,F~LOw`%)\u000bK18k\u00ae\u0011F'\"\u001fc\nz\u00e1\u009e29x\u00ab\u009e\u00db\u001b\u00b5\u00e3l\u00f5F\u009bg\u007f\u00fd\u0091\u009f\u00ad/\u00ffB\u00ab\u00a0^\u00a6\u000b\u00ad?\u00a6I\u00a7\u00ea\u00f9&\u00e7\u00a3\u0087\u0015\u00b3\u00e4e1\u00d8\u008d\u00fa\u00b7\u00b9q\u0084-\u00e0\u0089\u00db\u00eeKl\u001b\u00f8D)X\u0083\u001d\u00d0r\u0014\u00a4\u00bc\u0018\u0006\u00ad\b\u007f\u008b\u00ab\u00fd\u00e1\u0012H\u00e9\u00e8;\u00fb\u00e0\u00cc\u001f\u00e9\u00cf\u00fa&ou\u009f\u00cd\u00d4\u00ce\u00a9o\u0083\u00b1\u00e0\u0007<,\u009b?\u0086\u00b4\u00a1\u0007\u0098nk\u001b\u007f\u00df\u0088(\u007f\u0085\u00b51\u00d7B\u00e6Q l\u0080s\u00f9e9\u00a3\u00b4tLf\t\u00f4\u00a8\u00d26\u00e5\u0000\u00eb\u00f0\u00c2\u00f5\u00f07\u0016_\u0018b\u00c8i\u00b6\u000fM\u0093\u00bd\u00da>S~\u00b0F\u00dd\u00ed\u0014\u00f4\u00dd\u0006\"ut\u00b8.\u00c6\u00cb2G\u00cay\u00f7\u00e77z\u00c6\r\u00a7%\nMJ\u00af\u000f\"\u00c1\u0013\u0085\u0090S\u00ff\u00f8IC\u00b9\u000e6\u00f9\u00d2\u0097\u00d3\u00fa\u00c3\u0085\u00f1{\u001b\u00c0&M\u001b\u0084\u00cb\u0083\u00d4\u0002'lbS\u0000\u00c2\u00aeM\u00b6\u00af\u0082\"~\u0007\u00ba\u00d0e/\u00dd\u008e\u00819\n\u0090\u00f5\u00c5\u0014\u00de\u00db$\u00d7\u00f1\u00d4\u0018\u00c5\u00c0\u00ab\u00b8\u0006\u0016\u00cd\u001ay\u00c6E\u00e9\u0004\rz\u00d4\u00ef\u00b5i\u00bae.\u00c2\u00e7)\u00afl\u00e3-\u00ad\u00ab_Kg\u00f8B\u00d7\u0086y\u000b\u00d8\u008b\u00c3\u00da\u0016\u0080\u00d4\u00bf\u00111\u00b3\u00cb\u00b6\u00edU6\u008a\u0091\u00ec\u00c0~\u00f5]\b\u00f7\u0091\t9\u008a4\u00fc\u00f4\"\u00be\u008c\u0091".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 86;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u0084'\u00d9\u001b\u00b52\u0003'\u00b3*\u0087\u00d2a\u0086\u00a8x\u00a0\u0084\u00b0%\u00c7\u00d2\u00fbPM\u00d8\u008a\u00c1\n\u0014\u00989w[s;{\u00bc\u00d10\u008ffJ\u00d17\u00bbA\u001dYS";
                    var4_3 = "\u0084'\u00d9\u001b\u00b52\u0003'\u00b3*\u0087\u00d2a\u0086\u00a8x\u00a0\u0084\u00b0%\u00c7\u00d2\u00fbPM\u00d8\u008a\u00c1\n\u0014\u00989w[s;{\u00bc\u00d10\u008ffJ\u00d17\u00bbA\u001dYS".length();
                    var1_4 = 29;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 39;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 45;
                            break;
                        }
                        case 1: {
                            v15 = 51;
                            break;
                        }
                        case 2: {
                            v15 = 52;
                            break;
                        }
                        case 3: {
                            v15 = 31;
                            break;
                        }
                        case 4: {
                            v15 = 8;
                            break;
                        }
                        case 5: {
                            v15 = 80;
                            break;
                        }
                        default: {
                            v15 = 86;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[34];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0x3BDA) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 176;
                case 1 -> 40;
                case 2 -> 15;
                case 3 -> 169;
                case 4 -> 145;
                case 5 -> 160;
                case 6 -> 97;
                case 7 -> 9;
                case 8 -> 233;
                case 9 -> 125;
                case 10 -> 18;
                case 11 -> 37;
                case 12 -> 46;
                case 13 -> 218;
                case 14 -> 209;
                case 15 -> 99;
                case 16 -> 62;
                case 17 -> 138;
                case 18 -> 52;
                case 19 -> 1;
                case 20 -> 178;
                case 21 -> 109;
                case 22 -> 90;
                case 23 -> 127;
                case 24 -> 55;
                case 25 -> 130;
                case 26 -> 3;
                case 27 -> 153;
                case 28 -> 137;
                case 29 -> 5;
                case 30 -> 163;
                case 31 -> 227;
                case 32 -> 98;
                case 33 -> 80;
                case 34 -> 11;
                case 35 -> 197;
                case 36 -> 41;
                case 37 -> 123;
                case 38 -> 107;
                case 39 -> 213;
                case 40 -> 230;
                case 41 -> 120;
                case 42 -> 143;
                case 43 -> 79;
                case 44 -> 135;
                case 45 -> 240;
                case 46 -> 94;
                case 47 -> 241;
                case 48 -> 181;
                case 49 -> 157;
                case 50 -> 182;
                case 51 -> 146;
                case 52 -> 67;
                case 53 -> 186;
                case 54 -> 249;
                case 55 -> 6;
                case 56 -> 133;
                case 57 -> 32;
                case 58 -> 142;
                case 59 -> 242;
                case 60 -> 122;
                case 61 -> 212;
                case 62 -> 91;
                case 63 -> 89;
                case 64 -> 254;
                case 65 -> 207;
                case 66 -> 132;
                case 67 -> 168;
                case 68 -> 250;
                case 69 -> 71;
                case 70 -> 84;
                case 71 -> 86;
                case 72 -> 24;
                case 73 -> 70;
                case 74 -> 184;
                case 75 -> 231;
                case 76 -> 164;
                case 77 -> 69;
                case 78 -> 54;
                case 79 -> 149;
                case 80 -> 237;
                case 81 -> 210;
                case 82 -> 215;
                case 83 -> 252;
                case 84 -> 59;
                case 85 -> 48;
                case 86 -> 255;
                case 87 -> 58;
                case 88 -> 2;
                case 89 -> 223;
                case 90 -> 234;
                case 91 -> 152;
                case 92 -> 180;
                case 93 -> 101;
                case 94 -> 113;
                case 95 -> 199;
                case 96 -> 131;
                case 97 -> 166;
                case 98 -> 0;
                case 99 -> 126;
                case 100 -> 148;
                case 101 -> 60;
                case 102 -> 239;
                case 103 -> 73;
                case 104 -> 220;
                case 105 -> 27;
                case 106 -> 4;
                case 107 -> 245;
                case 108 -> 105;
                case 109 -> 21;
                case 110 -> 50;
                case 111 -> 198;
                case 112 -> 151;
                case 113 -> 81;
                case 114 -> 221;
                case 115 -> 65;
                case 116 -> 103;
                case 117 -> 201;
                case 118 -> 100;
                case 119 -> 35;
                case 120 -> 150;
                case 121 -> 187;
                case 122 -> 162;
                case 123 -> 96;
                case 124 -> 216;
                case 125 -> 68;
                case 126 -> 154;
                case 127 -> 121;
                case 128 -> 83;
                case 129 -> 175;
                case 130 -> 102;
                case 131 -> 228;
                case 132 -> 111;
                case 133 -> 211;
                case 134 -> 159;
                case 135 -> 74;
                case 136 -> 28;
                case 137 -> 189;
                case 138 -> 147;
                case 139 -> 202;
                case 140 -> 20;
                case 141 -> 165;
                case 142 -> 238;
                case 143 -> 170;
                case 144 -> 140;
                case 145 -> 173;
                case 146 -> 206;
                case 147 -> 183;
                case 148 -> 156;
                case 149 -> 45;
                case 150 -> 77;
                case 151 -> 196;
                case 152 -> 158;
                case 153 -> 139;
                case 154 -> 13;
                case 155 -> 116;
                case 156 -> 236;
                case 157 -> 203;
                case 158 -> 44;
                case 159 -> 43;
                case 160 -> 30;
                case 161 -> 192;
                case 162 -> 17;
                case 163 -> 106;
                case 164 -> 42;
                case 165 -> 34;
                case 166 -> 87;
                case 167 -> 155;
                case 168 -> 129;
                case 169 -> 61;
                case 170 -> 14;
                case 171 -> 226;
                case 172 -> 251;
                case 173 -> 195;
                case 174 -> 219;
                case 175 -> 33;
                case 176 -> 193;
                case 177 -> 115;
                case 178 -> 26;
                case 179 -> 19;
                case 180 -> 114;
                case 181 -> 161;
                case 182 -> 108;
                case 183 -> 243;
                case 184 -> 144;
                case 185 -> 229;
                case 186 -> 7;
                case 187 -> 119;
                case 188 -> 204;
                case 189 -> 31;
                case 190 -> 23;
                case 191 -> 225;
                case 192 -> 93;
                case 193 -> 167;
                case 194 -> 36;
                case 195 -> 66;
                case 196 -> 248;
                case 197 -> 194;
                case 198 -> 188;
                case 199 -> 8;
                case 200 -> 191;
                case 201 -> 75;
                case 202 -> 179;
                case 203 -> 177;
                case 204 -> 253;
                case 205 -> 217;
                case 206 -> 174;
                case 207 -> 171;
                case 208 -> 85;
                case 209 -> 117;
                case 210 -> 78;
                case 211 -> 47;
                case 212 -> 118;
                case 213 -> 56;
                case 214 -> 95;
                case 215 -> 244;
                case 216 -> 235;
                case 217 -> 110;
                case 218 -> 12;
                case 219 -> 10;
                case 220 -> 76;
                case 221 -> 141;
                case 222 -> 25;
                case 223 -> 82;
                case 224 -> 112;
                case 225 -> 72;
                case 226 -> 63;
                case 227 -> 49;
                case 228 -> 92;
                case 229 -> 38;
                case 230 -> 232;
                case 231 -> 214;
                case 232 -> 205;
                case 233 -> 16;
                case 234 -> 247;
                case 235 -> 172;
                case 236 -> 200;
                case 237 -> 53;
                case 238 -> 57;
                case 239 -> 104;
                case 240 -> 208;
                case 241 -> 224;
                case 242 -> 128;
                case 243 -> 64;
                case 244 -> 124;
                case 245 -> 222;
                case 246 -> 134;
                case 247 -> 22;
                case 248 -> 39;
                case 249 -> 51;
                case 250 -> 88;
                case 251 -> 29;
                case 252 -> 246;
                case 253 -> 185;
                case 254 -> 190;
                default -> 136;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 97013714420476L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1006879740 - 30905, 1006879740 - 25988, (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        int n2;
                        block4: {
                            l2 = 12094770670702L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            n2 = SshAgentIpcService.A();
                            try {
                                hANDLE2 = hANDLE;
                                if (n2 == 0) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (n2 == 0) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-142735230 + -25266, 142735230 + 8085, (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-142735230 + -25263, -142735230 + -8000, (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-142735230 + -25264, -142735230 + -13896, (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "g\u00fbK_\u00a5\t[\u0081\u0010\u0011,t\u0004\u00f8\u00d9\t\u00c2\u00cd\u00df~>b\u0005\f\u001a";
                    var4_3 = "g\u00fbK_\u00a5\t[\u0081\u0010\u0011,t\u0004\u00f8\u00d9\t\u00c2\u00cd\u00df~>b\u0005\f\u001a".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 24;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\r\u00d0\u00a0\u009c\u000e5\u0019D5bn\u008ae\u00a5\u0091.\u00c1f\u00c4B{\u00de\u0006\u00f8\u00aeN1x\u00bd\u000b9\u00eaF\u00f7\u0002\u00f9\u0019\u00899>\f\u00c5\bv\u0091\u00c2\u00e1\u00bbB\u0004s\u00ef\u0014T\u00f3\u00c4\u00f4\u009c\u0016";
                        var4_3 = "\r\u00d0\u00a0\u009c\u000e5\u0019D5bn\u008ae\u00a5\u0091.\u00c1f\u00c4B{\u00de\u0006\u00f8\u00aeN1x\u00bd\u000b9\u00eaF\u00f7\u0002\u00f9\u0019\u00899>\f\u00c5\bv\u0091\u00c2\u00e1\u00bbB\u0004s\u00ef\u0014T\u00f3\u00c4\u00f4\u009c\u0016".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 87;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 124;
                                break;
                            }
                            case 1: {
                                v15 = 65;
                                break;
                            }
                            case 2: {
                                v15 = 61;
                                break;
                            }
                            case 3: {
                                v15 = 50;
                                break;
                            }
                            case 4: {
                                v15 = 94;
                                break;
                            }
                            case 5: {
                                v15 = 23;
                                break;
                            }
                            default: {
                                v15 = 17;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFC9BF) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 174;
                    case 1 -> 68;
                    case 2 -> 238;
                    case 3 -> 17;
                    case 4 -> 221;
                    case 5 -> 202;
                    case 6 -> 58;
                    case 7 -> 236;
                    case 8 -> 98;
                    case 9 -> 13;
                    case 10 -> 121;
                    case 11 -> 86;
                    case 12 -> 59;
                    case 13 -> 211;
                    case 14 -> 201;
                    case 15 -> 44;
                    case 16 -> 0;
                    case 17 -> 178;
                    case 18 -> 50;
                    case 19 -> 188;
                    case 20 -> 225;
                    case 21 -> 161;
                    case 22 -> 254;
                    case 23 -> 65;
                    case 24 -> 71;
                    case 25 -> 115;
                    case 26 -> 173;
                    case 27 -> 186;
                    case 28 -> 243;
                    case 29 -> 200;
                    case 30 -> 182;
                    case 31 -> 39;
                    case 32 -> 70;
                    case 33 -> 7;
                    case 34 -> 213;
                    case 35 -> 75;
                    case 36 -> 40;
                    case 37 -> 131;
                    case 38 -> 214;
                    case 39 -> 252;
                    case 40 -> 126;
                    case 41 -> 95;
                    case 42 -> 206;
                    case 43 -> 147;
                    case 44 -> 100;
                    case 45 -> 154;
                    case 46 -> 176;
                    case 47 -> 156;
                    case 48 -> 204;
                    case 49 -> 231;
                    case 50 -> 76;
                    case 51 -> 138;
                    case 52 -> 109;
                    case 53 -> 196;
                    case 54 -> 15;
                    case 55 -> 36;
                    case 56 -> 226;
                    case 57 -> 164;
                    case 58 -> 127;
                    case 59 -> 112;
                    case 60 -> 114;
                    case 61 -> 189;
                    case 62 -> 63;
                    case 63 -> 246;
                    case 64 -> 77;
                    case 65 -> 66;
                    case 66 -> 149;
                    case 67 -> 37;
                    case 68 -> 41;
                    case 69 -> 84;
                    case 70 -> 56;
                    case 71 -> 53;
                    case 72 -> 57;
                    case 73 -> 82;
                    case 74 -> 29;
                    case 75 -> 143;
                    case 76 -> 245;
                    case 77 -> 169;
                    case 78 -> 8;
                    case 79 -> 227;
                    case 80 -> 79;
                    case 81 -> 142;
                    case 82 -> 97;
                    case 83 -> 31;
                    case 84 -> 194;
                    case 85 -> 152;
                    case 86 -> 19;
                    case 87 -> 43;
                    case 88 -> 160;
                    case 89 -> 253;
                    case 90 -> 249;
                    case 91 -> 218;
                    case 92 -> 93;
                    case 93 -> 64;
                    case 94 -> 54;
                    case 95 -> 94;
                    case 96 -> 199;
                    case 97 -> 12;
                    case 98 -> 192;
                    case 99 -> 101;
                    case 100 -> 177;
                    case 101 -> 16;
                    case 102 -> 158;
                    case 103 -> 216;
                    case 104 -> 18;
                    case 105 -> 232;
                    case 106 -> 141;
                    case 107 -> 21;
                    case 108 -> 125;
                    case 109 -> 122;
                    case 110 -> 10;
                    case 111 -> 233;
                    case 112 -> 146;
                    case 113 -> 198;
                    case 114 -> 148;
                    case 115 -> 25;
                    case 116 -> 219;
                    case 117 -> 107;
                    case 118 -> 85;
                    case 119 -> 6;
                    case 120 -> 27;
                    case 121 -> 244;
                    case 122 -> 183;
                    case 123 -> 166;
                    case 124 -> 234;
                    case 125 -> 119;
                    case 126 -> 179;
                    case 127 -> 205;
                    case 128 -> 195;
                    case 129 -> 193;
                    case 130 -> 22;
                    case 131 -> 222;
                    case 132 -> 145;
                    case 133 -> 220;
                    case 134 -> 72;
                    case 135 -> 207;
                    case 136 -> 24;
                    case 137 -> 87;
                    case 138 -> 250;
                    case 139 -> 229;
                    case 140 -> 111;
                    case 141 -> 247;
                    case 142 -> 99;
                    case 143 -> 103;
                    case 144 -> 242;
                    case 145 -> 30;
                    case 146 -> 168;
                    case 147 -> 155;
                    case 148 -> 133;
                    case 149 -> 11;
                    case 150 -> 26;
                    case 151 -> 184;
                    case 152 -> 2;
                    case 153 -> 49;
                    case 154 -> 130;
                    case 155 -> 175;
                    case 156 -> 255;
                    case 157 -> 197;
                    case 158 -> 228;
                    case 159 -> 129;
                    case 160 -> 88;
                    case 161 -> 248;
                    case 162 -> 208;
                    case 163 -> 212;
                    case 164 -> 167;
                    case 165 -> 116;
                    case 166 -> 251;
                    case 167 -> 180;
                    case 168 -> 46;
                    case 169 -> 92;
                    case 170 -> 187;
                    case 171 -> 67;
                    case 172 -> 150;
                    case 173 -> 224;
                    case 174 -> 172;
                    case 175 -> 140;
                    case 176 -> 51;
                    case 177 -> 90;
                    case 178 -> 237;
                    case 179 -> 170;
                    case 180 -> 108;
                    case 181 -> 32;
                    case 182 -> 134;
                    case 183 -> 118;
                    case 184 -> 157;
                    case 185 -> 81;
                    case 186 -> 35;
                    case 187 -> 241;
                    case 188 -> 104;
                    case 189 -> 135;
                    case 190 -> 124;
                    case 191 -> 91;
                    case 192 -> 159;
                    case 193 -> 190;
                    case 194 -> 80;
                    case 195 -> 181;
                    case 196 -> 128;
                    case 197 -> 120;
                    case 198 -> 223;
                    case 199 -> 20;
                    case 200 -> 96;
                    case 201 -> 137;
                    case 202 -> 102;
                    case 203 -> 230;
                    case 204 -> 1;
                    case 205 -> 136;
                    case 206 -> 203;
                    case 207 -> 69;
                    case 208 -> 165;
                    case 209 -> 113;
                    case 210 -> 52;
                    case 211 -> 5;
                    case 212 -> 14;
                    case 213 -> 74;
                    case 214 -> 60;
                    case 215 -> 163;
                    case 216 -> 210;
                    case 217 -> 89;
                    case 218 -> 62;
                    case 219 -> 3;
                    case 220 -> 38;
                    case 221 -> 162;
                    case 222 -> 55;
                    case 223 -> 191;
                    case 224 -> 28;
                    case 225 -> 23;
                    case 226 -> 48;
                    case 227 -> 151;
                    case 228 -> 33;
                    case 229 -> 45;
                    case 230 -> 153;
                    case 231 -> 209;
                    case 232 -> 42;
                    case 233 -> 106;
                    case 234 -> 217;
                    case 235 -> 239;
                    case 236 -> 83;
                    case 237 -> 139;
                    case 238 -> 73;
                    case 239 -> 110;
                    case 240 -> 185;
                    case 241 -> 171;
                    case 242 -> 235;
                    case 243 -> 78;
                    case 244 -> 240;
                    case 245 -> 117;
                    case 246 -> 9;
                    case 247 -> 132;
                    case 248 -> 34;
                    case 249 -> 215;
                    case 250 -> 47;
                    case 251 -> 123;
                    case 252 -> 144;
                    case 253 -> 105;
                    case 254 -> 4;
                    default -> 61;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 127710687530358L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "Ho]7`oo\u0011\tOeN=--r\r#";
                    var5_4 = "Ho]7`oo\u0011\tOeN=--r\r#".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 39;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 4;
                                    break;
                                }
                                case 1: {
                                    v11 = 45;
                                    break;
                                }
                                case 2: {
                                    v11 = 8;
                                    break;
                                }
                                case 3: {
                                    v11 = 126;
                                    break;
                                }
                                case 4: {
                                    v11 = 34;
                                    break;
                                }
                                case 5: {
                                    v11 = 36;
                                    break;
                                }
                                default: {
                                    v11 = 123;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 88811837310835L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "\rP[/'ut\u0004\u000bNW5\n\u0007Q\\5+wl-PU\t\u0007Q\\5+wl!Z\r\u0000WA8!zv!]F2 s";
                    var5_4 = "\rP[/'ut\u0004\u000bNW5\n\u0007Q\\5+wl-PU\t\u0007Q\\5+wl!Z\r\u0000WA8!zv!]F2 s".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 4;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = " uz\u000f\u0000]X\u0006 uz\u000f\fW";
                        var5_4 = " uz\u000f\u0000]X\u0006 uz\u000f\fW".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 35;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 64;
                                break;
                            }
                            case 1: {
                                v15 = 58;
                                break;
                            }
                            case 2: {
                                v15 = 54;
                                break;
                            }
                            case 3: {
                                v15 = 95;
                                break;
                            }
                            case 4: {
                                v15 = 74;
                                break;
                            }
                            case 5: {
                                v15 = 16;
                                break;
                            }
                            default: {
                                v15 = 28;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n23#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 68137722170471L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(1933937850 + (char)-19483, 1933937850 + (char)-4148, (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 7772099664004L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "\u00a6\u0086_\u00c7\u00d1\u0003\u00ab\tJ\u0005\u00fcz2\u009c\u009f\r\u00fc%\u0004=\u00ac\u00bd\u0081\u00e2.U\u0012G\u00df\u0010\u00ce\u00cc\u0085\u00eb\u00a3\u00f2K6\u00beK\u00e3\u00c9\u0007\u00d21\u00db\u0005vcc\u00bf\u00b53[P\u00d7\u00ae<\u001e\u0088\u00bf\u00bb\u0087\u00c8y\u00a4\u0095i,\u00d8\u00e8\u00c1<\u00f4\u0007\u00fe\u00c0\u00cf\u00cf\u0001\u008ac\u007f\u00a6Q\u00cc\u00f3\u00dd U$\u00dfA\u00c5\u001e\u00e0\u001f\u00fa\u00ab\u0088\u0086f\u0099+";
                    var4_3 = "\u00a6\u0086_\u00c7\u00d1\u0003\u00ab\tJ\u0005\u00fcz2\u009c\u009f\r\u00fc%\u0004=\u00ac\u00bd\u0081\u00e2.U\u0012G\u00df\u0010\u00ce\u00cc\u0085\u00eb\u00a3\u00f2K6\u00beK\u00e3\u00c9\u0007\u00d21\u00db\u0005vcc\u00bf\u00b53[P\u00d7\u00ae<\u001e\u0088\u00bf\u00bb\u0087\u00c8y\u00a4\u0095i,\u00d8\u00e8\u00c1<\u00f4\u0007\u00fe\u00c0\u00cf\u00cf\u0001\u008ac\u007f\u00a6Q\u00cc\u00f3\u00dd U$\u00dfA\u00c5\u001e\u00e0\u001f\u00fa\u00ab\u0088\u0086f\u0099+".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 4;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "ggdJK\u0012\u0082\u00feS\u0086\u008a\u00a4\u00fe\u00ab\u00da Ly\u00e8Pq\u00e7\u00bdye\u00a5f\u00f8\u0001\u00be\u0091A\u001e\f\u00abpv~\u00feQ\u0089\u00cd\u00d9\u00b0Z{\u00f8\u009e\u001a\u000f\u00a0\u0000\u0082\bz\u009a8\u008f\u0018\u00b2vq\u008c\u00e6\u008e\u008dxj\u00e7.\t\u00cf\u00bf\u00e7,\u0014\u00e6k\u00c4>\u00c7\r+\u00e4\u00d6W\u0090*\u00ee\u008e\u008a-\u00c5";
                        var4_3 = "ggdJK\u0012\u0082\u00feS\u0086\u008a\u00a4\u00fe\u00ab\u00da Ly\u00e8Pq\u00e7\u00bdye\u00a5f\u00f8\u0001\u00be\u0091A\u001e\f\u00abpv~\u00feQ\u0089\u00cd\u00d9\u00b0Z{\u00f8\u009e\u001a\u000f\u00a0\u0000\u0082\bz\u009a8\u008f\u0018\u00b2vq\u008c\u00e6\u008e\u008dxj\u00e7.\t\u00cf\u00bf\u00e7,\u0014\u00e6k\u00c4>\u00c7\r+\u00e4\u00d6W\u0090*\u00ee\u008e\u008a-\u00c5".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 18;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 123;
                                break;
                            }
                            case 1: {
                                v15 = 98;
                                break;
                            }
                            case 2: {
                                v15 = 72;
                                break;
                            }
                            case 3: {
                                v15 = 58;
                                break;
                            }
                            case 4: {
                                v15 = 10;
                                break;
                            }
                            case 5: {
                                v15 = 95;
                                break;
                            }
                            default: {
                                v15 = 45;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFF8CF8) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 209;
                    case 1 -> 15;
                    case 2 -> 44;
                    case 3 -> 71;
                    case 4 -> 51;
                    case 5 -> 21;
                    case 6 -> 201;
                    case 7 -> 244;
                    case 8 -> 96;
                    case 9 -> 23;
                    case 10 -> 18;
                    case 11 -> 163;
                    case 12 -> 59;
                    case 13 -> 239;
                    case 14 -> 180;
                    case 15 -> 4;
                    case 16 -> 218;
                    case 17 -> 152;
                    case 18 -> 190;
                    case 19 -> 83;
                    case 20 -> 139;
                    case 21 -> 233;
                    case 22 -> 37;
                    case 23 -> 202;
                    case 24 -> 102;
                    case 25 -> 224;
                    case 26 -> 174;
                    case 27 -> 116;
                    case 28 -> 215;
                    case 29 -> 122;
                    case 30 -> 114;
                    case 31 -> 241;
                    case 32 -> 229;
                    case 33 -> 206;
                    case 34 -> 221;
                    case 35 -> 128;
                    case 36 -> 165;
                    case 37 -> 120;
                    case 38 -> 13;
                    case 39 -> 126;
                    case 40 -> 188;
                    case 41 -> 56;
                    case 42 -> 127;
                    case 43 -> 172;
                    case 44 -> 12;
                    case 45 -> 30;
                    case 46 -> 52;
                    case 47 -> 38;
                    case 48 -> 140;
                    case 49 -> 19;
                    case 50 -> 162;
                    case 51 -> 169;
                    case 52 -> 220;
                    case 53 -> 185;
                    case 54 -> 255;
                    case 55 -> 45;
                    case 56 -> 67;
                    case 57 -> 79;
                    case 58 -> 50;
                    case 59 -> 121;
                    case 60 -> 135;
                    case 61 -> 193;
                    case 62 -> 94;
                    case 63 -> 82;
                    case 64 -> 89;
                    case 65 -> 63;
                    case 66 -> 226;
                    case 67 -> 186;
                    case 68 -> 138;
                    case 69 -> 100;
                    case 70 -> 16;
                    case 71 -> 175;
                    case 72 -> 29;
                    case 73 -> 132;
                    case 74 -> 62;
                    case 75 -> 87;
                    case 76 -> 101;
                    case 77 -> 86;
                    case 78 -> 217;
                    case 79 -> 42;
                    case 80 -> 199;
                    case 81 -> 117;
                    case 82 -> 137;
                    case 83 -> 107;
                    case 84 -> 194;
                    case 85 -> 10;
                    case 86 -> 198;
                    case 87 -> 204;
                    case 88 -> 6;
                    case 89 -> 161;
                    case 90 -> 27;
                    case 91 -> 146;
                    case 92 -> 191;
                    case 93 -> 39;
                    case 94 -> 95;
                    case 95 -> 235;
                    case 96 -> 214;
                    case 97 -> 141;
                    case 98 -> 55;
                    case 99 -> 106;
                    case 100 -> 148;
                    case 101 -> 93;
                    case 102 -> 212;
                    case 103 -> 11;
                    case 104 -> 210;
                    case 105 -> 24;
                    case 106 -> 25;
                    case 107 -> 159;
                    case 108 -> 0;
                    case 109 -> 49;
                    case 110 -> 181;
                    case 111 -> 80;
                    case 112 -> 166;
                    case 113 -> 234;
                    case 114 -> 238;
                    case 115 -> 232;
                    case 116 -> 216;
                    case 117 -> 243;
                    case 118 -> 17;
                    case 119 -> 253;
                    case 120 -> 85;
                    case 121 -> 103;
                    case 122 -> 91;
                    case 123 -> 129;
                    case 124 -> 192;
                    case 125 -> 237;
                    case 126 -> 9;
                    case 127 -> 155;
                    case 128 -> 77;
                    case 129 -> 168;
                    case 130 -> 73;
                    case 131 -> 178;
                    case 132 -> 154;
                    case 133 -> 182;
                    case 134 -> 143;
                    case 135 -> 43;
                    case 136 -> 236;
                    case 137 -> 22;
                    case 138 -> 197;
                    case 139 -> 35;
                    case 140 -> 64;
                    case 141 -> 70;
                    case 142 -> 130;
                    case 143 -> 36;
                    case 144 -> 195;
                    case 145 -> 34;
                    case 146 -> 81;
                    case 147 -> 118;
                    case 148 -> 66;
                    case 149 -> 133;
                    case 150 -> 179;
                    case 151 -> 58;
                    case 152 -> 157;
                    case 153 -> 57;
                    case 154 -> 2;
                    case 155 -> 248;
                    case 156 -> 47;
                    case 157 -> 108;
                    case 158 -> 254;
                    case 159 -> 207;
                    case 160 -> 60;
                    case 161 -> 78;
                    case 162 -> 105;
                    case 163 -> 8;
                    case 164 -> 164;
                    case 165 -> 149;
                    case 166 -> 176;
                    case 167 -> 113;
                    case 168 -> 110;
                    case 169 -> 203;
                    case 170 -> 147;
                    case 171 -> 74;
                    case 172 -> 112;
                    case 173 -> 219;
                    case 174 -> 28;
                    case 175 -> 98;
                    case 176 -> 247;
                    case 177 -> 3;
                    case 178 -> 48;
                    case 179 -> 167;
                    case 180 -> 123;
                    case 181 -> 171;
                    case 182 -> 189;
                    case 183 -> 32;
                    case 184 -> 223;
                    case 185 -> 97;
                    case 186 -> 40;
                    case 187 -> 5;
                    case 188 -> 7;
                    case 189 -> 84;
                    case 190 -> 46;
                    case 191 -> 246;
                    case 192 -> 184;
                    case 193 -> 153;
                    case 194 -> 231;
                    case 195 -> 196;
                    case 196 -> 252;
                    case 197 -> 119;
                    case 198 -> 109;
                    case 199 -> 1;
                    case 200 -> 75;
                    case 201 -> 187;
                    case 202 -> 99;
                    case 203 -> 136;
                    case 204 -> 173;
                    case 205 -> 68;
                    case 206 -> 31;
                    case 207 -> 251;
                    case 208 -> 242;
                    case 209 -> 20;
                    case 210 -> 208;
                    case 211 -> 115;
                    case 212 -> 211;
                    case 213 -> 177;
                    case 214 -> 183;
                    case 215 -> 150;
                    case 216 -> 158;
                    case 217 -> 41;
                    case 218 -> 205;
                    case 219 -> 72;
                    case 220 -> 54;
                    case 221 -> 53;
                    case 222 -> 227;
                    case 223 -> 230;
                    case 224 -> 134;
                    case 225 -> 222;
                    case 226 -> 200;
                    case 227 -> 228;
                    case 228 -> 151;
                    case 229 -> 125;
                    case 230 -> 142;
                    case 231 -> 144;
                    case 232 -> 250;
                    case 233 -> 213;
                    case 234 -> 245;
                    case 235 -> 240;
                    case 236 -> 26;
                    case 237 -> 104;
                    case 238 -> 14;
                    case 239 -> 170;
                    case 240 -> 90;
                    case 241 -> 156;
                    case 242 -> 160;
                    case 243 -> 111;
                    case 244 -> 249;
                    case 245 -> 225;
                    case 246 -> 124;
                    case 247 -> 145;
                    case 248 -> 92;
                    case 249 -> 33;
                    case 250 -> 88;
                    case 251 -> 69;
                    case 252 -> 61;
                    case 253 -> 65;
                    case 254 -> 131;
                    default -> 76;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 76912034079727L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(-2054653320 + -32280, 2054653320 + (char)-15955, (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 42408223981389L;
                    int n3 = SshAgentIpcService.A();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(283111200 - 20061, -283111200 - -23323, (int)l2));
                    int n4 = n3;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (n4 == 0) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 91394907014484L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "\u00ac\u008cc\u00a7\u00e3\u0003\u0088W\u00b1";
                var4_3 = "\u00ac\u008cc\u00a7\u00e3\u0003\u0088W\u00b1".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 86;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 49;
                                break;
                            }
                            case 1: {
                                v11 = 73;
                                break;
                            }
                            case 2: {
                                v11 = 100;
                                break;
                            }
                            case 3: {
                                v11 = 102;
                                break;
                            }
                            case 4: {
                                v11 = 34;
                                break;
                            }
                            case 5: {
                                v11 = 88;
                                break;
                            }
                            default: {
                                v11 = 19;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFF9F8F) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 222;
                    case 1 -> 115;
                    case 2 -> 141;
                    case 3 -> 250;
                    case 4 -> 7;
                    case 5 -> 73;
                    case 6 -> 22;
                    case 7 -> 4;
                    case 8 -> 46;
                    case 9 -> 51;
                    case 10 -> 57;
                    case 11 -> 136;
                    case 12 -> 32;
                    case 13 -> 191;
                    case 14 -> 199;
                    case 15 -> 163;
                    case 16 -> 236;
                    case 17 -> 94;
                    case 18 -> 67;
                    case 19 -> 98;
                    case 20 -> 190;
                    case 21 -> 152;
                    case 22 -> 196;
                    case 23 -> 3;
                    case 24 -> 129;
                    case 25 -> 202;
                    case 26 -> 6;
                    case 27 -> 68;
                    case 28 -> 109;
                    case 29 -> 118;
                    case 30 -> 34;
                    case 31 -> 245;
                    case 32 -> 233;
                    case 33 -> 154;
                    case 34 -> 244;
                    case 35 -> 30;
                    case 36 -> 137;
                    case 37 -> 33;
                    case 38 -> 249;
                    case 39 -> 239;
                    case 40 -> 226;
                    case 41 -> 71;
                    case 42 -> 235;
                    case 43 -> 28;
                    case 44 -> 139;
                    case 45 -> 185;
                    case 46 -> 27;
                    case 47 -> 40;
                    case 48 -> 74;
                    case 49 -> 186;
                    case 50 -> 128;
                    case 51 -> 108;
                    case 52 -> 122;
                    case 53 -> 238;
                    case 54 -> 44;
                    case 55 -> 215;
                    case 56 -> 23;
                    case 57 -> 53;
                    case 58 -> 172;
                    case 59 -> 166;
                    case 60 -> 99;
                    case 61 -> 159;
                    case 62 -> 88;
                    case 63 -> 243;
                    case 64 -> 192;
                    case 65 -> 79;
                    case 66 -> 14;
                    case 67 -> 29;
                    case 68 -> 248;
                    case 69 -> 75;
                    case 70 -> 107;
                    case 71 -> 168;
                    case 72 -> 113;
                    case 73 -> 69;
                    case 74 -> 104;
                    case 75 -> 9;
                    case 76 -> 65;
                    case 77 -> 78;
                    case 78 -> 102;
                    case 79 -> 31;
                    case 80 -> 124;
                    case 81 -> 110;
                    case 82 -> 119;
                    case 83 -> 237;
                    case 84 -> 161;
                    case 85 -> 89;
                    case 86 -> 85;
                    case 87 -> 140;
                    case 88 -> 143;
                    case 89 -> 0;
                    case 90 -> 116;
                    case 91 -> 35;
                    case 92 -> 218;
                    case 93 -> 240;
                    case 94 -> 207;
                    case 95 -> 147;
                    case 96 -> 84;
                    case 97 -> 20;
                    case 98 -> 125;
                    case 99 -> 13;
                    case 100 -> 66;
                    case 101 -> 62;
                    case 102 -> 93;
                    case 103 -> 43;
                    case 104 -> 144;
                    case 105 -> 194;
                    case 106 -> 177;
                    case 107 -> 220;
                    case 108 -> 211;
                    case 109 -> 21;
                    case 110 -> 167;
                    case 111 -> 151;
                    case 112 -> 87;
                    case 113 -> 111;
                    case 114 -> 37;
                    case 115 -> 205;
                    case 116 -> 208;
                    case 117 -> 105;
                    case 118 -> 181;
                    case 119 -> 96;
                    case 120 -> 80;
                    case 121 -> 254;
                    case 122 -> 15;
                    case 123 -> 106;
                    case 124 -> 25;
                    case 125 -> 130;
                    case 126 -> 170;
                    case 127 -> 56;
                    case 128 -> 174;
                    case 129 -> 54;
                    case 130 -> 179;
                    case 131 -> 1;
                    case 132 -> 91;
                    case 133 -> 47;
                    case 134 -> 148;
                    case 135 -> 39;
                    case 136 -> 214;
                    case 137 -> 63;
                    case 138 -> 5;
                    case 139 -> 81;
                    case 140 -> 160;
                    case 141 -> 162;
                    case 142 -> 138;
                    case 143 -> 241;
                    case 144 -> 10;
                    case 145 -> 50;
                    case 146 -> 178;
                    case 147 -> 155;
                    case 148 -> 242;
                    case 149 -> 101;
                    case 150 -> 173;
                    case 151 -> 188;
                    case 152 -> 146;
                    case 153 -> 95;
                    case 154 -> 24;
                    case 155 -> 203;
                    case 156 -> 131;
                    case 157 -> 213;
                    case 158 -> 224;
                    case 159 -> 150;
                    case 160 -> 133;
                    case 161 -> 252;
                    case 162 -> 255;
                    case 163 -> 227;
                    case 164 -> 2;
                    case 165 -> 60;
                    case 166 -> 86;
                    case 167 -> 100;
                    case 168 -> 197;
                    case 169 -> 12;
                    case 170 -> 209;
                    case 171 -> 253;
                    case 172 -> 175;
                    case 173 -> 219;
                    case 174 -> 126;
                    case 175 -> 221;
                    case 176 -> 164;
                    case 177 -> 165;
                    case 178 -> 216;
                    case 179 -> 11;
                    case 180 -> 187;
                    case 181 -> 223;
                    case 182 -> 103;
                    case 183 -> 180;
                    case 184 -> 169;
                    case 185 -> 77;
                    case 186 -> 232;
                    case 187 -> 70;
                    case 188 -> 156;
                    case 189 -> 127;
                    case 190 -> 45;
                    case 191 -> 247;
                    case 192 -> 153;
                    case 193 -> 61;
                    case 194 -> 52;
                    case 195 -> 171;
                    case 196 -> 49;
                    case 197 -> 176;
                    case 198 -> 217;
                    case 199 -> 157;
                    case 200 -> 42;
                    case 201 -> 19;
                    case 202 -> 55;
                    case 203 -> 48;
                    case 204 -> 38;
                    case 205 -> 120;
                    case 206 -> 200;
                    case 207 -> 195;
                    case 208 -> 142;
                    case 209 -> 18;
                    case 210 -> 189;
                    case 211 -> 36;
                    case 212 -> 229;
                    case 213 -> 204;
                    case 214 -> 76;
                    case 215 -> 184;
                    case 216 -> 72;
                    case 217 -> 228;
                    case 218 -> 158;
                    case 219 -> 132;
                    case 220 -> 149;
                    case 221 -> 135;
                    case 222 -> 121;
                    case 223 -> 193;
                    case 224 -> 134;
                    case 225 -> 8;
                    case 226 -> 112;
                    case 227 -> 83;
                    case 228 -> 90;
                    case 229 -> 225;
                    case 230 -> 59;
                    case 231 -> 246;
                    case 232 -> 82;
                    case 233 -> 58;
                    case 234 -> 92;
                    case 235 -> 182;
                    case 236 -> 123;
                    case 237 -> 183;
                    case 238 -> 201;
                    case 239 -> 26;
                    case 240 -> 17;
                    case 241 -> 230;
                    case 242 -> 117;
                    case 243 -> 97;
                    case 244 -> 212;
                    case 245 -> 145;
                    case 246 -> 206;
                    case 247 -> 251;
                    case 248 -> 198;
                    case 249 -> 16;
                    case 250 -> 210;
                    case 251 -> 41;
                    case 252 -> 231;
                    case 253 -> 64;
                    case 254 -> 114;
                    default -> 234;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

