/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.headerRoots;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.search.PsiElementProcessor;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.modulemap.resolve.FrameworkRootModuleMapCollector;
import com.jetbrains.cidr.lang.workspace.headerRoots.AppleFramework;
import com.jetbrains.cidr.lang.workspace.headerRoots.AppleFrameworkFilter;
import com.jetbrains.cidr.lang.workspace.headerRoots.FrameworksRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.ModuleMapLocationProvider;
import com.jetbrains.cidr.lang.workspace.headerRoots.RealFramework;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FrameworksSearchRoot
extends FrameworksRoot
implements ModuleMapLocationProvider {
    @NotNull
    public static FrameworksSearchRoot create(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            FrameworksSearchRoot.$$$reportNull$$$0(0);
        }
        if (file == null) {
            FrameworksSearchRoot.$$$reportNull$$$0(1);
        }
        return new Transient(project, file);
    }

    @NotNull
    public static FrameworksSearchRoot create(@NotNull Project project, @NotNull VirtualFilePointer pointer) {
        if (project == null) {
            FrameworksSearchRoot.$$$reportNull$$$0(2);
        }
        if (pointer == null) {
            FrameworksSearchRoot.$$$reportNull$$$0(3);
        }
        return new Pointer(project, pointer);
    }

    private FrameworksSearchRoot(@NotNull Project project) {
        if (project == null) {
            FrameworksSearchRoot.$$$reportNull$$$0(4);
        }
        super(project);
    }

    @NotNull
    public abstract String getUrl();

    @Nls
    @NotNull
    public String getPresentableName() {
        String string = OCBundle.message("header.search.root.frameworks", new Object[0]);
        if (string == null) {
            FrameworksSearchRoot.$$$reportNull$$$0(5);
        }
        return string;
    }

    public boolean processFrameworks(@NotNull PsiElementProcessor<? super PsiFileSystemItem> processor2, @NotNull Set<? super String> processed, boolean includeSdkFrameworks) {
        if (processor2 == null) {
            FrameworksSearchRoot.$$$reportNull$$$0(6);
        }
        if (processed == null) {
            FrameworksSearchRoot.$$$reportNull$$$0(7);
        }
        return FrameworksSearchRoot.processFrameworksUnder((PsiFileSystemItem)this, this.getVirtualFile(), processor2, processed);
    }

    public static boolean processFrameworksUnder(@NotNull PsiFileSystemItem parentSdkOrFramework, @Nullable VirtualFile root, @NotNull PsiElementProcessor<? super PsiFileSystemItem> processor2, @NotNull Set<? super String> processed) {
        if (parentSdkOrFramework == null) {
            FrameworksSearchRoot.$$$reportNull$$$0(8);
        }
        if (processor2 == null) {
            FrameworksSearchRoot.$$$reportNull$$$0(9);
        }
        if (processed == null) {
            FrameworksSearchRoot.$$$reportNull$$$0(10);
        }
        Project project = parentSdkOrFramework.getProject();
        if (root != null && root.isValid() && root.isDirectory() && !project.isDisposed()) {
            VirtualFile[] frameworkPaths;
            for (VirtualFile frameworkPath : frameworkPaths = AppleFrameworkFilter.Companion.filter(project, root.getChildren())) {
                RealFramework framework;
                if (!AppleFramework.isFrameworkRoot((VirtualFile)frameworkPath) || (framework = new RealFramework(project, frameworkPath, parentSdkOrFramework)).process(processor2, processed)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    @NotNull
    public Collection<? extends HeadersSearchRoot> getPossibleModuleMapLocations() {
        ArrayList<HeadersSearchRoot> roots = new ArrayList<HeadersSearchRoot>();
        this.processChildren((PsiElementProcessor)new FrameworkRootModuleMapCollector(this.myProject, roots));
        ArrayList<HeadersSearchRoot> arrayList = roots;
        if (arrayList == null) {
            FrameworksSearchRoot.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    public String toString() {
        return "FrameworksSearchRoot: " + this.getUrl();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointer";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/workspace/headerRoots/FrameworksSearchRoot";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processed";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentSdkOrFramework";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/workspace/headerRoots/FrameworksSearchRoot";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPossibleModuleMapLocations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 11: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processFrameworks";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processFrameworksUnder";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 11 -> new IllegalStateException(string);
        };
    }

    private static final class Transient
    extends FrameworksSearchRoot {
        @NotNull
        private final VirtualFile myRoot;

        private Transient(@NotNull Project project, @NotNull VirtualFile root) {
            if (project == null) {
                Transient.$$$reportNull$$$0(0);
            }
            if (root == null) {
                Transient.$$$reportNull$$$0(1);
            }
            super(project);
            this.myRoot = root;
        }

        @Nullable
        public VirtualFile getVirtualFile() {
            return this.myRoot;
        }

        @Override
        @NotNull
        public String getUrl() {
            String string = this.myRoot.getUrl();
            if (string == null) {
                Transient.$$$reportNull$$$0(2);
            }
            return string;
        }

        public boolean isValid() {
            return this.myRoot.isValid();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.myRoot.equals(((Transient)o).myRoot);
        }

        public int hashCode() {
            return Objects.hash(this.myRoot);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/workspace/headerRoots/FrameworksSearchRoot$Transient";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/workspace/headerRoots/FrameworksSearchRoot$Transient";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUrl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private static final class Pointer
    extends FrameworksSearchRoot {
        @NotNull
        private final VirtualFilePointer myRootPointer;

        private Pointer(@NotNull Project project, @NotNull VirtualFilePointer root) {
            if (project == null) {
                Pointer.$$$reportNull$$$0(0);
            }
            if (root == null) {
                Pointer.$$$reportNull$$$0(1);
            }
            super(project);
            this.myRootPointer = root;
        }

        @Nullable
        public VirtualFile getVirtualFile() {
            return this.myRootPointer.getFile();
        }

        @Override
        @NotNull
        public String getUrl() {
            String string = this.myRootPointer.getUrl();
            if (string == null) {
                Pointer.$$$reportNull$$$0(2);
            }
            return string;
        }

        public boolean isValid() {
            return this.myRootPointer.isValid();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Pointer pointer = (Pointer)o;
            return this.myRootPointer.equals((Object)pointer.myRootPointer);
        }

        public int hashCode() {
            return Objects.hash(this.myRootPointer);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/workspace/headerRoots/FrameworksSearchRoot$Pointer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/workspace/headerRoots/FrameworksSearchRoot$Pointer";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUrl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

